/*
 * Decompiled with CFR 0.152.
 */
package agent;

import agent.TAgentProfilerObj;
import aspect.Aspect;
import aspect.TMainWin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Timer;
import utility.TFile;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;

public class TAgentProfiler
implements ActionListener {
    private TMainWin MainWin = Aspect.MainWin;
    private String WorkingDate = dateutil.formatDate(new Date(), "MMddyyyy");
    private Hashtable hNodes = null;
    private boolean Modified = false;
    private Timer CallbackTimer = new Timer(5000, this);

    public TAgentProfiler() {
        this.CallbackTimer.start();
    }

    public synchronized TAgentProfilerObj nodeExecuted(String string, TAgentProfilerObj tAgentProfilerObj) {
        String[] stringArray;
        if (this.hNodes == null) {
            this.readFromFile();
        }
        if ((stringArray = charutil.getSubStringArray(string, ',', false)) != null && stringArray.length == 6) {
            TAgentProfilerObj tAgentProfilerObj2 = null;
            String string2 = stringArray[1].toUpperCase() + "_" + stringArray[3].toUpperCase();
            String string3 = charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(stringArray[5], "'", "\""), "//comma//", ",");
            int n = charutil.ival(stringArray[4]);
            if (this.hNodes.containsKey(string2)) {
                tAgentProfilerObj2 = (TAgentProfilerObj)this.hNodes.get(string2);
                tAgentProfilerObj2.NodeType = stringArray[2];
                tAgentProfilerObj2.TermType = n;
                tAgentProfilerObj2.Comment = string3;
            } else {
                tAgentProfilerObj2 = new TAgentProfilerObj(stringArray[1], stringArray[2], stringArray[3], n, string3);
                this.hNodes.put(string2, tAgentProfilerObj2);
            }
            long l = new Date().getTime();
            ++tAgentProfilerObj2.Count;
            tAgentProfilerObj2.LastUpdate = l;
            if (tAgentProfilerObj != null) {
                tAgentProfilerObj2.ParentNode = tAgentProfilerObj.ID;
                if (tAgentProfilerObj.LastUpdate > 0L) {
                    tAgentProfilerObj.ElapsedTime += l - tAgentProfilerObj.LastUpdate;
                }
            }
            if (!tAgentProfilerObj2.PathRecorded && tAgentProfilerObj2.NodeType.equalsIgnoreCase("AgentTerminate")) {
                int n2 = 500;
                ArrayList<TAgentProfilerObj> arrayList = new ArrayList<TAgentProfilerObj>();
                String string4 = tAgentProfilerObj2.ParentNode.trim();
                while (arrayList.size() < n2 && string4.length() > 0) {
                    string2 = tAgentProfilerObj2.Name.toUpperCase() + "_" + string4.toUpperCase();
                    TAgentProfilerObj tAgentProfilerObj3 = (TAgentProfilerObj)this.hNodes.get(string2);
                    if (tAgentProfilerObj3 != null) {
                        if (tAgentProfilerObj3.NodeType.equalsIgnoreCase("AgentStart")) {
                            tAgentProfilerObj2.PathRecorded = true;
                        }
                        arrayList.add(tAgentProfilerObj3);
                        string4 = tAgentProfilerObj3.ParentNode.trim();
                        continue;
                    }
                    string4 = "";
                }
                if (arrayList.size() < n2) {
                    int n3 = 0;
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        TAgentProfilerObj tAgentProfilerObj4 = (TAgentProfilerObj)arrayList.get(i);
                        tAgentProfilerObj4.Step = n3++;
                        tAgentProfilerObj4.Path = tAgentProfilerObj2.ID;
                    }
                    tAgentProfilerObj2.Step = arrayList.size();
                    tAgentProfilerObj2.Path = tAgentProfilerObj2.ID;
                } else {
                    System.out.println("An error has occurred calculating the path for " + tAgentProfilerObj2.Name + "_" + tAgentProfilerObj2.ID);
                }
            }
            this.Modified = true;
            return tAgentProfilerObj2;
        }
        System.out.println("Error initializing agent profile: " + string);
        return null;
    }

    private synchronized String getProfileFilename() {
        return TMainWin.Application.getHomeDir() + "agents/Agent_Profile_" + dateutil.formatDate(new Date(), "MMddyyyy") + ".txt";
    }

    private synchronized void readFromFile() {
        block8: {
            if (this.hNodes != null) {
                this.hNodes.clear();
            } else {
                this.hNodes = new Hashtable();
            }
            String string = this.getProfileFilename();
            File file = new File(string);
            if (file.exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
                    randomAccessFile.seek(0L);
                    byte[] byArray = new byte[(int)file.length()];
                    randomAccessFile.read(byArray);
                    randomAccessFile.close();
                    String string2 = new String(byArray).trim();
                    string2 = charutil.removeChar(string2, '\r');
                    String[] stringArray = charutil.getSubStringArray(string2, '\n', false);
                    if (stringArray == null) break block8;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2 = charutil.getSubStringArray(stringArray[i], ',', true);
                        boolean bl = false;
                        if (stringArray2 != null) {
                            bl = stringArray2.length == 12;
                            boolean bl2 = bl = bl && (charutil.ival(stringArray2[2]) > 0 || stringArray2[2].equalsIgnoreCase("AgentStart"));
                        }
                        if (!bl) {
                            System.out.println("Error parsing agent profile record: " + i);
                            this.hNodes.clear();
                            break;
                        }
                        TAgentProfilerObj tAgentProfilerObj = new TAgentProfilerObj(stringArray2[0], stringArray2[1], stringArray2[2], charutil.ival(stringArray2[6]), stringArray2[5]);
                        tAgentProfilerObj.Count = charutil.ival(stringArray2[3]);
                        tAgentProfilerObj.ElapsedTime = charutil.ival(stringArray2[4]);
                        tAgentProfilerObj.ParentNode = stringArray2[7];
                        tAgentProfilerObj.Path = stringArray2[8];
                        tAgentProfilerObj.Step = charutil.ival(stringArray2[9]);
                        tAgentProfilerObj.PathRecorded = charutil.boolval(stringArray2[10]);
                        this.hNodes.put(tAgentProfilerObj.Name.toUpperCase() + "_" + tAgentProfilerObj.ID.toUpperCase(), tAgentProfilerObj);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error reading agent profile stats: " + exception.toString());
                }
            }
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (!this.Modified) {
            return;
        }
        this.writeToFile();
        this.Modified = false;
        String string = dateutil.formatDate(new Date(), "MMddyyyy");
        if (!string.equals(this.WorkingDate)) {
            this.hNodes.clear();
        }
    }

    public synchronized void writeToFile() {
        Object object;
        Object object2;
        String string;
        if (this.hNodes == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = this.hNodes.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object2 = (TAgentProfilerObj)this.hNodes.get(string);
            object = "\"" + charutil.removeChar(charutil.removeChar(((TAgentProfilerObj)object2).Name, '\"'), '\'') + "\",";
            object = (String)object + ((TAgentProfilerObj)object2).NodeType + ",";
            object = (String)object + ((TAgentProfilerObj)object2).ID + ",";
            object = (String)object + Long.toString(((TAgentProfilerObj)object2).Count) + ",";
            object = (String)object + Long.toString(((TAgentProfilerObj)object2).ElapsedTime) + ",";
            object = (String)object + "\"" + charutil.removeChar(charutil.removeChar(charutil.removeChar(((TAgentProfilerObj)object2).Comment, '\"'), '\n'), '\r') + "\",";
            object = (String)object + ((TAgentProfilerObj)object2).TermType + ",";
            object = (String)object + ((TAgentProfilerObj)object2).ParentNode + ",";
            object = (String)object + ((TAgentProfilerObj)object2).Path + ",";
            object = (String)object + Integer.toString(((TAgentProfilerObj)object2).Step) + ",";
            object = (String)object + Boolean.toString(((TAgentProfilerObj)object2).PathRecorded) + ",";
            object = (String)object + "EOL\r\n";
            stringBuilder.append((String)object);
        }
        try {
            string = this.getProfileFilename();
            object2 = new TFile(string);
            ((TFile)object2).validatePathToFile(true);
            dosutil.deleteFile((File)object2);
            if (!((File)object2).exists()) {
                object = new RandomAccessFile(string, "rwd");
                ((RandomAccessFile)object).write(stringBuilder.toString().getBytes());
                ((RandomAccessFile)object).close();
            } else {
                System.out.println("Unable to overwrite agent profiler records");
            }
        }
        catch (Exception exception) {
            System.out.println("Error writing agent profile stats: " + exception.toString());
        }
    }
}

