/*
 * Decompiled with CFR 0.152.
 */
package aspect;

import aspect.Aspect;
import aspect.TConsoleSettings;
import aspect.TMainWin;
import cache.TCacheWidget;
import collections.TComboBoxColl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import resources.TApplication;
import scripts.TExecScript;
import utility.TFile;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dateutil;
import utility.security.TPasswordService;

public class TActivityLogWriter {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    public static final int BLANK = 0;
    public static final int PROGRAM_START = 1;
    public static final int PROGRAM_TERMINATE = 2;
    public static final int INFO = 3;
    public static final int ERROR = 4;
    public static final int SCROLLWIN_OPEN = 5;
    public static final int SCROLLWIN_CLOSE = 6;
    public static final int LOADING_PACKAGE = 7;
    public static final int LOADING_RESOURCE = 8;
    public static final int SOCKET_INFO = 9;
    public static final int DEBUGGING = 10;
    public static final int STACKTRACE = 11;
    public static final int ACTION = 12;
    public static final int TASKSTART = 13;
    public static final int TASKEND = 14;
    public static final int SCRIPTSTART = 15;
    public static final int SCRIPTEND = 16;
    public static final int SERVERNOTIFICATIONSENT = 17;
    public static final int SERVERNOTIFICATIONRECEIVED = 18;
    public static final int NOTIFICATIONSEHT = 19;
    public static final int NOTIFICATIONRECEIVED = 20;
    public static final int PROCESSNOTIFICATIONSTART = 21;
    public static final int PROCESSNOTIFICATIONEND = 22;
    public static final int NOTIFICATIONEXPIRED = 23;
    public static final int UPDATEDEPENDENTDRIVERSTARTED = 24;
    public static final int UPDATEDEPENDENTDRIVERCOMPLETE = 25;
    public static final int EXECUTEAGENTMETHODSTARTED = 26;
    public static final int EXECUTEAGENTMETHODCOMPLETE = 27;
    private String LogFilename = "";
    private RandomAccessFile F = null;
    private String LastMsg = "";
    private StringBuilder LogBuffer = new StringBuilder();
    private int ActivityLogStartIndex = 0;
    private Hashtable hStringTable = null;
    private Hashtable hLookupStringTable = null;
    DateFormat dateFormat1 = DateFormat.getInstance();
    DateFormat dateFormat2 = DateFormat.getInstance();
    DateFormat dateFormat3 = DateFormat.getInstance();
    long TimeLastFlush = 0L;
    private static int iMaxLogSize = 0x1400000;
    private static TConsoleSettings ConsoleSettings = null;
    boolean bDumpingStats = false;
    long tmLastDump = 0L;
    NumberFormat numberFormat = null;
    TConsoleSettings ConsoleSettingsForView = null;
    long ConsoleSettingsForViewLastRead = 0L;

    public TActivityLogWriter(Date date) {
        DateFormat dateFormat = DateFormat.getInstance();
        ((SimpleDateFormat)dateFormat).applyPattern("yyyyMMdd");
        String string = dateFormat.format(date);
        this.LogFilename = this.Application == null ? "C:\\Aspect7\\AspectLogs\\log_20130227.txt" : this.Application.getHomeDir() + "aspectlogs/log_" + string + ".txt";
        try {
            new TFile(this.LogFilename).validatePathToFile(true);
            this.F = new RandomAccessFile(this.LogFilename, "rwd");
        }
        catch (Exception exception) {
            System.out.println("Error opening log file: " + this.LogFilename);
            System.out.println(exception.toString());
        }
        ((SimpleDateFormat)this.dateFormat1).applyPattern("MM-dd-yyyy HH:mm:ss:SSS");
        ((SimpleDateFormat)this.dateFormat2).applyPattern("MMddyyyy_HHmmssSSS");
        ((SimpleDateFormat)this.dateFormat3).applyPattern("MM-dd-yyyy");
        this.ActivityLogStartIndex = this.getRecordCount() + 1;
        this.hStringTable = new Hashtable();
        this.hLookupStringTable = new Hashtable();
        TComboBoxColl tComboBoxColl = this.Application.AppCollections.getCollection("Stringtable_For_Activity_Log", new StringBuilder(), new TFormulaEvaluator(), false, "", "");
        for (int i = 0; i < tComboBoxColl.size(); ++i) {
            TComboBoxColl.TComboBoxCollObj tComboBoxCollObj = (TComboBoxColl.TComboBoxCollObj)tComboBoxColl.get(i);
            this.hStringTable.put(tComboBoxCollObj.Value.toUpperCase(), tComboBoxCollObj.KeyValue);
            this.hLookupStringTable.put(tComboBoxCollObj.KeyValue, tComboBoxCollObj.Value);
        }
        TActivityLogWriter.getConsoleSettings();
    }

    public void dispose() {
        this.flushBuffer();
        try {
            this.F.close();
        }
        catch (Exception exception) {
            System.out.println("Error closing log file: " + exception.toString());
        }
    }

    public static TConsoleSettings getConsoleSettings() {
        if (ConsoleSettings == null) {
            ConsoleSettings = new TConsoleSettings();
            ConsoleSettings.readFromFile();
        }
        return ConsoleSettings;
    }

    public static void readConsoleSettings() {
        if (ConsoleSettings != null) {
            ConsoleSettings.readFromFile();
        }
    }

    public String dumpState(String string, String string2) {
        if (this.bDumpingStats) {
            return "";
        }
        Date date = new Date();
        if (date.getTime() - this.tmLastDump < 15000L) {
            return "";
        }
        this.tmLastDump = date.getTime();
        this.bDumpingStats = true;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "gw(\"K4Ui6j3Y1rwlvukPkOqn25Em\",\"Notification Container\",\"154388\",\"action=getServerStats\")";
        String string4 = (String)new TFormulaEvaluator().getFormulaValue(string3);
        TCacheWidget.initializeWidgetContainer();
        stringBuilder.append("<!--!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"-->");
        stringBuilder.append("<html>");
        stringBuilder.append("<head>");
        stringBuilder.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=Edge;chrome=1\" >");
        stringBuilder.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        stringBuilder.append("<meta name=\"viewport\" content=\"user-scalable=yes,width=device-width,height=device-height,initial-scale=1.0,maximum-scale=6.0,minimum-scale=1.0\"/>");
        stringBuilder.append("<style>");
        stringBuilder.append(TCacheWidget.sStylesheet2012[0]);
        stringBuilder.append("</style>");
        stringBuilder.append("<script>");
        stringBuilder.append(TCacheWidget.sJavascript2012);
        stringBuilder.append("</script>");
        stringBuilder.append("</head>");
        stringBuilder.append("<body>");
        stringBuilder.append("<h1>State: " + string2 + "</h1>");
        stringBuilder.append(string4);
        stringBuilder.append("</body>");
        stringBuilder.append("</html>");
        String string5 = this.Application.getHomeDir() + "aspectlogs/state/";
        new File(string5).mkdirs();
        String string6 = string5 + "state_" + this.dateFormat2.format(new Date()) + ".html";
        Boolean bl = (Boolean)new TFormulaEvaluator().getFormulaValue("isPackageLoaded(\"Aspect_Support\")");
        if (!bl.booleanValue()) {
            string6 = string5 + "state_" + this.dateFormat3.format(new Date()) + ".html";
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string6, "rwd");
            randomAccessFile.writeBytes(stringBuilder.toString());
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Error writing activity log state: " + exception.toString());
        }
        this.bDumpingStats = false;
        return string6;
    }

    public synchronized int getRecordCount() {
        int n = 0;
        this.flushBuffer();
        try {
            this.F.seek(0L);
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[8192];
            do {
                n3 = this.F.read(byArray, 0, byArray.length);
                for (int i = 0; i < n3; ++i) {
                    if (byArray[i] != 10) continue;
                    ++n;
                }
                n2 += n3;
            } while (n3 > 0);
        }
        catch (Exception exception) {
            System.out.println("Error in log getRecordCount: " + exception.toString());
        }
        return n;
    }

    public synchronized long getRecordIndex(int n) {
        if (n == 0) {
            return 0L;
        }
        int n2 = 0;
        this.flushBuffer();
        try {
            this.F.seek(0L);
            int n3 = 0;
            int n4 = 0;
            byte[] byArray = new byte[8192];
            do {
                n4 = this.F.read(byArray, 0, byArray.length);
                for (int i = 0; i < n4; ++i) {
                    if (byArray[i] == 10) {
                        ++n2;
                    }
                    if (n2 != n) continue;
                    return n3 + i + 1;
                }
                n3 += n4;
            } while (n4 > 0);
        }
        catch (Exception exception) {
            System.out.println("Error in getRecordIndex: " + exception.toString());
        }
        return 0L;
    }

    public synchronized void flushBuffer() {
        this.TimeLastFlush = new Date().getTime();
        if (this.LogBuffer.length() == 0) {
            return;
        }
        String string = charutil.replaceAllSubstrings(this.LogBuffer.toString(), ",\"\",", ",,");
        try {
            this.F.seek(this.F.length());
            this.F.writeBytes(string);
        }
        catch (Exception exception) {
            System.out.println("Error writing to log file: " + exception.toString());
        }
        this.LogBuffer.setLength(0);
    }

    public synchronized boolean clear() {
        this.flushBuffer();
        try {
            this.F.setLength(0L);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public synchronized String getStringForLog(String string) {
        if (string == null) {
            return "";
        }
        if (string.trim().length() == 0) {
            return string.trim();
        }
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance();
            if (this.numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)this.numberFormat).applyPattern("0000");
            }
        }
        if (this.hStringTable.containsKey(string.toUpperCase())) {
            int n = charutil.ival((String)this.hStringTable.get(string.toUpperCase()));
            return "~" + this.numberFormat.format(n);
        }
        return string;
    }

    public synchronized void appendToLog(String string, String string2, Thread thread, Throwable throwable, int n, String string3, String string4, String string5, int n2, boolean bl, String string6, int n3, int n4, String string7, int n5, String string8, String string9, int n6, int n7, String string10, String string11, String string12, int n8, String string13, String string14, String string15, String string16, int n9, String string17, String string18, String string19, String string20) {
        File file;
        StringBuilder stringBuilder;
        char c;
        if (this.F == null) {
            return;
        }
        if ((n == 3 || n == 4 || n == 10) && string3.equals(this.LastMsg)) {
            return;
        }
        this.LastMsg = string3;
        if (!this.MainWin.isRunningOnServer() && !this.MainWin.isDevelopmentMode()) {
            try {
                if (this.F.length() > (long)iMaxLogSize) {
                    System.out.println("Aborting write to activity log because size has exceeded " + iMaxLogSize);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Runtime runtime = Runtime.getRuntime();
        StringBuilder stringBuilder2 = new StringBuilder(string3);
        StringBuilder stringBuilder3 = new StringBuilder(string7);
        StringBuilder stringBuilder4 = new StringBuilder("");
        StringBuilder stringBuilder5 = new StringBuilder(string12);
        if (throwable != null) {
            stringBuilder4.append(throwable.toString());
        }
        charutil.remove_char(stringBuilder2, stringBuilder2, '\r');
        charutil.remove_char(stringBuilder3, stringBuilder3, '\r');
        charutil.remove_char(stringBuilder4, stringBuilder4, '\r');
        charutil.remove_char(stringBuilder5, stringBuilder5, '\r');
        charutil.remove_char(stringBuilder2, stringBuilder2, '\n');
        charutil.remove_char(stringBuilder3, stringBuilder3, '\n');
        charutil.remove_char(stringBuilder4, stringBuilder4, '\n');
        charutil.remove_char(stringBuilder5, stringBuilder5, '\n');
        charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, "\"", "'");
        charutil.replaceAllSubstrings(stringBuilder3, stringBuilder3, "\"", "'");
        charutil.replaceAllSubstrings(stringBuilder4, stringBuilder4, "\"", "'");
        charutil.replaceAllSubstrings(stringBuilder5, stringBuilder5, "\"", "'");
        int n10 = 0;
        while (n10 < stringBuilder5.length()) {
            c = stringBuilder5.charAt(n10);
            if (c < ' ' || c > '~') {
                stringBuilder5.deleteCharAt(n10);
                continue;
            }
            ++n10;
        }
        if (stringBuilder2.length() > 4096) {
            stringBuilder2.delete(4096, stringBuilder2.length());
        }
        if (stringBuilder3.length() > 4096) {
            stringBuilder3.delete(4096, stringBuilder3.length());
        }
        if (stringBuilder5.length() > 512) {
            stringBuilder5.delete(512, stringBuilder5.length());
        }
        charutil.replaceAllSubstrings(stringBuilder3, stringBuilder3, "(", "&#40;");
        charutil.replaceAllSubstrings(stringBuilder3, stringBuilder3, ")", "&#42;");
        charutil.replaceAllSubstrings(stringBuilder5, stringBuilder5, ")", "&#42;");
        c = '\u0001';
        if (ConsoleSettings != null) {
            c = (char)(ConsoleSettings.shouldShow(string, string2, thread, throwable, n, string3, string5) ? 1 : 0);
        }
        while (stringBuilder2.length() > 0 && stringBuilder2.charAt(0) == '\n') {
            stringBuilder2.deleteCharAt(0);
        }
        if (!TMainWin.IsClosing && n != 11) {
            stringBuilder = new StringBuilder();
            if (throwable != null) {
                stringBuilder.append(" [Exception: " + throwable.toString() + "] ");
            }
            if (n == 15) {
                stringBuilder.append("[start] ");
            }
            if (n == 16) {
                stringBuilder.append("[end] ");
            }
            if (n == 13) {
                stringBuilder.append("[start] ");
            }
            if (n == 14) {
                stringBuilder.append("[end] ");
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            if (string.equalsIgnoreCase("TExecScript") && string2.equalsIgnoreCase("run") && string5.length() > 0) {
                c = '\u0000';
            }
            if (c != '\u0000') {
                String string21 = "";
                string21 = thread != null ? "Thread: " + thread.getName() : (string5.length() > 0 ? "Task: " + string5 : "Script: " + string6);
                while (string21.length() < 70) {
                    string21 = string21 + " ";
                }
                string21 = string21.substring(0, 70);
                if (stringBuilder.length() > 128) {
                    stringBuilder.setLength(128);
                }
                System.out.println("[" + dateutil.formatDate(new Date(), "HH:mm:ss") + "] [" + Thread.activeCount() + "]\t" + string21 + "\t" + stringBuilder.toString());
            }
        }
        while (stringBuilder2.length() > 0 && stringBuilder2.charAt(0) == '\t') {
            stringBuilder2.deleteCharAt(0);
        }
        this.LogBuffer.append(TPasswordService.generateSalt(8) + ",");
        this.LogBuffer.append(new Date().getTime() + ",");
        this.LogBuffer.append((int)(runtime.totalMemory() / 1000L) + ",");
        this.LogBuffer.append((int)(runtime.freeMemory() / 1000L) + ",");
        if (thread != null) {
            stringBuilder = new StringBuilder(thread.getName());
            int n11 = stringBuilder.indexOf("&", 0);
            if (n11 > 0) {
                stringBuilder.delete(n11, stringBuilder.length());
            }
            if (stringBuilder.length() > 6 && stringBuilder.charAt(5) == '_') {
                stringBuilder.delete(0, 6);
            }
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "\"", "'");
            this.LogBuffer.append("\"" + this.getStringForLog(stringBuilder.toString()) + "\",");
        } else {
            this.LogBuffer.append(",");
        }
        this.LogBuffer.append("\"" + this.getStringForLog(string) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(string2) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(stringBuilder4.toString()) + "\",");
        this.LogBuffer.append(n + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(stringBuilder2.toString()) + "\",");
        this.LogBuffer.append((int)(runtime.maxMemory() / 1000L) + ",");
        this.LogBuffer.append(Thread.activeCount() + ",");
        this.LogBuffer.append(TExecScript.countScripts() + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(string5) + "\",");
        this.LogBuffer.append(n2 + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(string4) + "\",");
        this.LogBuffer.append(Boolean.toString(bl).charAt(0) + ",");
        if (TFormulaEvaluator.SocketQueue != null) {
            this.LogBuffer.append(TFormulaEvaluator.SocketQueue.getQueueCount() + ",");
        } else {
            this.LogBuffer.append("0,");
        }
        this.LogBuffer.append(n4 + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(stringBuilder3.toString()) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(charutil.removeQuotes(string6)) + "\",");
        this.LogBuffer.append(n3 + ",");
        this.LogBuffer.append(n5 + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(string8) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(string9) + "\",");
        this.LogBuffer.append(n6 + ",");
        this.LogBuffer.append(n7 + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(string10) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(string11) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(stringBuilder5.toString()) + "\",");
        this.LogBuffer.append(n8 + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(string13) + "\",");
        int n12 = 0;
        if (string13.length() > 0 && (file = new File(string13)).exists()) {
            n12 = (int)file.length();
        }
        this.LogBuffer.append(n12 + ",");
        this.LogBuffer.append("\"" + this.getStringForLog(string14) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(string15) + "\",");
        this.LogBuffer.append("\"" + this.getStringForLog(string16) + "\",");
        this.LogBuffer.append(n9 + ",");
        this.LogBuffer.append("\"" + string17.substring(0, Math.min(string17.length(), 4)) + "\",");
        this.LogBuffer.append("\"" + string18.substring(0, Math.min(string18.length(), 4)) + "\",");
        this.LogBuffer.append("\"" + string19.substring(0, Math.min(string19.length(), 4)) + "\",");
        this.LogBuffer.append("\"" + string20.substring(0, Math.min(string20.length(), 4)) + "\"");
        this.LogBuffer.append("\r\n");
        if (throwable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintWriter(byteArrayOutputStream, true));
            StringBuilder stringBuilder6 = new StringBuilder();
            stringBuilder6.append(byteArrayOutputStream.toString());
            charutil.remove_char(stringBuilder6, stringBuilder6, '\t');
            charutil.remove_char(stringBuilder6, stringBuilder6, '\n');
            String[] stringArray = charutil.getSubStringArray(stringBuilder6, '\r', false);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith("at java.awt.EventDispatchThread") || stringArray[i].startsWith("at java.awt.EventQueue") || stringArray[i].startsWith("at java.awt.event.InvocationEvent")) continue;
                    this.appendToLog(string, string2, thread, null, n, stringArray[i], string4, string5, n2, bl, string6, n3, n4, string7, 0, string8, string9, n6, n7, string10, string11, string12, n8, string13, string14, string15, string16, n9, "", "", "", "");
                }
            }
        }
        if (this.LogBuffer.length() > 16384 || new Date().getTime() > this.TimeLastFlush + 10000L) {
            this.flushBuffer();
        }
    }

    public synchronized String convertToken(String string) {
        String string2;
        String string3 = string2 = string.startsWith("~") ? string.substring(1) : string;
        while (string2.startsWith("0")) {
            string2 = string2.substring(1);
        }
        Object v = this.hLookupStringTable.get(string2);
        if (v != null) {
            return (String)v;
        }
        return string;
    }

    public synchronized String getActivityLogContents(int n, String string) {
        int n2;
        Object object;
        this.flushBuffer();
        DateFormat dateFormat = DateFormat.getInstance();
        ((SimpleDateFormat)dateFormat).applyPattern("HH:mm:ss:SSS");
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n < 0 ? this.ActivityLogStartIndex - 1 : n;
        int n4 = this.getRecordCount();
        n3 = Math.max(n3, n4 - 250);
        if (n3 < 0) {
            n3 = 0;
        }
        long l = this.getRecordIndex(n3);
        try {
            object = new byte[(int)(this.F.length() - l)];
            this.F.seek(l);
            int n5 = this.F.read((byte[])object, 0, ((byte[])object).length);
            for (n2 = 0; n2 < n5; ++n2) {
                stringBuilder.append((char)object[n2]);
            }
        }
        catch (Exception exception) {
            System.out.println("Error in getActivityLogContents: " + exception.toString());
        }
        object = new StringBuilder();
        String[] stringArray = charutil.getSubStringArray(stringBuilder, '\n', false);
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                int n6;
                int n7;
                String[] stringArray2 = charutil.getSubStringArray(stringArray[n2], ',', true);
                if (stringArray2 == null) continue;
                Date date = new Date(charutil.lval(stringArray2[1]));
                String string2 = stringArray2[9];
                if (string2.startsWith("~")) {
                    string2 = (String)this.hLookupStringTable.get(string2);
                }
                if (string2 == null) {
                    string2 = "";
                }
                int n8 = charutil.ival(stringArray2[8]);
                int n9 = charutil.ival(stringArray2[18]);
                String string3 = stringArray2[19];
                if (string3.startsWith("~")) {
                    string3 = (String)this.hLookupStringTable.get(string3);
                }
                if (string3 == null) {
                    string3 = "";
                }
                if (string3.length() > 0) {
                    string2 = string2 + ": " + string3;
                }
                if ((n7 = string3.toUpperCase().indexOf("&USER-AGENT")) >= 0 && (n6 = string3.indexOf("&", n7 + 1)) >= 0) {
                    string3 = string3.substring(0, n7) + string3.substring(n6);
                }
                if (n8 == 15) {
                    string2 = "[start] " + string2;
                }
                if (n8 == 16) {
                    string2 = "[end " + n9 + "ms] " + string2;
                }
                if (n8 == 13) {
                    string2 = "[start] " + string2;
                }
                if (n8 == 14) {
                    string2 = "[end] " + string2;
                }
                String string4 = stringArray2[4];
                String string5 = stringArray2[5];
                String string6 = stringArray2[6];
                String string7 = stringArray2[13];
                String string8 = stringArray2[20];
                if (string4.startsWith("~")) {
                    string4 = this.convertToken(string4);
                }
                if (string5.startsWith("~")) {
                    string5 = this.convertToken(string5);
                }
                if (string6.startsWith("~")) {
                    string6 = this.convertToken(string6);
                }
                if (string7.startsWith("~")) {
                    string7 = this.convertToken(string7);
                }
                if (string8.startsWith("~")) {
                    string8 = this.convertToken(string8);
                }
                if (string4 == null) {
                    string4 = "";
                }
                if (string5 == null) {
                    string5 = "";
                }
                if (string6 == null) {
                    string6 = "";
                }
                if (string7 == null) {
                    string7 = "";
                }
                if (string8 == null) {
                    string8 = "";
                }
                String string9 = "";
                if (string4.length() > 0) {
                    string9 = "Thread: " + string4;
                } else if (string7.length() > 0) {
                    string9 = "Task: " + string7;
                } else if (string8.length() > 0) {
                    string9 = "Script: " + string8;
                }
                string9 = charutil.replaceChar(string4, '%', ' ');
                string9 = charutil.replaceChar(string4, '%', ' ');
                if (string9.trim().length() == 0) {
                    System.out.println("sThreadName=" + string4 + " sTaskName=" + string7 + " sScriptID=" + string8 + " s1=" + string9);
                    System.out.println("arRecords[i]=" + stringArray[n2]);
                }
                if (string.equals("0")) {
                    string2 = charutil.replaceChar(string2, '\t', ' ');
                    string2 = charutil.replaceChar(string2, '\n', ' ');
                    ((StringBuilder)object).append(dateFormat.format(date) + "\t" + stringArray2[3] + "\t" + stringArray2[11] + "\t" + string9 + "\t" + string2 + "\n");
                    continue;
                }
                if (this.ConsoleSettingsForView == null) {
                    this.ConsoleSettingsForView = new TConsoleSettings();
                }
                if (!this.ConsoleSettingsForView.LastFilterIDRead.equalsIgnoreCase(string) || new Date().getTime() - this.ConsoleSettingsForViewLastRead > 120000L) {
                    this.ConsoleSettingsForView.readFromFile(string);
                    this.ConsoleSettingsForViewLastRead = new Date().getTime();
                }
                if (!this.ConsoleSettingsForView.shouldShow(string5, string6, string4, null, n8, string2, string7)) continue;
                string2 = charutil.replaceChar(string2, '\t', ' ');
                string2 = charutil.replaceChar(string2, '\n', ' ');
                ((StringBuilder)object).append(dateFormat.format(date) + "\t" + stringArray2[3] + "\t" + stringArray2[11] + "\t" + string9 + "\t" + string2 + "\n");
            }
        }
        if (((StringBuilder)object).length() == 0) {
            return "";
        }
        return Integer.toString(n4 - 1) + "," + ((StringBuilder)object).toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("open driver");
        TActivityLogWriter tActivityLogWriter = new TActivityLogWriter(new Date());
        System.out.println("Records=" + tActivityLogWriter.getRecordCount());
        System.out.println("Record1 offset=" + tActivityLogWriter.getRecordIndex(1));
        System.out.println("getcontent=");
        System.out.println(tActivityLogWriter.getActivityLogContents(tActivityLogWriter.getRecordCount() - 5, ""));
        System.out.println("dispose driver");
        tActivityLogWriter.dispose();
    }
}

