/*
 * Decompiled with CFR 0.152.
 */
package aspect;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.nio.channels.IllegalBlockingModeException;
import utility.TFormulaEvaluator;
import utility.charutil;

public class TMultipleInstanceCheck
extends Thread {
    private static boolean Debug = false;
    private static int ListenOnPort = 13715;
    private int ListeningOnPort = -1;
    private boolean Initialized = false;
    private boolean ExitThread = false;

    public TMultipleInstanceCheck() {
        super("TMultipleInstanceCheck");
        this.setPriority(1);
    }

    public void dispose() {
        this.ExitThread = true;
    }

    public int getListeningOnPort() {
        return this.ListeningOnPort;
    }

    public DatagramSocket createSocket() {
        DatagramSocket datagramSocket = null;
        int n = ListenOnPort;
        boolean bl = false;
        DatagramPacket datagramPacket = new DatagramPacket(new byte[16], 16);
        do {
            try {
                datagramSocket = new DatagramSocket(n, InetAddress.getLocalHost());
                bl = true;
            }
            catch (Exception exception) {
                Aspect.MainWin.appendToLog("TMainWin", "isHomeDirectoryValid", Thread.currentThread(), exception, 4, "Could not open socket on port: " + n + " " + exception.toString());
                ++n;
            }
        } while (!bl && n < ListenOnPort + 10);
        return datagramSocket;
    }

    public int countInstances() {
        DatagramSocket datagramSocket;
        int n = ListenOnPort;
        byte[] byArray = "Aspect".getBytes();
        try {
            datagramSocket = new DatagramSocket(this.ListeningOnPort + 10);
            datagramSocket.setSoTimeout(100);
        }
        catch (Exception exception) {
            return -1;
        }
        int n2 = 1;
        do {
            if (n == this.ListeningOnPort) continue;
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), n);
                datagramSocket.send(datagramPacket);
                DatagramPacket datagramPacket2 = new DatagramPacket(new byte[1024], 1024);
                datagramSocket.receive(datagramPacket2);
                String string = new String(datagramPacket2.getData(), 0, datagramPacket2.getLength());
                if (string.equalsIgnoreCase("Aspect Loader")) {
                    System.out.println("Excluding loader from instance count");
                    continue;
                }
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (++n < ListenOnPort + 10);
        datagramSocket.close();
        return n2;
    }

    public String sendLocalMessage(String string, boolean bl, int n, boolean bl2) {
        DatagramSocket datagramSocket;
        if (Debug) {
            System.out.println("Sending packet to port " + ListenOnPort);
        }
        byte[] byArray = string.getBytes();
        try {
            datagramSocket = new DatagramSocket(this.ListeningOnPort + 10);
            datagramSocket.setSoTimeout(n);
        }
        catch (Exception exception) {
            return "error: " + exception.toString();
        }
        String string2 = "";
        for (int i = ListenOnPort; i < ListenOnPort + 10; ++i) {
            if (!bl2 && i == this.ListeningOnPort) continue;
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), i);
                datagramSocket.send(datagramPacket);
                if (!bl) continue;
                DatagramPacket datagramPacket2 = new DatagramPacket(new byte[1024], 1024);
                datagramSocket.receive(datagramPacket2);
                if (string2.length() > 0) {
                    string2 = string2 + "|";
                }
                string2 = string2 + new String(datagramPacket2.getData(), 0, datagramPacket2.getLength());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        datagramSocket.close();
        return string2;
    }

    boolean isInitialized() {
        return this.Initialized;
    }

    @Override
    public void run() {
        DatagramSocket datagramSocket;
        TMainWin tMainWin = Aspect.MainWin;
        DatagramPacket datagramPacket = new DatagramPacket(new byte[1024], 1024);
        try {
            datagramSocket = this.createSocket();
            this.Initialized = true;
            if (datagramSocket == null) {
                return;
            }
            this.ListeningOnPort = datagramSocket.getLocalPort();
            datagramSocket.setSoTimeout(1000);
            tMainWin.appendToLog("TMultipleInstanceCheck", "run", Thread.currentThread(), null, 3, "Opened instance check on port: " + this.ListeningOnPort);
        }
        catch (Exception exception) {
            tMainWin.appendToLog("TMainWin", "isHomeDirectoryValid", Thread.currentThread(), exception, 4, "Error opening instance check: " + exception.toString());
            return;
        }
        do {
            boolean bl = false;
            String string = null;
            try {
                datagramSocket.receive(datagramPacket);
                string = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                Thread.yield();
                if (Math.random() < 0.1) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (PortUnreachableException portUnreachableException) {
                this.ExitThread = true;
            }
            catch (IOException iOException) {
            }
            catch (IllegalBlockingModeException illegalBlockingModeException) {
                // empty catch block
            }
            if (string != null && !this.ExitThread) {
                byte[] byArray;
                Object object;
                InetAddress inetAddress = datagramPacket.getAddress();
                int n = datagramPacket.getPort();
                if ((string = charutil.removeQuotes(string)).startsWith("=")) {
                    System.out.println("Msg=" + string);
                    object = new TFormulaEvaluator().getFormulaValue(string, -1, -1);
                    byArray = TFormulaEvaluator.convertToString(object).getBytes();
                } else {
                    byArray = datagramPacket.getData();
                }
                try {
                    object = new DatagramPacket(byArray, 0, byArray.length, new InetSocketAddress(inetAddress, n));
                    datagramSocket.send((DatagramPacket)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!TMainWin.IsClosing) continue;
            datagramSocket.close();
            System.exit(0);
        } while (!this.ExitThread);
        datagramSocket.close();
        if (Debug) {
            System.out.println("Multiple instance check complete");
        }
    }
}

