/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCache;
import cache.TCacheObj;
import cache.TCacheServerInfo;
import cache.TRawWidgetGetter;
import cache.TRawWidgetGetterObj;
import cache.TWidgetContainer;
import collections.TComboBoxColl;
import controls.htmlviewer.THtmlContent;
import drivers.aspect.TDriverDisplay;
import drivers.files.TBinaryFile;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dosutil;
import utility.notifications.TNotification;
import utility.security.TPasswordService;
import utility.session.TSession;
import utility.session.TSessionObj;

public class TCacheWidget {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    TCacheObj CacheObj;
    private static TBinaryFile drvWidgetMetadata = null;
    private static Boolean IsSupport = null;
    private static String[] sContainerWidget = null;
    public static String[] sStylesheet2012 = null;
    public static String sJavascript2012 = null;
    private static String sCalendarJs = null;
    private static boolean bContainerInitialized = false;
    private static String LeftBarContent_Support = null;
    private static String LeftBarContent_Deployed = null;
    private static String LeftBarContent_Support2015 = null;
    private static String LeftBarContent_Deployed2015 = null;
    private static String TopBarContent_Support = null;
    private static String TopBarContent_Deployed = null;
    private static String TopBarContent_Support_Mobile = null;
    private static String TopBarContent_Deployed_Mobile = null;
    private static String TopBarContent_Support2015 = null;
    private static String TopBarContent_Deployed2015 = null;
    private static String TopBarContent_Support_Mobile2015 = null;
    private static String TopBarContent_Deployed_Mobile2015 = null;
    private static int TrackItCounter = 0;
    private static String TrackItID = "";

    public TCacheWidget(TCacheObj tCacheObj) {
        this.CacheObj = tCacheObj;
    }

    private static boolean isSupport() {
        if (IsSupport == null) {
            IsSupport = (Boolean)new TFormulaEvaluator().getFormulaValue("isPackageLoaded(\"Aspect_Support\")");
        }
        return IsSupport;
    }

    private static void openWidgetMetadata() {
        block2: {
            TAppDriversObject tAppDriversObject = TCacheWidget.Application.AppDrivers.getAppDriversObject("Widget_Library_Metadata");
            drvWidgetMetadata = new TBinaryFile(TMainWin.Application, tAppDriversObject, 0, false);
            try {
                drvWidgetMetadata.makeEditableFile();
            }
            catch (Exception exception) {
                if (!TCacheObj.DebugCache) break block2;
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal error opening widget metadata");
            }
        }
    }

    public static TBinaryFile getWidgetMetadataDriver() {
        if (drvWidgetMetadata == null) {
            TCacheWidget.openWidgetMetadata();
        }
        return drvWidgetMetadata;
    }

    public static String replaceTokens(String string) {
        string = charutil.replaceAllSubstrings(string, "\\\\crlf\\\\", "\r\n");
        string = charutil.replaceAllSubstrings(string, "\\\\tab\\\\", "\t");
        string = charutil.replaceAllSubstrings(string, "\\\\quot\\\\", "\"");
        string = charutil.replaceAllSubstrings(string, "\\\\plus\\\\", "+");
        string = charutil.replaceAllSubstrings(string, "\\\\comma\\\\", ",");
        string = charutil.replaceAllSubstrings(string, "\\\\apos\\\\", "'");
        string = charutil.replaceAllSubstrings(string, "\\\\amp\\\\", "&");
        string = charutil.replaceAllSubstrings(string, "\\\\power\\\\", "^");
        string = charutil.replaceAllSubstrings(string, "\\\\pound\\\\", "#");
        string = charutil.replaceAllSubstrings(string, "\\\\percent\\\\", "%");
        string = charutil.replaceAllSubstrings(string, "//crlf//", "\r\n");
        string = charutil.replaceAllSubstrings(string, "//tab//", "\t");
        string = charutil.replaceAllSubstrings(string, "//quot//", "\"");
        string = charutil.replaceAllSubstrings(string, "//plus//", "+");
        string = charutil.replaceAllSubstrings(string, "//comma//", ",");
        string = charutil.replaceAllSubstrings(string, "//apos//", "'");
        string = charutil.replaceAllSubstrings(string, "//amp//", "&");
        string = charutil.replaceAllSubstrings(string, "//power//", "^");
        string = charutil.replaceAllSubstrings(string, "//pound//", "#");
        string = charutil.replaceAllSubstrings(string, "//percent//", "%");
        string = charutil.replaceAllSubstrings(string, "{{pipe{{", "|");
        string = charutil.replaceAllSubstrings(string, "~~pipe~~", "|");
        return string;
    }

    public static boolean isMobileWidget(String string, String string2) {
        TComboBoxColl tComboBoxColl = TCacheWidget.Application.AppCollections.getCollection("Widget_Target_Device", null, null, false, "", "");
        if (tComboBoxColl != null) {
            Object object = tComboBoxColl.getValueOfKey(string + "_" + string2);
            if (object != null) {
                System.out.println("isMobileWidget(" + string + "," + string2 + ") value = " + (String)object);
                return ((String)object).toUpperCase().startsWith("MOBILE");
            }
            MainWin.appendToLog("TCacheWidget", "isMobileWidget", Thread.currentThread(), null, 4, "isMobileWidget cannot locate widget DocumentID=" + string + " Widget=" + string2);
        } else {
            MainWin.appendToLog("TCacheWidget", "isMobileWidget", Thread.currentThread(), null, 4, "isMobileWidget cannot get collection: Widget_Target_Device");
        }
        return false;
    }

    public static String getText(String string, String string2, boolean bl, String string3, String string4, boolean bl2, String string5) {
        int n;
        String string6 = Application.getHomeDir() + "cache/" + "widgetEdit_" + string + "_" + string2 + ".html";
        if (new File(string6).exists()) {
            String string7 = TAsciiInput.getEntireFile(string6);
            if (bl2) {
                THtmlContent tHtmlContent = new THtmlContent(TCacheWidget.replaceTokens(string7), false);
                string7 = tHtmlContent.getProcessedContent(string5, false).trim();
            }
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getText: Returning " + string7.length() + " bytes for " + string2);
            }
            return string7;
        }
        if (drvWidgetMetadata == null) {
            TCacheWidget.openWidgetMetadata();
        }
        String string8 = "((Library_ID=\"" + string + "\") and (Name=\"" + string2 + "\"))";
        if (bl) {
            String string9 = string + "_" + string2 + string3;
            string8 = "(MetaData=\"" + string9 + "\") and (Name=\"" + string9 + string4 + "\")";
        }
        drvWidgetMetadata.clearBuffer();
        int n2 = drvWidgetMetadata.getMatchingRecord(string8, 0);
        if (n2 >= 0) {
            int n3 = (Integer)drvWidgetMetadata.getField("offset", n2);
            n = (Integer)drvWidgetMetadata.getField("size", n2);
            if (n > 0) {
                String string10 = TAsciiInput.getEntireFile(Application.getHomeDir() + "cache/widgetlib_" + string).substring(n3, n3 + n);
                string10 = TCacheWidget.replaceTokens(string10);
                if (bl2) {
                    THtmlContent tHtmlContent = new THtmlContent(string10, false);
                    string10 = tHtmlContent.getProcessedContent(string5, false).trim();
                }
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getText: Found widget in metadata.  Returning " + string10.length() + " bytes for " + string2);
                }
                return string10;
            }
        }
        if (new File(string6 = Application.getHomeDir() + "cache/widgetlib_" + string).exists()) {
            String string11 = TAsciiInput.getEntireFile(string6);
            n = string11.toUpperCase().indexOf("<WIDGET NAME=\"" + string2.toUpperCase());
            if (n >= 0) {
                int n4 = string11.toUpperCase().indexOf("</WIDGET", n);
                string11 = string11.substring(n, n4);
                string11 = string11.substring(string11.indexOf(">") + 1);
                string11 = TCacheWidget.replaceTokens(string11);
                if (bl2) {
                    THtmlContent tHtmlContent = new THtmlContent(string11, false);
                    string11 = tHtmlContent.getProcessedContent(string5, false).trim();
                }
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCacheWidget", "getText", Thread.currentThread(), null, 10, "TCacheWidget.getText got widget from cache. Returning " + string11.length() + " bytes for " + string2);
                }
                return string11;
            }
            MainWin.appendToLog("TCacheWidget", "getText", Thread.currentThread(), null, 10, "TCacheWidget.getText cannot locate text in cache for widget named " + string2 + " in document " + string);
        }
        MainWin.appendToLog("TCacheWidget", "getText", Thread.currentThread(), null, 10, "TCacheWidget.getText cannot locate cache file for widget named " + string2 + " in document " + string);
        return "";
    }

    public static String getText2(String string, String string2) {
        int n;
        String string3 = Application.getHomeDir() + "cache/" + "widgetEdit_" + string + "_" + string2 + ".html";
        if (new File(string3).exists()) {
            String string4 = TAsciiInput.getEntireFile(string3);
            return string4;
        }
        if (drvWidgetMetadata == null) {
            TCacheWidget.openWidgetMetadata();
        }
        String string5 = "((Library_ID=\"" + string + "\") and (Name=\"" + string2 + "\"))";
        drvWidgetMetadata.clearBuffer();
        int n2 = drvWidgetMetadata.getMatchingRecord(string5, 0);
        if (n2 >= 0) {
            int n3 = (Integer)drvWidgetMetadata.getField("offset", n2);
            n = (Integer)drvWidgetMetadata.getField("size", n2);
            if (n > 0) {
                String string6 = TAsciiInput.getEntireFile(Application.getHomeDir() + "cache/widgetlib_" + string).substring(n3, n3 + n);
                return string6;
            }
        }
        if (new File(string3 = Application.getHomeDir() + "cache/widgetlib_" + string).exists()) {
            String string7 = TAsciiInput.getEntireFile(string3);
            n = string7.toUpperCase().indexOf("<WIDGET NAME=\"" + string2.toUpperCase());
            if (n >= 0) {
                int n4 = string7.toUpperCase().indexOf("</WIDGET", n);
                string7 = string7.substring(n, n4);
                string7 = string7.substring(string7.indexOf(">") + 1);
                string7 = TCacheWidget.replaceTokens(string7);
                return string7;
            }
            MainWin.appendToLog("TCacheWidget", "getText", Thread.currentThread(), null, 10, "TCacheWidget.getText cannot locate text in cache for widget named " + string2 + " in document " + string);
        }
        MainWin.appendToLog("TCacheWidget", "getText", Thread.currentThread(), null, 10, "TCacheWidget.getText cannot locate cache file for widget named " + string2 + " in document " + string);
        return "";
    }

    public static void resetContainer() {
        System.out.println("Re-initilalized widget containers");
        sContainerWidget = null;
        sStylesheet2012 = null;
        sJavascript2012 = null;
        sCalendarJs = null;
        bContainerInitialized = false;
    }

    public static void initializeWidgetContainer() {
        int n;
        int n2;
        String[] stringArray = new String[]{"Widget Container 2", "javascript 2012", "calendar-js"};
        String[] stringArray2 = new String[]{"K4Ui6j3Y1rwlvukPkOqn25Em", "77NaWu0FhKDKXL7C70JpnKmy", "77NaWu0FhKDKXL7C70JpnKmy"};
        String[] stringArray3 = new String[stringArray.length];
        String string = Application.getHomeDir() + "cache/widgetEdit_";
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray3[n2] = string + stringArray2[n2] + "_" + stringArray[n2] + ".html";
        }
        int n3 = n2 = !bContainerInitialized ? 1 : 0;
        if (n2 == 0) {
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!new File(stringArray3[i]).exists()) continue;
                n2 = 1;
            }
            if (new File(string + "77NaWu0FhKDKXL7C70JpnKmy" + "_stylesheet 2015.html").exists()) {
                n2 = 1;
            }
            if (new File(string + "77NaWu0FhKDKXL7C70JpnKmy" + "_Javascript 2015.html").exists()) {
                n2 = 1;
            }
            if (new File(string + "77NaWu0FhKDKXL7C70JpnKmy" + "_javascript1.html").exists()) {
                n2 = 1;
            }
            if (new File(string + "77NaWu0FhKDKXL7C70JpnKmy" + "_stylesheet.html").exists()) {
                n2 = 1;
            }
        }
        if (n2 == 0) {
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.initializeWidgetContainer: Widget container is up to date.");
            }
            return;
        }
        if (sContainerWidget == null) {
            sContainerWidget = new String[4];
        }
        if (sStylesheet2012 == null) {
            sStylesheet2012 = new String[2];
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.initializeWidgetContainer: Getting content for widget container");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TCacheWidget.getText(stringArray2[0], stringArray[0], false, "", "", false, ""));
        StringBuilder[] stringBuilderArray = new StringBuilder[4];
        THtmlContent tHtmlContent = new THtmlContent(stringBuilder.toString(), false);
        stringBuilderArray[0] = new StringBuilder(tHtmlContent.getProcessedContent("EditContainer=false", false).trim());
        tHtmlContent = new THtmlContent(stringBuilder.toString(), false);
        stringBuilderArray[1] = new StringBuilder(tHtmlContent.getProcessedContent("mobilecontainer=true&EditContainer=false", false).trim());
        if (TCacheWidget.Application.AppCollections.isResourceDefined("Packages_Function_Groups_By_Filename")) {
            tHtmlContent = new THtmlContent(stringBuilder.toString(), false);
            stringBuilderArray[2] = new StringBuilder(tHtmlContent.getProcessedContent("EditContainer=true", false).trim());
            tHtmlContent = new THtmlContent(stringBuilder.toString(), false);
            stringBuilderArray[3] = new StringBuilder(tHtmlContent.getProcessedContent("mobilecontainer=true&EditContainer=true", false).trim());
        } else {
            tHtmlContent = new THtmlContent(stringBuilder.toString(), false);
            stringBuilderArray[2] = new StringBuilder(tHtmlContent.getProcessedContent("EditContainer=false", false).trim());
            tHtmlContent = new THtmlContent(stringBuilder.toString(), false);
            stringBuilderArray[3] = new StringBuilder(tHtmlContent.getProcessedContent("mobilecontainer=true&EditContainer=false", false).trim());
        }
        String string2 = string + "77NaWu0FhKDKXL7C70JpnKmy" + "_stylesheet 2015.html";
        if (new File(string2).exists() || sStylesheet2012[0] == null) {
            String string3 = "DocumentID=77NaWu0FhKDKXL7C70JpnKmy&Widget=Stylesheet 2015&ContainerItemID=804309";
            TCache tCache = TFormulaEvaluator.getCache();
            String string4 = Application.getAspectHashID();
            TFormulaEvaluator.getSessionManager();
            TCacheWidget.sStylesheet2012[0] = tCache.getCachedContent(0, string4, string3, false, "127.0.0.1", "Aspect", TSession.getLocalSession(""), "", "", null);
        }
        int n4 = stringBuilderArray[0].indexOf("<!--insert head elements-->");
        stringBuilderArray[0].insert(n4, "\n<style>\n" + sStylesheet2012[0] + "\n</style>\n");
        n4 = stringBuilderArray[2].indexOf("<!--insert head elements-->");
        stringBuilderArray[2].insert(n4, "\n<style>\n" + sStylesheet2012[0] + "\n</style>\n");
        string2 = string + "77NaWu0FhKDKXL7C70JpnKmy" + "_stylesheet mobile 2012.html";
        if (new File(string2).exists() || sStylesheet2012[1] == null) {
            TCacheWidget.sStylesheet2012[1] = TCacheWidget.getText("77NaWu0FhKDKXL7C70JpnKmy", "stylesheet mobile 2012", false, "", "", true, "");
        }
        n4 = stringBuilderArray[1].indexOf("<!--insert head elements-->");
        stringBuilderArray[1].insert(n4, "\n<style>\n" + sStylesheet2012[1] + "\n</style>\n");
        n4 = stringBuilderArray[3].indexOf("<!--insert head elements-->");
        stringBuilderArray[3].insert(n4, "\n<style>\n" + sStylesheet2012[1] + "\n</style>\n");
        string2 = string + "77NaWu0FhKDKXL7C70JpnKmy" + "_javascript 2015.html";
        if (new File(string2).exists() || sJavascript2012 == null) {
            String string5 = "DocumentID=77NaWu0FhKDKXL7C70JpnKmy&Widget=Javascript 2015&ContainerItemID=370976";
            TCache tCache = TFormulaEvaluator.getCache();
            String string6 = Application.getAspectHashID();
            TFormulaEvaluator.getSessionManager();
            sJavascript2012 = tCache.getCachedContent(0, string6, string5, false, "127.0.0.1", "Aspect", TSession.getLocalSession(""), "", "", null);
        }
        for (n = 0; n < 4; ++n) {
            n4 = stringBuilderArray[n].indexOf("<!--insert head elements-->");
            String string7 = sJavascript2012;
            if (n == 1 || n == 3) {
                string7 = charutil.replaceSubstring(string7, "bIsMobileDevice=false", "bIsMobileDevice=true");
            }
            stringBuilderArray[n].insert(n4, "\n<script language='javascript'>\n" + string7 + "\n</script>\n");
        }
        if (new File(stringArray3[2]).exists() || sCalendarJs == null) {
            sCalendarJs = TCacheWidget.getText(stringArray2[2], stringArray[2], false, "", "", true, "");
        }
        for (n = 0; n < 4; ++n) {
            n4 = stringBuilderArray[n].indexOf("<!--insert head elements-->");
            stringBuilderArray[n].insert(n4, "\n<script language='javascript'>\n" + sCalendarJs + "\n</script>\n");
        }
        for (n = 0; n < 4; ++n) {
            TCacheWidget.sContainerWidget[n] = stringBuilderArray[n].toString();
        }
        bContainerInitialized = true;
    }

    private static String getLeftBarComputer(String string) {
        return charutil.getParamValue(string, "LeftBarComputer", '&');
    }

    private static boolean deployedViewEnabled() {
        return charutil.boolval(Application.getTokenValue("Aspect_Support_Show_Deployed_View"));
    }

    private static String getLeftBarContent(String string) {
        if (TCacheWidget.isSupport() && LeftBarContent_Support == null) {
            LeftBarContent_Support = "<!include type:widget; server:{aspecthashid}; secure:false; documentID:M2HDPGX49Sct3l6etItu5n1J; widget:Support Home; containerItemID:\"left_bar\"; params:\"package={@\"__package__\"}|menu=__menu__|LeftBarCompany=__LeftBarCompany__&LeftBarComputer=__LeftBarComputer__&updateCompanyList=__updateCompanyList__\";>";
        }
        if (LeftBarContent_Deployed == null) {
            LeftBarContent_Deployed = "<!include type:widget; server:{aspecthashid}; secure:false; documentID:h0BE4ziTlLytqKxtWLMy5CVY; widget:Backoffice Home; containerItemID:\"left_bar\"; params:\"package={@\"__package__\"}|menu=__menu__|LeftBarCompany=__LeftBarCompany__&LeftBarComputer=__LeftBarComputer__&updateCompanyList=__updateCompanyList__\";>";
        }
        if (TCacheWidget.isSupport() && !TCacheWidget.deployedViewEnabled()) {
            return LeftBarContent_Support;
        }
        return LeftBarContent_Deployed;
    }

    private static String getTopBarContent(String string, boolean bl) {
        if (bl) {
            if (TCacheWidget.isSupport() && !TCacheWidget.deployedViewEnabled()) {
                if (TopBarContent_Support_Mobile == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Support Home - Mobile.html")) {
                    TopBarContent_Support_Mobile = "<include type:widget; server:{aspecthashid}; secure:false; documentID:M2HDPGX49Sct3l6etItu5n1J; widget:Support Home - Mobile; containerItemID:\"401890\"; params:\"\";>";
                }
                return TopBarContent_Support_Mobile;
            }
            if (TopBarContent_Deployed_Mobile == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Backoffice Home - Mobile.html")) {
                TopBarContent_Deployed_Mobile = "<include type:widget; server:{aspecthashid}; secure:false; documentID:h0BE4ziTlLytqKxtWLMy5CVY; widget:Backoffice Home - Mobile; containerItemID:\"85097\"; params:\"\";>";
            }
            return TopBarContent_Deployed_Mobile;
        }
        if (TCacheWidget.isSupport() && !TCacheWidget.deployedViewEnabled()) {
            if (TopBarContent_Support == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Support Home.html")) {
                TopBarContent_Support = "<include type:widget; server:{aspecthashid}; secure:false; documentID:M2HDPGX49Sct3l6etItu5n1J; widget:Support Home; containerItemID:\"top_bar\"; params:\"\";>";
            }
            return TopBarContent_Support;
        }
        if (TopBarContent_Deployed == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Backoffice Home.html")) {
            TopBarContent_Deployed = "<include type:widget; server:{aspecthashid}; secure:false; documentID:h0BE4ziTlLytqKxtWLMy5CVY; widget:Backoffice Home; containerItemID:\"top_bar\"; params:\"\";>";
        }
        return TopBarContent_Deployed;
    }

    private static String getLeftBarContent2015(String string) {
        if (TCacheWidget.isSupport() && !TCacheWidget.deployedViewEnabled()) {
            if (LeftBarContent_Support2015 == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Support Home 2015.html")) {
                LeftBarContent_Support2015 = "<!include type:widget; server:{aspecthashid}; secure:false; documentID:M2HDPGX49Sct3l6etItu5n1J; widget:Support Home 2015; containerItemID:\"left_bar2015\"; params:\"package={@\"__package__\"}|menu=__menu__|LeftBarCompany=__LeftBarCompany__&LeftBarComputer=__LeftBarComputer__&updateCompanyList=__updateCompanyList__\";>";
            }
            return LeftBarContent_Support;
        }
        if (TopBarContent_Deployed2015 == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Backoffice Home 2015.html")) {
            LeftBarContent_Deployed2015 = "<!include type:widget; server:{aspecthashid}; secure:false; documentID:h0BE4ziTlLytqKxtWLMy5CVY; widget:Backoffice Home 2015; containerItemID:\"left_bar2015\"; params:\"package={@\"__package__\"}|menu=__menu__|LeftBarCompany=__LeftBarCompany__&LeftBarComputer=__LeftBarComputer__&updateCompanyList=__updateCompanyList__\";>";
        }
        return LeftBarContent_Deployed;
    }

    private static String getTopBarContent2015(String string, boolean bl) {
        if (bl) {
            if (TCacheWidget.isSupport() && !TCacheWidget.deployedViewEnabled()) {
                if (TopBarContent_Support_Mobile2015 == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Support Home - Mobile 2015.html")) {
                    TopBarContent_Support_Mobile2015 = "<include type:widget; server:{aspecthashid}; secure:false; documentID:M2HDPGX49Sct3l6etItu5n1J; widget:Support Home - Mobile 2015; containerItemID:\"top_bar2015\"; params:\"\";>";
                }
                return TopBarContent_Support_Mobile;
            }
            if (TopBarContent_Deployed_Mobile2015 == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Backoffice Home - Mobile 2015.html")) {
                TopBarContent_Deployed_Mobile2015 = "<include type:widget; server:{aspecthashid}; secure:false; documentID:h0BE4ziTlLytqKxtWLMy5CVY; widget:Backoffice Home - Mobile 2015; containerItemID:\"top_bar2015\"; params:\"\";>";
            }
            return TopBarContent_Deployed_Mobile;
        }
        if (TCacheWidget.isSupport() && !TCacheWidget.deployedViewEnabled()) {
            if (TopBarContent_Support2015 == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Support Home 2015.html")) {
                TopBarContent_Support2015 = "<include type:widget; server:{aspecthashid}; secure:false; documentID:M2HDPGX49Sct3l6etItu5n1J; widget:Support Home 2015; containerItemID:\"top_bar2015\"; params:\"\";>";
            }
            return TopBarContent_Support;
        }
        if (TopBarContent_Deployed2015 == null || dosutil.fileExists(Application.getHomeDir() + "cache/WidgetEdit_M2HDPGX49Sct3l6etItu5n1J_Backoffice Home 2015.html")) {
            TopBarContent_Deployed2015 = "<include type:widget; server:{aspecthashid}; secure:false; documentID:h0BE4ziTlLytqKxtWLMy5CVY; widget:Backoffice Home 2015; containerItemID:\"top_bar2015\"; params:\"\";>";
        }
        return TopBarContent_Deployed;
    }

    public static String getContent(TCacheObj tCacheObj, TSessionObj tSessionObj, String string, String string2, boolean bl) {
        String[] stringArray;
        Object object;
        int n;
        String string3;
        boolean bl2;
        String[] stringArray2 = charutil.getSubStringArray(tCacheObj.Params, '&', true);
        String string4 = charutil.getParamValue(stringArray2, "DocumentID");
        String string5 = charutil.getParamValue(stringArray2, "Widget");
        boolean bl3 = charutil.boolval(charutil.getParamValue(stringArray2, "EditContainer"));
        boolean bl4 = charutil.boolval(charutil.getParamValue(stringArray2, "Text"));
        boolean bl5 = charutil.boolval(charutil.getParamValue(stringArray2, "isProxyRequest"));
        String string6 = charutil.getParamValue(stringArray2, "Title");
        if (drvWidgetMetadata == null) {
            TCacheWidget.openWidgetMetadata();
        }
        String string7 = "";
        String string8 = "((Library_ID=\"" + string4 + "\") and (Name=\"" + string5 + "\"))";
        String string9 = charutil.getParamValue(stringArray2, "ContainerItemID");
        if (bl) {
            String string10 = charutil.getParamValue(stringArray2, "DriverID");
            String string11 = charutil.getParamValue(stringArray2, "DisplayName");
            bl2 = charutil.boolval(charutil.getParamValue(stringArray2, "Mobile"));
            string3 = charutil.getParamValue(stringArray2, "Metadata").trim();
            if (string3.length() == 0) {
                string3 = TDriverDisplay.getMetadata(string10, string4, string5, string9, bl2);
            }
            string8 = "Name=\"" + string3 + string11 + "\"";
        }
        if (tCacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getContent[" + tCacheObj.ID + "] Filter=" + string8);
        }
        drvWidgetMetadata.clearBuffer();
        int n2 = drvWidgetMetadata.getMatchingRecord(string8, 0);
        boolean bl6 = false;
        if (n2 >= 0) {
            string7 = (String)drvWidgetMetadata.getField("type", n2);
            if (string6.trim().length() == 0) {
                string6 = (String)drvWidgetMetadata.getField("PublicName", n2);
            }
            if (string6.trim().length() == 0) {
                string6 = string5;
            }
            bl6 = (Boolean)drvWidgetMetadata.getField("mobile", n2);
        } else {
            int n3;
            String string12 = Application.getHomeDir() + "cache/widgetlib_" + string4;
            if (new File(string12).exists() && (n3 = (string3 = TAsciiInput.getEntireFile(string12)).toUpperCase().indexOf("<WIDGET NAME=\"" + string5.toUpperCase())) >= 0) {
                n = string3.indexOf(">", n3);
                string3 = string3.substring(n3 + 8, n);
                string7 = charutil.getParamValue(string3, "type", ' ');
            }
        }
        bl2 = string7.equalsIgnoreCase("container");
        if (tCacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getContent[" + tCacheObj.ID + "] WidgetType=" + string7 + " Params: " + tCacheObj.Params + " bEditContainer=" + bl3);
        }
        if (tCacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getContent[" + tCacheObj.ID + "] user-agent=" + string2);
        }
        string3 = tCacheObj.getContent();
        if (bl2 && string9.length() > 0) {
            if (!tCacheObj.isBinary()) {
                string3 = TCacheWidget.replaceTokens(string3);
                string3 = charutil.replaceAllSubstrings(string3, "{{backslash{{", "\\");
                string3 = charutil.replaceAllSubstrings(string3, "~~backslash~~", "\\");
            }
            if (tCacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getContent[" + tCacheObj.ID + "] returning container item " + string9 + " from " + string7 + " widget (" + string3.length() + " bytes) Binary=" + tCacheObj.isBinary());
            }
            return string3;
        }
        if (!bl2) {
            if (!tCacheObj.isBinary()) {
                string3 = TCacheWidget.replaceTokens(string3);
            }
            if (tCacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getContent[" + tCacheObj.ID + "] returning " + string7 + " widget (" + string3.length() + " bytes) Binary=" + tCacheObj.isBinary());
            }
            return string3;
        }
        if (bl4) {
            if (tCacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getContent[" + tCacheObj.ID + "] returning " + string7 + " widget (" + string3.length() + " bytes) as text");
            }
            return string3;
        }
        String string13 = string3.toUpperCase();
        for (n = 0; n < stringArray2.length; ++n) {
            int n4 = stringArray2[n].indexOf(61);
            if (n4 < 0) continue;
            object = "__" + stringArray2[n].substring(0, n4) + "__";
            Object object2 = stringArray = n4 < stringArray2[n].length() - 1 ? stringArray2[n].substring(n4 + 1) : "";
            if (string13.indexOf((String)object) < 0) continue;
            string3 = charutil.replaceAllSubstrings(string3, (String)object, (String)stringArray);
        }
        if (bl5) {
            // empty if block
        }
        if (string3.toUpperCase().indexOf("HEAD CONTAINERPROCESSEDBY") > 0) {
            if (tCacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget.getContent[" + tCacheObj.ID + "] returning processed container content (" + string3.length() + " bytes)");
            }
            return string3;
        }
        TCacheWidget.initializeWidgetContainer();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            if (bl6) {
                stringBuilder.append(sContainerWidget[3]);
            } else {
                stringBuilder.append(sContainerWidget[2]);
            }
        } else if (bl6) {
            stringBuilder.append(sContainerWidget[1]);
        } else {
            stringBuilder.append(sContainerWidget[0]);
        }
        TWidgetContainer tWidgetContainer = new TWidgetContainer(string3);
        object = tCacheObj.getParameters();
        stringArray = charutil.getSubStringArray(string3, '^', true);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n5;
                String string14;
                int n6;
                String string15 = stringArray[i];
                if (string15.startsWith("\r\n")) {
                    string15 = string15.substring(2);
                }
                String[] stringArray3 = charutil.getSubStringArray(string15, '|', true);
                String string16 = charutil.getParamValue(stringArray3, "content_type");
                boolean bl7 = charutil.boolval(charutil.getParamValue(stringArray3, "ProcessContent"));
                String string17 = charutil.getParamValue(stringArray3, "Source").trim();
                String string18 = charutil.getParamValue(stringArray3, "Content");
                String string19 = charutil.getParamValue(stringArray3, "ID");
                if (tCacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] handling container item: " + string19 + " item " + (i + 1) + " of " + stringArray.length);
                }
                if (string19.equalsIgnoreCase("left_bar") && !bl6 && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string18 = TCacheWidget.getLeftBarContent(TCacheWidget.getLeftBarComputer(tCacheObj.Params));
                }
                if (string19.equalsIgnoreCase("top_bar") && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string18 = TCacheWidget.getTopBarContent(TCacheWidget.getLeftBarComputer(tCacheObj.Params), bl6);
                }
                if (string19.equalsIgnoreCase("left_bar2015") && !bl6 && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string18 = TCacheWidget.getLeftBarContent2015(TCacheWidget.getLeftBarComputer(tCacheObj.Params));
                }
                if (string19.equalsIgnoreCase("top_bar2015") && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string18 = TCacheWidget.getTopBarContent2015(TCacheWidget.getLeftBarComputer(tCacheObj.Params), bl6);
                }
                if (string18 == null) {
                    System.out.println("Content=null for ID:" + string19);
                    string18 = "Error getting content2";
                }
                string18 = tWidgetContainer.replaceIncludes(string18, (Hashtable)object);
                string18 = TCacheWidget.replaceTokens(string18);
                string18 = charutil.replaceAllSubstrings(string18, "//quote//", "\"");
                string18 = charutil.replaceAllSubstrings(string18, "\\\\quote\\\\", "\"");
                string18 = charutil.replaceAllSubstrings(string18, "__d__", string4);
                string18 = charutil.replaceAllSubstrings(string18, "__w__", string5);
                string18 = charutil.replaceAllSubstrings(string18, "__i__", string19);
                string18 = charutil.replaceAllSubstrings(string18, "__containertitle__", string6);
                string18 = charutil.replaceAllSubstrings(string18, "__containerargs__", tCacheObj.getParamString('&'));
                string18 = charutil.replaceAllSubstrings(string18, "__parentd__", string4);
                string18 = charutil.replaceAllSubstrings(string18, "__parentw__", string5);
                if (bl7 && (string17.length() == 0 || string17.equalsIgnoreCase(Application.getAspectHashID()))) {
                    Object object3;
                    TCacheObj tCacheObj2 = TFormulaEvaluator.getCache().getCacheObj(6, tCacheObj.HashID, "ProcessedItemID=" + string19 + "&" + tCacheObj.Params);
                    if (tCacheObj2 == null) {
                        tCacheObj2 = TFormulaEvaluator.getCache().addCacheObj(6, tCacheObj.HashID, "ProcessedItemID=" + string19 + "&" + tCacheObj.Params);
                    }
                    n6 = 0;
                    string14 = "Undefined";
                    String string20 = "";
                    int n7 = string18.toUpperCase().indexOf("<STATE>");
                    if (n7 >= 0) {
                        int n8 = string18.toUpperCase().indexOf("</STATE>");
                        if (n8 > n7) {
                            if (tCacheObj.debugCache()) {
                                MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] evaluating state tag");
                            }
                            string14 = string18.substring(n7 + 7, n8);
                            THtmlContent tHtmlContent = new THtmlContent(string14, false);
                            object3 = charutil.removeControlChars(tHtmlContent.getProcessedContent(tCacheObj.Params + "&LastState=" + tCacheObj2.State, true).trim());
                            string20 = Integer.toString(charutil.getHashCode((String)object3, false));
                            boolean bl8 = false;
                            if (string14.toUpperCase().indexOf("DEBUG=TRUE") >= 0) {
                                System.out.println("State: Params=" + tCacheObj.Params);
                                System.out.println("State: State=" + string14);
                                System.out.println("State: StateContent=" + (String)object3);
                                System.out.println("State: StateValue=" + string20);
                                if (string20.equalsIgnoreCase(tCacheObj2.State)) {
                                    System.out.println("State: state has not changed");
                                } else {
                                    System.out.println("State: state has changed");
                                }
                                bl8 = true;
                            }
                            if ((((String)object3).equalsIgnoreCase(tCacheObj2.State) || string20.equalsIgnoreCase(tCacheObj2.State)) && tCacheObj2.contentExists()) {
                                if (tCacheObj.debugCache()) {
                                    MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] state has not changed");
                                }
                                string18 = tCacheObj2.getContent();
                                if (bl8) {
                                    System.out.println("State: got content from cache");
                                }
                                n6 = 1;
                            } else {
                                if (tCacheObj.debugCache()) {
                                    MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] Previous state3: " + tCacheObj2.State);
                                }
                                if (tCacheObj.debugCache()) {
                                    MainWin.appendToLog("TCacheWidget", "ProcessedItem", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] Current state3: " + string20);
                                }
                                if (bl8) {
                                    System.out.println("State: Did not get content from cache");
                                }
                            }
                        } else if (tCacheObj.debugCache()) {
                            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] invalid state tag");
                        }
                    } else if (tCacheObj.debugCache()) {
                        MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] no state tag found[1]");
                    }
                    if (n6 != 0) {
                        tCacheObj2.Last_Access = new Date();
                        ++tCacheObj2.Access_Count;
                        tCacheObj2.writeToDriver(TCache.drvCache, true);
                    } else {
                        long l = new Date().getTime();
                        if (tCacheObj.debugCache()) {
                            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] processing content");
                        }
                        object3 = new THtmlContent(string18, false);
                        string18 = ((THtmlContent)object3).getProcessedContent(tCacheObj.getParamString('&') + "&IsMobileDoc=" + bl6, false);
                        tCacheObj2.setContent(string18, string20);
                        tCacheObj2.Updated = new Date();
                        tCacheObj2.Last_Access = new Date();
                        ++tCacheObj2.Access_Count;
                        tCacheObj2.Processing_Time += (double)(new Date().getTime() - l);
                        ++tCacheObj2.Update_Count;
                        ++tCacheObj2.Update_Called_Count;
                        tCacheObj2.writeToDriver(TCache.drvCache, true);
                        if (tCacheObj.debugCache()) {
                            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] processing content complete");
                        }
                    }
                }
                if (string16.equalsIgnoreCase("javascript") || string16.equalsIgnoreCase("css")) {
                    if (tCacheObj.debugCache()) {
                        MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] adding head elements to container");
                    }
                    string18 = charutil.replaceAllSubstrings(string18, "~~backslash~~", "\\");
                    if (string16.equalsIgnoreCase("javascript")) {
                        string18 = "\n<script language='javascript'>\n" + string18 + "</script>\n";
                    } else if (string16.equalsIgnoreCase("css")) {
                        string18 = "\n<style>\n" + string18 + "</style>\n";
                    }
                    int n9 = stringBuilder.indexOf("<!--insert head elements-->");
                    stringBuilder.insert(n9, string18);
                    if (!bl3) continue;
                    stringBuilder2.append("^" + stringArray[i]);
                    continue;
                }
                stringBuilder2.append("^" + stringArray[i]);
                if (!bl7 || string17.length() != 0 && !string17.equalsIgnoreCase(Application.getAspectHashID())) continue;
                if (tCacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] adding pre-processed divs to container");
                }
                if (stringBuilder.indexOf("<!--insert processed elements-->") < 0 || (n5 = stringArray[i].toUpperCase().indexOf("ID=")) < 0 || (n6 = stringArray[i].indexOf(124, n5)) < 0) continue;
                string14 = stringArray[i].substring(n5 + 3, n6);
                string18 = "<div ID=\"__processed" + string14 + "\" style='display:none'>" + string18 + "</div>\r\n";
                int n10 = stringBuilder.indexOf("<!--insert processed elements-->");
                if (n10 < 0) continue;
                stringBuilder.insert(n10, string18);
            }
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2.deleteCharAt(0);
        }
        string3 = stringBuilder2.toString();
        string3 = charutil.replaceAllSubstrings(string3, "\n", "$$lf$$");
        string3 = charutil.replaceAllSubstrings(string3, "\r", "");
        string3 = charutil.replaceAllSubstrings(string3, "\"", "//quot//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\quot\\\\", "//quot//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\crlf\\\\", "//crlf//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\tab\\\\", "//tab//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\quot\\\\", "//quot//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\plus\\\\", "//plus//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\comma\\\\", "//comma//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\apos\\\\", "//apos//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\amp\\\\", "//amp//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\power\\\\", "//power//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\pound\\\\", "//pound//");
        string3 = charutil.replaceAllSubstrings(string3, "\\\\percent\\\\", "//percent//");
        string3 = charutil.replaceAllSubstrings(string3, "\\", "~~backslash~~");
        string3 = charutil.replaceAllSubstrings(string3, "<", "$$lt$$");
        string3 = charutil.replaceAllSubstrings(string3, ">", "$$gt$$");
        string3 = charutil.replaceAllSubstrings(string3, "//crlf//", "$$wclf$$");
        string3 = charutil.replaceAllSubstrings(string3, "//quot//", "$$wcquot$$");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__d__", string4);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__w__", string5);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__i__", string9);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__containertitle__", string6);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__containerargs__", tCacheObj.getParamString('&'));
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__parentd__", string4);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__parentw__", string5);
        if (!bl5 && string.trim().length() > 0) {
            TCacheServerInfo tCacheServerInfo = new TCacheServerInfo(string);
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__RequestServer__", tCacheServerInfo.getServer());
            System.out.println("TCacheWidget replacing RequestServer with " + tCacheServerInfo.getServer() + " bIsProxyRequest=" + bl5 + " ARemoteIP=" + string);
        }
        if (tSessionObj != null) {
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__Session__", tSessionObj.getID());
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "__ProcessItemHashID__", tCacheObj.HashID);
        StringBuilder stringBuilder3 = new StringBuilder();
        int n11 = 0;
        while (n11 < string3.length()) {
            int n12 = Math.min(n11 + 1024, string3.length());
            stringBuilder3.append("sContainerText+=\"" + string3.substring(n11, n12) + "\";\r\n");
            n11 = n12;
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "/*__ContainerText__*/", stringBuilder3.toString());
        if (tCacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "getContent", Thread.currentThread(), null, 10, "TCacheWidget:getContent[" + tCacheObj.ID + "] returns " + stringBuilder.length() + " bytes");
        }
        return stringBuilder.toString();
    }

    public boolean update(TSessionObj tSessionObj, String string, String string2, boolean bl) {
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget: update RemoteIP=" + string + " User-Agent=" + string2 + " Params=" + this.CacheObj.Params);
        }
        if (bl || this.CacheObj.HashID.equalsIgnoreCase(Application.getAspectHashID())) {
            if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget: Updating locally");
            }
            return this.updateLocal(string, string2, bl);
        }
        return this.updateByNotification(tSessionObj, string, string2);
    }

    private boolean updateByNotification(TSessionObj tSessionObj, String string, String string2) {
        String string3 = TPasswordService.generateSalt(16);
        String string4 = this.CacheObj.Params;
        if ((string4 = string4 + "&user-agent=" + string2 + "&remoteIP=" + string).toUpperCase().indexOf("GET_RUNNING_SCRIPTS") >= 0) {
            if (TrackItID.length() == 0) {
                TrackItID = TPasswordService.generateSalt(4);
            }
            string3 = "DIAG_" + TrackItID + "_" + Integer.toString(++TrackItCounter);
        }
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "updateByNotification", Thread.currentThread(), null, 10, "TCacheWidget:updateByNotification Updating by notification Data=" + string4);
        }
        TNotification tNotification = new TNotification(string3, Application.getAspectHashID(), this.CacheObj.HashID, TNotification.NOTIFICATION_PROXY_WIDGET, string4, -1, "", "", new Date(), TNotification.encryptPassword(), 5);
        String string5 = charutil.getParamValue(string4, "AttachedFilename", '&');
        if (string5.trim().length() > 0) {
            tNotification.setAttachedFilename(string5);
        }
        TFormulaEvaluator.getNotificationClient().addProxyRequest(this.CacheObj, tNotification, string);
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget: Waiting for response");
        }
        Date date = this.CacheObj.Updated;
        int n = 0;
        boolean bl = false;
        while (n < TCache.CacheTimeoutSeconds && !bl) {
            if (this.CacheObj.Updated.getTime() == date.getTime()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            bl = true;
        }
        if (this.CacheObj.debugCache()) {
            if (bl) {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:update got response");
            } else {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:update timed out");
            }
        }
        return bl;
    }

    public boolean updateLocal(String string, String string2, boolean bl) {
        boolean bl2;
        THtmlContent tHtmlContent;
        String string3;
        Object object;
        TRawWidgetGetterObj tRawWidgetGetterObj;
        String string4;
        Object object2;
        String[] stringArray;
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal started RemoteIP=" + string + " UserAgent=" + string2);
        }
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal CacheObj params: " + this.CacheObj.Params);
        }
        if (drvWidgetMetadata == null) {
            TCacheWidget.openWidgetMetadata();
        }
        if (this.CacheObj.Params.toUpperCase().indexOf("DOCUMENTID") < 0 && this.CacheObj.Params.toUpperCase().indexOf("VIEWID") >= 0) {
            stringArray = charutil.getElementValue(this.CacheObj.Params, "ViewID", '&');
            object2 = TCacheWidget.Application.AppCollections.getCollection("Greenlight_UI_View_Params_by_ID");
            string4 = (String)((TComboBoxColl)object2).getValueOfKey(stringArray);
            if (string4 == null) {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal found ViewID=" + (String)stringArray);
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal could not find document");
            }
            if (string4 != null) {
                this.CacheObj.Params = string4 + "&" + this.CacheObj.Params;
            }
        }
        if ((stringArray = charutil.getSubStringArray(this.CacheObj.Params, '&', true)) == null) {
            stringArray = new String[]{};
        }
        object2 = "";
        string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string8;
            int n = stringArray[i].indexOf("=");
            if (n < 0) continue;
            String string9 = stringArray[i].substring(0, n).toUpperCase();
            String string10 = string8 = n < stringArray[i].length() - 1 ? stringArray[i].substring(n + 1) : "";
            if (string9.equalsIgnoreCase("DriverID")) {
                object2 = string8;
                continue;
            }
            if (string9.equalsIgnoreCase("DocumentID")) {
                string4 = string8;
                string4 = charutil.removeChar(string4, '\r');
                string4 = charutil.removeChar(string4, '\n');
                string4 = charutil.replaceChar(string4, '/', '\\');
                string4 = string4.trim();
                continue;
            }
            if (string9.equalsIgnoreCase("Widget")) {
                string5 = string8;
                string5 = charutil.removeChar(string5, '\r');
                string5 = charutil.removeChar(string5, '\n');
                string5 = charutil.replaceChar(string5, '/', '\\');
                string5 = string5.trim();
                continue;
            }
            if (string9.equalsIgnoreCase("ContainerItemID")) {
                string6 = string8;
                string6 = charutil.removeChar(string6, '\r');
                string6 = charutil.removeChar(string6, '\n');
                string6 = charutil.replaceChar(string6, '/', '\\');
                string6 = string6.trim();
                continue;
            }
            if (string9.equalsIgnoreCase("Text")) {
                bl3 = charutil.boolval(string8);
                continue;
            }
            if (string9.equalsIgnoreCase("Metadata")) {
                string7 = string8;
                continue;
            }
            if (string9.equalsIgnoreCase("Params")) {
                stringBuilder.append("&" + charutil.replaceChar(string8, '|', '&'));
                continue;
            }
            stringBuilder.append("&" + string9 + "=" + string8);
        }
        if (string2.trim().length() != 0 || !MainWin.isRunningOnServer()) {
            // empty if block
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(0);
        }
        String string11 = "((Library_ID=\"" + string4 + "\") and (Name=\"" + string5 + "\"))";
        if (bl) {
            String string12 = charutil.getParamValue(stringArray, "DisplayName");
            boolean bl4 = charutil.boolval(charutil.getParamValue(stringArray, "Mobile"));
            if (string7.trim().length() == 0) {
                string7 = TDriverDisplay.getMetadata((String)object2, string4, string5, string6, bl4);
            }
            string11 = "Name=\"" + string7 + string12 + "\"";
        }
        if ((tRawWidgetGetterObj = TRawWidgetGetter.getUnprocessedContent(string4, string5, string11, bl)) == null) {
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 4, "TCacheWidget:updateLocal could not locate widget.  Document=" + string4 + " Name=" + string5 + " Item=" + string6 + " Display=" + bl);
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 4, "TCacheWidget:updateLocal Filter=" + string11);
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 4, "TCacheWidget:updateLocal Params=" + this.CacheObj.Params);
            this.CacheObj.setContent("Cache Content not found: Document=" + string4 + " Name=" + string5 + " Item=" + string6);
            return true;
        }
        String string13 = tRawWidgetGetterObj.getContent();
        boolean bl5 = tRawWidgetGetterObj.bIsContainer;
        boolean bl6 = tRawWidgetGetterObj.bIsMobileDoc;
        string13 = charutil.replaceAllSubstrings(string13, "~~backslash~~", "\\");
        if (bl5 && string6.length() > 0) {
            TWidgetContainer tWidgetContainer;
            int n;
            if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal looking for container item: " + string6);
            }
            if ((n = (tWidgetContainer = new TWidgetContainer(string13)).containsItem(string6)) < 0) {
                TRawWidgetGetter.clearCache();
                tRawWidgetGetterObj = TRawWidgetGetter.getUnprocessedContent(string4, string5, string11, bl);
                string13 = tRawWidgetGetterObj.getContent();
                bl5 = tRawWidgetGetterObj.bIsContainer;
                bl6 = tRawWidgetGetterObj.bIsMobileDoc;
                string13 = charutil.replaceAllSubstrings(string13, "~~backslash~~", "\\");
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 3, "TCacheWidget:updateLocal cleared cache because item not found");
            }
            if (n >= 0) {
                if (this.CacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal found container item: " + string6);
                }
                Hashtable hashtable = this.CacheObj.getParameters();
                String string14 = TCacheWidget.replaceTokens(tWidgetContainer.getContent(string6, hashtable));
                String string15 = "";
                if (string6.equalsIgnoreCase("left_bar") && !bl6 && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string14 = TCacheWidget.getLeftBarContent(TCacheWidget.getLeftBarComputer(this.CacheObj.Params));
                }
                if (string6.equalsIgnoreCase("top_bar") && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string14 = TCacheWidget.getTopBarContent(TCacheWidget.getLeftBarComputer(this.CacheObj.Params), bl6);
                }
                if (string6.equalsIgnoreCase("left_bar2015") && !bl6 && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string14 = TCacheWidget.getLeftBarContent2015(TCacheWidget.getLeftBarComputer(this.CacheObj.Params));
                }
                if (string6.equalsIgnoreCase("top_bar2015") && !string5.toUpperCase().startsWith("SUPPORT HOME") && !string5.toUpperCase().startsWith("BACKOFFICE HOME")) {
                    string14 = TCacheWidget.getTopBarContent2015(TCacheWidget.getLeftBarComputer(this.CacheObj.Params), bl6);
                }
                if (string14 == null) {
                    System.out.println("Content=null for ID:" + string6);
                    string14 = "Error getting content1";
                }
                if (!bl3) {
                    String string16;
                    Object object3;
                    boolean bl7;
                    String string17 = "Undefined";
                    int n2 = string14.toUpperCase().indexOf("<STATE>");
                    String string18 = "";
                    if (this.CacheObj.Params.toUpperCase().indexOf("VIEWID=") >= 0) {
                        String string19 = charutil.getElementValue(this.CacheObj.Params, "ViewID", '&');
                        bl7 = false;
                        object3 = TCacheWidget.Application.AppCollections.getCollection("Greenlight_UI_View_Enable_Caching_by_ID");
                        if (object3 != null) {
                            string16 = (String)((TComboBoxColl)object3).getValueOfKey(string19.toUpperCase());
                            boolean bl8 = bl7 = string16 == null ? false : charutil.boolval(string16);
                        }
                        if (bl7 && (object3 = TCacheWidget.Application.AppCollections.getCollection("Greenlight_UI_View_State_Expression_by_ID")) != null) {
                            string18 = (String)((TComboBoxColl)object3).getValueOfKey(string19.toUpperCase());
                            if (n2 < 0 && string18 == null) {
                                object3 = TCacheWidget.Application.AppCollections.getCollection("Greenlight_UI_View_Cache_State_Expression_by_ID");
                                String string20 = string18 = object3 == null ? null : (String)((TComboBoxColl)object3).getValueOfKey(string19.toUpperCase());
                                if (string18 == null) {
                                    string18 = "1";
                                }
                            }
                            if (string18 != null && (string18 = string18.trim()).length() > 0 && n2 < 0) {
                                string14 = "<state></state>" + string14;
                                n2 = 0;
                            }
                        }
                    }
                    if (n2 >= 0) {
                        int n3 = string14.toUpperCase().indexOf("</STATE>");
                        if (n3 > n2) {
                            if (this.CacheObj.debugCache()) {
                                MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal evaluating state tag");
                            }
                            string17 = string14.substring(n2 + 7, n3);
                            if (string18 != null) {
                                string17 = string17 + "\r\n";
                                string17 = string17 + "<include type:expression; expression:" + string18 + ">";
                            }
                            bl7 = string17.toUpperCase().indexOf("DEBUG=TRUE") >= 0;
                            object3 = new THtmlContent(string17, false);
                            string16 = charutil.removeControlChars(((THtmlContent)object3).getProcessedContent(stringBuilder + "&user-agent=" + string2 + "&LastState=" + this.CacheObj.State, true).trim());
                            string15 = Integer.toString(charutil.getHashCode(string16, false));
                            if (bl7 || this.CacheObj.debugCache()) {
                                MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 3, "TCacheWidget.updateLocal state tag: " + string17);
                                MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 3, "TCacheWidget.updateLocal params: " + stringBuilder + "&user-agent=" + string2 + "&LastState=" + this.CacheObj.State);
                                MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 3, "TCacheWidget.updateLocal state content: " + string16);
                                MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 3, "TCacheWidget.updateLocal Previous state1: " + this.CacheObj.State);
                                MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 3, "TCacheWidget.updateLocal Current state1: " + string15);
                            }
                            if (this.CacheObj.contentExists()) {
                                if (string16.equalsIgnoreCase(this.CacheObj.State) || string15.equalsIgnoreCase(this.CacheObj.State)) {
                                    if (bl7 || this.CacheObj.debugCache()) {
                                        MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal state has not changed");
                                    }
                                    return false;
                                }
                                if (bl7 || this.CacheObj.debugCache()) {
                                    MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal state has changed");
                                }
                            } else if (bl7 || this.CacheObj.debugCache()) {
                                MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal Skipping state tag because content does not exist: " + this.CacheObj.getContentFilename());
                            }
                        } else if (this.CacheObj.debugCache()) {
                            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal: invalid state tag");
                        }
                    } else if (this.CacheObj.debugCache()) {
                        MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget.updateLocal: no state tag found[2]");
                    }
                    string14 = tWidgetContainer.replaceIncludes(string14, hashtable);
                    string14 = charutil.replaceAllSubstrings(string14, "__d__", string4);
                    string14 = charutil.replaceAllSubstrings(string14, "__w__", string5);
                    string14 = charutil.replaceAllSubstrings(string14, "__i__", string6);
                    string14 = charutil.replaceAllSubstrings(string14, "__parentd__", charutil.getParamValue(stringArray, "ParentD"));
                    string14 = charutil.replaceAllSubstrings(string14, "__parentw__", charutil.getParamValue(stringArray, "ParentW"));
                    string14 = charutil.replaceAllSubstrings(string14, "__containertitle__", charutil.getParamValue(stringArray, "Title"));
                    string14 = charutil.replaceAllSubstrings(string14, "__containerargs__", this.CacheObj.getParamString('&'));
                    THtmlContent tHtmlContent2 = new THtmlContent(string14, false);
                    stringBuilder.append("&user-agent=" + string2);
                    stringBuilder.append("&remoteIP=" + string);
                    stringBuilder.append("&DocumentID=" + string4);
                    stringBuilder.append("&Widget=" + string5);
                    stringBuilder.append("&ContainerItemID=" + string6);
                    if (this.CacheObj.debugCache()) {
                        MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal processing container item");
                    }
                    string14 = tHtmlContent2.getProcessedContent(stringBuilder.toString() + "&IsMobileDoc=" + bl6, false);
                } else if (this.CacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal returning container item as text");
                }
                this.CacheObj.setContent(string14, string15);
                if (this.CacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal returning container item: " + string6 + " (" + string13.length() + " bytes)");
                }
                return true;
            }
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 4, "Error: Could not locate container item with ID=" + string6);
            this.CacheObj.setContent("Error: Cannot locate container item with ID=" + string6);
            return false;
        }
        if (bl3 || bl || bl5) {
            if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal returning widget as text");
            }
            this.CacheObj.setContent(string13);
            return true;
        }
        String string21 = "Undefined";
        String string22 = "";
        int n = string13.toUpperCase().indexOf("<STATE>");
        String string23 = "";
        if (this.CacheObj.Params.toUpperCase().indexOf("VIEWID=") >= 0) {
            String string24 = charutil.getElementValue(this.CacheObj.Params, "ViewID", '&');
            boolean bl9 = false;
            object = TCacheWidget.Application.AppCollections.getCollection("Greenlight_UI_View_Enable_Caching_by_ID");
            if (object != null) {
                string3 = (String)((TComboBoxColl)object).getValueOfKey(string24.toUpperCase());
                boolean bl10 = bl9 = string3 == null ? false : charutil.boolval(string3);
            }
            if (bl9 && (object = TCacheWidget.Application.AppCollections.getCollection("Greenlight_UI_View_State_Expression_by_ID")) != null) {
                string23 = (String)((TComboBoxColl)object).getValueOfKey(string24.toUpperCase());
                if (n < 0 && string23 == null) {
                    object = TCacheWidget.Application.AppCollections.getCollection("Greenlight_UI_View_Cache_State_Expression_by_ID");
                    String string25 = string23 = object == null ? null : (String)((TComboBoxColl)object).getValueOfKey(string24.toUpperCase());
                    if (string23 == null) {
                        string23 = "1";
                    }
                }
                if (string23 != null && (string23 = string23.trim()).length() > 0 && n < 0) {
                    string13 = "<state></state>" + string13;
                    n = 0;
                }
            }
        }
        if (n >= 0) {
            int n4 = string13.toUpperCase().indexOf("</STATE>");
            if (n4 > n) {
                if (this.CacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal evaluating state tag");
                }
                string21 = string13.substring(n + 7, n4);
                if (string23 != null) {
                    string21 = string21 + "\r\n";
                    string21 = string21 + "<include type:expression; expression:" + string23 + ">";
                }
                THtmlContent tHtmlContent3 = new THtmlContent(string21, false);
                object = charutil.removeControlChars(tHtmlContent3.getProcessedContent(stringBuilder.toString() + "&LastState=" + this.CacheObj.State, true).trim());
                string22 = Integer.toString(charutil.getHashCode((String)object, false));
                if (string21.toUpperCase().indexOf("DEBUG=TRUE") >= 0) {
                    System.out.println("Params=" + stringBuilder);
                    System.out.println("State=" + string21);
                    System.out.println("sStateContent=" + (String)object);
                    System.out.println("StateValue=" + string22);
                }
                if ((((String)object).equalsIgnoreCase(this.CacheObj.State) || string22.equalsIgnoreCase(this.CacheObj.State)) && this.CacheObj.contentExists()) {
                    if (this.CacheObj.debugCache()) {
                        MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal state has not changed");
                    }
                    return false;
                }
                if (this.CacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal Previous state2: " + this.CacheObj.State);
                }
                if (this.CacheObj.debugCache()) {
                    MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal Current state2: " + string22);
                }
            } else if (this.CacheObj.debugCache()) {
                MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal invalid state tag");
            }
        } else if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal no state tag found[3]");
        }
        if (string.trim().length() > 0) {
            TCacheServerInfo tCacheServerInfo = new TCacheServerInfo(string);
            stringBuilder.append("&RequestServer=" + tCacheServerInfo.getServer());
        }
        stringBuilder.append("&user-agent=" + string2);
        stringBuilder.append("&remoteIP=" + string);
        if (this.CacheObj.debugCache()) {
            MainWin.appendToLog("TCacheWidget", "update", Thread.currentThread(), null, 10, "TCacheWidget:updateLocal processing content Params=" + stringBuilder);
        }
        if ((string13 = (tHtmlContent = new THtmlContent(string13, false)).getProcessedContent(stringBuilder.toString() + "&IsMobileDoc=" + bl6, true).trim()).toUpperCase().indexOf("__WIDGETID__") >= 0) {
            string13 = "<div ID='__WidgetID__'>" + string13 + "</div>";
            string13 = charutil.replaceAllSubstrings(string13, "__WidgetID__", "w" + TPasswordService.generateSalt(24));
        }
        if (!(bl2 = charutil.boolval(charutil.getParamValue(stringArray, "isProxyRequest")))) {
            if (string13.toUpperCase().indexOf("OK: GETFILECONTENT=") >= 0) {
                int n5 = string13.indexOf("=");
                if (n5 >= 0) {
                    string3 = string13.substring(n5 + 1);
                    if (dosutil.fileExists(string3)) {
                        this.CacheObj.setContentFromFile(string3);
                        return true;
                    }
                    MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 4, "TCacheWidget:cannot find file: " + string3);
                    string13 = "";
                } else {
                    MainWin.appendToLog("TCacheWidget", "updateLocal", Thread.currentThread(), null, 4, "TCacheWidget:Bad content in request go getFileContent");
                    string13 = "";
                }
            } else if (string13.toUpperCase().indexOf("ERROR: GETFILECONTENT=") >= 0) {
                string13 = "";
            }
        }
        this.CacheObj.setContent(string13, string22);
        return true;
    }
}

