/*
 * Decompiled with CFR 0.152.
 */
package controls;

import aspect.AKDockLayout;
import aspect.Aspect;
import aspect.TMainWin;
import controls.TFrame;
import drivers.aspect.TAspectDriver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import resources.TAppActionObject;
import resources.TAppDriversObject;
import resources.TApplication;
import scripts.TExecScript;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.dialogpanel.TScrollDialogPanelEvent;
import scrollwin.dialogpanel.TScrollDialogPanelListenerInterface;
import scrollwin.table.TScrollTablePanel;
import utility.charutil;

public class TDesktopNavigator
extends JPanel
implements TScrollDialogPanelListenerInterface,
PropertyChangeListener,
ComponentListener {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDesktopPane");
    public TFrame Parent;
    private TApplication Application = TMainWin.Application;
    public TScrollDialogPanel DesktopPanel = null;
    private TAspectDriver DesktopDriver = null;
    private JPanel ContentPanel = null;
    private TScrollDialogPanel StatusPanel = null;

    public TDesktopNavigator(TFrame tFrame) {
        this.setLayout(new BorderLayout());
        this.Parent = tFrame;
        this.Parent.addPropertyChangeListener(this);
        this.Parent.addComponentListener(this);
        this.ContentPanel = new JPanel();
        this.ContentPanel.setLayout(new AKDockLayout());
        this.add((Component)this.ContentPanel, "Center");
    }

    public TScrollDialogPanel getDesktopPanel() {
        return this.DesktopPanel;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.ContentPanel.setPreferredSize(dimension);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public String getDriverID() {
        if (this.DesktopDriver == null) {
            return null;
        }
        return this.DesktopDriver.getDriverID();
    }

    public void createStatusPanel() {
        if (this.StatusPanel != null) {
            return;
        }
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Common_Desktop_Navigator_Loading", 1, true, false, "");
        this.StatusPanel = new TScrollDialogPanel(this.Application, tAspectDriver, tAspectDriver.AppDriverObj.DialogIDStart.toString());
        this.StatusPanel.createPanel();
        this.StatusPanel.transferValues(0, 0);
    }

    public void addBackgroundPanel(String string) {
        String[] stringArray;
        ArrayList arrayList;
        TAppDriversObject tAppDriversObject = null;
        Rectangle rectangle = this.getBounds();
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() >= 0 && !string.equals("0")) {
            tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(string);
        }
        if (tAppDriversObject == null) {
            this.MainWin.appendToLog("TDesktopNavigator", "addBackgroundPanel", Thread.currentThread(), null, 4, "Cannot locate driver: " + string);
            return;
        }
        String string2 = this.getDriverID();
        if (string2 == null) {
            string2 = "";
        }
        if ((arrayList = this.MainWin.getPackageIDs()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray = (String)arrayList.get(i) + "_desktop_unloaded";
                if (!TMainWin.Application.AppScripts.isResourceDefined((String)stringArray)) continue;
                TExecScript tExecScript = new TExecScript((String)stringArray, null, null);
                tExecScript.setParameters(string2);
                tExecScript.start();
            }
        }
        String string3 = "desktop_unloaded_" + this.getDriverID();
        if (TMainWin.Application.AppScripts.isResourceDefined(string3)) {
            stringArray = new TExecScript(string3, null, null);
            stringArray.setParameters(string);
            stringArray.start();
        }
        if (tAppDriversObject.ExecuteOnOpenMethod.length() > 0) {
            this.Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenMethod);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object = TMainWin.execClassMethod(stringArray[i]);
                    if (object == null || !(object instanceof Boolean) || ((Boolean)object).booleanValue()) continue;
                    if (this.Debug) {
                        Aspect.MainWin.appendToLog("TDesktopPane", "addBackgroundPanel", Thread.currentThread(), null, 3, "Execute method before opening driver returns false, so exiting.");
                    }
                    return;
                }
            }
        }
        this.removeBackgroundPanel();
        this.createStatusPanel();
        this.StatusPanel.transferValues(0, 0);
        this.StatusPanel.setBounds(0, 0, rectangle.width, rectangle.height);
        this.StatusPanel.setPreferredSize(this.getSize());
        this.ContentPanel.setPreferredSize(this.getSize());
        this.ContentPanel.add((Component)this.StatusPanel, "Center");
        this.DesktopDriver = new TAspectDriver(this.Application, tAppDriversObject, 1, true, "");
        this.DesktopPanel = new TScrollDialogPanel(this.Application, this.DesktopDriver, tAppDriversObject.DialogIDStart.toString());
        this.DesktopPanel.createPanel();
        this.DesktopPanel.transferValues(0, 0);
        this.DesktopPanel.addScrollDialogPanelListener(this);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = (String)arrayList.get(i) + "_desktop_loaded";
                if (!TMainWin.Application.AppScripts.isResourceDefined(string3)) continue;
                TExecScript tExecScript = new TExecScript(string3, null, null);
                tExecScript.setParameters(string2);
                tExecScript.start();
            }
        }
        string3 = "desktop_loaded_" + this.getDriverID();
        if (TMainWin.Application.AppScripts.isResourceDefined(string3)) {
            TExecScript tExecScript = new TExecScript(string3, null, null);
            tExecScript.setParameters(string2);
            tExecScript.executeScript();
        }
        this.ContentPanel.remove(this.StatusPanel);
        this.ContentPanel.add((Component)this.DesktopPanel, "Center");
    }

    public void resizeComponents() {
    }

    public void removeBackgroundPanel() {
        if (this.DesktopDriver != null) {
            this.DesktopDriver.dispose();
        }
        if (this.DesktopPanel != null) {
            this.DesktopPanel.dispose();
        }
        if (!TMainWin.IsClosing) {
            Component[] componentArray = this.ContentPanel.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof TScrollDialogPanel)) continue;
                this.ContentPanel.remove(componentArray[i]);
            }
        }
    }

    public TScrollTablePanel getTablePanelWithDriverID(String string) {
        if (this.DesktopPanel != null) {
            return this.DesktopPanel.getTablePanelWithDriverID(string);
        }
        return null;
    }

    @Override
    public void ok() {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close(String string) {
        final String string2 = this.DesktopPanel.getReturnValue();
        Thread thread = new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string;
                        String[] stringArray;
                        if (string2.toUpperCase().startsWith("ACTION.")) {
                            String string2 = string2.substring(7);
                            TAppActionObject tAppActionObject = ((TDesktopNavigator)TDesktopNavigator.this).Application.AppAction.getAppActionObject(string2);
                            if (tAppActionObject != null) {
                                Aspect.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
                            } else {
                                TDesktopNavigator.this.MainWin.appendToLog("TDesktopPane", "close", Thread.currentThread(), null, 3, "Unable to locate an action with the ID of '" + string2 + "'");
                            }
                        } else if (string2.toUpperCase().startsWith("SCRIPT.")) {
                            String string3 = string2.substring(7);
                            Aspect.MainWin.executeScript(string3);
                        } else if (string2.toUpperCase().startsWith("DIALOG.")) {
                            String string4 = string2.substring(7);
                            String[] stringArray2 = charutil.getSubStringArray(string4, '?', true);
                            if (stringArray2 != null && stringArray2.length > 0) {
                                String string5 = stringArray2[0];
                                int n = 0;
                                if (stringArray2.length > 1) {
                                    n = charutil.ival(stringArray2[1]);
                                }
                                TMainWin.executeDialog(string5, n);
                            }
                        } else if (string2.toUpperCase().startsWith("DRIVERCMD.") && (stringArray = charutil.getSubStringArray(string = string2.substring(10), ',', true)) != null) {
                            if (stringArray.length == 1) {
                                Aspect.MainWin.executeDriverCommand(stringArray[0], "");
                            } else {
                                Aspect.MainWin.executeDriverCommand(stringArray[0], stringArray[1]);
                            }
                        }
                    }
                });
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void beginTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
    }

    @Override
    public void endTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
    }

    @Override
    public void scrollDialogPanelEventOccurred(TScrollDialogPanelEvent tScrollDialogPanelEvent) {
    }

    @Override
    public void nextRecord() {
        int n = this.DesktopPanel.getRecordNumber();
        if (n < this.DesktopDriver.getRecordCount() - 1) {
            this.DesktopPanel.transferValues(++n, 0);
        }
    }

    @Override
    public void previousRecord() {
        int n = this.DesktopPanel.getRecordNumber();
        if (n > 0) {
            this.DesktopPanel.transferValues(--n, 0);
        }
    }

    @Override
    public void firstRecord() {
        int n = this.DesktopPanel.getRecordNumber();
        if (n > 0) {
            n = 0;
            this.DesktopPanel.transferValues(n, 0);
        }
    }

    @Override
    public void lastRecord() {
        int n = this.DesktopPanel.getRecordNumber();
        if (n < this.DesktopDriver.getRecordCount() - 1) {
            n = this.DesktopDriver.getRecordCount() - 1;
            this.DesktopPanel.transferValues(n, 0);
        }
    }

    @Override
    public void gotoRecord(int n) {
    }
}

