/*
 * Decompiled with CFR 0.152.
 */
package controls;

import controls.TTextFieldLimitLength;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import utility.charutil;

public class TPassword
extends JPasswordField {
    public String ControlID;
    int MinLength = 0;
    int MaxLength = 0;

    public TPassword(StringBuilder stringBuilder, int n, int n2) {
        this.ControlID = stringBuilder.toString();
        this.MinLength = n;
        this.MaxLength = n2;
        this.setInputVerifier(new FormattedTextFieldVerifier());
        this.setDocument(new TTextFieldLimitLength(this.MaxLength));
    }

    public class FormattedTextFieldVerifier
    extends InputVerifier {
        private boolean DisplayingMessage = false;

        @Override
        public boolean verify(JComponent jComponent) {
            if (this.DisplayingMessage) {
                return true;
            }
            JPasswordField jPasswordField = (JPasswordField)jComponent;
            String string = new String(jPasswordField.getPassword());
            StringBuilder stringBuilder = new StringBuilder();
            if (string.length() < TPassword.this.MinLength) {
                this.DisplayingMessage = true;
                charutil.strcpy(stringBuilder, "Must be at least ");
                charutil.strcat(stringBuilder, Integer.toString(TPassword.this.MinLength));
                charutil.strcat(stringBuilder, " characters long.");
                JOptionPane.showMessageDialog(null, stringBuilder, "Problem...", 0);
                this.DisplayingMessage = false;
                return false;
            }
            if (string.length() > TPassword.this.MaxLength) {
                this.DisplayingMessage = true;
                charutil.strcpy(stringBuilder, "May be a maximum of ");
                charutil.strcat(stringBuilder, Integer.toString(TPassword.this.MaxLength));
                charutil.strcat(stringBuilder, " characters long.");
                JOptionPane.showMessageDialog(null, stringBuilder, "Problem...", 0);
                this.DisplayingMessage = false;
                return false;
            }
            return true;
        }
    }
}

