/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.TMainWin;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    Color currentColor;
    JButton button = new JButton();
    JColorChooser colorChooser;
    JDialog dialog;

    public TColorEditor() {
        this.button.setActionCommand("edit");
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= TMainWin.Application.getTokenValueAsInt("$EditClickCount");
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("edit".equals(actionEvent.getActionCommand())) {
            this.button.setBackground(this.currentColor);
            this.colorChooser.setColor(this.currentColor);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return new Integer(this.currentColor.getRGB());
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentColor = new Color((Integer)object);
        return this.button;
    }
}

