/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.TMainWin;
import controls.TDateSpinner;
import drivers.aspect.TDriverStructRecord;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import utility.dateutil;

public class TDateSpinnerCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private TDateSpinner DateSpinner = null;
    private TDriverStructRecord DSRec = null;

    public TDateSpinnerCellEditor(TDriverStructRecord tDriverStructRecord) {
        SimpleDateFormat simpleDateFormat = null;
        this.DSRec = tDriverStructRecord;
        if (this.DSRec.FormatPattern.length() > 0) {
            simpleDateFormat = new SimpleDateFormat(this.DSRec.FormatPattern);
        } else {
            switch (this.DSRec.FieldType) {
                case 10: {
                    simpleDateFormat = dateutil.getDateTimeFormat(0);
                    break;
                }
                case 18: {
                    simpleDateFormat = dateutil.getDateTimeFormat(1);
                    break;
                }
                case 13: {
                    simpleDateFormat = dateutil.getDateTimeFormat(2);
                    break;
                }
                case 21: {
                    simpleDateFormat = dateutil.getDateTimeFormat(2);
                }
            }
        }
        this.DateSpinner = new TDateSpinner(simpleDateFormat);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.DateSpinner.setValue(object);
        return this.DateSpinner;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= TMainWin.Application.getTokenValueAsInt("$EditClickCount");
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.DateSpinner.getValue();
    }
}

