/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import utility.TFormulaEvaluator;
import utility.imageutil;

public class TExecScriptCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    TAspectDriver AspectDriver;
    TDriverStructRecord DSRec = null;
    TFormulaEvaluator FormulaEvaluator = null;
    JButton button;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    int EditingRow = -1;

    public TExecScriptCellEditor(TAspectDriver tAspectDriver) {
        this.AspectDriver = tAspectDriver;
        this.button = new JButton();
        this.button.addActionListener(new buttonActionListener());
        this.selectedBorder = BorderFactory.createRaisedBevelBorder();
        this.unselectedBorder = BorderFactory.createRaisedBevelBorder();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.button.setText("");
        this.button.setHorizontalAlignment(0);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.DSRec = this.AspectDriver.getDriverStructRecord(n2);
        if (this.DSRec != null) {
            String string;
            Object object2;
            this.FormulaEvaluator = new TFormulaEvaluator(this.AspectDriver.getFormulaEvaluator());
            this.EditingRow = n;
            if (this.DSRec.EditorLabel.length() > 0 && (object2 = this.FormulaEvaluator.getFormulaValue(this.DSRec.EditorLabel, this.AspectDriver.getAbsoluteDiskIndex(this.EditingRow), this.EditingRow)) != null) {
                string = TFormulaEvaluator.convertToString(object2);
                this.button.setText(string);
            }
            if (this.DSRec.EditorIcon.length() > 0) {
                object2 = this.FormulaEvaluator.getFormulaValue(this.DSRec.EditorIcon, this.AspectDriver.getAbsoluteDiskIndex(this.EditingRow), this.EditingRow);
                if (object2 != null) {
                    string = TFormulaEvaluator.convertToString(object2);
                    ImageIcon imageIcon = imageutil.getIcon(this, string, "");
                    this.button.setIcon(imageIcon);
                }
                switch (this.DSRec.EditorLabelPosition) {
                    case 0: {
                        this.button.setHorizontalTextPosition(2);
                        break;
                    }
                    case 1: {
                        this.button.setHorizontalTextPosition(0);
                        break;
                    }
                    case 2: {
                        this.button.setHorizontalTextPosition(4);
                        break;
                    }
                    case 3: {
                        this.button.setHorizontalTextPosition(10);
                        break;
                    }
                    case 4: {
                        this.button.setHorizontalTextPosition(11);
                    }
                }
            }
        }
        return this.button;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    public class buttonActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TExecScriptCellEditor.this.DSRec != null) {
                TMainWin tMainWin = Aspect.MainWin;
                String string = TMainWin.Application.parse_tokens(TExecScriptCellEditor.this.DSRec.EditorScript);
                tMainWin.executeScript(string);
            }
        }
    }
}

