/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.TMainWin;
import controls.TFileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TFileChooserCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    JButton button = new JButton();
    TFileChooser FileChooser;
    String FileName = "";

    public TFileChooserCellEditor(int n) {
        this.button.setActionCommand("edit");
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.FileChooser = new TFileChooser();
        this.FileChooser.setFileSelectionMode(n);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= TMainWin.Application.getTokenValueAsInt("$EditClickCount");
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("edit".equals(actionEvent.getActionCommand())) {
            if (this.FileName.length() > 0) {
                this.FileChooser.setSelectedFile(new File(this.FileName));
            }
            int n = this.FileChooser.showOpenDialog(this.button);
            switch (n) {
                case 1: {
                    break;
                }
                case 0: {
                    this.FileName = this.FileChooser.getFileName();
                    break;
                }
            }
            this.fireEditingStopped();
        } else {
            this.FileName = this.FileChooser.getName();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.FileName;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.FileName = (String)object;
        return this.button;
    }
}

