/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.TMainWin;
import controls.TTextFieldLimitLength;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;

public class TTextAreaCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    public TableTextArea textArea;
    public JScrollPane scrollPane;

    public TTextAreaCellEditor(int n, Font font) {
        this.textArea = new TableTextArea(n, font);
        this.scrollPane = new JScrollPane(this.textArea, 20, 30);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.textArea.setText((String)object);
        return this.textArea;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= TMainWin.Application.getTokenValueAsInt("$EditClickCount");
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    public class TableTextArea
    extends JTextArea
    implements ActionListener {
        Font font;

        public TableTextArea(int n, Font font) {
            this.font = font;
            this.setFont(this.font);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setDocument(new TTextFieldLimitLength(n));
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 2, false);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, false);
            this.registerKeyboardAction(this, "StopEditing", keyStroke, 0);
            this.registerKeyboardAction(this, "CancelEditing", keyStroke2, 0);
        }

        @Override
        public void setFont(Font font) {
            if (this.font != null) {
                super.setFont(this.font);
            } else {
                super.setFont(font);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equalsIgnoreCase("StopEditing")) {
                TTextAreaCellEditor.this.stopCellEditing();
            } else if (actionEvent.getActionCommand().equalsIgnoreCase("CancelEditing")) {
                System.out.println("cancel editing");
                TTextAreaCellEditor.this.cancelCellEditing();
            }
        }
    }
}

