/*
 * Decompiled with CFR 0.152.
 */
package controls.htmlviewer;

import aspect.Aspect;
import aspect.TMainWin;
import controls.htmlviewer.THtmlConstant;
import controls.htmlviewer.THtmlInclude;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import utility.TFormulaEvaluator;
import utility.THtmlTag;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dosutil;
import utility.objectutil;
import utility.security.TPasswordService;

public class THtmlContent {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    public boolean bErrorInInclude = false;
    boolean boolRemoveClientContent = false;
    String strSourceContent = "";
    private String strOriginalSource = "";
    boolean WrapInHtmlTags = true;
    Hashtable hashClientTags = null;
    StringBuilder strProcessedContent = new StringBuilder();
    private boolean bIsMobileDoc = false;
    private String ThreadName = "";
    TProcessTimer ProcessTimer = null;

    public THtmlContent(String string) {
        this.strSourceContent = string;
    }

    public THtmlContent(String string, boolean bl) {
        this.strSourceContent = string;
        this.WrapInHtmlTags = bl;
    }

    public THtmlContent(String string, boolean bl, String string2) {
        this.strSourceContent = string;
        this.WrapInHtmlTags = bl;
        this.strOriginalSource = string2;
    }

    public void setRemoveClientContent(boolean bl) {
        this.boolRemoveClientContent = bl;
    }

    private void replaceRelativeLinks(String string) {
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "processHtml:http", "processHtml_:http");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "processHtml:https", "processHtml_:https");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "processHtml:file", "processHtml_:file");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "processHtml:ftp", "processHtml_:ftp");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src=\"http:", "src_=\"http:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src=\"https:", "src_=\"https:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src=\"file:", "src_=\"file:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src='file:", "src_='file:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src=\"ftp:", "src_=\"ftp:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src=\"__RequestServer__", "src_=\"__RequestServer__");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"#\"", "href_=\"#\"");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"http:", "href_=\"http:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"https:", "href_=\"https:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"file:", "href_=\"file:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"ftp:", "href_=\"ftp:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"mailto:", "href_=\"mailto:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"javascript:", "href_=\"javascript:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"processHtml:", "href_=\"processHtml:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(http:", "url_(http:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(\"http:", "url_(\"http:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(https:", "url_(https:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(\"https:", "url_(\"https:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(file:", "url_(file:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(\"file:", "url_(\"file:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(\"file:", "url_(\"file:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "getFormSubmissionUrl(", "getFormSubmissionUrl_(");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"/", "href_=\"file:///");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "processHtml:", "processHtml_:" + charutil.tokenizeForPost(string, true));
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src=\"", "src_=\"" + string);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"", "href_=\"" + string);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(\"", "url_(\"" + string);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url(", "url_(" + string);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "processHtml_:", "processHtml:");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src_=", "src=");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href_=", "href=");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "getFormSubmissionUrl_(", "getFormSubmissionUrl(");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "url_(", "url(");
    }

    private void replaceJarredFiles(String string) {
        String string2 = string.toUpperCase();
        int n = -1;
        boolean bl = true;
        boolean bl2 = false;
        do {
            Object object;
            if ((n = this.strProcessedContent.toString().toUpperCase().indexOf(string2, n + 1)) < 0) continue;
            String string3 = charutil.getLeftChars(this.strProcessedContent, n, "\"", 255);
            String string4 = charutil.getRightChars(this.strProcessedContent, n + 1, "\"", 255);
            String string5 = string3 + string4;
            if (bl2) {
                this.MainWin.appendToLog("THtmlViewer", "replaceJarredFiles", Thread.currentThread(), null, 3, "Found jarred url: " + string5);
            }
            boolean bl3 = false;
            if (!string5.toUpperCase().startsWith("FILE://")) {
                if (bl2) {
                    this.MainWin.appendToLog("THtmlViewer", "replaceJarredFiles", Thread.currentThread(), null, 3, "\tSkipping because it is not a local file");
                }
                bl3 = true;
            }
            if (string5.toUpperCase().indexOf(".HTM") >= 0) {
                if (bl2) {
                    this.MainWin.appendToLog("THtmlViewer", "replaceJarredFiles", Thread.currentThread(), null, 3, "\tSkipping because it is an html file");
                }
                bl3 = true;
            }
            if (!bl3) {
                String[] stringArray;
                string5 = string5.substring(7);
                string3 = charutil.getLeftChars(this.strProcessedContent, n, "/\\:");
                string4 = charutil.getRightChars(this.strProcessedContent, n + 1, "\"/\\");
                String string6 = string3 + string4;
                if (bl2) {
                    System.out.println("Found jar url:" + string5);
                    System.out.println("Filename = " + string6);
                }
                if ((stringArray = dosutil.splitPath(string5.toString())) == null) {
                    return;
                }
                if (stringArray[0] == null) {
                    object = dosutil.splitPath(TMainWin.Application.getHomeDirectory());
                    stringArray[0] = object[0];
                }
                if (bl2) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.MainWin.appendToLog("THtmlViewer", "replaceJarredFiles", Thread.currentThread(), null, 3, "arString[" + i + "] = " + stringArray[i]);
                    }
                }
                stringArray[1] = charutil.replaceAllSubstrings(stringArray[1], string2, "");
                stringArray[1] = charutil.replaceAllSubstrings(stringArray[1], "/", "\\");
                stringArray[1] = dosutil.removeRelativeDirectories(stringArray[1], '/');
                String string7 = "";
                if (stringArray[0] != null) {
                    string7 = string7 + stringArray[0];
                }
                if (stringArray[1] != null) {
                    string7 = string7 + stringArray[1];
                }
                string7 = charutil.replaceAllSubstrings(string7, "http:/www.aspect-software.net/Aspect7/core/Aspect7/", TMainWin.Application.getTokenValue("execdir"));
                if ((string7 = charutil.replaceAllSubstrings(string7, "http://www.aspect-software.net/Aspect7/core/Aspect7/", TMainWin.Application.getTokenValue("execdir"))).toUpperCase().startsWith("HTTP")) continue;
                File file = new File(string7 = charutil.replaceAllSubstrings(string7, "%20", " "));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (stringArray[2] != null) {
                    string7 = string7 + stringArray[2];
                }
                if (stringArray[3] != null) {
                    string7 = string7 + stringArray[3];
                }
                file = new File(string7);
                String string8 = dosutil.removeTrailingSlash(dosutil.removeRelativeDirectories(string5, '/'));
                string8 = charutil.replaceAllSubstrings(string8, "%20", " ");
                if (bl2) {
                    this.MainWin.appendToLog("THtmlViewer", "replaceJarredFiles", Thread.currentThread(), null, 3, "\tCopying " + string8 + " to \n\t" + string7);
                }
                object = dosutil.copyFile(string8, string7, 0, false, "", "", "");
                string7 = charutil.replaceAllSubstrings(string7, "\\", "/");
                string7 = charutil.replaceAllSubstrings(string7, " ", "%20");
                if (bl2) {
                    this.MainWin.appendToLog("THtmlViewer", "replaceJarredFiles", Thread.currentThread(), null, 3, "\tReplacing " + string5);
                    this.MainWin.appendToLog("THtmlViewer", "replaceJarredFiles", Thread.currentThread(), null, 3, "\t\twith /" + string7);
                }
                if (this.Debug && this.ProcessTimer != null) {
                    this.ProcessTimer.addElement("Replacing " + string5 + " with " + string7);
                }
                charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, string5, "/" + string7);
                continue;
            }
            if (!this.Debug || this.ProcessTimer == null) continue;
            object = charutil.replaceAllSubstrings(string5, "<", "&lt;");
            object = charutil.replaceAllSubstrings((String)object, ">", "&gt;");
            this.ProcessTimer.addElement("Skipping " + (String)object);
        } while (n >= 0);
    }

    public void replaceTokens() {
        if (this.strProcessedContent.indexOf("{") < 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        do {
            if ((n = charutil.get_token_string(stringBuilder2, this.strProcessedContent, n)) < 0) continue;
            if (TMainWin.Application.isTokenDefined(charutil.remove_braces(stringBuilder2, "{}"))) {
                TMainWin.Application.getTokenValue(stringBuilder, charutil.remove_braces(stringBuilder2, "{}"));
                if (this.Debug && this.ProcessTimer != null) {
                    this.ProcessTimer.addElement("Replacing token " + stringBuilder2 + " with " + stringBuilder.toString());
                }
                charutil.replace_sub_string(this.strProcessedContent, this.strProcessedContent, stringBuilder2, stringBuilder);
            }
            ++n;
        } while (n >= 0);
    }

    public void replaceIncludeTags(String string, ArrayList arrayList, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = "<" + string.toUpperCase();
        int n = -1;
        int n2 = -1;
        do {
            String string9;
            if ((n = (string9 = this.strProcessedContent.toString().toUpperCase()).indexOf(string8)) < 0) continue;
            n2 = n + 1;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 32;
            do {
                char c;
                if ((c = string9.charAt(n2)) == '\"') {
                    bl = !bl;
                } else if (!bl && n3 != 92) {
                    if (c == '>') {
                        bl2 = true;
                    } else if (c == '<') {
                        this.MainWin.appendToLog("THtmlContent", "replaceIncludeTags", Thread.currentThread(), null, 4, "Opening '<' found before closing '>' in include tag[1] " + this.strProcessedContent.substring(n, n2 + 1) + "...[1]");
                        System.out.println(this.strProcessedContent.substring(n, n2 + 1));
                        new Throwable().printStackTrace();
                        return;
                    }
                }
                n3 = c;
            } while (!bl2 && ++n2 < string9.length());
            if (!bl2) {
                this.MainWin.appendToLog("THtmlContent", "replaceIncludeTags", Thread.currentThread(), null, 4, "No closing '>' in include tag " + this.strProcessedContent.substring(n));
                this.bErrorInInclude = true;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(this.strProcessedContent.substring(n, n2));
            String string10 = "";
            if (this.Debug && this.ProcessTimer != null) {
                string10 = charutil.replaceAllSubstrings(stringBuilder.toString(), "<", "&lt;");
                string10 = charutil.replaceAllSubstrings(string10, ">", "&gt;");
            }
            while (stringBuilder.toString().startsWith("<!")) {
                stringBuilder.deleteCharAt(1);
            }
            while (stringBuilder.toString().startsWith("<_")) {
                stringBuilder.deleteCharAt(1);
            }
            Date date = new Date();
            THtmlInclude tHtmlInclude = this.strOriginalSource.length() > 0 ? new THtmlInclude(stringBuilder.toString(), arrayList, this.strOriginalSource, string2, string3, string4, string5, this.bIsMobileDoc, this.ThreadName, string6, string7) : new THtmlInclude(stringBuilder.toString(), arrayList, this.strSourceContent, string2, string3, string4, string5, this.bIsMobileDoc, this.ThreadName, string6, string7);
            this.strProcessedContent.replace(n, n2 + 0, tHtmlInclude.getText());
            this.removeClientTags();
            if (!this.Debug || this.ProcessTimer == null) continue;
            if (string.toUpperCase().indexOf("INCLUDE") >= 0) {
                this.ProcessTimer.addElement(string10 + " [" + this.strProcessedContent.length() + " bytes] ", new Date().getTime() - date.getTime());
                continue;
            }
            this.ProcessTimer.addElement(string10);
        } while (n >= 0 && n2 >= 0);
    }

    public void replacePageArgs(Hashtable hashtable) {
        String string = this.strProcessedContent.toString().toUpperCase();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (string3.equalsIgnoreCase(string2 = (String)hashtable.get(string3)) || string.indexOf(string3.toUpperCase()) < 0) continue;
            if (this.Debug && this.ProcessTimer != null) {
                String string4 = charutil.replaceAllSubstrings(string2, "<", "&lt;");
                string4 = charutil.replaceAllSubstrings(string4, ">", "&gt;");
                string4 = "Replacing #3cfont color='blue'#3e" + string3 + "#3c/font#3e with #3cfont color='blue'#3e" + string4 + "#3c/font#3e";
                this.ProcessTimer.addElement(string4);
            }
            if (string2.toUpperCase().indexOf(string3.toUpperCase()) >= 0) {
                charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, string3, "\u00e1");
                charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "\u00e1", string2);
            } else {
                charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, string3, string2);
            }
            string = this.strProcessedContent.toString().toUpperCase();
        }
    }

    public void replaceConstants(ArrayList arrayList) {
        boolean bl = false;
        String string = this.strProcessedContent.toString().toUpperCase();
        while (!bl) {
            bl = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                THtmlConstant tHtmlConstant = (THtmlConstant)arrayList.get(i);
                String string2 = tHtmlConstant.getName();
                String string3 = tHtmlConstant.getValue();
                if (string2.length() <= 0 || string2.equalsIgnoreCase(string3) || string.indexOf(string2.toUpperCase()) < 0) continue;
                if (this.Debug && this.ProcessTimer != null) {
                    String string4 = charutil.replaceAllSubstrings(string3, "<", "&lt;");
                    string4 = charutil.replaceAllSubstrings(string4, ">", "&gt;");
                    string4 = "Replacing #3cfont color='blue'#3e" + string2 + "#3c/font#3e with #3cfont color='blue'#3e" + string4 + "#3c/font#3e";
                    this.ProcessTimer.addElement(string4);
                }
                if (string3.toUpperCase().indexOf(string2.toUpperCase()) >= 0) {
                    charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, string2, "\u00e1");
                    charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "\u00e1", string3);
                } else {
                    charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, string2, string3);
                }
                string = this.strProcessedContent.toString().toUpperCase();
                bl = false;
            }
        }
    }

    public String replaceBraces(StringBuilder stringBuilder, StringBuilder stringBuilder2, char c, char c2, String string) {
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        String string2 = stringBuilder2.toString().toUpperCase();
        String string3 = "<" + string.toUpperCase();
        String string4 = "</" + string.toUpperCase();
        int n = -1;
        int n2 = -1;
        stringBuilder.setLength(0);
        stringBuilder.append((CharSequence)stringBuilder3);
        do {
            if ((n = string2.indexOf(string3, n + 1)) < 0 || (n2 = string2.indexOf(string4, n + 1)) <= n) continue;
            for (int i = n; i < n2; ++i) {
                if (stringBuilder.charAt(i) != c) continue;
                stringBuilder.setCharAt(i, c2);
            }
            n = n2 + 1;
        } while (n >= 0);
        return stringBuilder.toString();
    }

    public String removeScripts() {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            String string = this.strProcessedContent.toString().toUpperCase();
            int n = string.indexOf("<SCRIPT");
            if (n >= 0) {
                int n2 = string.indexOf("</SCRIPT>");
                if (n2 > n) {
                    this.strProcessedContent.delete(n, n2 + 9);
                    bl2 = true;
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        if (bl2) {
            // empty if block
        }
        return this.strProcessedContent.toString();
    }

    public String removeStateTag() {
        boolean bl = false;
        while (!bl) {
            String string = this.strProcessedContent.toString().toUpperCase();
            int n = string.indexOf("<STATE");
            if (n >= 0) {
                int n2 = string.indexOf("</STATE>");
                if (n2 > n) {
                    this.strProcessedContent.delete(n, n2 + 8);
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        return this.strProcessedContent.toString();
    }

    public String removeCharset() {
        int n = this.strProcessedContent.toString().toUpperCase().indexOf("CHARSET=");
        if (n >= 0) {
            int n2 = this.strProcessedContent.indexOf("\"", n);
            int n3 = this.strProcessedContent.indexOf("'", n);
            if (n3 > n && n3 < n2) {
                n2 = n3;
            }
            this.strProcessedContent.delete(n, n2);
        }
        return this.strProcessedContent.toString();
    }

    public void replaceConditionals(String string) {
        if (this.strProcessedContent.toString().toUpperCase().indexOf("</CONDITIONAL") < 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        int n2 = -1;
        int n3 = 14;
        if (string.startsWith("<!")) {
            ++n3;
        }
        if (string.startsWith("<!!")) {
            ++n3;
        }
        do {
            int n4;
            int n5;
            String string2;
            if ((n = (string2 = this.strProcessedContent.toString().toUpperCase()).indexOf(string)) < 0) continue;
            n2 = n + 1;
            boolean bl = false;
            boolean bl2 = false;
            stringBuilder.setLength(0);
            do {
                char c;
                if ((c = string2.charAt(n2)) == '\"') {
                    bl = !bl;
                    stringBuilder.append(c);
                    continue;
                }
                if (!bl) {
                    if (c == '>') {
                        bl2 = true;
                        continue;
                    }
                    if (c == '<') {
                        this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "Opening '<' found before closing '>' in conditional tag[3] " + this.strProcessedContent.substring(n, n + 80) + "...[3]");
                        return;
                    }
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
            } while (!bl2 && ++n2 < string2.length());
            if (!bl2) {
                this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "No closing '>' in conditional tag " + this.strProcessedContent.substring(n, Math.min(n + 50, this.strProcessedContent.length())) + "...");
                return;
            }
            int n6 = n;
            int n7 = n;
            do {
                n5 = string2.indexOf("<CONDITIONAL", n6 + 1);
                n4 = string2.indexOf("<!CONDITIONAL", n6 + 1);
            } while ((n6 = n5 >= 0 && n4 >= 0 ? Math.min(n5, n4) : Math.max(n5, n4)) < (n7 = string2.indexOf("</CONDITIONAL", n7 + 1)) && n6 >= 0);
            n5 = stringBuilder.toString().toUpperCase().indexOf("EXPRESSION:");
            if (n5 >= 0) {
                String string3 = charutil.removeQuotes(stringBuilder.substring(n5 + 11, stringBuilder.length()));
                Object object = new TFormulaEvaluator().getFormulaValue(string3 = charutil.replaceAllSubstrings(string3, "'", "\""), 0, 0);
                Boolean bl3 = TFormulaEvaluator.convertToBoolean(object);
                if (bl3.booleanValue()) {
                    if (this.Debug && this.ProcessTimer != null) {
                        this.ProcessTimer.addElement("#3cfont color='green'#3eInclude#3c/font#3e: " + stringBuilder);
                    }
                    if (n < 0 || n >= this.strProcessedContent.length() || n + stringBuilder.length() + 2 < n || n + stringBuilder.length() + 2 > this.strProcessedContent.length()) {
                        this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "Misplaced conditional tag1.  " + this.strProcessedContent.substring(n, Math.min(n + 1024, this.strProcessedContent.length())) + "...");
                        return;
                    }
                    this.strProcessedContent.replace(n, n + stringBuilder.length() + 2, "");
                    int n8 = n7 - (stringBuilder.length() + 2);
                    int n9 = n7 - (stringBuilder.length() + 2) + 14;
                    if (n8 >= 0 && n8 < this.strProcessedContent.length() && n9 >= n8 && n9 <= this.strProcessedContent.length()) {
                        this.strProcessedContent.replace(n8, n9, "");
                        continue;
                    }
                    this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "Misplaced conditional tag2.  " + this.strProcessedContent.substring(n, Math.min(n + 1024, this.strProcessedContent.length())) + "...");
                    return;
                }
                if (this.Debug && this.ProcessTimer != null) {
                    this.ProcessTimer.addElement("#3cfont color='red'#3eExclude#3c/font#3e: " + stringBuilder + " (" + (n7 + 14 - n) + " bytes)");
                }
                if (n7 < 0) {
                    this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "no closing tag in conditional1: startIndex=" + n + " closingIndex=" + n7 + " len=" + this.strProcessedContent.length());
                    this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "error replacing conditional1: content=" + this.strProcessedContent.substring(n, Math.min(n + 2048, this.strProcessedContent.length())));
                    return;
                }
                if (n >= this.strProcessedContent.length() || n7 + 14 > this.strProcessedContent.length()) {
                    this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "error replacing conditional2: startIndex=" + n + " closingIndex+14=" + (n7 + 14) + " len=" + this.strProcessedContent.length());
                    this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "error replacing conditional2: content=" + this.strProcessedContent.substring(n, Math.min(n + 2048, this.strProcessedContent.length())));
                    return;
                }
                this.strProcessedContent.replace(n, n7 + 14, "");
                continue;
            }
            if (this.Debug && this.ProcessTimer != null) {
                this.ProcessTimer.addElement("Error in conditional: " + stringBuilder);
            }
            this.MainWin.appendToLog("THtmlContent", "replaceConditionals", Thread.currentThread(), null, 4, "Missing expression in conditional tag.  " + this.strProcessedContent.substring(n, n + 20) + "...");
            this.strProcessedContent.replace(n, n7 + 14, "");
        } while (n >= 0 && n2 >= 0);
    }

    public ArrayList getElements(String string) {
        ArrayList<THtmlTag> arrayList = new ArrayList<THtmlTag>();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (c == '<') {
                if (bl) continue;
                bl = true;
                n = i;
                continue;
            }
            if (c == '>') {
                if (!bl || bl2) continue;
                String string2 = string.substring(n + 1, i);
                String[] stringArray = charutil.getSubStringArray(string2, ' ', false);
                if (stringArray != null && stringArray.length > 0) {
                    THtmlTag tHtmlTag = new THtmlTag(stringArray[0]);
                    for (int j = 1; j < stringArray.length; ++j) {
                        String[] stringArray2 = charutil.getSubStringArray(stringArray[j], '=', false);
                        if (stringArray2 == null || stringArray2.length <= 0) continue;
                        if (stringArray2.length == 1) {
                            tHtmlTag.setProperty(stringArray2[0], null);
                            continue;
                        }
                        StringBuilder stringBuilder2 = new StringBuilder(stringArray2[1]);
                        for (int k = 2; k < stringArray2.length; ++k) {
                            stringBuilder2.append("=" + stringArray2[k]);
                        }
                        charutil.replace_char(stringBuilder2, stringBuilder2, '\'', '\"');
                        charutil.remove_quotes(stringBuilder2, stringBuilder2);
                        tHtmlTag.setProperty(stringArray2[0], stringBuilder2.toString());
                    }
                    arrayList.add(tHtmlTag);
                    stringBuilder.setLength(0);
                }
                bl = false;
                continue;
            }
            if (!bl) continue;
            stringBuilder.append(c);
        }
        return arrayList;
    }

    public void removeClientTags() {
        int n;
        String string = this.strProcessedContent.toString().toUpperCase();
        int n2 = 0;
        int n3 = string.indexOf("<CLIENT>", n2);
        while (n3 >= 0 && (n = string.indexOf("</CLIENT>", n3)) >= 0) {
            String string2;
            String string3 = this.strProcessedContent.substring(n3, n + 9);
            if (this.Debug && this.ProcessTimer != null) {
                string2 = charutil.replaceAllSubstrings(string3, "<", "&lt;");
                string2 = charutil.replaceAllSubstrings(string2, ">", "&gt;");
                this.ProcessTimer.addElement(string2);
            }
            string3 = charutil.replaceAllSubstrings(string3, "<client>", "");
            string3 = charutil.replaceAllSubstrings(string3, "</client>", "");
            string2 = "$" + TPasswordService.generateSalt(16).toUpperCase() + "$";
            if (this.hashClientTags == null) {
                this.hashClientTags = new Hashtable();
            }
            this.hashClientTags.put(string2, string3);
            this.strProcessedContent.delete(n3, n + 9);
            this.strProcessedContent.insert(n3, string2);
            string = this.strProcessedContent.toString().toUpperCase();
            n2 = n3 + 1;
            n3 = this.strProcessedContent.toString().toUpperCase().indexOf("<CLIENT>", n2);
        }
    }

    public void restoreClientContent() {
        if (this.hashClientTags == null) {
            return;
        }
        Enumeration enumeration = this.hashClientTags.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            charutil.replace_sub_string(this.strProcessedContent, this.strProcessedContent, string, (String)this.hashClientTags.get(string));
        }
    }

    public void processRecords(String string) {
        String string2 = this.strProcessedContent.toString().toUpperCase();
        int n = 0;
        int n2 = string2.indexOf(string, n);
        while (n2 >= 0) {
            Object object;
            Object object2;
            int n3 = string2.indexOf("</RECORD>", n2);
            if (n3 < 0) {
                System.out.println("No closing </record> found in:");
                System.out.println("=============================================================");
                System.out.println(this.strProcessedContent.substring(n2, n2 + 256));
                System.out.println("=============================================================");
                break;
            }
            String string3 = this.strProcessedContent.substring(n2, n3 + 9);
            int n4 = charutil.getNextOccurrence(string3, '>', 1, true);
            if (n4 < 0 || n4 > string3.length() - 1) {
                System.out.println("No closing '>' in record tag: " + string3);
                break;
            }
            String string4 = null;
            String string5 = null;
            String string6 = "";
            int n5 = string3.indexOf(32);
            if (n5 > 0 && n5 < n4) {
                object2 = string3.substring(n5 + 1, n4);
                String string7 = charutil.getParamValue((String)object2, "DriverID", ';');
                if (string7.length() > 0) {
                    string4 = charutil.removeQuotes(string7);
                }
                if ((string7 = charutil.getParamValue((String)object2, "Expression", ';')).length() > 0) {
                    string5 = charutil.replaceAllSubstrings(charutil.removeQuotes(string7), "'", "\"");
                }
                if ((string7 = charutil.getParamValue((String)object2, "DriverParams", ';')).length() > 0) {
                    string6 = charutil.removeQuotes(string7);
                }
            }
            string3 = string3.substring(n4 + 1);
            string3 = charutil.replaceAllSubstrings(string3, "<!record>", "");
            string3 = charutil.replaceAllSubstrings(string3, "</record>", "");
            if (string4 == null && string5 == null) {
                object2 = this.getElements(string3);
                for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                    THtmlTag tHtmlTag = (THtmlTag)((ArrayList)object2).get(i);
                    object = tHtmlTag.getProperty("Name");
                    if (object == null) continue;
                    Object object3 = tHtmlTag.getProperty("Value");
                    if (((String)object).equalsIgnoreCase("DriverID")) {
                        string4 = (String)object3;
                    }
                    if (((String)object).equalsIgnoreCase("Expression")) {
                        string5 = (String)object3;
                    }
                    if (!((String)object).equalsIgnoreCase("DriverParams")) continue;
                    string6 = (String)object3;
                }
            }
            if (string4 == null) {
                this.MainWin.appendToLog("THtmlContent", "processRecords", Thread.currentThread(), null, 4, "No driver ID supplied in record tag.");
                return;
            }
            if (string5 == null) {
                this.MainWin.appendToLog("THtmlContent", "processRecords", Thread.currentThread(), null, 4, "No expression supplied in record tag.");
                return;
            }
            if (this.Debug && this.ProcessTimer != null) {
                this.ProcessTimer.addElement("DriverID: " + string4 + " params: " + string6 + " Expression: " + string5);
            }
            object2 = new TAspectDriver(string4, 1, true, false, string6);
            ((TAspectDriver)object2).setActiveFilter(string5, true);
            int n6 = -1;
            boolean bl = false;
            switch (((TAspectDriver)object2).getRecordCount()) {
                case 0: {
                    n6 = ((TAspectDriver)object2).initializeNewRecord();
                    ((TAspectDriver)object2).addToFilterList(n6, 0);
                    n6 = ((TAspectDriver)object2).getFilteredIndex(n6);
                    bl = true;
                    break;
                }
                case 1: {
                    n6 = 0;
                    break;
                }
                default: {
                    this.MainWin.appendToLog("THtmlContent", "processRecordForm", Thread.currentThread(), null, 4, "More than one record matches the expression: " + string5 + " while processing record for " + string4);
                    n6 = 0;
                }
            }
            object = ((TAspectDriver)object2).getDriverStruct();
            string2 = string3.toUpperCase();
            for (int i = 0; i < ((TDriverStruct)object).FieldColl.size(); ++i) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)((TDriverStruct)object).FieldColl.get(i);
                if (string2.indexOf("__" + tDriverStructRecord.ID.toUpperCase() + "__") < 0 && string2.indexOf("__!" + tDriverStructRecord.ID.toUpperCase() + "__") < 0 && string2.indexOf("__$" + tDriverStructRecord.ID.toUpperCase() + "$__") < 0) continue;
                Object object4 = ((TAspectDriver)object2).getFieldForHtml(tDriverStructRecord, n6);
                Object object5 = ((TAspectDriver)object2).getField(tDriverStructRecord, n6);
                String string8 = tDriverStructRecord.FormatPattern;
                if (string8.length() == 0) {
                    string8 = objectutil.getDefaultPattern(tDriverStructRecord.FieldType);
                }
                String string9 = objectutil.applyPattern(object4, string8);
                string3 = charutil.replaceAllSubstrings(string3, "__" + tDriverStructRecord.ID + "__", string9);
                String string10 = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object5);
                string3 = charutil.replaceAllSubstrings(string3, "__!" + tDriverStructRecord.ID + "__", string10);
                string9 = charutil.replaceAllSubstrings(string9, "<", "&lt;");
                string9 = charutil.replaceAllSubstrings(string9, "'", "&#39;");
                string9 = charutil.replaceAllSubstrings(string9, "\"", "&#34;");
                string9 = charutil.replaceAllSubstrings(string9, "__", "&#95;&#95;");
                string9 = charutil.replaceAllSubstrings(string9, "{", "&#123;");
                string9 = charutil.replaceAllSubstrings(string9, "}", "&#125;");
                string3 = charutil.replaceAllSubstrings(string3, "__$" + tDriverStructRecord.ID + "$__", string9);
            }
            if (bl) {
                ((TAspectDriver)object2).deleteRecord(n6);
            }
            ((TAspectDriver)object2).dispose();
            this.strProcessedContent.replace(n2, n3 + 9, string3);
            this.removeClientTags();
            string2 = this.strProcessedContent.toString().toUpperCase();
            n = n2 + 1;
            n2 = this.strProcessedContent.toString().toUpperCase().indexOf(string, n);
        }
    }

    public void removeComments() {
        boolean bl = false;
        while (!bl) {
            String string = this.strProcessedContent.toString().toUpperCase();
            int n = string.indexOf("[!--");
            if (n >= 0) {
                int n2 = string.indexOf("--]", n);
                if (n2 > n) {
                    this.strProcessedContent.delete(n, n2 + 3);
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
    }

    public String getProcessedContent() {
        return this.getProcessedContent("", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProcessedContent(String string, boolean bl) {
        Object object;
        Object object2;
        ArrayList arrayList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        boolean bl2 = charutil.boolval(charutil.getParamValue(string, "binary", '&'));
        boolean bl3 = charutil.getParamValue(string, "Script", '&').equalsIgnoreCase("getExternalContents");
        if (this.strSourceContent == null) return "";
        if (this.strSourceContent.length() == 0) {
            return "";
        }
        String string14 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = charutil.getSubStringArray(string, '&', true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = charutil.getSubStringArray(stringArray[i], '=', true);
                if (object2 == null || ((String[])object2).length <= 1) continue;
                object = object2[1];
                for (int j = 2; j < ((String[])object2).length; ++j) {
                    object = (String)object + "=" + object2[j];
                }
                hashtable.put("__" + object2[0] + "__", (String)object);
                if (object2[0].equalsIgnoreCase("ThreadName")) {
                    this.ThreadName = object;
                }
                if (object2[0].equalsIgnoreCase("DocumentID") || object2[0].equalsIgnoreCase("Widget") || object2[0].equalsIgnoreCase("ContainerItemID") || object2[0].equalsIgnoreCase("Content")) continue;
                if (string14.length() > 0) {
                    string14 = string14 + "&";
                }
                string14 = string14 + object2[0] + "=" + (String)object;
            }
        }
        string9 = charutil.getParamValue(stringArray, "DocumentID");
        string10 = charutil.getParamValue(stringArray, "Widget");
        string11 = charutil.getParamValue(stringArray, "WidgetContainerItemID");
        if (string11.length() == 0) {
            string11 = charutil.getParamValue(stringArray, "ContainerItemID");
        }
        string12 = charutil.getParamValue(stringArray, "user-agent");
        string13 = charutil.getParamValue(stringArray, "RemoteIP");
        this.bIsMobileDoc = charutil.boolval(charutil.getParamValue(stringArray, "IsMobileDoc"));
        if (string9.length() == 0) {
            string9 = charutil.getParamValue(stringArray, "OldDocumentID");
        }
        if (string10.length() == 0) {
            string10 = charutil.getParamValue(stringArray, "OldWidget");
        }
        if (string11.length() == 0) {
            string11 = charutil.getParamValue(stringArray, "OldContainerItemID");
        }
        this.strProcessedContent.setLength(0);
        this.strProcessedContent.append(this.strSourceContent);
        int n = Math.min(this.strProcessedContent.length(), 10);
        if (n > 0) {
            string2 = this.strProcessedContent.substring(0, n).toUpperCase();
        }
        if (string2.startsWith("HTTP://") || string2.startsWith("HTTPS:/") || string2.startsWith("FILE:/")) {
            Object object3;
            this.replaceTokens();
            stringArray = dosutil.splitPath(this.strSourceContent);
            string4 = stringArray[0];
            string5 = stringArray[1];
            string6 = stringArray[2];
            string7 = stringArray[3];
            string8 = string4 + string5 + string6 + string7;
            if (string6 == null) {
                string6 = "";
            }
            if (string7 == null) {
                string7 = "";
            }
            if (string2.startsWith("FILE:/") || this.strProcessedContent.toString().toUpperCase().indexOf("ASPECT7.JAR") > 0 || !string2.startsWith("HTTP") && (this.strProcessedContent.toString().toUpperCase().indexOf(".JAR") > 0 || this.strProcessedContent.toString().toUpperCase().indexOf(".ZIP") > 0)) {
                object3 = this.strProcessedContent.toString();
                n = ((String)object3).indexOf("?");
                if (n > 0) {
                    object3 = ((String)object3).substring(0, n - 1);
                }
                object2 = new TAsciiInput((String)object3, '\u0000', true);
                object = ((TAsciiInput)object2).get_entire_file();
                ((TAsciiInput)object2).dispose();
                if (object == null || ((Object)object).length == 0) {
                    if (this.strProcessedContent.toString().toUpperCase().indexOf("CGIEMAIL") >= 0) return "Error reading page.";
                    this.MainWin.appendToLog("THtmlViewer", "getLinkContent", Thread.currentThread(), null, 4, "\tError reading link: " + this.strProcessedContent);
                    return "Error reading page.";
                }
                this.strProcessedContent.setLength(0);
                this.strProcessedContent.append(new String((byte[])object));
            } else {
                object3 = dosutil.makeURL(this.strProcessedContent.toString());
                object2 = new String[6];
                object2[0] = ((URL)object3).getHost();
                object2[1] = ((URL)object3).getPath();
                if (((String)object2[1]).length() == 0) {
                    object2[1] = "/";
                }
                object2[2] = ((URL)object3).getQuery() == null ? "" : ((URL)object3).getQuery();
                object2[3] = ((URL)object3).getPort() < 0 ? "80" : Integer.toString(((URL)object3).getPort());
                object2[4] = "60000";
                object2[5] = "false";
                if (string2.startsWith("HTTPS:/")) {
                    object2[5] = "true";
                }
                this.strProcessedContent.setLength(0);
                object = "httpGet(\"" + (String)object2[0] + "\",\"" + (String)object2[1] + "\",\"" + (String)object2[2] + "\"," + (String)object2[3] + "," + (String)object2[4] + ",true," + (String)object2[5] + ")";
                this.strProcessedContent.append(new TFormulaEvaluator().getFormulaValue((String)object, -1, -1));
            }
            if (stringArray != null && stringArray.length > 1) {
                if (stringArray[0].toUpperCase().startsWith("HTTP") || stringArray[0].toUpperCase().startsWith("HTTPS")) {
                    try {
                        object3 = dosutil.makeURL(TMainWin.Application.parse_tokens(this.strSourceContent));
                        string3 = charutil.replaceAllSubstrings(stringArray[0] + stringArray[1], "\\", "/");
                    }
                    catch (Exception exception) {}
                } else {
                    string3 = charutil.replaceAllSubstrings(stringArray[0] + stringArray[1], "\\", "/");
                }
                string3 = dosutil.addTrailingSlash(string3);
            }
        } else {
            string3 = "";
            if (this.strOriginalSource.length() > 0 && !this.strOriginalSource.startsWith("<")) {
                stringArray = dosutil.splitPath(this.strOriginalSource);
                string4 = stringArray[0];
                string5 = stringArray[1];
                string6 = stringArray[2];
                string7 = stringArray[3];
                string8 = string4 + string5 + string6 + string7;
                if (string6 == null) {
                    string6 = "";
                }
                if (string7 == null) {
                    string7 = "";
                }
                string3 = charutil.replaceAllSubstrings(string4 + string5, "\\", "/");
            }
        }
        boolean bl4 = false;
        if (this.strProcessedContent.toString().toUpperCase().indexOf("SERVERDEBUG=TRUE") >= 0) {
            this.Debug = true;
        }
        if (this.strProcessedContent.toString().toUpperCase().indexOf("SERVERTIMER=TRUE") >= 0) {
            this.Debug = true;
            bl4 = true;
        }
        if (bl4) {
            this.ProcessTimer = new TProcessTimer();
        }
        this.removeClientTags();
        if (bl4) {
            this.ProcessTimer.addEvent("remove ClientTags");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "href=\"{packageurl_", "href=\"file://{packageurl_");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "src=\"{packageurl_", "src=\"file://{packageurl_");
        if (bl4) {
            this.ProcessTimer.addEvent("restore // roots");
        }
        this.removeStateTag();
        if (this.strProcessedContent.toString().toUpperCase().indexOf("[SRC") >= 0) {
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src]", this.strSourceContent);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_name]", string6);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_ext]", string7);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_drive]", string4);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_dir]", string5);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_filename]", string8);
            if (bl4) {
                this.ProcessTimer.addEvent("replace [src reference");
            }
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[baseurl]", string3);
        if (bl4) {
            this.ProcessTimer.addEvent("replace [baseurl reference");
        }
        if (bl4) {
            if (this.strProcessedContent.toString().toUpperCase().indexOf("__PAGEARGS__") >= 0) {
                this.ProcessTimer.addElement("replace __PageArgs__ with " + string);
            } else {
                this.ProcessTimer.addElement("no PageArgs token found");
            }
            this.ProcessTimer.addEvent("replace PageArgs token");
        }
        object2 = charutil.replaceChar(string14, '&', '~');
        object2 = charutil.removeChar((String)object2, '(');
        object2 = charutil.removeChar((String)object2, ')');
        object2 = charutil.removeChar((String)object2, ';');
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "__PageArgs__", (String)object2);
        object2 = charutil.replaceAllSubstrings((String)object2, ";", "\\semicolon\\");
        object2 = charutil.replaceAllSubstrings((String)object2, "\"", "\\quote\\");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "__PageArgs1__", (String)object2);
        this.replacePageArgs(hashtable);
        if (bl4) {
            this.ProcessTimer.addEvent("replace page args1");
        }
        this.replaceIncludeTags("constant", arrayList, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <constant1>");
        }
        this.replaceConstants(arrayList);
        if (bl4) {
            this.ProcessTimer.addEvent("replace constants1");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[baseurl]", string3);
        if (bl4) {
            this.ProcessTimer.addEvent("replace baseurl");
        }
        this.replaceIncludeTags("__include", null, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("replace <__include>");
        }
        this.replaceIncludeTags("constant", arrayList, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <constant1a>");
        }
        this.replaceConstants(arrayList);
        if (bl4) {
            this.ProcessTimer.addEvent("replace constants1a");
        }
        this.replaceConditionals("<_CONDITIONAL");
        if (bl4) {
            this.ProcessTimer.addEvent("process <_conditional>");
        }
        this.replaceIncludeTags("_include", null, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("replace <_include>");
        }
        this.replaceIncludeTags("constant", arrayList, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <constant1b>");
        }
        this.replaceIncludeTags("include", null, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("replace <include>");
        }
        this.replaceIncludeTags("constant", arrayList, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <constant2>");
        }
        this.replaceConstants(arrayList);
        if (bl4) {
            this.ProcessTimer.addEvent("replace constants2");
        }
        this.replacePageArgs(hashtable);
        if (bl4) {
            this.ProcessTimer.addEvent("replace page args2");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "http://viewsource.", "http://_viewsource.");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "https://viewsource.", "https://_viewsource.");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "http://viewsource", "http://viewsrc.[src]");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "https://viewsource", "https://viewsrc.[src]");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "http://_viewsource.", "http://viewsrc.");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "https://_viewsource.", "https://viewsrc.");
        if (bl4) {
            this.ProcessTimer.addEvent("replace viewsource");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "http://sendto.", "http://_sendto.");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "https://sendto.", "https://_sendto.");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "http://sendto", "http://send.[src]");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "https://sendto", "https://send.[src]");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "http://_sendto.", "http://send.");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "https://_sendto.", "https://send.");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "http://sendto", "http://send.[src]");
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "https://sendto", "https://send.[src]");
        if (bl4) {
            this.ProcessTimer.addEvent("replace sendto");
        }
        if (this.strProcessedContent.toString().toUpperCase().indexOf("[SRC") >= 0) {
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src]", this.strSourceContent);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_name]", string6);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_ext]", string7);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_drive]", string4);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_dir]", string5);
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_filename]", string8);
            if (bl4) {
                this.ProcessTimer.addEvent("replace [src");
            }
        }
        if (!bl2) {
            this.replaceTokens();
        }
        if (bl4) {
            this.ProcessTimer.addEvent("replaceTokens");
        }
        this.processRecords("<RECORD");
        if (bl4) {
            this.ProcessTimer.addEvent("process <record>");
        }
        this.replaceConditionals("<CONDITIONAL");
        if (bl4) {
            this.ProcessTimer.addEvent("process <conditional>");
        }
        this.processRecords("<!RECORD");
        if (bl4) {
            this.ProcessTimer.addEvent("process <!record>");
        }
        this.replaceIncludeTags("!include", null, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <!include>");
        }
        this.replaceIncludeTags("constant", arrayList, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <constant3>");
        }
        this.replaceConstants(arrayList);
        if (bl4) {
            this.ProcessTimer.addEvent("replace constants3");
        }
        this.replacePageArgs(hashtable);
        if (bl4) {
            this.ProcessTimer.addEvent("replace page args3");
        }
        this.replaceConditionals("<!CONDITIONAL");
        if (bl4) {
            this.ProcessTimer.addEvent("process <!conditional>");
        }
        if (bl2) {
            return this.strProcessedContent.toString();
        }
        this.replaceBraces(this.strProcessedContent, this.strProcessedContent, '{', '\u00fe', "style");
        this.replaceBraces(this.strProcessedContent, this.strProcessedContent, '{', '\u00fe', "script");
        this.replaceTokens();
        this.replaceBraces(this.strProcessedContent, this.strProcessedContent, '\u00fe', '{', "style");
        this.replaceBraces(this.strProcessedContent, this.strProcessedContent, '\u00fe', '{', "script");
        if (bl4) {
            this.ProcessTimer.addEvent("replace tokens");
        }
        if (bl) {
            this.replaceRelativeLinks(string3);
        }
        if (bl4) {
            this.ProcessTimer.addEvent("replace relative links");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "processHtml:", "http://127.0.0.1:" + TMainWin.Application.getTokenValue("GreenLight_Client_Http_Port") + "/?Network=GreenLight&ID=processHtml&url=");
        if (bl4) {
            this.ProcessTimer.addEvent("replace processHtml");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src]", this.strSourceContent);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_name]", string6);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_ext]", string7);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_drive]", string4);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_dir]", string5);
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "[src_filename]", string8);
        if (bl4) {
            this.ProcessTimer.addEvent("replace [src");
        }
        this.replaceJarredFiles(".jar");
        this.replaceJarredFiles(".zip");
        if (bl4) {
            this.ProcessTimer.addEvent("replace jarred files");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "file:////", "file:///");
        if (!bl3) {
            this.replaceIncludeTags("!!include", null, string9, string10, string11, string12, string13, string);
        }
        if (bl4) {
            this.ProcessTimer.addEvent("process <!!include>");
        }
        this.replaceIncludeTags("constant", arrayList, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <constant4>");
        }
        this.replaceConstants(arrayList);
        if (bl4) {
            this.ProcessTimer.addEvent("replace constants4");
        }
        this.replacePageArgs(hashtable);
        if (bl4) {
            this.ProcessTimer.addEvent("replace page args4");
        }
        this.replaceConditionals("<!!CONDITIONAL");
        if (bl4) {
            this.ProcessTimer.addEvent("process <!!conditional>");
        }
        this.replaceIncludeTags("!!!include", null, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <!!!include>");
        }
        this.replaceIncludeTags("constant", arrayList, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <constant5>");
        }
        this.replaceConstants(arrayList);
        if (bl4) {
            this.ProcessTimer.addEvent("replace constants5");
        }
        this.replaceConditionals("<!!!CONDITIONAL");
        if (bl4) {
            this.ProcessTimer.addEvent("process <!!conditional>");
        }
        if (bl4) {
            if (this.strProcessedContent.toString().toUpperCase().indexOf("__PAGEARGS__") >= 0) {
                this.ProcessTimer.addElement("replace __PageArgs__ with " + string);
            } else {
                this.ProcessTimer.addElement("no PageArgs token found");
            }
            this.ProcessTimer.addEvent("replace PageArgs token");
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "__PageArgs__", charutil.replaceChar(string14, '&', '~'));
        this.replaceIncludeTags("!!!!!include", null, string9, string10, string11, string12, string13, string);
        if (bl4) {
            this.ProcessTimer.addEvent("process <!!!!!include>");
        }
        if (!bl3) {
            this.removeComments();
        }
        if (this.WrapInHtmlTags && this.strProcessedContent.toString().toUpperCase().indexOf("<HTML") < 0) {
            this.strProcessedContent.insert(0, "<html>");
        }
        if (!bl3) {
            object = "https://127.0.0.1:" + TMainWin.Application.getTokenValue("greenlight_client_https_port");
            String string15 = "http://127.0.0.1:" + TMainWin.Application.getTokenValue("greenlight_client_http_port");
            charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, (String)object, string15);
        }
        if (!this.boolRemoveClientContent) {
            this.restoreClientContent();
            if (bl4) {
                this.ProcessTimer.addEvent("replace <client> tags");
            }
        }
        if (bl3) return this.strProcessedContent.toString();
        if (bl4) {
            if (TMainWin.Application.getTokenValue("execmode").equalsIgnoreCase("development")) {
                this.ProcessTimer.addEvent("Finished");
                object = new StringBuilder();
                ((StringBuilder)object).append("<h2>Arguments</h2>");
                ((StringBuilder)object).append("<table>");
                ((StringBuilder)object).append("<tr><th align='left'>Name</th><th align='left'>Value</th></tr>");
                Enumeration enumeration = hashtable.keys();
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        ((StringBuilder)object).append("</table><br><h2>Processing</h2>");
                        ((StringBuilder)object).append(this.ProcessTimer.getResults());
                        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "__ServerTimerResults__", ((StringBuilder)object).toString());
                        this.ProcessTimer.dispose();
                        return this.strProcessedContent.toString();
                    }
                    String string16 = (String)enumeration.nextElement();
                    String string17 = (String)hashtable.get(string16);
                    ((StringBuilder)object).append("<tr><td>" + string16 + "</td><td>" + string17 + "</td></tr>");
                }
            }
        }
        charutil.replaceAllSubstrings(this.strProcessedContent, this.strProcessedContent, "__ServerTimerResults__", "");
        return this.strProcessedContent.toString();
    }

    class TProcessTimer {
        ArrayList arDescription = new ArrayList();
        ArrayList arTime = new ArrayList();
        ArrayList arElements = new ArrayList();
        StringBuilder strElement = new StringBuilder();
        Date tmStart = null;
        long intTotal = 0L;

        TProcessTimer() {
        }

        void dispose() {
            this.arDescription.clear();
            this.arTime.clear();
            this.arElements.clear();
        }

        void addEvent(String string) {
            Date date = new Date();
            if (this.tmStart == null) {
                this.tmStart = date;
            } else {
                this.intTotal = date.getTime() - this.tmStart.getTime();
            }
            String string2 = charutil.replaceAllSubstrings(string, "<", "&lt;");
            string2 = charutil.replaceAllSubstrings(string2, ">", "&gt;");
            string2 = charutil.replaceAllSubstrings(string2, "[", "%5B");
            string2 = charutil.replaceAllSubstrings(string2, "]", "%5D");
            this.arTime.add(date);
            this.arDescription.add(string2);
            this.arElements.add(new String(this.strElement));
            this.strElement.setLength(0);
        }

        void addElement(String string) {
            String string2 = charutil.replaceAllSubstrings(string, "<", "&lt;");
            string2 = charutil.replaceAllSubstrings(string2, ">", "&gt;");
            string2 = charutil.replaceAllSubstrings(string2, "[", "&#91;");
            string2 = charutil.replaceAllSubstrings(string2, "]", "&#93;");
            string2 = charutil.replaceAllSubstrings(string2, "{", "&#123;");
            string2 = charutil.replaceAllSubstrings(string2, "}", "&#125;");
            string2 = charutil.replaceAllSubstrings(string2, "_", "&#95;");
            string2 = charutil.replaceAllSubstrings(string2, "#3c", "<");
            string2 = charutil.replaceAllSubstrings(string2, "#3e", ">");
            this.strElement.append(string2 + "<br>");
        }

        void addElement(String string, long l) {
            String string2 = charutil.replaceAllSubstrings(string, "<", "&lt;");
            string2 = charutil.replaceAllSubstrings(string2, ">", "&gt;");
            string2 = charutil.replaceAllSubstrings(string2, "[", "&#91;");
            string2 = charutil.replaceAllSubstrings(string2, "]", "&#93;");
            string2 = charutil.replaceAllSubstrings(string2, "{", "&#123;");
            string2 = charutil.replaceAllSubstrings(string2, "}", "&#125;");
            string2 = charutil.replaceAllSubstrings(string2, "_", "&#95;");
            string2 = charutil.replaceAllSubstrings(string2, "#3c", "<");
            string2 = charutil.replaceAllSubstrings(string2, "#3e", ">");
            string2 = string2 + "<span style='font-weight:bold'>[" + l + "ms]</span>";
            this.strElement.append(string2 + "<br><br>");
        }

        String getResults() {
            long l = 0L;
            long l2 = 0L;
            Date date = null;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<table border='1'><tr>\r\n");
            stringBuilder.append("<th style='border-width:1px; border-style:solid; padding:5px'>Time</th>\r\n");
            stringBuilder.append("<th style='border-width:1px; border-style:solid; padding:5px'>%</th>\r\n");
            stringBuilder.append("<th style='border-width:1px; border-style:solid; padding:5px'>Total</th>\r\n");
            stringBuilder.append("<th style='border-width:1px; border-style:solid; padding:5px' align='left'>Description</th>\r\n");
            if (THtmlContent.this.Debug) {
                stringBuilder.append("<th style='border-width:1px; border-style:solid; padding:5px' align='left'>Elements</th>\r\n</tr>\r\n");
            }
            for (int i = 0; i < this.arDescription.size(); ++i) {
                l = 0L;
                if (date != null) {
                    l = ((Date)this.arTime.get(i)).getTime() - date.getTime();
                }
                l2 += l;
                double d = 0.0;
                if (this.intTotal > 0L) {
                    d = (double)l / (double)this.intTotal;
                }
                stringBuilder.append("<tr>\r\n");
                stringBuilder.append("<td align='right' style='border-width:1px; border-style:solid; padding:5px'>" + objectutil.applyPattern(new Long(l), "####") + "</td>\r\n");
                String string = objectutil.applyPattern(new Double(d), "###%");
                if (d >= 0.1) {
                    string = "<font color='red'>" + string + "</font>";
                }
                stringBuilder.append("<td align='right' style='border-width:1px; border-style:solid; padding:5px'>" + string + "</td>\r\n");
                stringBuilder.append("<td align='right' style='border-width:1px; border-style:solid; padding:5px'>" + objectutil.applyPattern(new Long(l2), "#####") + "</td>\r\n");
                stringBuilder.append("<td align='left' style='border-width:1px; border-style:solid; padding:5px'>" + this.arDescription.get(i) + "</td>\r\n");
                if (THtmlContent.this.Debug) {
                    stringBuilder.append("<td align='left' style='width:500px; border-width:1px; border-style:solid; padding:5px'>" + this.arElements.get(i) + "</td>\r\n");
                }
                stringBuilder.append("</tr>\r\n");
                date = (Date)this.arTime.get(i);
            }
            stringBuilder.append("</table>\r\n");
            stringBuilder.append("Total time: " + this.intTotal + " ms\r\n");
            return stringBuilder.toString();
        }
    }
}

