/*
 * Decompiled with CFR 0.152.
 */
package controls.htmlviewer;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TDatePicker;
import controls.htmlviewer.THtmlContent;
import controls.htmlviewer.THtmlEditorKit;
import controls.htmlviewer.THtmlEditorPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import pub.exec;
import resources.TAppActionObject;
import scripts.TExecScript;
import utility.TFile;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.email.TSendMail;
import utility.imageutil;

public class THtmlViewer
extends JScrollPane
implements HyperlinkListener,
ActionListener,
PropertyChangeListener,
DocumentListener {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTHtmlViewer");
    private THtmlEditorPane EditorPane;
    private String strHomePage = null;
    private Stack stackBack = new Stack();
    private Stack stackNext = new Stack();
    private ArrayList arListeners = new ArrayList();
    private PopupListener popupListener;
    private Component DefaultFocus = null;
    private String strSetText = "";
    private File TempFile = null;
    private TSetTextThread SetTextThread = null;
    private boolean InSetText = false;
    private boolean InPropertyChange = false;
    private Component lastComponent = null;

    public THtmlViewer(THtmlEditorPane tHtmlEditorPane) {
        super(tHtmlEditorPane, 20, 30);
        if (!(tHtmlEditorPane instanceof THtmlEditorPane)) {
            System.out.println("THtmlViewer not initialized with THtmlEditorPane");
        }
        this.EditorPane = tHtmlEditorPane;
        this.EditorPane.setEditable(false);
        this.EditorPane.addHyperlinkListener(this);
        this.EditorPane.setEditorKit(new THtmlEditorKit());
        ((THtmlEditorKit)this.EditorPane.getEditorKit()).setAutoFormSubmission(false);
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.EditorPane.setBorder(null);
        this.popupListener = new PopupListener();
        this.EditorPane.addMouseListener(this.popupListener);
        this.EditorPane.addPropertyChangeListener(this);
    }

    public File getTempFile() {
        if (this.TempFile == null) {
            String string = TMainWin.Application.getHomeDir() + "temporary_files/";
            File file = new File(string);
            try {
                if (file.exists() && file.isFile()) {
                    file.delete();
                }
                file.mkdir();
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TBinaryFile", "getRecord", Thread.currentThread(), exception, 4, "Error creating directory. " + string);
            }
            this.TempFile = dosutil.createTempFile(string, ".$$$");
            this.TempFile.deleteOnExit();
        }
        return this.TempFile;
    }

    public void addListener(JComponent jComponent) {
        this.arListeners.add(jComponent);
    }

    public void removeListener(JComponent jComponent) {
        if (this.arListeners.contains(jComponent)) {
            this.arListeners.remove(jComponent);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("page")) {
            this.addFramePopupListener(this.EditorPane);
            this.setButtonRollovers(((HTMLDocument)this.EditorPane.getDocument()).getDefaultRootElement());
        }
        if (!this.isShowing()) {
            return;
        }
        if (this.InPropertyChange) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("document")) {
            if (this.DefaultFocus == null) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        THtmlViewer.this.InPropertyChange = true;
                        for (int i = 0; THtmlViewer.this.DefaultFocus == null && i < 20; ++i) {
                            THtmlViewer.this.setDefaultComponent(THtmlViewer.this.EditorPane);
                            dosutil.sleep(this, 500);
                        }
                        if (THtmlViewer.this.DefaultFocus != null) {
                            THtmlViewer.this.DefaultFocus.requestFocus();
                        }
                        THtmlViewer.this.InPropertyChange = false;
                    }
                };
                thread.setPriority(1);
                thread.start();
            } else {
                this.DefaultFocus.requestFocus();
            }
        }
    }

    Element findElement(Element element, Element element2) {
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element3 = element.getElement(i);
            if (element3.equals(element2)) {
                return element3;
            }
            Element element4 = this.findElement(element3, element2);
            if (element4 == null) continue;
            return element4;
        }
        return null;
    }

    public void setDefaultComponent(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            try {
                Component component = container.getComponent(i);
                if (component instanceof JTextField || component instanceof JCheckBox || component instanceof JPasswordField || component instanceof JRadioButton || component instanceof JList || component instanceof JComboBox || component instanceof JTextArea) {
                    this.DefaultFocus = component;
                    component.requestFocus();
                }
                if (!(component instanceof Container)) continue;
                this.setDefaultComponent((Container)component);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addFramePopupListener(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            try {
                Component component = container.getComponent(i);
                if (component.getClass().getName().indexOf("FrameView") > 0) {
                    component.removeMouseListener(this.popupListener);
                    component.addMouseListener(this.popupListener);
                }
                if (!(component instanceof Container)) continue;
                this.addFramePopupListener((Container)component);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setButtonRollovers(Element element) {
        Object object;
        Object object2;
        if (element == null) {
            return;
        }
        Component component = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        AttributeSet attributeSet = element.getAttributes();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = object2.toString();
            if (((String)object).equalsIgnoreCase("model") || ((String)object).equalsIgnoreCase("type")) {
                component = this.getComponent(element);
            }
            if (((String)object).equalsIgnoreCase("rollover")) {
                string = attributeSet.getAttribute(object2).toString();
                if (!string.toUpperCase().startsWith("FILE")) continue;
                string = charutil.replaceAllSubstrings(string, "%20", " ");
                continue;
            }
            if (((String)object).equalsIgnoreCase("editable")) {
                if (!attributeSet.getAttribute(object2).toString().equalsIgnoreCase("true")) continue;
                bl = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("img")) {
                string2 = attributeSet.getAttribute(object2).toString();
                continue;
            }
            if (((String)object).equalsIgnoreCase("width")) {
                n = charutil.ival(attributeSet.getAttribute(object2).toString());
                continue;
            }
            if (((String)object).equalsIgnoreCase("height")) {
                n2 = charutil.ival(attributeSet.getAttribute(object2).toString());
                continue;
            }
            if (!((String)object).equalsIgnoreCase("tooltip")) continue;
            string3 = attributeSet.getAttribute(object2).toString();
        }
        if (component != null && component instanceof JComponent && string3 != null) {
            ((JComponent)component).setToolTipText(string3);
        }
        if (component != null && component instanceof JButton) {
            Serializable serializable;
            object2 = (JButton)component;
            if (((AbstractButton)object2).getIcon() != null) {
                ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder());
                ((AbstractButton)object2).setBorderPainted(false);
                ((AbstractButton)object2).setContentAreaFilled(false);
                ((AbstractButton)object2).setRolloverEnabled(false);
            }
            if (object2 != null && string2 != null) {
                ImageIcon imageIcon;
                object = ((JComponent)object2).getBorder();
                serializable = object.getBorderInsets((Component)object2);
                ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(serializable.top, serializable.top, serializable.bottom, serializable.right));
                Image image = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(string2), -1, -1);
                if (image != null) {
                    imageIcon = new ImageIcon(image);
                    ((AbstractButton)object2).setIcon(imageIcon);
                    if (((AbstractButton)object2).getText().length() == 0) {
                        ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder());
                        ((AbstractButton)object2).setBorderPainted(false);
                        ((AbstractButton)object2).setContentAreaFilled(false);
                    }
                }
                if (string != null && (image = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(string), -1, -1)) != null) {
                    imageIcon = new ImageIcon(image);
                    ((AbstractButton)object2).setRolloverIcon(imageIcon);
                    ((AbstractButton)object2).setRolloverEnabled(true);
                }
            }
            if (string != null && (object = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(string), -1, -1)) != null) {
                serializable = new ImageIcon((Image)object);
                ((AbstractButton)object2).setRolloverIcon((Icon)((Object)serializable));
                ((AbstractButton)object2).setRolloverEnabled(true);
            }
        }
        if (component != null && component instanceof JComboBox) {
            object2 = (JComboBox)component;
            object = ((JComponent)object2).getPreferredSize();
            if (n > 0 || n2 > 0) {
                if (n > 0) {
                    ((Dimension)object).width = n;
                }
                if (n2 > 0) {
                    ((Dimension)object).height = n2;
                }
                ((JComponent)object2).setPreferredSize((Dimension)object);
                ((JComponent)object2).setMinimumSize((Dimension)object);
                ((JComboBox)object2).updateUI();
            }
        }
        if (component != null && component instanceof JTextField) {
            object2 = (JTextField)component;
            object = ((JTextField)object2).getPreferredSize();
            if (n > 0 || n2 > 0) {
                if (n > 0) {
                    ((Dimension)object).width = n;
                }
                if (n2 > 0) {
                    ((Dimension)object).height = n2;
                }
                ((JComponent)object2).setPreferredSize((Dimension)object);
                ((JComponent)object2).setMinimumSize((Dimension)object);
                ((JTextComponent)object2).updateUI();
            }
        }
        int n3 = element.getElementCount();
        for (int i = 0; i < n3; ++i) {
            this.setButtonRollovers(element.getElement(i));
        }
    }

    public Component findComponent(Container container, Object object) {
        Component component = null;
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            try {
                ComboBoxModel comboBoxModel;
                component = container.getComponent(i);
                if (!(component instanceof JTextField ? (comboBoxModel = (PlainDocument)((JTextField)component).getDocument()).equals(object) : (component instanceof JButton ? (comboBoxModel = ((JButton)component).getModel()).equals(object) : (component instanceof JComboBox ? (comboBoxModel = ((JComboBox)component).getModel()).equals(object) : component instanceof Container && (component = this.findComponent((Container)component, object)) != null)))) continue;
                return component;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Component getComponent(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object obj = enumeration.nextElement();
            if (!obj.toString().equalsIgnoreCase("model") || (object = attributeSet.getAttribute(obj)) == null) continue;
            Component component = this.findComponent(this.EditorPane, object);
            return component;
        }
        return null;
    }

    public void setElementText(String string, String string2) {
        Element element = ((HTMLDocument)this.EditorPane.getDocument()).getElement(string);
        if (element != null) {
            AttributeSet attributeSet = element.getAttributes();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (!obj.toString().equalsIgnoreCase("model")) continue;
                Object object = attributeSet.getAttribute(obj);
                if (object instanceof PlainDocument) {
                    PlainDocument plainDocument = (PlainDocument)object;
                    try {
                        plainDocument.remove(0, plainDocument.getLength());
                        plainDocument.insertString(0, string2, new SimpleAttributeSet());
                    }
                    catch (Exception exception) {
                        System.out.println("error in setElementText: " + exception.toString());
                    }
                    continue;
                }
                if (object instanceof JToggleButton.ToggleButtonModel) {
                    if (string2.equalsIgnoreCase("true")) {
                        ((JToggleButton.ToggleButtonModel)object).setSelected(true);
                        continue;
                    }
                    ((JToggleButton.ToggleButtonModel)object).setSelected(false);
                    continue;
                }
                if (object instanceof ComboBoxModel) {
                    ((ComboBoxModel)object).setSelectedItem(string2);
                    continue;
                }
                System.out.println("Model is a " + object.getClass().getName());
            }
        }
    }

    public String getElementText(String string) {
        Element element = ((HTMLDocument)this.EditorPane.getDocument()).getElement(string);
        if (element != null) {
            AttributeSet attributeSet = element.getAttributes();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (!obj.toString().equalsIgnoreCase("model")) continue;
                Object object = attributeSet.getAttribute(obj);
                if (object instanceof PlainDocument) {
                    PlainDocument plainDocument = (PlainDocument)object;
                    try {
                        return plainDocument.getText(0, plainDocument.getLength());
                    }
                    catch (Exception exception) {
                        System.out.println("error in getElementText: " + exception.toString());
                        continue;
                    }
                }
                this.MainWin.appendToLog("THtmlViewer", "getElementText", Thread.currentThread(), null, 4, "Element uses unrecognized model");
            }
        }
        return null;
    }

    public void processFormSubmission(final HyperlinkEvent hyperlinkEvent) {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        boolean bl = false;
        if (((FormSubmitEvent)hyperlinkEvent).getData().toUpperCase().indexOf("DEBUG=TRUE") > 0) {
            System.out.println("____________________________________________________");
            System.out.println("Form submitted");
            System.out.println("url=" + hyperlinkEvent.getURL());
            System.out.println("port=" + hyperlinkEvent.getURL().getPort());
            System.out.println("Method=" + (Object)((Object)((FormSubmitEvent)hyperlinkEvent).getMethod()));
            System.out.println("Data=" + ((FormSubmitEvent)hyperlinkEvent).getData());
            System.out.println("____________________________________________________");
        }
        if ((string2 = (string = hyperlinkEvent.getURL().toString()).toUpperCase()).startsWith("FILE:/") && !string2.startsWith("FILE://")) {
            string = "file://" + string.substring(5);
            string2 = string.toUpperCase();
        }
        final String string3 = string;
        final String string4 = string2;
        boolean bl2 = string4.startsWith("HTTPS");
        String string5 = ((FormSubmitEvent)hyperlinkEvent).getData();
        string = charutil.tokenizeForPost(string5, false);
        if (string.length() > 0 && (object3 = charutil.getSubStringArray(string, '&', true)) != null && ((Object)object3).length > 0) {
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object2 = charutil.getSubStringArray((String)object3[i], '=', true);
                if (object2 == null || ((String[])object2).length <= 1) continue;
                if (object2[0].startsWith("*")) {
                    object = new StringBuilder();
                    for (int j = 1; j < ((String[])object2).length; ++j) {
                        if (j > 1) {
                            ((StringBuilder)object).append("=");
                        }
                        ((StringBuilder)object).append(object2[j]);
                    }
                    TMainWin.Application.setTokenValue(object2[0].substring(1), charutil.replaceChar(((StringBuilder)object).toString(), '+', ' '));
                    continue;
                }
                if (object2[0].equalsIgnoreCase("refresh") && object2[1].equalsIgnoreCase("true")) {
                    bl = true;
                    continue;
                }
                if (object2[0].toUpperCase().startsWith("DATECHOOSER-")) {
                    object = charutil.getSubStringArray(object2[0], '-', true);
                    String string6 = object[1];
                    string6 = charutil.replaceAllSubstrings(string6, ".x", "");
                    string6 = charutil.replaceAllSubstrings(string6, ".y", "");
                    Element element = ((HTMLDocument)this.EditorPane.getDocument()).getElement(string6);
                    if (element != null) {
                        String string7 = this.getElementText(string6);
                        Date date = dateutil.parseDate(string7);
                        Component component = this.getComponent(element);
                        Rectangle rectangle = component.getBounds();
                        Point point = new Point(component.getX(), component.getY());
                        SwingUtilities.convertPointToScreen(point, component);
                        date = TDatePicker.selectDate(this.MainWin, date, point.x, point.y + rectangle.height);
                        if (date != null) {
                            this.setElementText(string6, dateutil.formatDate(date, "MM-dd-yyyy"));
                        }
                    }
                    return;
                }
                if (!object2[0].toUpperCase().startsWith("FILECHOOSER-")) continue;
                object = charutil.getSubStringArray(object2[0], '-', true);
                String[] stringArray = new String[3];
                String string8 = object[1];
                string8 = charutil.replaceAllSubstrings(string8, ".x", "");
                string8 = charutil.replaceAllSubstrings(string8, ".y", "");
                stringArray[0] = "";
                stringArray[1] = "";
                stringArray[2] = "file";
                if (((Object)object).length > 2) {
                    stringArray[0] = object[2];
                }
                if (((Object)object).length > 3) {
                    stringArray[1] = object[3];
                }
                if (((Object)object).length > 4) {
                    stringArray[2] = object[4];
                }
                if (exec.selectFile(stringArray).booleanValue()) {
                    this.setElementText(string8, TMainWin.Application.getTokenValue("$SelectFile"));
                }
                return;
            }
        }
        if (((String)(object3 = charutil.replaceAllSubstrings(string5, "&*", "&"))).startsWith("*")) {
            object3 = ((String)object3).substring(1);
        }
        Object object4 = object3;
        if (string4.startsWith("HTTP://!") || string4.startsWith("HTTPS://!")) {
            System.out.println("strHyperlink=" + string3);
            System.out.println("strData=" + (String)object4);
            object2 = new StringBuilder(string3 + "?" + charutil.tokenizeForPost((String)object4, false));
            charutil.remove_char((StringBuilder)object2, (StringBuilder)object2, '!');
            exec.launchViewer(((StringBuilder)object2).toString());
            return;
        }
        boolean bl3 = bl;
        if (string4.startsWith("HTTP://BACK")) {
            this.previousPage();
            return;
        }
        if (string4.startsWith("HTTP://NEXT")) {
            this.nextPage();
            return;
        }
        if (string4.startsWith("HTTP://HOME")) {
            this.homePage();
            return;
        }
        if (string4.startsWith("HTTP://REFRESH")) {
            this.refresh();
            return;
        }
        if (string4.startsWith("HTTP://MAILTO:")) {
            exec.launchViewer(hyperlinkEvent.getURL().toString().substring(7));
            return;
        }
        if (string4.startsWith("MAILTO:")) {
            exec.launchViewer(hyperlinkEvent.getURL().toString());
            return;
        }
        if (string4.startsWith("HTTP://VIEWSRC.")) {
            this.viewSource(hyperlinkEvent.getURL().toString().substring(15));
            return;
        }
        if (string4.startsWith("HTTP://SEND.")) {
            this.sendTo(hyperlinkEvent.getURL().toString().substring(12));
            return;
        }
        if (string4.startsWith("HTTP://SCRIPT.")) {
            object = new Thread((String)object4, bl3){
                final /* synthetic */ String val$strData;
                final /* synthetic */ boolean val$finalBoolRefresh;
                {
                    this.val$strData = string2;
                    this.val$finalBoolRefresh = bl;
                }

                @Override
                public void run() {
                    Object object;
                    String string = string3.substring(14);
                    Cursor cursor = THtmlViewer.this.EditorPane.getCursor();
                    THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(3));
                    TExecScript tExecScript = new TExecScript(string, null, null);
                    tExecScript.setParameters(this.val$strData);
                    if (THtmlViewer.this.Debug) {
                        System.out.println("THtmlViewer Executing Script: " + string);
                    }
                    tExecScript.executeScript();
                    if (THtmlViewer.this.Debug) {
                        System.out.println("THtmlViewer Executing Script Complete: " + string);
                    }
                    if ((object = tExecScript.getScriptResult()) != null) {
                        String string2 = (String)object;
                        if (this.val$finalBoolRefresh || string2.equalsIgnoreCase("refresh")) {
                            THtmlViewer.this.refresh();
                        } else if (THtmlViewer.this.strSetText.length() > 0) {
                            if (THtmlViewer.this.Debug) {
                                System.out.println("THtmlViewer setting content to script result");
                            }
                            THtmlContent tHtmlContent = new THtmlContent(string2);
                            String string32 = tHtmlContent.getProcessedContent();
                            THtmlViewer.this.EditorPane.setDocument(THtmlViewer.this.EditorPane.getEditorKit().createDefaultDocument());
                            THtmlViewer.this.EditorPane.setText(string32);
                            THtmlViewer.this.EditorPane.setCaretPosition(0);
                        }
                    } else if (this.val$finalBoolRefresh) {
                        THtmlViewer.this.refresh();
                    }
                    THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            ((Thread)object).setPriority(1);
            ((Thread)object).start();
            return;
        }
        if (string4.startsWith("HTTP://ACTION.")) {
            object = string3.substring(14);
            TAppActionObject tAppActionObject = TMainWin.Application.AppAction.getAppActionObject((String)object);
            if (tAppActionObject != null) {
                this.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
            }
            return;
        }
        if (string4.startsWith("HTTP://VIEW.")) {
            object3 = string3.substring(12);
            object = charutil.getSubStringArray((String)object3, '&', true);
            if (object != null && ((Object)object).length > 0) {
                TExecScript tExecScript = new TExecScript("Aspect_Common_selectView", null, null);
                String[] stringArray = new String[]{"THtmlViewer", "", "Description=" + (String)object[0] + "&" + (String)object4};
                tExecScript.setParameters(stringArray);
                tExecScript.start();
            } else {
                this.MainWin.appendToLog("THtmlViewer", "hyperlinkUpdate", Thread.currentThread(), null, 3, "Invalid view in URL: " + string3);
            }
            return;
        }
        if (!(string4.startsWith("HTTP://ACTION.") || string4.startsWith("HTTP://DRIVERCMD.") || string4.startsWith("HTTP://DIALOG.") || string4.startsWith("HTTP://VIEW."))) {
            this.stackBack.push(this.strSetText);
            this.stackNext.clear();
            object = ((HTMLFrameHyperlinkEvent)hyperlinkEvent).getTarget();
            if (((String)object).equalsIgnoreCase("_self")) {
                Element element = ((HTMLDocument)hyperlinkEvent.getSourceElement().getDocument()).getDefaultRootElement();
                Element element2 = this.findElement(((HTMLDocument)this.EditorPane.getDocument()).getDefaultRootElement(), element);
                if (element2 != null) {
                    String string9 = string3;
                    string9 = string9.endsWith("/") && string9.indexOf("?") < 0 ? string9 + "?" + (String)object4 : string9 + "&" + (String)object4;
                    URL uRL = dosutil.makeURL(string9);
                    HTMLDocument hTMLDocument = (HTMLDocument)this.EditorPane.getDocument();
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = new HTMLFrameHyperlinkEvent(hyperlinkEvent.getSource(), HyperlinkEvent.EventType.ACTIVATED, uRL, element2, "_self");
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                }
            } else if (!((String)object).equalsIgnoreCase("_self")) {
                Element element;
                final HTMLDocument hTMLDocument = (HTMLDocument)this.EditorPane.getDocument();
                final Element element3 = hTMLDocument.getElement(element = hTMLDocument.getDefaultRootElement(), HTML.Attribute.NAME, object);
                if (element3 != null) {
                    String string10 = string3;
                    string10 = string10.endsWith("/") && string10.indexOf("?") < 0 ? string10 + "?" + (String)object4 : string10 + "&" + (String)object4;
                    final URL uRL = dosutil.makeURL(string10);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = new HTMLFrameHyperlinkEvent(hyperlinkEvent.getSource(), HyperlinkEvent.EventType.ACTIVATED, uRL, element3, "_self");
                            hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                        }
                    });
                } else {
                    this.MainWin.appendToLog("THtmlViewer", "hyperlinkUpdate", Thread.currentThread(), null, 4, "Cannot locate frame with the name  " + (String)object);
                }
                return;
            }
            Thread thread = new Thread((String)object4, hyperlinkEvent, bl2){
                final /* synthetic */ String val$strData;
                final /* synthetic */ HyperlinkEvent val$e;
                final /* synthetic */ boolean val$boolSecure;
                {
                    this.val$strData = string32;
                    this.val$e = hyperlinkEvent;
                    this.val$boolSecure = bl;
                }

                @Override
                public void run() {
                    if (string4.startsWith("FILE:")) {
                        THtmlViewer.this.stackBack.push(THtmlViewer.this.strSetText);
                        THtmlViewer.this.stackNext.clear();
                        THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(3));
                        THtmlContent tHtmlContent = new THtmlContent(string3, false, string3);
                        tHtmlContent.getProcessedContent();
                        tHtmlContent.removeCharset();
                        String string = tHtmlContent.removeScripts();
                        THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(0));
                        THtmlViewer.this.strSetText = string3;
                        THtmlViewer.this.EditorPane.setDocument(THtmlViewer.this.EditorPane.getEditorKit().createDefaultDocument());
                        THtmlViewer.this.EditorPane.setText(string);
                        THtmlViewer.this.EditorPane.setCaretPosition(0);
                    } else {
                        THtmlViewer.this.stackBack.push(THtmlViewer.this.strSetText);
                        THtmlViewer.this.stackNext.clear();
                        THtmlViewer.this.strSetText = string3;
                        if (this.val$strData.length() > 0) {
                            THtmlViewer.this.strSetText = THtmlViewer.this.strSetText + ("?" + charutil.tokenizeForPost(this.val$strData, true));
                        }
                        URL uRL = null;
                        Cursor cursor = THtmlViewer.this.EditorPane.getCursor();
                        THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(3));
                        TExecScript tExecScript = ((FormSubmitEvent)this.val$e).getMethod() == FormSubmitEvent.MethodType.valueOf("GET") ? new TExecScript("Aspect_Core_Http_Get", null, null) : new TExecScript("Aspect_Core_Http_Post", null, null);
                        try {
                            uRL = dosutil.makeURL(string3);
                        }
                        catch (Exception exception) {
                            THtmlViewer.this.MainWin.appendToLog("THtmlViewer", "hyperlinkUpdate", Thread.currentThread(), null, 4, "Error posting form: " + exception.toString());
                        }
                        String[] stringArray = new String[6];
                        stringArray[0] = uRL.getHost();
                        stringArray[1] = uRL.getPath();
                        if (stringArray[1].length() == 0) {
                            stringArray[1] = "/";
                        }
                        String string = "\u00ff";
                        stringArray[2] = charutil.replaceAllSubstrings(this.val$strData, "%26", string);
                        stringArray[2] = charutil.tokenizeForPost(stringArray[2], false);
                        stringArray[2] = charutil.replaceAllSubstrings(this.val$strData, string, "%26");
                        String string2 = uRL.getQuery();
                        if (string2 != null) {
                            string2 = charutil.tokenizeForPost(string2, false);
                            if (stringArray[2].length() > 0) {
                                stringArray[2] = stringArray[2] + "&";
                            }
                            stringArray[2] = stringArray[2] + string2;
                        }
                        stringArray[3] = uRL.getPort() <= 0 ? "80" : Integer.toString(uRL.getPort());
                        stringArray[4] = "120000";
                        stringArray[5] = this.val$boolSecure ? "true" : "false";
                        tExecScript.setParameters(stringArray);
                        tExecScript.executeScript();
                        Object object = tExecScript.getScriptResult();
                        THtmlContent tHtmlContent = new THtmlContent((String)object, false, string3);
                        String string32 = tHtmlContent.getProcessedContent();
                        THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(0));
                        THtmlViewer.this.EditorPane.setDocument(THtmlViewer.this.EditorPane.getEditorKit().createDefaultDocument());
                        THtmlViewer.this.EditorPane.setText(string32);
                        THtmlViewer.this.EditorPane.setCaretPosition(0);
                        THtmlViewer.this.setButtonRollovers(((HTMLDocument)THtmlViewer.this.EditorPane.getDocument()).getDefaultRootElement());
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
            return;
        }
    }

    public void processFrameHyperlink(HyperlinkEvent hyperlinkEvent) {
        Object object;
        Object object2;
        String string = hyperlinkEvent.getURL().toString();
        String string2 = string.toUpperCase();
        if (string2.startsWith("FILE:/") && !string2.startsWith("FILE://")) {
            string = "file://" + string.substring(5);
            string2 = string.toUpperCase();
        }
        String string3 = string;
        String string4 = string2;
        boolean bl = string4.startsWith("HTTPS");
        if (string4.startsWith("HTTP://VIEWSRC.")) {
            this.viewSource(hyperlinkEvent.getURL().toString().substring(15));
            return;
        }
        if (string4.startsWith("HTTP://SEND.")) {
            this.sendTo(hyperlinkEvent.getURL().toString().substring(12));
            return;
        }
        if (string4.startsWith("HTTP://SCRIPT.")) {
            String string5 = string3.substring(14);
            Aspect.MainWin.executeScript(string5);
            return;
        }
        if (string4.startsWith("HTTP://ACTION.")) {
            String string6 = string3.substring(14);
            TAppActionObject tAppActionObject = TMainWin.Application.AppAction.getAppActionObject(string6);
            if (tAppActionObject != null) {
                this.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
            }
            return;
        }
        if (string4.startsWith("HTTP://VIEW.")) {
            object2 = string3.substring(12);
            object = new TExecScript("Aspect_Common_selectView", null, null);
            String[] stringArray = new String[]{"THtmlViewer", "", "Description=" + (String)object2};
            ((TExecScript)object).setParameters(stringArray);
            ((Thread)object).start();
        }
        object2 = (HTMLDocument)this.EditorPane.getDocument();
        object = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
        ((HTMLDocument)object2).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)object);
    }

    public void processHyperlink(final HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Object object;
            Object object2;
            int n;
            Object object3;
            if (hyperlinkEvent.getURL() == null) {
                this.MainWin.appendToLog("THtmlViewer", "getLinkContent", Thread.currentThread(), null, 3, "Invalid hyperlink[1]");
                return;
            }
            String string = hyperlinkEvent.getURL().toString();
            String string2 = string.toUpperCase();
            boolean bl = false;
            if (string2.indexOf("DEBUG=TRUE") > 0) {
                bl = true;
                System.out.println("____________________________________________________");
                System.out.println("Processing hyperlink");
                System.out.println("URL=" + string);
            }
            if (string2.startsWith("FILE:/") && !string2.startsWith("FILE://")) {
                string = "file://" + string.substring(5);
                string2 = string.toUpperCase();
            }
            String string3 = "";
            String string4 = charutil.tokenizeForPost(string, false);
            if (string4.length() > 0 && (object3 = charutil.getSubStringArray(string4, '?', true)) != null && ((String[])object3).length > 1) {
                string3 = object3[1];
                object3 = charutil.getSubStringArray(object3[1], '&', true);
                for (n = 0; n < ((String[])object3).length; ++n) {
                    object2 = charutil.getSubStringArray(object3[n], '=', true);
                    if (object2 == null || ((String[])object2).length <= 1 || !object2[0].startsWith("*")) continue;
                    object = ((String)object2[0]).substring(1);
                    String string5 = charutil.replaceChar((String)object2[1], '+', ' ');
                    TMainWin.Application.setTokenValue((String)object, string5);
                    if (!bl) continue;
                    System.out.println("Set Token " + (String)object + " to " + string5);
                }
            }
            if (bl) {
                System.out.println("____________________________________________________");
            }
            object3 = charutil.replaceAllSubstrings(string3, "*", "");
            if (string.toUpperCase().startsWith("FILE:")) {
                if (string2.indexOf(".JAR") >= 0 || string2.indexOf(".ZIP") >= 0) {
                    String string6 = string;
                    int n2 = string6.indexOf("?");
                    if (n2 > 0) {
                        string6 = string6.substring(0, n2 - 1);
                    }
                    object = new TAsciiInput(string6, '\u0000');
                    boolean bl2 = ((TAsciiInput)object).isValid();
                    ((TAsciiInput)object).dispose();
                    if (!bl2) {
                        this.MainWin.appendToLog("THtmlViewer", "getLinkContent", Thread.currentThread(), null, 3, "Hyperlink does not exist in archive: '" + string + "'");
                        return;
                    }
                } else {
                    try {
                        File file = null;
                        object2 = "";
                        object2 = string.toUpperCase().startsWith("FILE://!") ? string.substring(8) : (string.toUpperCase().startsWith("FILE://") ? string.substring(7) : string.substring(5));
                        int n3 = ((String)object2).indexOf("?");
                        if (n3 > 0) {
                            object2 = ((String)object2).substring(0, n3 - 1);
                        }
                        if (!(file = new File((String)object2)).exists()) {
                            this.MainWin.appendToLog("THtmlViewer", "getLinkContent", Thread.currentThread(), null, 3, "Hyperlink does not exist: '" + string + "'");
                            return;
                        }
                        if (file.isDirectory()) {
                            this.MainWin.appendToLog("THtmlViewer", "getLinkContent", Thread.currentThread(), null, 3, "Hyperlink is a directory, not a file: '" + string + "'");
                            return;
                        }
                    }
                    catch (Exception exception) {
                        this.MainWin.appendToLog("THtmlViewer", "getLinkContent", Thread.currentThread(), exception, 3, "Invalid hyperlink[2]: '" + string + "'");
                    }
                }
            }
            if (string2.startsWith("HTTP://BACK")) {
                this.previousPage();
            } else if (string2.startsWith("HTTP://NEXT")) {
                this.nextPage();
            } else if (string2.startsWith("HTTP://HOME")) {
                this.homePage();
            } else {
                if (string2.startsWith("HTTP://REFRESH")) {
                    this.refresh();
                    return;
                }
                if (string2.startsWith("HTTP://MAILTO:")) {
                    exec.launchViewer(hyperlinkEvent.getURL().toString().substring(7));
                } else if (string2.startsWith("MAILTO:")) {
                    exec.launchViewer(hyperlinkEvent.getURL().toString());
                } else if (string2.startsWith("HTTP://VIEWSRC.")) {
                    this.viewSource(hyperlinkEvent.getURL().toString().substring(15));
                } else if (string2.startsWith("HTTP://SEND.")) {
                    this.sendTo(hyperlinkEvent.getURL().toString().substring(12));
                } else {
                    if (string2.startsWith("HTTP://SCRIPT.")) {
                        final String string7 = string;
                        Thread thread = new Thread(){

                            @Override
                            public void run() {
                                Object object;
                                String string = string7.substring(14);
                                Cursor cursor = THtmlViewer.this.EditorPane.getCursor();
                                THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(3));
                                TExecScript tExecScript = new TExecScript(string, null, null);
                                if (THtmlViewer.this.Debug) {
                                    System.out.println("THtmlViewer Executing Script: " + string);
                                }
                                tExecScript.executeScript();
                                if (THtmlViewer.this.Debug) {
                                    System.out.println("THtmlViewer Executing Script Complete: " + string);
                                }
                                if ((object = tExecScript.getScriptResult()) != null) {
                                    String string2 = (String)object;
                                    if (string2.equalsIgnoreCase("refresh")) {
                                        THtmlViewer.this.refresh();
                                    } else if (string2.length() > 0) {
                                        if (THtmlViewer.this.Debug) {
                                            System.out.println("THtmlViewer setting content to script result");
                                        }
                                        THtmlContent tHtmlContent = new THtmlContent(string2);
                                        String string3 = tHtmlContent.getProcessedContent();
                                        THtmlViewer.this.EditorPane.setDocument(THtmlViewer.this.EditorPane.getEditorKit().createDefaultDocument());
                                        THtmlViewer.this.EditorPane.setText(string3);
                                        THtmlViewer.this.EditorPane.setCaretPosition(0);
                                    }
                                }
                                THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        };
                        thread.setPriority(1);
                        thread.start();
                        return;
                    }
                    if (!(string2.startsWith("HTTP://SCRIPT.") || string2.startsWith("HTTP://ACTION.") || string2.startsWith("HTTP://DRIVERCMD.") || string2.startsWith("HTTP://DIALOG.") || string2.startsWith("HTTP://VIEW."))) {
                        if (string2.startsWith("HTTP://!") || string2.startsWith("HTTPS://!") || string2.startsWith("FILE://!")) {
                            StringBuilder stringBuilder = new StringBuilder(string);
                            charutil.remove_char(stringBuilder, stringBuilder, '!');
                            exec.launchViewer(stringBuilder.toString());
                        } else {
                            this.stackBack.push(this.strSetText);
                            this.stackNext.clear();
                            Thread thread = new Thread(){

                                @Override
                                public void run() {
                                    Serializable serializable;
                                    THtmlViewer.this.strSetText = hyperlinkEvent.getURL().toString();
                                    THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(3));
                                    THtmlContent tHtmlContent = new THtmlContent(hyperlinkEvent.getURL().toString());
                                    tHtmlContent.getProcessedContent();
                                    tHtmlContent.removeCharset();
                                    String string = tHtmlContent.removeScripts();
                                    THtmlViewer.this.EditorPane.setDocument(THtmlViewer.this.EditorPane.getEditorKit().createDefaultDocument());
                                    try {
                                        serializable = THtmlViewer.this.getTempFile();
                                        FileOutputStream fileOutputStream = new FileOutputStream((File)serializable, false);
                                        fileOutputStream.write(string.getBytes());
                                        fileOutputStream.close();
                                        THtmlViewer.this.EditorPane.setPage(((File)serializable).toURL());
                                    }
                                    catch (Exception exception) {
                                        System.out.println("fileoutputstream error: " + exception.toString());
                                    }
                                    serializable = new Point(0, 0);
                                    THtmlViewer.this.getViewport().scrollRectToVisible(new Rectangle(((Point)serializable).x, ((Point)serializable).y, 1, 1));
                                    THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            };
                            thread.setPriority(1);
                            thread.start();
                        }
                    }
                }
            }
            if (this.arListeners.size() > 0) {
                for (n = 0; n < this.arListeners.size(); ++n) {
                    ((HyperlinkListener)this.arListeners.get(n)).hyperlinkUpdate(hyperlinkEvent);
                }
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent instanceof FormSubmitEvent) {
            this.processFormSubmission(hyperlinkEvent);
        } else if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
            this.processFrameHyperlink(hyperlinkEvent);
        } else {
            this.processHyperlink(hyperlinkEvent);
        }
    }

    public void refresh() {
        if (this.InSetText) {
            return;
        }
        this.setText(this.strSetText, true, true);
    }

    public THtmlEditorPane getEditorPane() {
        return this.EditorPane;
    }

    public synchronized void setText(String string, boolean bl, boolean bl2) {
        if (this.SetTextThread != null && this.SetTextThread.isAlive()) {
            this.SetTextThread.abort();
        }
        this.InSetText = true;
        this.EditorPane.setDocument(this.EditorPane.getEditorKit().createDefaultDocument());
        String string2 = TMainWin.Application.getTokenValue("packageurl_aspect_software_net_core");
        if (string2.length() > 0) {
            if (!(string2 = string2 + "core/doc/loading.html").toUpperCase().startsWith("HTTP")) {
                string2 = string2.startsWith("/") || string2.startsWith("\\") ? "file://" + string2 : "file:///" + string2;
            }
            THtmlContent tHtmlContent = new THtmlContent(string2);
            String string3 = tHtmlContent.getProcessedContent();
            this.EditorPane.setText(string3);
            this.EditorPane.setCaretPosition(0);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Point point = new Point(0, 0);
        if (this.strHomePage == null) {
            this.strHomePage = string;
        }
        this.strSetText = string;
        this.SetTextThread = new TSetTextThread(string);
        this.SetTextThread.start();
    }

    public String getText() {
        return this.EditorPane.getText();
    }

    public void homePage() {
        if (this.strHomePage != null) {
            this.stackNext.clear();
            this.stackBack.clear();
            this.setText(this.strHomePage, false, true);
        }
    }

    public void previousPage() {
        if (this.stackBack.size() > 0) {
            this.stackNext.push(this.strSetText);
            this.strSetText = (String)this.stackBack.pop();
            this.setText(this.strSetText, true, true);
            this.EditorPane.setCaretPosition(0);
        }
    }

    public void nextPage() {
        if (this.stackNext.size() > 0) {
            this.stackBack.push(this.strSetText);
            this.strSetText = (String)this.stackNext.pop();
            this.setText(this.strSetText, true, true);
            this.EditorPane.setCaretPosition(0);
        }
    }

    public int getStackCount(int n) {
        if (n == 0) {
            return this.stackBack.size();
        }
        if (n == 1) {
            return this.stackNext.size();
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.EditorPane.setPreferredSize(dimension);
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getMaximumSize();
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        super.setMaximumSize(dimension);
        this.EditorPane.setMaximumSize(dimension);
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(dimension);
        this.EditorPane.setMinimumSize(dimension);
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.EditorPane != null) {
            this.EditorPane.setOpaque(bl);
        }
    }

    @Override
    public void setBorder(Border border) {
        this.setViewportBorder(border);
    }

    @Override
    public Border getBorder() {
        return this.getViewportBorder();
    }

    @Override
    public void invalidate() {
        if (this.EditorPane != null) {
            this.EditorPane.invalidate();
        }
        super.invalidate();
    }

    @Override
    public void revalidate() {
        if (this.EditorPane != null) {
            this.EditorPane.revalidate();
        }
        super.revalidate();
    }

    public boolean saveToFile(String string) {
        try {
            TFile tFile = new TFile(string);
            tFile.validatePathToFile(true);
            FileOutputStream fileOutputStream = new FileOutputStream(tFile);
            fileOutputStream.write(this.getText().getBytes());
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("THtmlViewer", "saveToFile", Thread.currentThread(), exception, 4, "Error saving document to file: " + exception.toString());
            return false;
        }
    }

    public void sendAsAttachment(String string) {
        String string2 = TMainWin.executeDialog("Aspect_Common_Send_Mail", 0);
        if (string2.equalsIgnoreCase("ok")) {
            Object object;
            String string3 = TMainWin.Application.getHomeDir();
            String string4 = dosutil.getTempFilename(string3 + "temp", "", "txt");
            final String string5 = string3 + "temp/" + string4;
            try {
                object = new TFile(string5);
                ((File)object).deleteOnExit();
                ((TFile)object).validatePathToFile(true);
                FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                fileOutputStream.write(string.getBytes());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("THtmlViewer", "sendAsAttachment", Thread.currentThread(), null, 4, "Error sending attachment: " + exception.toString());
                return;
            }
            object = new Thread(){

                @Override
                public void run() {
                    THtmlViewer.this.MainWin;
                    String string = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_Account");
                    THtmlViewer.this.MainWin;
                    String string2 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_To");
                    THtmlViewer.this.MainWin;
                    String string3 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_CC");
                    THtmlViewer.this.MainWin;
                    String string4 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_BCC");
                    THtmlViewer.this.MainWin;
                    String string52 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_Subject");
                    THtmlViewer.this.MainWin;
                    String string6 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_Body");
                    String[] stringArray = new String[]{string5};
                    String string7 = TSendMail.sendMail(string, string2, string52, string6, stringArray, string3, string4);
                    try {
                        File file = new File(string5);
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            ((Thread)object).setPriority(1);
            ((Thread)object).start();
        }
    }

    public void sendTo(String string) {
        System.out.println("sendTo: " + string);
        String string2 = TMainWin.executeDialog("Aspect_Common_Send_Mail", 0);
        if (string2.equalsIgnoreCase("ok")) {
            Object object;
            String string3 = TMainWin.Application.getHomeDir();
            String string4 = dosutil.getFileName(string) + dosutil.getFileExt(string);
            final String string5 = string3 + "temp/" + string4;
            try {
                object = new TAsciiInput(string, '\u0000', true);
                byte[] byArray = ((TAsciiInput)object).get_entire_file();
                ((TAsciiInput)object).dispose();
                TFile tFile = new TFile(string5);
                tFile.deleteOnExit();
                tFile.validatePathToFile(true);
                FileOutputStream fileOutputStream = new FileOutputStream(tFile);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("THtmlViewer", "sendTo", Thread.currentThread(), null, 4, "Error sending attachment: " + exception.toString());
                return;
            }
            object = new Thread(){

                @Override
                public void run() {
                    THtmlViewer.this.MainWin;
                    String string = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_Account");
                    THtmlViewer.this.MainWin;
                    String string2 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_To");
                    THtmlViewer.this.MainWin;
                    String string3 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_CC");
                    THtmlViewer.this.MainWin;
                    String string4 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_BCC");
                    THtmlViewer.this.MainWin;
                    String string52 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_Subject");
                    THtmlViewer.this.MainWin;
                    String string6 = TMainWin.Application.getTokenValue("Aspect_Common_Send_Mail_Body");
                    String[] stringArray = new String[]{string5};
                    String string7 = TSendMail.sendMail(string, string2, string52, string6, stringArray, string3, string4);
                    try {
                        File file = new File(string5);
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            ((Thread)object).setPriority(1);
            ((Thread)object).start();
        }
    }

    public void viewSource(String string) {
        try {
            String string2 = TMainWin.Application.getHomeDir();
            String string3 = dosutil.getTempFilename(string2 + "temp", "", "txt");
            String string4 = string2 + "temp/" + string3;
            TAsciiInput tAsciiInput = new TAsciiInput(string, '\u0000', true);
            byte[] byArray = tAsciiInput.get_entire_file();
            tAsciiInput.dispose();
            TFile tFile = new TFile(string4);
            tFile.validatePathToFile(true);
            tFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(tFile);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            exec.launchViewer(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void viewSource() {
        try {
            String string = TMainWin.Application.getHomeDir();
            String string2 = dosutil.getTempFilename(string + "temp", "", "txt");
            String string3 = string + "temp/" + string2;
            TFile tFile = new TFile(string3);
            tFile.validatePathToFile(true);
            tFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(tFile);
            fileOutputStream.write(this.getText().getBytes());
            fileOutputStream.close();
            exec.launchViewer(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("back")) {
            this.previousPage();
        } else if (string.equalsIgnoreCase("next")) {
            this.nextPage();
        } else if (string.equalsIgnoreCase("home")) {
            this.homePage();
        } else if (string.equalsIgnoreCase("mail")) {
            this.sendAsAttachment(this.getText());
        } else if (string.equalsIgnoreCase("Save To File")) {
            String string2 = TMainWin.executeDialog("CommonSelectFile", 0);
            if (string2.equalsIgnoreCase("ok")) {
                String string3 = TMainWin.Application.getTokenValue("$CommonSelectFileName");
                this.saveToFile(string3);
            }
        } else if (string.equalsIgnoreCase("View Source")) {
            this.viewSource();
        } else if (string.equalsIgnoreCase("Refresh")) {
            this.refresh();
        }
    }

    private class TSetTextThread
    extends Thread {
        String text = "";
        boolean Abort = false;

        public TSetTextThread(String string) {
            this.setPriority(1);
            this.text = string;
        }

        public void abort() {
            this.Abort = true;
        }

        @Override
        public void run() {
            Cursor cursor = THtmlViewer.this.EditorPane.getCursor();
            THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(3));
            THtmlContent tHtmlContent = new THtmlContent(this.text);
            tHtmlContent.getProcessedContent();
            tHtmlContent.removeCharset();
            String string = tHtmlContent.removeScripts();
            if (!this.Abort) {
                Serializable serializable;
                THtmlViewer.this.DefaultFocus = null;
                THtmlViewer.this.EditorPane.getDocument().addDocumentListener(THtmlViewer.this);
                try {
                    serializable = THtmlViewer.this.getTempFile();
                    FileOutputStream fileOutputStream = new FileOutputStream((File)serializable, false);
                    fileOutputStream.write(string.getBytes());
                    fileOutputStream.close();
                    THtmlViewer.this.EditorPane.setPage(((File)serializable).toURL());
                }
                catch (Exception exception) {
                    System.out.println("fileoutputstream error: " + exception.toString());
                }
                serializable = new Point(0, 0);
                THtmlViewer.this.getViewport().scrollRectToVisible(new Rectangle(((Point)serializable).x, ((Point)serializable).y, 1, 1));
                THtmlViewer.this.EditorPane.setCursor(Cursor.getPredefinedCursor(0));
            }
            THtmlViewer.this.InSetText = false;
        }
    }

    public class PopupListener
    extends MouseAdapter {
        private Component LastSource = null;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.LastSource = mouseEvent.getComponent();
                THtmlViewer.this.requestFocus();
                THtmlViewer.this.MainWin;
                JPopupMenu jPopupMenu = TMainWin.Application.AppMenu.createPopupMenu("DesktopPopupMenu", null);
                if (jPopupMenu == null) {
                    jPopupMenu = new JPopupMenu();
                } else if (!(jPopupMenu.getComponent(0) instanceof JSeparator)) {
                    jPopupMenu.insert(new JSeparator(), 0);
                }
                JMenuItem jMenuItem = new JMenuItem("Home");
                jMenuItem.addActionListener(THtmlViewer.this);
                jPopupMenu.insert(jMenuItem, 0);
                jMenuItem = new JMenuItem("Back");
                jMenuItem.addActionListener(THtmlViewer.this);
                jPopupMenu.insert(jMenuItem, 1);
                jMenuItem = new JMenuItem("Next");
                jMenuItem.addActionListener(THtmlViewer.this);
                jPopupMenu.insert(jMenuItem, 2);
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Mail");
                jMenuItem.addActionListener(THtmlViewer.this);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Save To File");
                jMenuItem.addActionListener(THtmlViewer.this);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("View Source");
                jMenuItem.addActionListener(THtmlViewer.this);
                jPopupMenu.add(jMenuItem);
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Refresh");
                jMenuItem.addActionListener(THtmlViewer.this);
                jPopupMenu.add(jMenuItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

