/*
 * Decompiled with CFR 0.152.
 */
package controls.renderers;

import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import utility.TFormulaEvaluator;
import utility.imageutil;

public class TButtonRenderer
implements TableCellRenderer {
    JButton button;
    JLabel label;
    TAspectDriver AspectDriver;
    boolean isBordered;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    Color colorBackground = UIManager.getColor("Button.background");
    Color colorForeground = UIManager.getColor("Button.foreground");

    public TButtonRenderer(boolean bl, TAspectDriver tAspectDriver) {
        this.isBordered = bl;
        this.AspectDriver = tAspectDriver;
        this.button = new JButton();
        this.button.setOpaque(true);
        this.label = new JLabel();
        this.selectedBorder = BorderFactory.createRaisedBevelBorder();
        this.unselectedBorder = BorderFactory.createRaisedBevelBorder();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (jTable.getSelectedRow() != n) {
            return this.label;
        }
        this.button.setText("");
        this.button.setHorizontalAlignment(0);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setIcon(null);
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n2);
        if (tDriverStructRecord != null) {
            String string;
            Object object2;
            TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
            if (tDriverStructRecord.RendererLabel != null && tDriverStructRecord.RendererLabel.length() > 0 && (object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.RendererLabel, this.AspectDriver.getAbsoluteDiskIndex(n), n)) != null) {
                string = TFormulaEvaluator.convertToString(object2);
                this.button.setText(string);
            }
            switch (tDriverStructRecord.RendererHorzLabelPosition) {
                case 0: 
                case 3: {
                    this.button.setHorizontalAlignment(0);
                    break;
                }
                case 1: {
                    this.button.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    this.button.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    this.button.setHorizontalAlignment(10);
                    break;
                }
                case 5: {
                    this.button.setHorizontalAlignment(11);
                }
            }
            switch (tDriverStructRecord.RendererVertLabelPosition) {
                case 0: 
                case 3: {
                    this.button.setVerticalAlignment(0);
                    break;
                }
                case 1: {
                    this.button.setVerticalAlignment(1);
                    break;
                }
                case 2: {
                    this.button.setVerticalAlignment(3);
                }
            }
            if (tDriverStructRecord.RendererIcon != null && tDriverStructRecord.RendererIcon.length() > 0) {
                object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.RendererIcon, this.AspectDriver.getAbsoluteDiskIndex(n), n);
                if (object2 != null) {
                    string = TFormulaEvaluator.convertToString(object2);
                    Image image = imageutil.getScaledImage(this.getClass(), string, -1, jTable.getRowHeight() - 10);
                    ImageIcon imageIcon = new ImageIcon(image);
                    if (imageIcon != null) {
                        this.button.setIcon(imageIcon);
                        imageIcon.setImageObserver(this.button);
                    }
                }
                switch (tDriverStructRecord.RendererHorzIconPosition) {
                    case 0: 
                    case 3: {
                        this.button.setHorizontalTextPosition(0);
                        break;
                    }
                    case 1: {
                        this.button.setHorizontalTextPosition(4);
                        break;
                    }
                    case 2: {
                        this.button.setHorizontalTextPosition(2);
                        break;
                    }
                    case 4: {
                        this.button.setHorizontalTextPosition(11);
                        break;
                    }
                    case 5: {
                        this.button.setHorizontalTextPosition(10);
                    }
                }
                switch (tDriverStructRecord.RendererVertIconPosition) {
                    case 0: 
                    case 3: {
                        this.button.setVerticalTextPosition(0);
                        break;
                    }
                    case 1: {
                        this.button.setVerticalTextPosition(3);
                        break;
                    }
                    case 2: {
                        this.button.setVerticalTextPosition(1);
                    }
                }
            }
        }
        if (this.isBordered) {
            if (bl && !bl2) {
                this.button.setBorder(this.selectedBorder);
            } else {
                this.button.setBorder(this.unselectedBorder);
            }
        }
        this.button.setForeground(this.colorForeground);
        this.button.setBackground(this.colorBackground);
        return this.button;
    }
}

