/*
 * Decompiled with CFR 0.152.
 */
package controls.renderers;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import utility.charutil;

public class TColorRenderer
extends JLabel
implements TableCellRenderer {
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;

    public TColorRenderer(boolean bl) {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = object == null ? Color.black : (object instanceof Integer ? new Color((Integer)object) : Color.black);
        this.setBackground(color);
        if (this.isBordered) {
            if (bl) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        String string4 = "RGB value: " + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "<br>";
        string4 = string4 + "Html Notation: #" + string + string2 + string3;
        this.setToolTipText(charutil.wrapAsHtml(string4));
        return this;
    }
}

