/*
 * Decompiled with CFR 0.152.
 */
package drivercmd;

import aspect.Aspect;
import aspect.TMainWin;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import resources.TApplication;
import utility.charutil;

public class TDriverCmdProperties {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDriverCmdProperties");
    private String DriverCmd = "unnamed driver command";
    private String strProperties = "";
    private String strRequiredProperties = "";
    private String strOptionalProperties = "";
    private Properties hashProperties = new Properties();
    private Hashtable hashRequiredProperties = new Hashtable();
    private Hashtable hashOptionalProperties = new Hashtable();

    public TDriverCmdProperties(String string, String string2, String string3, String string4) {
        this.DriverCmd = string;
        this.setRequiredProperties(string2);
        this.setOptionalProperties(string3);
        this.setProperties(string4);
    }

    public String[] getRequiredProperties() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.hashRequiredProperties.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        return (String[])arrayList.toArray();
    }

    public String[] getOptionalProperties() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.hashOptionalProperties.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        return (String[])arrayList.toArray();
    }

    public void setProperties(String string) {
        Object object;
        this.strProperties = string;
        this.hashProperties.clear();
        String[] stringArray = charutil.getSubStringArray(this.strProperties, ',', true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = charutil.getSubStringArray(stringArray[i], '=', true);
                if (object == null) continue;
                if (((String[])object).length == 1) {
                    this.hashProperties.put(object[0].toUpperCase(), "");
                    continue;
                }
                if (((String[])object).length == 2) {
                    this.hashProperties.put(object[0].toUpperCase(), object[1]);
                    continue;
                }
                this.MainWin.appendToLog("TDriverCmdProperties", "setProperties", Thread.currentThread(), null, 4, "Error parsing properties for driver command: " + stringArray[i]);
            }
        }
        if (this.Debug) {
            if (this.hashProperties.size() == 0) {
                this.MainWin.appendToLog("TDriverCmdProperties", "setProperties", Thread.currentThread(), null, 10, "No properties are defined for driver command " + this.DriverCmd);
            } else {
                this.MainWin.appendToLog("TDriverCmdProperties", "setProperties", Thread.currentThread(), null, 10, "Properties for driver command " + this.DriverCmd + ":");
                object = this.hashProperties.propertyNames();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    String string3 = this.hashProperties.getProperty(string2);
                    this.MainWin.appendToLog("TDriverCmdProperties", "setProperties", Thread.currentThread(), null, 10, string2 + " = " + string3);
                }
            }
        }
    }

    public void setRequiredProperties(String string) {
        this.strRequiredProperties = string;
        this.hashRequiredProperties.clear();
        String[] stringArray = charutil.getSubStringArray(string, ',', true);
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '|', true);
            if (stringArray2 == null) continue;
            String string2 = stringArray2[0];
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray2.length > 1) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    arrayList.add(stringArray2[j]);
                }
            } else {
                arrayList.add("*");
            }
            this.hashRequiredProperties.put(string2.toUpperCase(), arrayList);
        }
    }

    public void setOptionalProperties(String string) {
        this.strOptionalProperties = string;
        this.hashOptionalProperties.clear();
        String[] stringArray = charutil.getSubStringArray(string, ',', true);
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '|', true);
            if (stringArray2 == null) continue;
            String string2 = stringArray2[0];
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray2.length > 1) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    arrayList.add(stringArray2[j]);
                }
            } else {
                arrayList.add("*");
            }
            this.hashOptionalProperties.put(string2.toUpperCase(), arrayList);
        }
    }

    public String[] getValidPropertyValues(String string) {
        if (this.hashRequiredProperties.contains(string.toUpperCase())) {
            ArrayList arrayList = (ArrayList)this.hashRequiredProperties.get(string.toUpperCase());
            return (String[])arrayList.toArray();
        }
        if (this.hashOptionalProperties.contains(string.toUpperCase())) {
            ArrayList arrayList = (ArrayList)this.hashOptionalProperties.get(string.toUpperCase());
            return (String[])arrayList.toArray();
        }
        return null;
    }

    public boolean getHasValidProperties() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Enumeration<Object> enumeration = this.hashRequiredProperties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.hashProperties.containsKey(string)) continue;
            bl = false;
            this.MainWin.appendToLog("TDriverCmdProperties", "getHasValidProperties", Thread.currentThread(), null, 4, "Missing required property '" + string + "' " + "in driver command " + this.DriverCmd);
        }
        enumeration = this.hashProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            string = (String)enumeration.nextElement();
            String string2 = this.hashProperties.getProperty(string);
            ArrayList arrayList = (ArrayList)this.hashRequiredProperties.get(string);
            if (arrayList == null) {
                arrayList = (ArrayList)this.hashOptionalProperties.get(string);
            }
            if (arrayList == null) continue;
            boolean bl2 = false;
            for (n = 0; !bl2 && n < arrayList.size(); ++n) {
                String string3 = (String)arrayList.get(n);
                if (!string3.equals("*") && !string2.equalsIgnoreCase(string3)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            bl = false;
            stringBuilder.setLength(0);
            stringBuilder.append("Invalid property value for '" + string + "'.  Valid values are: ");
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder.append((String)arrayList.get(n));
                if (n >= arrayList.size() - 1) continue;
                stringBuilder.append(", ");
            }
            this.MainWin.appendToLog("getHasValidProperties", "getHasValidProperties", Thread.currentThread(), null, 4, stringBuilder.toString());
        }
        return bl;
    }

    public String getPropertyValue(String string) {
        return (String)this.hashProperties.get(string.toUpperCase());
    }
}

