/*
 * Decompiled with CFR 0.152.
 */
package drivercmd.common;

import aspect.Aspect;
import aspect.TMainWin;
import drivercmd.TAbstractDriverCmd;
import drivercmd.TDriverCmdInterface;
import drivers.aspect.TDriverStructRecord;
import pub.exec;
import utility.charutil;

public class TDriverCmdGoogleMap
extends TAbstractDriverCmd
implements TDriverCmdInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDriverCmdGoogleMap");

    public TDriverCmdGoogleMap(String string, String string2) {
        super(string, "MapServerUrl", "", "", "", string2);
    }

    @Override
    public String getDriverCommandName() {
        return this.getClass().getName();
    }

    @Override
    public boolean getMultipleInstancesAllowed() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void run() {
        if (this.RecordNumber < 0) {
            return;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverInterface.getDriverStructRecord("MapServerURL");
        String string = TDriverCmdGoogleMap.getGoogleMapUrl((String)this.AspectDriver.getField(tDriverStructRecord, this.RecordNumber));
        if (this.Debug) {
            MainWin.appendToLog("TAbstractDriver", "openGoogleMap", Thread.currentThread(), null, 10, "Google URL = " + string);
        }
        exec.launchViewer(string);
    }

    @Override
    public boolean cancel() {
        this.TerminateDriverCmd = true;
        return true;
    }

    public static String getGoogleMapUrl(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        TMainWin.Application.getTokenValue(stringBuilder, "GoogleMapUrl");
        stringBuilder.append(string);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "  ", " ");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, " ", "%20");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "|", "%2c");
        return stringBuilder.toString();
    }
}

