/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivercmd.TAbstractDriverCmd;
import drivercmd.TDriverCmdInterface;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverListenerEvent;
import drivers.aspect.TDriverListenerInterface;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.aspect.TUndoManager;
import drivers.external_data.TExternalData;
import extensions.SwingWorker;
import extensions.TClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;
import performance.TPerformanceFileMark;
import resources.TAppDriversObject;
import resources.TApplication;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.table.TScrollTable;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.netutil;
import utility.objectutil;
import utility.whois.TWhoIs;

public abstract class TAbstractDriver
implements TDriverInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTAbstractDriver");
    public TApplication Application = null;
    public TAppDriversObject AppDriversObject = null;
    public int Mode = 0;
    public TAspectDriver AspectDriver = null;
    public TDriverStruct DriverStruct = null;
    public TFormulaEvaluator FormulaEvaluator = null;
    public TUndoManager undoManager = null;
    public ArrayList arDriverListeners = null;
    public String FileName = "";
    public int RecordSize = 0;
    public int MaxRecords = 0;
    public int intNewRecordSeed = 0;
    public boolean IsLocal = false;
    public boolean IsWriteable = true;
    public boolean Modified = false;
    public boolean BufferOn = true;
    public boolean AIsWrappedDriver = false;
    private boolean HasHeader = false;
    public int HeaderSize = 0;
    public boolean IsFiltered = false;
    public Hashtable arComboBoxColl = null;
    public double rand = Math.random();
    public Date dtOpened = new Date();
    private String KeyExpression = null;
    public TPerformanceFileMark PerformanceMark = null;
    public Hashtable hProfileFieldReadCount = null;
    public Hashtable hProfileFieldReadMs = null;
    private ArrayList arDriverCmdThreads = new ArrayList();
    boolean DisplayedNullEvaluationMessage = false;

    public TAbstractDriver() {
    }

    public TAbstractDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        this.Application = tApplication;
        this.AppDriversObject = tAppDriversObject;
        this.Mode = n;
        if (this.AppDriversObject != null) {
            this.FileName = tApplication.parse_tokens(tAppDriversObject.FileName.toString());
            String string = this.getClass().getName();
            this.DriverStruct = string.indexOf("TExecScriptDriver") < 0 && string.indexOf("TConsolidatedHorzDriver") < 0 && string.indexOf("TConsolidatedVertDriver") < 0 && string.indexOf("TPivotTableDriver") < 0 && tAppDriversObject.ExternalDriverstruct.trim().length() == 0 && this.AppDriversObject.DriverParams.toUpperCase().indexOf("TRANSPOSE=TRUE") < 0 ? TDriverStruct.getDriverStruct(tAppDriversObject, this.AppDriversObject.StructureIndex.toString(), this.AppDriversObject.DriverParams, true) : new TDriverStruct(this.Application, this.AppDriversObject.StructureIndex.toString(), this.AppDriversObject.DriverParams);
            this.RecordSize = this.DriverStruct.RecordSize;
            if (this.RecordSize == 0) {
                MainWin.appendToLog("TAbstractDriver", "init", Thread.currentThread(), null, 4, "Record size is 0 in driver: " + this.AppDriversObject.DriverID);
            }
            this.FormulaEvaluator = new TFormulaEvaluator(this.Application, this.DriverStruct, this);
        }
    }

    @Override
    public void dispose() {
        if (this.isModified() && this.Mode == 1) {
            this.updateSourceFile();
        }
        if (this.arDriverListeners != null) {
            this.arDriverListeners.clear();
        }
        this.arDriverCmdThreads.clear();
        this.clearBuffer();
        if (this.arComboBoxColl != null) {
            this.arComboBoxColl.clear();
        }
        if (this.FormulaEvaluator != null) {
            this.FormulaEvaluator.dispose();
        }
        TExternalData.getInstance().removeRequestor(this);
        if (this.undoManager != null) {
            this.undoManager.dispose();
        }
        if (this.PerformanceMark != null) {
            this.PerformanceMark.destroy();
        }
    }

    public int getPhysicalRecordSize() {
        return this.RecordSize;
    }

    @Override
    public void enableFieldProfile() {
        if (this.hProfileFieldReadCount == null) {
            this.hProfileFieldReadCount = new Hashtable();
            this.hProfileFieldReadMs = new Hashtable();
        } else {
            this.hProfileFieldReadCount.clear();
            this.hProfileFieldReadMs.clear();
        }
    }

    @Override
    public void writeFieldProfile() {
        if (this.hProfileFieldReadCount != null) {
            String string = "c:\\aspect7\\temporary_files\\" + this.AppDriversObject.DriverID + "_" + dateutil.formatDate(new Date(), "MMddyyyyHHmm") + ".profile";
            String string2 = "c:\\aspect7\\temporary_files\\" + this.AppDriversObject.DriverID + ".profile";
            System.out.println("TAbstractDriver writeFieldProfile to:" + string);
            String string3 = "Count\tMS\tFieldID\r\n";
            Enumeration enumeration = this.hProfileFieldReadCount.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                string3 = string3 + ((Integer)this.hProfileFieldReadCount.get(string4)).toString();
                string3 = string3 + "\t" + ((Integer)this.hProfileFieldReadMs.get(string4)).toString();
                string3 = string3 + "\t" + string4 + "\r\n";
            }
            System.out.println("write to file.  s len=" + string3.length());
            TAsciiOutput.writeContent(string, string3);
            TAsciiOutput.writeContent(string2, string3);
        } else {
            System.out.println("TAbstractDriver hProfileFieldReadCount=null");
        }
    }

    @Override
    public TDriverStruct getDriverStruct() {
        return this.DriverStruct;
    }

    public void setDriverStruct(TDriverStruct tDriverStruct) {
        this.DriverStruct = tDriverStruct;
        this.RecordSize = this.DriverStruct.RecordSize;
        this.FormulaEvaluator = new TFormulaEvaluator(this.Application, this.DriverStruct, this);
    }

    @Override
    public int updateSourceFile() {
        return 0;
    }

    @Override
    public void createUndoManager() {
        if (this.undoManager == null) {
            this.undoManager = new TUndoManager(this);
        }
    }

    @Override
    public String getFileName() {
        return this.FileName;
    }

    @Override
    public Date getTimeOpened() {
        return this.dtOpened;
    }

    @Override
    public Date getFileModified() {
        File file = new File(this.FileName);
        if (file.exists()) {
            return new Date(file.lastModified());
        }
        return new Date(0L);
    }

    @Override
    public String getDriverParams() {
        if (this.AppDriversObject == null) {
            return "";
        }
        return this.AppDriversObject.DriverParams;
    }

    @Override
    public void setDriverParams(String string) {
        if (this.AppDriversObject != null) {
            this.AppDriversObject.DriverParams = string;
        }
    }

    @Override
    public int getMode() {
        return this.Mode;
    }

    @Override
    public String getKeyExpression() {
        if (this.KeyExpression != null) {
            return this.KeyExpression;
        }
        this.KeyExpression = charutil.getParamValue(this.getDriverParams(), "KeyExpression", '|');
        if (this.KeyExpression.length() == 0) {
            TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField("ID");
            if (tDriverStructRecord != null) {
                this.KeyExpression = "ID";
                String string = this.getDriverParams();
                if (string.length() > 0) {
                    string = string + "|";
                }
                string = string + "KeyExpression=" + this.KeyExpression;
            } else {
                MainWin.appendToLog("TAbstractDriver", "getKeyExpression", Thread.currentThread(), null, 4, "No Key Expression defined for driver: " + this.AppDriversObject.DriverID);
            }
        }
        return this.KeyExpression;
    }

    @Override
    public TAppDriversObject getAppDriversObject() {
        return this.AppDriversObject;
    }

    @Override
    public ArrayList getSupportedDriverCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isLocal() && this.isWriteable()) {
            arrayList.add("AppendRecord");
            arrayList.add("CutRecords");
            arrayList.add("Delete");
            arrayList.add("DuplicateRecords");
            arrayList.add("Edit");
            arrayList.add("InsertCopiedRecords");
            arrayList.add("MoveUp");
            arrayList.add("MoveDown");
            arrayList.add("InsertRecord");
            arrayList.add("CutCells");
            arrayList.add("DeleteCells");
            arrayList.add("PasteCells");
            arrayList.add("PasteRecords");
            arrayList.add("Replace");
            arrayList.add("/drivercmd/core/TDriverCmdSelect.class");
            arrayList.add("/drivercmd/core/TDriverCmdAddFiles.class");
            arrayList.add("/drivercmd/core/TDriverCmdEditRecordWizard.class");
            arrayList.add("/drivercmd/common/TDriverCmdEmailReceive.class");
        }
        arrayList.add("CopyRecords");
        arrayList.add("CopyCells");
        arrayList.add("Note");
        arrayList.add("Display");
        arrayList.add("Search");
        arrayList.add("RefreshTable");
        arrayList.add("LoadDisplay");
        arrayList.add("LoadAsSpreadsheet");
        arrayList.add("ExportToAscii");
        arrayList.add("AddToViews");
        arrayList.add("/drivercmd/core/TDriverCmdPrintPreview.class");
        arrayList.add("/drivercmd/common/TDriverCmdDriverInformation.class");
        if (this.getUndoManager() != null) {
            arrayList.add("Undo");
            arrayList.add("Redo");
        }
        return arrayList;
    }

    @Override
    public int getMaxRecords() {
        return this.MaxRecords;
    }

    @Override
    public void setMaxRecords(int n) {
        this.MaxRecords = n;
    }

    @Override
    public void setAspectDriver(TAspectDriver tAspectDriver) {
        this.AspectDriver = tAspectDriver;
        if (this.FormulaEvaluator != null) {
            this.FormulaEvaluator.setAspectDriver(tAspectDriver);
        }
    }

    @Override
    public TAspectDriver getAspectDriver() {
        return this.AspectDriver;
    }

    @Override
    public void addDriverListener(TDriverListenerInterface tDriverListenerInterface) {
        if (this.arDriverListeners == null) {
            this.arDriverListeners = new ArrayList();
        }
        this.arDriverListeners.add(tDriverListenerInterface);
    }

    public void notifyListeners(int n, String string, Object object, Object object2) {
        if (this.arDriverListeners == null) {
            return;
        }
        TDriverListenerEvent tDriverListenerEvent = new TDriverListenerEvent(this, n, string, object, object2);
        for (int i = 0; i < this.arDriverListeners.size(); ++i) {
            ((TDriverListenerInterface)this.arDriverListeners.get(i)).dataChanged(tDriverListenerEvent);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isModified() {
        return this.Modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.Modified = bl;
    }

    @Override
    public void f_create() {
    }

    @Override
    public int makeEditableFile() throws IOException {
        return 0;
    }

    @Override
    public int executeTimerEvent(TScrollTable tScrollTable) {
        return 0;
    }

    @Override
    public boolean verifySaveChanges() {
        return true;
    }

    @Override
    public TFormulaEvaluator getFormulaEvaluator() {
        return this.FormulaEvaluator;
    }

    @Override
    public void setFormulaEvaluator(TFormulaEvaluator tFormulaEvaluator) {
        this.FormulaEvaluator = tFormulaEvaluator;
    }

    @Override
    public TDriverStructRecord getDriverStructRecord(String string) {
        return this.DriverStruct.getField(string);
    }

    public TDriverStructRecord getDriverStructRecord(int n) {
        if (n >= 0 && n < this.DriverStruct.FieldColl.size()) {
            return (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
        }
        return null;
    }

    @Override
    public TDriverStructRecord getVirtualIndexField() {
        TDriverStructRecord tDriverStructRecord = null;
        if (this.AppDriversObject == null) {
            return null;
        }
        if (charutil.nullstr(this.AppDriversObject.VirtualIndexField)) {
            return null;
        }
        String string = this.AppDriversObject.VirtualIndexField;
        tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            return null;
        }
        if (tDriverStructRecord.FieldType != 7) {
            MainWin.appendToLog("TAbstractDriver", "getVirtualIndexField", Thread.currentThread(), null, 4, "Virtual index field '" + string + "' must be a long data type in driver: " + this.AppDriversObject.DriverID);
            return null;
        }
        return tDriverStructRecord;
    }

    @Override
    public int getNextVirtualIndex() {
        int n = -1;
        TDriverStructRecord tDriverStructRecord = this.getVirtualIndexField();
        if (tDriverStructRecord == null) {
            return -1;
        }
        for (int i = 0; i < this.getRecordCount(); ++i) {
            Integer n2 = (Integer)this.getField(tDriverStructRecord, i);
            n = Math.max(n, n2);
            if (!this.AppDriversObject.DriverID.toString().equalsIgnoreCase("Greenlight_UI_Embedded_View")) continue;
            System.out.println("getNextVirtualIndex " + i + "\t" + n2.toString());
        }
        if (this.AppDriversObject.DriverID.toString().equalsIgnoreCase("Greenlight_UI_Embedded_View")) {
            System.out.println("getNextVirtualIndex returns " + (n + 1));
        }
        return n + 1;
    }

    @Override
    public int getRecordCount() {
        return 0;
    }

    public int getFieldCount() {
        return this.DriverStruct.FieldColl.size();
    }

    public void setHasHeader(boolean bl) {
        this.HasHeader = bl;
    }

    public void setHeaderSize(int n) {
        this.HeaderSize = n;
    }

    public void getFileHeader() {
    }

    public static boolean isString(int n) {
        return n == 3 || n == 11 || n == 15 || n == 20 || n == 22 || n == 24 || n == 26;
    }

    @Override
    public boolean isLocal() {
        return this.IsLocal;
    }

    @Override
    public boolean isWriteable() {
        return this.IsWriteable;
    }

    @Override
    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return false;
        }
        if (charutil.nullstr(stringBuilder)) {
            return false;
        }
        return this.isInFilter(n, stringBuilder);
    }

    public boolean isDeleted(int n, String string) {
        return this.isDeleted(n, new StringBuilder(string));
    }

    @Override
    public boolean isDeleted(int n) {
        return this.isDeleted(n, this.AppDriversObject.DeleteMask);
    }

    @Override
    public String getKeyValue(int n) {
        return TFormulaEvaluator.convertToString(this.FormulaEvaluator.getFormulaValue(this.getKeyExpression(), n, 0));
    }

    @Override
    public String getKeyValue(String string, int n) {
        return TFormulaEvaluator.convertToString(this.FormulaEvaluator.getFormulaValue(string, n, 0));
    }

    @Override
    public int getCheckSum(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            Object object;
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (tDriverStructRecord.IsCalculated || tDriverStructRecord.IsVirtual || (object = this.getField(tDriverStructRecord, n)) == null) continue;
            stringBuilder.append(objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object));
        }
        return charutil.getHashCode(stringBuilder.toString());
    }

    @Override
    public int getCheckSum(int n, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(stringArray[i]);
            if (tDriverStructRecord != null) {
                Object object = this.getField(tDriverStructRecord, n);
                if (object == null) continue;
                stringBuilder.append(objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object));
                continue;
            }
            MainWin.appendToLog("TAbstractDriver", "getCheckSum", Thread.currentThread(), null, 4, "Invalid field in getCheckSum: " + stringArray[i]);
        }
        return charutil.getHashCode(stringBuilder.toString());
    }

    @Override
    public boolean isFiltered() {
        return this.IsFiltered;
    }

    @Override
    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return true;
        }
        Object object = this.FormulaEvaluator.getFormulaValue(stringBuilder, n, 0);
        return object instanceof Boolean && (Boolean)object == true;
    }

    @Override
    public boolean isInFilter(int n, String string) {
        return this.isInFilter(n, new StringBuilder(string));
    }

    public int[] getMatchingRecords(String string) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder(string);
        for (n = 0; n < this.getRecordCount(); ++n) {
            if (this.isDeleted(n) || !this.isInFilter(n, stringBuilder)) continue;
            arrayList.add(new Integer(n));
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    @Override
    public synchronized int getMatchingRecord(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = n;
        int n3 = this.getRecordCount();
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i = n2; i < n3; ++i) {
            if (this.isDeleted(i) || !this.isInFilter(i, stringBuilder)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getFieldDescription(int n, String string) {
        return string;
    }

    @Override
    public String getFieldTooltip(int n, String string) {
        return string;
    }

    @Override
    public int mouseClickedOnTableHeader(int n, boolean bl, TDriverStruct tDriverStruct) {
        return 0;
    }

    @Override
    public Integer getMinValue(TDriverStructRecord tDriverStructRecord, int n) {
        return null;
    }

    @Override
    public Integer getMaxValue(TDriverStructRecord tDriverStructRecord, int n) {
        return null;
    }

    @Override
    public String getExternalDataFilename(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord.External_Data_Filename.trim().length() == 0) {
            if (this.FileName.length() == 0) {
                return "";
            }
            return this.FileName + ".adn";
        }
        Object object = this.FormulaEvaluator.getFormulaValue(tDriverStructRecord.External_Data_Filename, n, 0);
        if (object != null) {
            object = TFormulaEvaluator.convertToString(object).trim();
        }
        return (String)object;
    }

    @Override
    public String getExternalDataKey(TDriverStructRecord tDriverStructRecord, int n) {
        Object object = this.FormulaEvaluator.getFormulaValue(tDriverStructRecord.External_Data_Key, n, 0);
        if (object != null) {
            object = TFormulaEvaluator.convertToString(object).trim();
        }
        return (String)object;
    }

    @Override
    public Object getExternalData(TDriverStructRecord tDriverStructRecord, int n) {
        String string = this.getExternalDataFilename(tDriverStructRecord, n);
        if (string.length() == 0) {
            MainWin.appendToLog("TAbstractDriver", "getExternalData", Thread.currentThread(), null, 4, "Missing filename for external data field: " + tDriverStructRecord.FullID);
            return null;
        }
        String string2 = this.getExternalDataKey(tDriverStructRecord, n);
        if (string2.length() == 0) {
            MainWin.appendToLog("TAbstractDriver", "getExternalData", Thread.currentThread(), null, 4, "Missing key for external data field: " + tDriverStructRecord.FullID);
            return null;
        }
        String string3 = TExternalData.getInstance().getField(this, string, "", tDriverStructRecord.FullID, string2);
        Object object = null;
        switch (tDriverStructRecord.FieldType) {
            case 1: 
            case 16: 
            case 19: 
            case 25: {
                boolean bl = false;
                if (charutil.strcmpi(string3, "true") == 0) {
                    bl = true;
                }
                object = new Boolean(bl);
                break;
            }
            case 2: {
                object = new Integer(charutil.unsignedByteToInt(charutil.byteval(string3)));
                break;
            }
            case 4: {
                object = new Integer(charutil.shortval(string3));
                break;
            }
            case 5: {
                object = new Integer(charutil.unsignedShortToInt(charutil.shortval(string3)));
                break;
            }
            case 6: 
            case 7: {
                object = new Integer(charutil.ival(string3));
                break;
            }
            case 8: {
                object = new Float(charutil.fval(string3));
                break;
            }
            case 9: 
            case 12: {
                object = new Double(charutil.dval(string3));
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 21: {
                object = dateutil.parseDate(string3);
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                object = string3;
            }
        }
        return object;
    }

    @Override
    public boolean putExternalData(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        String string = this.getExternalDataFilename(tDriverStructRecord, n);
        if (string.length() == 0) {
            MainWin.appendToLog("TAbstractDriver", "getExternalData", Thread.currentThread(), null, 4, "Missing filename for external data field: " + tDriverStructRecord.FullID);
            return false;
        }
        String string2 = this.getExternalDataKey(tDriverStructRecord, n);
        if (string2.length() == 0) {
            MainWin.appendToLog("TAbstractDriver", "getExternalData", Thread.currentThread(), null, 4, "Missing key for external data field: " + tDriverStructRecord.FullID);
            return false;
        }
        String string3 = TFormulaEvaluator.convertToString(object);
        System.out.println("TAbstractDriver putExternalData ExternalDataFilename=" + string + " DSRec.FullID=" + tDriverStructRecord.FullID + " ExternalDataKey=" + string2 + " s=" + string3);
        TExternalData.getInstance().putField(this, string, "", tDriverStructRecord.FullID, string2, string3);
        return true;
    }

    @Override
    public boolean deleteExternalData(TDriverStructRecord tDriverStructRecord, int n) {
        System.out.println("TAbstractDriver deleteExternalData: " + tDriverStructRecord.FullID);
        String string = this.getExternalDataFilename(tDriverStructRecord, n);
        if (string.length() == 0) {
            MainWin.appendToLog("TAbstractDriver", "getExternalData", Thread.currentThread(), null, 4, "Missing filename for external data field: " + tDriverStructRecord.FullID);
            return false;
        }
        String string2 = this.getExternalDataKey(tDriverStructRecord, n);
        if (string2.length() == 0) {
            MainWin.appendToLog("TAbstractDriver", "getExternalData", Thread.currentThread(), null, 4, "Missing key for external data field: " + tDriverStructRecord.FullID);
            return false;
        }
        System.out.println("TAbstractDriver deleteExternalData calling TExternalData.deleteField");
        return TExternalData.getInstance().deleteField(this, string, "", tDriverStructRecord.FullID, string2);
    }

    public Object calculateField(TDriverStructRecord tDriverStructRecord, int n) {
        Object object = null;
        Object object2 = this.FormulaEvaluator.getFormulaValue(tDriverStructRecord.Formula, n, 0, tDriverStructRecord);
        if (object2 != null) {
            boolean bl;
            String string;
            int n2 = TFormulaEvaluator.getVariableType(object2);
            if (n2 == 2) {
                string = (String)object2;
                switch (tDriverStructRecord.FieldType) {
                    case 1: 
                    case 16: 
                    case 19: 
                    case 25: {
                        bl = false;
                        if (charutil.strcmpi(string, "true") == 0) {
                            bl = true;
                        }
                        object = new Boolean(bl);
                        break;
                    }
                    case 2: {
                        object = new Integer(charutil.unsignedByteToInt(charutil.byteval(string)));
                        break;
                    }
                    case 4: {
                        object = new Integer(charutil.shortval(string));
                        break;
                    }
                    case 5: {
                        object = new Integer(charutil.unsignedShortToInt(charutil.shortval(string)));
                        break;
                    }
                    case 6: 
                    case 7: {
                        object = new Integer(charutil.ival(string));
                        break;
                    }
                    case 8: {
                        object = new Float(charutil.fval(string));
                        break;
                    }
                    case 9: 
                    case 12: {
                        object = new Double(charutil.dval(string));
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 18: 
                    case 21: {
                        object = dateutil.parseDate(string);
                        break;
                    }
                    case 3: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 22: 
                    case 24: 
                    case 26: {
                        object = string;
                    }
                }
            }
            if (n2 == 3) {
                string = ((Boolean)object2).toString();
                bl = (Boolean)object2;
                int n3 = 0;
                if (bl) {
                    n3 = 1;
                }
                switch (tDriverStructRecord.FieldType) {
                    case 1: 
                    case 19: 
                    case 25: {
                        object = (Boolean)object2;
                        break;
                    }
                    case 16: {
                        object = new Byte((byte)n3);
                        break;
                    }
                    case 2: {
                        object = new Integer(charutil.unsignedByteToInt((byte)n3));
                        break;
                    }
                    case 4: 
                    case 5: {
                        object = new Integer((short)n3);
                        break;
                    }
                    case 6: 
                    case 7: {
                        object = new Integer(n3);
                        break;
                    }
                    case 8: {
                        object = new Float(n3);
                        break;
                    }
                    case 9: 
                    case 12: {
                        object = new Double(n3);
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 18: 
                    case 21: {
                        object = null;
                        break;
                    }
                    case 3: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 22: 
                    case 24: 
                    case 26: {
                        object = string;
                    }
                }
            }
            if (n2 == 0) {
                double d = (Double)object2;
                switch (tDriverStructRecord.FieldType) {
                    case 1: 
                    case 16: 
                    case 19: 
                    case 25: {
                        bl = false;
                        if (d != 0.0) {
                            bl = true;
                        }
                        object = new Boolean(bl);
                        break;
                    }
                    case 2: {
                        object = new Integer(charutil.unsignedByteToInt((byte)d));
                        break;
                    }
                    case 4: {
                        object = new Integer((short)d);
                        break;
                    }
                    case 5: {
                        object = new Integer(charutil.unsignedShortToInt((short)d));
                        break;
                    }
                    case 6: 
                    case 7: {
                        object = new Integer((int)d);
                        break;
                    }
                    case 8: {
                        object = new Float((float)d);
                        break;
                    }
                    case 9: 
                    case 12: {
                        object = new Double(d);
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 18: 
                    case 21: {
                        object = new Date();
                        break;
                    }
                    case 3: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 22: 
                    case 24: 
                    case 26: {
                        object = Double.toString(d);
                    }
                }
            }
            if (n2 == 1) {
                long l = ((Date)object2).getTime();
                switch (tDriverStructRecord.FieldType) {
                    case 1: 
                    case 16: 
                    case 19: 
                    case 25: {
                        bl = false;
                        if (l != 0L) {
                            bl = true;
                        }
                        object = new Boolean(bl);
                        break;
                    }
                    case 2: {
                        object = new Integer(0);
                        break;
                    }
                    case 4: 
                    case 5: {
                        object = new Integer(0);
                        break;
                    }
                    case 6: 
                    case 7: {
                        object = new Integer(0);
                        break;
                    }
                    case 8: {
                        object = new Float(0.0f);
                        break;
                    }
                    case 9: 
                    case 12: {
                        object = new Double(l);
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 18: 
                    case 21: {
                        object = object2;
                        break;
                    }
                    case 3: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 22: 
                    case 24: 
                    case 26: {
                        object = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss").format((Date)object2);
                    }
                }
            }
        } else if (!this.DisplayedNullEvaluationMessage && tDriverStructRecord.Formula.trim().length() > 0) {
            String string = "calculateField returns null for " + tDriverStructRecord.ID + " R=" + n;
            string = this.AppDriversObject == null ? string + " AppDriversObject=null" : string + " Driver=" + this.AppDriversObject.DriverID.toString();
            string = string + " Driver Params: " + this.getDriverParams();
            string = string + " Formula=" + tDriverStructRecord.Formula;
            System.out.println(string);
            MainWin.appendToLog("TAbstractDriver", "calculateField", Thread.currentThread(), null, 4, string);
            this.DisplayedNullEvaluationMessage = true;
        }
        return object;
    }

    @Override
    public synchronized Object getField(String string, int n) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            System.out.println("TAbstractDriver getField DSRec is null for ID: " + string);
            return null;
        }
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public synchronized Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        return null;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getField(tDriverStructRecord, n);
    }

    public void setBufferOn(boolean bl) {
        this.BufferOn = bl;
    }

    @Override
    public void clearBuffer() {
    }

    @Override
    public void clearWriteBuffer() {
    }

    @Override
    public void notifyRecordDelete() {
        this.intNewRecordSeed = 0;
    }

    @Override
    public synchronized int initializeNewRecord(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        boolean bl2 = false;
        if (this.AppDriversObject != null && this.AppDriversObject.InsertMode == 0) {
            int n3 = this.getRecordCount();
            for (n = this.intNewRecordSeed; !bl2 && n < n3; ++n) {
                if (!this.isDeleted(n)) continue;
                n2 = n;
                bl2 = true;
            }
            this.clearBuffer();
        }
        if (!bl2) {
            n2 = this.getRecordCount();
        }
        this.intNewRecordSeed = n2;
        for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
            Object object;
            Object object2;
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
            if (tDriverStructRecord.IsVirtual) continue;
            stringBuilder.setLength(0);
            if (bl && this.FormulaEvaluator != null && tDriverStructRecord.DefaultOnInsert.length() > 0 && (object2 = this.FormulaEvaluator.getFormulaValue(tDriverStructRecord.DefaultOnInsert, n2, 0)) != null) {
                stringBuilder.append(TFormulaEvaluator.convertToString(object2));
            }
            if ((object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringBuilder.toString(), n2)) == null) {
                System.out.println("Error converting " + tDriverStructRecord.FullID);
            }
            this.putField(tDriverStructRecord, n2, object);
        }
        return n2;
    }

    @Override
    public boolean isFieldDefined(String string) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return tDriverStructRecord != null;
    }

    @Override
    public synchronized int putField(String string, int n, Object object) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.putField(tDriverStructRecord, n, object);
    }

    @Override
    public synchronized int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        return 0;
    }

    @Override
    public void swapRecords(int n, int n2) {
    }

    @Override
    public synchronized byte[] getRecord(int n) {
        return null;
    }

    @Override
    public synchronized void putRecord(int n, byte[] byArray) {
    }

    @Override
    public String copyDriver(TDriverInterface tDriverInterface, String[] stringArray, String[] stringArray2) {
        TDriverStructRecord tDriverStructRecord;
        TDriverStructRecord tDriverStructRecord2;
        Object object;
        int n;
        ArrayList<TDriverStructRecord> arrayList = new ArrayList<TDriverStructRecord>();
        ArrayList<TDriverStructRecord> arrayList2 = new ArrayList<TDriverStructRecord>();
        Hashtable<String, String> hashtable = null;
        if (stringArray != null) {
            hashtable = new Hashtable<String, String>();
            for (n = 0; n < stringArray.length; ++n) {
                hashtable.put(stringArray[n].toUpperCase(), stringArray[n].toUpperCase());
            }
            if (stringArray2 != null) {
                for (n = 0; n < stringArray2.length; ++n) {
                    object = charutil.getSubStringArray(stringArray2[n], '=', true);
                    if (object != null && ((String[])object).length == 2) {
                        if (!hashtable.containsKey(object[0].toUpperCase())) continue;
                        hashtable.put(object[0].toUpperCase(), object[1]);
                        continue;
                    }
                    System.out.println("Error in copyDriver.  Invalid alias field: " + stringArray2[n]);
                }
            }
        }
        this.f_create();
        for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
            tDriverStructRecord2 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
            if (tDriverStructRecord2.IsVirtual || tDriverStructRecord2.IsCalculated || tDriverStructRecord2.IsToken || stringArray != null && !hashtable.containsKey(tDriverStructRecord2.FullID.toUpperCase())) continue;
            object = tDriverStructRecord2.ID;
            if (hashtable != null) {
                object = (String)hashtable.get(tDriverStructRecord2.FullID.toUpperCase());
            }
            if ((tDriverStructRecord = tDriverInterface.getDriverStructRecord((String)object)) == null) continue;
            arrayList.add(tDriverStructRecord2);
            arrayList2.add(tDriverStructRecord);
        }
        for (n = 0; n < tDriverInterface.getRecordCount(); ++n) {
            if (n + 1 >= this.getRecordCount()) {
                this.initializeNewRecord(true);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                tDriverStructRecord2 = (TDriverStructRecord)arrayList.get(i);
                tDriverStructRecord = (TDriverStructRecord)arrayList2.get(i);
                Object object2 = tDriverInterface.getField(tDriverStructRecord, n);
                if (tDriverStructRecord2.FieldType != tDriverStructRecord.FieldType) {
                    String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object2);
                    object2 = objectutil.convertStringToFieldType(tDriverStructRecord2.FieldType, string, n);
                }
                this.putField(tDriverStructRecord2, n, object2);
            }
        }
        this.updateSourceFile();
        return "ok";
    }

    @Override
    public void packRecords(StringBuilder stringBuilder) {
    }

    public TUndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoRecording(boolean bl) {
        if (this.undoManager != null) {
            this.undoManager.setUndoRecording(bl);
        }
    }

    @Override
    public boolean getUndoRecording() {
        if (this.undoManager != null) {
            return this.undoManager.getUndoRecording();
        }
        return false;
    }

    @Override
    public void removeLastUndo() {
        if (this.undoManager != null) {
            this.undoManager.removeLastUndo();
        }
    }

    @Override
    public void beginNewUndoOperation(String string) {
        if (this.undoManager != null) {
            this.undoManager.beginNewUndoOperation(string);
        }
    }

    public void recordUndoEvent(TDriverStructRecord tDriverStructRecord, int n, Object object, Object object2) {
        if (tDriverStructRecord.ID.startsWith("Aspect_Displays")) {
            return;
        }
        if (this.undoManager == null || this.undoManager.isRecording()) {
            // empty if block
        }
    }

    @Override
    public void undo() {
        if (this.undoManager != null) {
            this.undoManager.undo();
        }
    }

    @Override
    public void redo() {
        if (this.undoManager != null) {
            this.undoManager.redo();
        }
    }

    public void getWhoIsForRecord(JComponent jComponent) {
        TAspectDriver tAspectDriver = null;
        int n = -1;
        if (jComponent instanceof TScrollTable) {
            n = ((TScrollTable)jComponent).getSelectedRow();
            tAspectDriver = ((TScrollTable)jComponent).AspectDriver;
        } else if (jComponent instanceof TScrollDialogPanel) {
            n = ((TScrollDialogPanel)jComponent).getRecordNumber();
            tAspectDriver = ((TScrollDialogPanel)jComponent).AspectDriver;
        }
        if (n < 0 || tAspectDriver == null) {
            return;
        }
        this.getWhoIsForRecord(tAspectDriver.getAbsoluteDiskIndex(n));
    }

    public void getWhoIsForRecord(int n) {
        Properties properties;
        int n2;
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField("WhoIsLookupName");
        if (tDriverStructRecord == null) {
            MainWin.appendToLog("TAbstractDriver", "getWhoIsForRecord", Thread.currentThread(), null, 4, "Cannot locate field <WhoIsLookupName> in structure.");
            return;
        }
        String string = (String)this.getField(tDriverStructRecord, n);
        if (string.length() > 1 && !netutil.isValidIPAddress(string)) {
            string = netutil.getIPAddress(string);
        }
        if ((n2 = string.indexOf(45)) >= 0) {
            string = string.substring(0, n2);
        }
        if (this.Debug) {
            MainWin.appendToLog("TAbstractDriver", "getWhoIsForRecord", Thread.currentThread(), null, 3, "Looking up WhoIs for " + string);
        }
        if ((properties = TWhoIs.getWhoIs(string)) == null) {
            if (this.Debug) {
                MainWin.appendToLog("TAbstractDriver", "getWhoIsForRecord", Thread.currentThread(), null, 3, "Lookup returns null");
            }
            if ((tDriverStructRecord = this.DriverStruct.getField("WhoIsOrgName")) != null) {
                this.putField(tDriverStructRecord, n, (Object)"Unknown");
            }
        } else {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                tDriverStructRecord = this.DriverStruct.getField(string2);
                if (tDriverStructRecord != null) {
                    this.putField(tDriverStructRecord, n, (Object)string3);
                    if (!this.Debug) continue;
                    MainWin.appendToLog("TAbstractDriver", "getWhoIsForRecord", Thread.currentThread(), null, 3, "Recording property: " + string2 + " = " + string3);
                    continue;
                }
                if (!this.Debug) continue;
                MainWin.appendToLog("TAbstractDriver", "getWhoIsForRecord", Thread.currentThread(), null, 3, "Cannot locate field for " + string2);
            }
        }
    }

    @Override
    public String executeDriverCommand(final JComponent jComponent, String string, String string2) {
        String string3 = "ok";
        if (jComponent != null && jComponent instanceof TScrollTable) {
            ((TScrollTable)jComponent).stopEditing();
        }
        if (this.Debug) {
            MainWin.appendToLog("TAbstractDriver", "executeDriverCommand", Thread.currentThread(), null, 10, "Driver command = " + string + " Params = " + string2);
        }
        if (string.equalsIgnoreCase("DriverWhoIsForRecord")) {
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    TAbstractDriver.this.getWhoIsForRecord(jComponent);
                }
            };
            swingWorker.start();
        } else {
            try {
                TClassLoader tClassLoader = new TClassLoader();
                System.out.println("executeDriverCommand loadClass:" + string);
                Class clazz = null;
                if (!string.equals("InitStructFromFile")) {
                    clazz = tClassLoader.loadClass(string);
                }
                if (clazz != null) {
                    Class[] classArray = new Class[]{String.class, String.class};
                    Constructor constructor = clazz.getConstructor(classArray);
                    if (constructor != null) {
                        String[] stringArray = new String[]{string, string2};
                        TAbstractDriverCmd tAbstractDriverCmd = (TAbstractDriverCmd)constructor.newInstance(stringArray);
                        if (tAbstractDriverCmd != null) {
                            if (jComponent != null) {
                                tAbstractDriverCmd.setParentComponent(jComponent);
                            } else if (this.AspectDriver != null) {
                                tAbstractDriverCmd.setAspectDriver(this.AspectDriver);
                            }
                            if (tAbstractDriverCmd.getHasRequiredFields() && tAbstractDriverCmd.getHasValidProperties()) {
                                if (this.undoManager != null && tAbstractDriverCmd.getDisableUndo()) {
                                    this.undoManager.disableForThread(tAbstractDriverCmd.getThreadName(), true);
                                    this.undoManager.clear();
                                }
                                tAbstractDriverCmd.initialize();
                                tAbstractDriverCmd.start();
                                this.arDriverCmdThreads.add(tAbstractDriverCmd);
                            }
                        } else {
                            string3 = "Error initializing driver command object for driver command: " + string;
                            MainWin.appendToLog("TAbstractDriver", "executeDriverCommand", Thread.currentThread(), null, 4, string3);
                        }
                    } else {
                        string3 = "Error locating constructor for driver command: " + string;
                        MainWin.appendToLog("TAbstractDriver", "executeDriverCommand", Thread.currentThread(), null, 4, string3);
                    }
                } else {
                    string3 = "Unable to load class for driver command: " + string;
                    MainWin.appendToLog("TAbstractDriver", "executeDriverCommand", Thread.currentThread(), null, 4, string3);
                }
            }
            catch (Exception exception) {
                string3 = "Error executing driver command: " + string;
                MainWin.appendToLog("TAbstractDriver", "executeDriverCommand", Thread.currentThread(), exception, 3, string3);
            }
        }
        return string3;
    }

    @Override
    public void sendDriverCmdMsg(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = dosutil.splitPath(string);
        stringBuilder.setLength(0);
        stringBuilder.append(stringArray[1] + stringArray[2]);
        charutil.replace_char(stringBuilder, stringBuilder, '/', '.');
        charutil.replace_char(stringBuilder, stringBuilder, '\\', '.');
        if (stringBuilder.charAt(0) == '.') {
            stringBuilder.deleteCharAt(0);
        }
        String string3 = stringBuilder.toString();
        for (int i = 0; i < this.arDriverCmdThreads.size(); ++i) {
            TDriverCmdInterface tDriverCmdInterface = (TDriverCmdInterface)this.arDriverCmdThreads.get(i);
            String string4 = tDriverCmdInterface.getDriverCommandName();
            System.out.println("TAbstractDriver.sendDriverCmdMsg: DriverCmdID=" + string4 + " ADriverCmd=" + string3);
            if (!string4.equalsIgnoreCase(string3)) continue;
            tDriverCmdInterface.msg(string2);
        }
    }

    @Override
    public void msgDriverCmdTerminating(TDriverCmdInterface tDriverCmdInterface) {
        for (int i = 0; i < this.arDriverCmdThreads.size(); ++i) {
            TDriverCmdInterface tDriverCmdInterface2 = (TDriverCmdInterface)this.arDriverCmdThreads.get(i);
            if (!tDriverCmdInterface2.equals(tDriverCmdInterface)) continue;
            this.arDriverCmdThreads.remove(i);
        }
    }

    @Override
    public boolean isDriverCmdRunning(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = dosutil.splitPath(string);
        stringBuilder.setLength(0);
        stringBuilder.append(stringArray[1] + stringArray[2]);
        charutil.replace_char(stringBuilder, stringBuilder, '/', '.');
        charutil.replace_char(stringBuilder, stringBuilder, '\\', '.');
        if (stringBuilder.charAt(0) == '.') {
            stringBuilder.deleteCharAt(0);
        }
        String string2 = stringBuilder.toString();
        for (int i = 0; i < this.arDriverCmdThreads.size(); ++i) {
            TDriverCmdInterface tDriverCmdInterface = (TDriverCmdInterface)this.arDriverCmdThreads.get(i);
            String string3 = tDriverCmdInterface.getDriverCommandName();
            if (!string3.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static int getFieldSize(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 24: {
                n2 = 1;
                break;
            }
            case 26: {
                n2 = 1;
                break;
            }
            case 22: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            case 9: {
                n2 = 8;
                break;
            }
            case 10: {
                n2 = 12;
                break;
            }
            case 11: {
                n2 = 1;
                break;
            }
            case 12: {
                n2 = 6;
                break;
            }
            case 13: {
                n2 = 12;
                break;
            }
            case 15: {
                n2 = 1;
                break;
            }
            case 16: {
                n2 = 1;
                break;
            }
            case 17: {
                n2 = 41;
                break;
            }
            case 18: {
                n2 = 12;
                break;
            }
            case 19: {
                n2 = 1;
                break;
            }
            case 20: {
                n2 = 1;
                break;
            }
            case 21: {
                n2 = 8;
                break;
            }
            case 25: {
                n2 = 1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    public static String getFieldTypeName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "bool";
                break;
            }
            case 2: {
                string = "byte";
                break;
            }
            case 3: {
                string = "char";
                break;
            }
            case 24: {
                string = "char (null term)";
                break;
            }
            case 26: {
                string = "char (encrypted)";
                break;
            }
            case 22: {
                string = "binary";
                break;
            }
            case 4: {
                string = "int";
                break;
            }
            case 5: {
                string = "word";
                break;
            }
            case 6: {
                string = "dword";
                break;
            }
            case 7: {
                string = "long";
                break;
            }
            case 8: {
                string = "float";
                break;
            }
            case 9: {
                string = "double";
                break;
            }
            case 10: {
                string = "date";
                break;
            }
            case 11: {
                string = "string";
                break;
            }
            case 12: {
                string = "real";
                break;
            }
            case 13: {
                string = "datetime";
                break;
            }
            case 15: {
                string = "note";
                break;
            }
            case 16: {
                string = "bitmap";
                break;
            }
            case 17: {
                string = "structure";
                break;
            }
            case 18: {
                string = "time";
                break;
            }
            case 19: {
                string = "boolean";
                break;
            }
            case 20: {
                string = "filename";
                break;
            }
            case 21: {
                string = "longdate";
                break;
            }
            case 25: {
                string = "boolyn";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public static int getMaxFieldValue(int n) {
        int n2;
        switch (n) {
            case 2: {
                n2 = (int)Math.pow(2.0, 8.0) - 1;
                break;
            }
            case 5: {
                n2 = (int)Math.pow(2.0, 16.0) - 1;
                break;
            }
            case 6: {
                n2 = (int)Math.pow(2.0, 32.0) - 1;
                break;
            }
            case 7: {
                n2 = (int)Math.pow(2.0, 32.0) - 1;
                break;
            }
            case 4: {
                n2 = (int)Math.pow(2.0, 16.0) - 0;
                break;
            }
            case 8: {
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 9: {
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 12: {
                n2 = Integer.MAX_VALUE;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    @Override
    public Hashtable getHashComboBoxColl() {
        return this.arComboBoxColl;
    }

    @Override
    public void setHashComboBoxColl(Hashtable hashtable) {
        if (this.arComboBoxColl != null) {
            this.arComboBoxColl.clear();
        }
        this.arComboBoxColl = hashtable;
    }

    @Override
    public void initCollections() {
    }

    @Override
    public TComboBoxColl getComboBoxColl(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, boolean bl, boolean bl2, int n) {
        TDriverStructRecord tDriverStructRecord;
        TComboBoxColl tComboBoxColl = null;
        String string2 = "";
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.arComboBoxColl == null) {
            this.arComboBoxColl = new Hashtable();
        }
        if ((tDriverStructRecord = this.DriverStruct.getField(string)) != null) {
            string2 = tDriverStructRecord.CollectionID;
            if (tFormulaEvaluator != null && tDriverStructRecord.AlternateCollection.length() > 0) {
                Object object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.AlternateCollection, tFormulaEvaluator.getAltRecordNumber(), 0);
                if (object instanceof String) {
                    string2 = (String)object;
                }
                if (string2.length() == 0) {
                    return new TComboBoxColl(false, 0);
                }
            }
            if (stringBuilder != null && !charutil.nullstr(stringBuilder)) {
                bl3 = true;
            }
            if (!bl2 && !bl3) {
                tComboBoxColl = (TComboBoxColl)this.arComboBoxColl.get(string2);
            }
            if (tComboBoxColl == null) {
                tComboBoxColl = TMainWin.Application.AppCollections.getCollection(string2, stringBuilder, tFormulaEvaluator, bl, this.getDriverParams(), "");
                if (!bl2 && !bl3 && tComboBoxColl != null) {
                    this.arComboBoxColl.put(string2, tComboBoxColl);
                }
            }
        } else {
            System.out.println("ERROR: TDriverStruct.getComboBoxColl - could not find structure field for " + string);
        }
        if (tComboBoxColl == null) {
            System.out.println("TDriverStruct.getComboBoxColl(" + string + ") returns null");
        }
        return tComboBoxColl;
    }

    @Override
    public TComboBoxColl getComboBoxColl(String string, String string2, TFormulaEvaluator tFormulaEvaluator, boolean bl, int n) {
        TComboBoxColl tComboBoxColl = null;
        boolean bl2 = false;
        if (this.arComboBoxColl == null) {
            this.arComboBoxColl = new Hashtable();
        }
        if (string2 != null && !charutil.nullstr(string2)) {
            bl2 = true;
        }
        if (!bl && !bl2) {
            tComboBoxColl = (TComboBoxColl)this.arComboBoxColl.get(string);
        }
        if (tComboBoxColl == null) {
            tComboBoxColl = TMainWin.Application.AppCollections.getCollection(string, new StringBuilder(string2), tFormulaEvaluator, false, this.getDriverParams(), "");
            if (tComboBoxColl == null) {
                MainWin.appendToLog("TAbstractDriver", "getComboBoxColl", Thread.currentThread(), null, 4, "Error creating collection " + string + " in driver " + this.AppDriversObject.DriverID);
            }
            if (!bl && !bl2 && tComboBoxColl != null) {
                this.arComboBoxColl.put(string, tComboBoxColl);
            }
        }
        return tComboBoxColl;
    }
}

