/*
 * Decompiled with CFR 0.152.
 */
package drivers.consolidated;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAbstractDriverWrapper;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverInterface;
import drivers.consolidated.TConsolidatedHorzDriver;
import drivers.consolidated.TConsolidatedVertDriver;
import drivers.consolidated.TMashupRecord;
import drivers.files.TBinaryBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TDriverMerge;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dateutil;

public class TMashupDriver
extends TAbstractDriverWrapper {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTMashupDriver");
    private static final String[] arSetTypeDescription = new String[]{"None", "Date", "Time", "Number", "Letter", "Delimited", "Collection"};
    private TAppDriversObject AppDriversObjVert = null;
    private TAppDriversObject AppDriversObjHorz = null;
    private TDriverInterface ConsolidatedDriver = null;
    private int CurrentOrientation = -1;
    private ArrayList arMashupRecordInit = new ArrayList();

    public TMashupDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, 1, bl);
        this.AppDriversObjVert = this.Application.AppDrivers.getAppDriversObject("ConsDriverVert");
        this.AppDriversObjHorz = this.Application.AppDrivers.getAppDriversObject("ConsDriverHorz");
        if (this.Debug) {
            MainWin.appendToLog("TMashupDriver", "init", Thread.currentThread(), null, 3, "TMashup init DriverParams=" + this.AppDriversObject.DriverParams);
        }
        this.FormulaEvaluator.setConstant("Params", this.AppDriversObject.DriverParams);
        String[] stringArray = charutil.getSubStringArray(this.AppDriversObject.DriverParams, '|', false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', false);
                if (stringArray2 == null || stringArray2.length != 2) continue;
                this.FormulaEvaluator.setConstant("#" + stringArray2[0], stringArray2[1]);
            }
        }
        this.doMashup();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public ArrayList getSet(TMashupRecord tMashupRecord) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = tMashupRecord.getSet_Type();
        if (n == 0) {
            arrayList.add("");
            return arrayList;
        }
        String string = tMashupRecord.getSet_Filter();
        String string2 = tMashupRecord.getSet_Name();
        if (string2.length() > 0) {
            string2 = string2 + "=";
        }
        String string3 = tMashupRecord.getSet_Start();
        String string4 = tMashupRecord.getSet_End();
        Object object = this.FormulaEvaluator.getFormulaValue(string3, -1, -1);
        Object object2 = this.FormulaEvaluator.getFormulaValue(string4, -1, -1);
        if (this.Debug) {
            MainWin.appendToLog("TMashupDriver", "init", Thread.currentThread(), null, 3, "TMashup.Creating set collection.  Type=" + arSetTypeDescription[n] + " Start=" + object + " End=" + object2 + " Filter=" + string);
        }
        if (n == 6) {
            TComboBoxColl tComboBoxColl;
            if (!(object instanceof String)) {
                object = TFormulaEvaluator.convertToString(object);
            }
            String string5 = tMashupRecord.getSet_Collection();
            if (this.Debug) {
                MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Mashup - creating set with Collection=" + string5 + " Filter=" + string);
            }
            if ((tComboBoxColl = this.Application.AppCollections.getCollection(string5, new StringBuilder(string), this.FormulaEvaluator, false, this.getDriverParams(), "")) == null || tComboBoxColl.size() == 0) {
                MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Mashup Error: Collection contains no elements.  Collection=" + string5 + " Filter=" + string);
                return null;
            }
            ArrayList arrayList2 = tMashupRecord.getSet_Collection_Option() == 0 ? tComboBoxColl.getKeys() : tComboBoxColl.getValues();
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList.add(string2 + (String)arrayList2.get(i));
            }
            tComboBoxColl.dispose();
            return arrayList;
        }
        if (object == null) {
            MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid starting value in set:starting value " + string3);
            return null;
        }
        if (object2 == null && n != 5) {
            MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid ending value in set:ending value " + string4);
            return null;
        }
        String string6 = tMashupRecord.getSet_Increment();
        Object object3 = this.FormulaEvaluator.getFormulaValue(string6, -1, -1);
        String string7 = tMashupRecord.getSet_Pattern();
        switch (n) {
            case 1: {
                if (!(object instanceof Date)) {
                    object = TFormulaEvaluator.convertToDate(object);
                }
                if (!(object2 instanceof Date)) {
                    object2 = TFormulaEvaluator.convertToDate(object2);
                }
                if (!(object instanceof Date)) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid starting date in mashup: " + string3);
                    return null;
                }
                if (!(object2 instanceof Date)) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid ending date in mashup: " + string4);
                    return null;
                }
                if (this.Debug) {
                    System.out.print("setStart = " + dateutil.formatDate((Date)object, "MM-dd-yyyy"));
                    System.out.println(" setEnd = " + dateutil.formatDate((Date)object2, "MM-dd-yyyy"));
                }
                if (((Date)object).getTime() > ((Date)object2).getTime()) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Starting date is later than ending date." + ((Date)object).getTime() + ">" + ((Date)object2).getTime());
                    return null;
                }
                int n2 = (int)TFormulaEvaluator.convertToNumber(object3);
                if (n2 < 1) {
                    n2 = 1;
                }
                Date date = (Date)object;
                Date date2 = (Date)object2;
                while (date.getTime() <= date2.getTime()) {
                    arrayList.add(string2 + dateutil.formatDate(date, string7));
                    date.setTime(date.getTime() + (long)(86400000 * n2));
                }
                break;
            }
            case 2: {
                if (!(object instanceof Date)) {
                    object = TFormulaEvaluator.convertToDate(object);
                }
                if (!(object2 instanceof Date)) {
                    object2 = TFormulaEvaluator.convertToDate(object2);
                }
                if (!(object instanceof Date)) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid starting date in mashup: " + string3);
                    return null;
                }
                if (!(object2 instanceof Date)) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid ending date in mashup: " + string4);
                    return null;
                }
                if (((Date)object).getTime() > ((Date)object2).getTime()) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Starting date is later than ending date." + ((Date)object).getTime() + ">" + ((Date)object2).getTime());
                    return null;
                }
                int n3 = (int)TFormulaEvaluator.convertToNumber(object3);
                if (n3 < 1) {
                    n3 = 1;
                }
                Date date = (Date)object;
                Date date3 = (Date)object2;
                while (date.getTime() <= date3.getTime()) {
                    arrayList.add(string2 + dateutil.formatDate(date, string7));
                    date.setTime(date.getTime() + (long)(1000 * n3));
                }
                break;
            }
            case 3: {
                if (!(object instanceof Double)) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid starting number in mashup: " + string3);
                    return null;
                }
                if (!(object2 instanceof Double)) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid ending date in mashup: " + string4);
                    return null;
                }
                double d = (Double)object;
                double d2 = (Double)object2;
                if (this.Debug) {
                    System.out.print("setStart = " + d);
                    System.out.println(" setEnd = " + d2);
                }
                if (d > d2) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Starting number is later than ending number." + d + ">" + d2);
                    return null;
                }
                double d3 = TFormulaEvaluator.convertToNumber(object3);
                if (d3 <= 0.0) {
                    d3 = 1.0;
                }
                NumberFormat numberFormat = NumberFormat.getInstance();
                ((DecimalFormat)numberFormat).applyPattern(string7);
                while (d <= d2) {
                    arrayList.add(string2 + numberFormat.format(d));
                    d += d3;
                }
                break;
            }
            case 4: {
                char c;
                if (!(object instanceof String)) {
                    object = TFormulaEvaluator.convertToString(object);
                }
                if (!(object2 instanceof String)) {
                    object2 = TFormulaEvaluator.convertToString(object2);
                }
                if (((String)object).length() == 0) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid starting character in mashup: " + object);
                    return null;
                }
                if (((String)object2).length() == 0) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Invalid ending character in mashup: " + object);
                    return null;
                }
                int n4 = ((String)object).charAt(0);
                if (n4 > (c = ((String)object2).charAt(0))) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Starting character is greater than ending character." + ((String)object).charAt(0) + ">" + ((String)object2).charAt(0));
                    return null;
                }
                int n5 = (int)TFormulaEvaluator.convertToNumber(object3);
                if (n5 <= 0) {
                    n5 = 1;
                }
                while (n4 <= c) {
                    arrayList.add(string2 + new StringBuilder((char)n4).toString());
                    n4 += n5;
                }
                break;
            }
            case 5: {
                String[] stringArray;
                if (!(object instanceof String)) {
                    object = TFormulaEvaluator.convertToString(object);
                }
                if ((stringArray = charutil.getSubStringArray((String)object, ',', true)) == null || stringArray.length == 0) {
                    MainWin.appendToLog("TMashupDriver", "getSet", Thread.currentThread(), null, 4, "Empty delimited string in mashup: " + object);
                    return null;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(string2 + stringArray[i]);
                }
                break;
            }
        }
        return arrayList;
    }

    @Override
    public int makeEditableFile() {
        return 1;
    }

    @Override
    public boolean isFiltered() {
        return this.IsFiltered;
    }

    public void doMashup() {
        boolean bl;
        Object object;
        int n;
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Mashup", 0, true, false, "");
        String[] stringArray = new String[]{"Virtual_Index"};
        tAspectDriver.setSortOptions(stringArray, false);
        tAspectDriver.setActiveFilter("ID=\"" + this.AppDriversObject.FileName.toString() + "\"", true);
        int n2 = tAspectDriver.getRecordCount();
        if (n2 == 0) {
            MainWin.appendToLog("TMashupDriver", "doMashup", Thread.currentThread(), null, 3, "Cannot locate any mashup commands for " + this.AppDriversObject.FileName.toString());
            tAspectDriver.dispose();
            return;
        }
        TMashupRecord tMashupRecord = new TMashupRecord(tAspectDriver, 0);
        for (n = 0; n < n2; ++n) {
            int n3;
            tMashupRecord.setRecord(n);
            if (!tMashupRecord.getEnabled()) continue;
            ArrayList arrayList = this.getSet(tMashupRecord);
            if (this.Debug) {
                if (arrayList == null) {
                    System.out.println("No elements returned in set");
                } else {
                    System.out.println("Elements in set: ");
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        System.out.println("  Element [" + n3 + "] " + arrayList.get(n3).toString());
                    }
                }
            }
            if (arrayList == null) continue;
            if (tMashupRecord.getSource_Filter().length() > 0) {
                this.IsFiltered = true;
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                String string;
                int n4;
                String string2;
                object = (String)arrayList.get(n3);
                if (this.AppDriversObject.DriverParams.length() > 0) {
                    object = this.AppDriversObject.DriverParams + "|" + (String)object;
                }
                if ((string2 = tMashupRecord.getDriver_Params()).length() > 0) {
                    object = (String)object + "|" + string2;
                }
                if ((n4 = (string = (String)arrayList.get(n3)).indexOf(61)) >= 0 && n4 < string.length() - 1) {
                    string = string.substring(n4 + 1);
                }
                object = (String)object + "|SetName=" + string;
                TMashupRecordInit tMashupRecordInit = new TMashupRecordInit(tMashupRecord, (String)object);
                this.arMashupRecordInit.add(tMashupRecordInit);
                tMashupRecordInit.start();
            }
        }
        do {
            if (this.Debug) {
                MainWin.appendToLog("TMashupDriver", "doMashup", Thread.currentThread(), null, 10, "Waiting for drivers to initialize...");
            }
            bl = true;
            for (int i = 0; bl && i < this.arMashupRecordInit.size(); ++i) {
                object = (TMashupRecordInit)this.arMashupRecordInit.get(i);
                if (!((Thread)object).isAlive()) continue;
                bl = false;
            }
            if (bl) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!bl);
        block12: for (n = 0; n < this.arMashupRecordInit.size(); ++n) {
            TMashupRecordInit tMashupRecordInit = (TMashupRecordInit)this.arMashupRecordInit.get(n);
            switch (tMashupRecordInit.MashupType) {
                case 0: {
                    this.addDriver(tMashupRecordInit);
                    continue block12;
                }
                case 1: {
                    this.breakLinks();
                    this.mergeDriver(tMashupRecordInit);
                    continue block12;
                }
                case 2: {
                    this.breakLinks();
                }
            }
        }
        tAspectDriver.dispose();
        if (this.ConsolidatedDriver != null) {
            this.WrappedDriver = this.ConsolidatedDriver;
        }
    }

    public boolean addDriver(TMashupRecordInit tMashupRecordInit) {
        if (this.Debug) {
            MainWin.appendToLog("TNashupDriver", "addDriver", Thread.currentThread(), null, 10, "Mashing driver ID: " + tMashupRecordInit.AddDriverID + " Params: " + tMashupRecordInit.SetParams);
        }
        if (tMashupRecordInit.driver == null) {
            return false;
        }
        if (tMashupRecordInit.Orientation != this.CurrentOrientation) {
            TAbstractDriver tAbstractDriver;
            if (tMashupRecordInit.Orientation == 0) {
                tAbstractDriver = new TConsolidatedHorzDriver(this.Application, this.AppDriversObjHorz, 1, true);
                this.CurrentOrientation = 0;
                if (this.ConsolidatedDriver != null) {
                    ((TConsolidatedHorzDriver)tAbstractDriver).addDriver(this.ConsolidatedDriver, "", "", "", "");
                }
            } else {
                tAbstractDriver = new TConsolidatedVertDriver(this.Application, this.AppDriversObjVert, 1, true);
                this.CurrentOrientation = 1;
                if (this.ConsolidatedDriver != null) {
                    ((TConsolidatedVertDriver)tAbstractDriver).addDriver(this.ConsolidatedDriver, "", "", "");
                }
            }
            this.ConsolidatedDriver = tAbstractDriver;
        }
        if (tMashupRecordInit.Orientation == 0) {
            ((TConsolidatedHorzDriver)this.ConsolidatedDriver).addDriver(tMashupRecordInit.driver.F, tMashupRecordInit.strAlias_Fields, tMashupRecordInit.Fields_To_Mash, tMashupRecordInit.strFilter, tMashupRecordInit.strKey_Fields);
        } else {
            ((TConsolidatedVertDriver)this.ConsolidatedDriver).addDriver(tMashupRecordInit.driver.F, tMashupRecordInit.strAlias_Fields, tMashupRecordInit.Fields_To_Mash, tMashupRecordInit.strFilter);
        }
        if (this.Debug) {
            MainWin.appendToLog("TNashupDriver", "addDriver", Thread.currentThread(), null, 10, "Mashing driver ID: " + tMashupRecordInit.AddDriverID + " Complete");
        }
        return true;
    }

    private boolean mergeDriver(TMashupRecordInit tMashupRecordInit) {
        if (this.Debug) {
            MainWin.appendToLog("TNashupDriver", "addDriver", Thread.currentThread(), null, 10, "Merging driver ID: " + tMashupRecordInit.AddDriverID);
        }
        if (this.ConsolidatedDriver != null) {
            if (tMashupRecordInit.driver == null) {
                return false;
            }
            TAspectDriver tAspectDriver = new TAspectDriver(TMainWin.Application, null, (TAbstractDriver)this.ConsolidatedDriver, true, false);
            tAspectDriver.setActiveFilter("true", true);
            TDriverMerge tDriverMerge = new TDriverMerge(tMashupRecordInit.boolMergeAppend, tAspectDriver, tMashupRecordInit.strMergeDestFilter, tMashupRecordInit.driver, tMashupRecordInit.strFilter, tMashupRecordInit.strKey_Fields, tMashupRecordInit.Fields_To_Mash, tMashupRecordInit.strAlias_Fields, tMashupRecordInit.boolMergeNewRecordsOnly);
            String string = tDriverMerge.merge();
            if (this.Debug) {
                MainWin.appendToLog("TMashupDriver", "doMashup", Thread.currentThread(), null, 3, "Merge Result: " + string);
            }
            tAspectDriver.getAspectDriverFilter().dispose();
        }
        return true;
    }

    private boolean breakLinks() {
        if (this.Debug) {
            MainWin.appendToLog("TNashupDriver", "addDriver", Thread.currentThread(), null, 10, "Breaking links to source drivers");
        }
        if (this.ConsolidatedDriver != null) {
            TBinaryBuffer tBinaryBuffer = new TBinaryBuffer(TMainWin.Application, null, 1, false);
            tBinaryBuffer.setDriverStruct(this.ConsolidatedDriver.getDriverStruct());
            tBinaryBuffer.copyDriver(this.ConsolidatedDriver, null, null);
            this.ConsolidatedDriver.dispose();
            this.ConsolidatedDriver = tBinaryBuffer;
            this.CurrentOrientation = -1;
        }
        return true;
    }

    private class TMashupRecordInit
    extends Thread {
        int MashupType;
        String AddDriverID;
        int Orientation;
        String strKey_Fields;
        String Fields_To_Mash;
        String strAlias_Fields;
        String strFilter;
        String SetParams;
        boolean boolMergeAppend;
        boolean boolMergeNewRecordsOnly;
        String strMergeDestFilter;
        TAspectDriver driver;

        TMashupRecordInit(TMashupRecord tMashupRecord, String string) {
            this.setPriority(1);
            this.MashupType = tMashupRecord.getMashup_Type();
            this.AddDriverID = tMashupRecord.getDriver();
            this.Orientation = tMashupRecord.getOrientation();
            this.strKey_Fields = tMashupRecord.getKey_Fields();
            this.Fields_To_Mash = tMashupRecord.getInclude_Fields();
            this.strAlias_Fields = tMashupRecord.getAlias_Fields();
            this.strFilter = tMashupRecord.getSource_Filter();
            this.SetParams = string;
            this.boolMergeAppend = tMashupRecord.getMerge_New_Records();
            this.boolMergeNewRecordsOnly = tMashupRecord.getMerge_New_Records_Only();
            this.strMergeDestFilter = tMashupRecord.getMerge_Destination_Filter();
            if (this.strFilter.startsWith("=")) {
                Object object = TMashupDriver.this.FormulaEvaluator.getFormulaValue(this.strFilter, -1, -1);
                TFormulaEvaluator cfr_ignored_0 = TMashupDriver.this.FormulaEvaluator;
                this.strFilter = TFormulaEvaluator.convertToString(object);
            }
        }

        @Override
        public void run() {
            TAppDriversObject tAppDriversObject;
            if ((this.MashupType == 0 || this.MashupType == 1) && (tAppDriversObject = TMashupDriver.this.Application.AppDrivers.getAppDriversObject(this.AddDriverID)) != null) {
                this.driver = new TAspectDriver(this.AddDriverID, 1, false, false, this.SetParams);
                if (this.MashupType == 0 && this.Orientation == 0 && this.strKey_Fields.trim().length() == 0) {
                    MainWin.appendToLog("TMashupDriver", "addDriver", Thread.currentThread(), null, 3, "No key fields defined when adding driver: " + this.AddDriverID);
                }
            }
        }
    }
}

