/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.files.TBinaryBuffer;
import java.io.IOException;
import java.io.RandomAccessFile;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.asciifiles.TAsciiInput;

public class TAspectFileBuffer
extends TBinaryBuffer {
    private static TMainWin MainWin = Aspect.MainWin;

    public TAspectFileBuffer(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        this.PerformanceMark.ClassName = "TAspectFileBuffer";
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.clearBuffer();
    }

    @Override
    public synchronized int makeEditableFile() throws IOException {
        if (this.FileName == null || this.FileName.trim().length() == 0) {
            return 0;
        }
        TAsciiInput tAsciiInput = new TAsciiInput(this.FileName, '\u0000');
        if (tAsciiInput.isValid()) {
            byte[] byArray = tAsciiInput.get_entire_file();
            this.arBuffer = new byte[byArray.length - 290];
            System.arraycopy(byArray, 290, this.arBuffer, 0, byArray.length - 290);
        } else {
            MainWin.appendToLog("TAspectFileBuffer", "makeEditableFile", Thread.currentThread(), null, 4, "Error occurred reading file:" + this.FileName + " ");
        }
        tAsciiInput.dispose();
        this.cRecords = this.arBuffer.length / this.RecordSize;
        return 0;
    }

    @Override
    public synchronized int updateSourceFile() {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.FileName, "rwd");
            randomAccessFile.seek(290L);
            randomAccessFile.write(this.arBuffer);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            MainWin.appendToLog("TAspectFileBuffer", "updateSourceFile", Thread.currentThread(), exception, 4, "Error writing file:" + this.FileName + " ");
        }
        return 0;
    }

    @Override
    public synchronized void clearBuffer() {
    }

    @Override
    public synchronized void clearWriteBuffer() {
        this.updateSourceFile();
    }
}

