/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import performance.TPerformanceFileMark;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFile;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.objectutil;

public class TBinaryFile
extends TAbstractDriver {
    private byte[] ARIntBuffer = new byte[4];
    private byte[] ARShortBuffer = new byte[2];
    private byte[] ARLongBuffer = new byte[8];
    private byte[] ARFloatBuffer = new byte[4];
    private byte[] ARDoubleBuffer = new byte[8];
    private byte[] arCharBuffer = new byte[16384];
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTBinaryFile");
    public String AccessMode;
    private int BufferStartRec;
    public RandomAccessFile F = null;
    public String TempFileName = null;
    private GregorianCalendar calendar = new GregorianCalendar();
    private TWriteBuffer WriteBuffer = null;
    private int countPutField = 0;
    private int countCommitWrite = 0;
    private int countBufferedWrites = 0;
    private boolean IsValid = true;
    private Hashtable hashedFields = new Hashtable();
    private boolean HashEmpty = true;
    private int MaxReadBufferSize = 64000;
    private int RecsToBuffer = 0;
    private byte[] FileBuffer;
    private int RecordCount = 0;
    Date RecordCountInitialized = new Date();
    private String FileNameUpperCase = "";
    private static Hashtable hPutFieldTime = new Hashtable();
    private String[] arRecordCountException = new String[]{"widget_library_metadata1.dta", "DataMsg", "history", "Library_Documents_01.dta"};
    private boolean bGetRecordCountFromFilesize = false;
    private static long InstanceCount = 0L;
    private long Instance = InstanceCount++;
    String LastRecordCountErrMsg = "";
    private long tLastInitializeNewRecord = 0L;
    private boolean bLastInitializeNewRecordAppend = false;

    public TBinaryFile(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        this.FileNameUpperCase = charutil.replaceChar(this.FileName.toUpperCase(), '\\', '/');
        for (int i = 0; i < this.arRecordCountException.length; ++i) {
            if (this.FileNameUpperCase.indexOf(this.arRecordCountException[i].toUpperCase()) < 0) continue;
            this.bGetRecordCountFromFilesize = true;
        }
        this.PerformanceMark = new TPerformanceFileMark("TBinaryFile", this.AppDriversObject.DriverID.toString(), this.AppDriversObject.FileName.toString(), this.AppDriversObject.DriverParams);
        TFormulaEvaluator.Performance.addMark(this.PerformanceMark);
        switch (n) {
            case 0: {
                this.AccessMode = "r";
                this.IsWriteable = false;
                break;
            }
            case 1: {
                this.AccessMode = "rwd";
                this.IsWriteable = true;
            }
        }
        this.BufferStartRec = -1;
    }

    @Override
    public synchronized void dispose() {
        if (this.WriteBuffer != null) {
            this.WriteBuffer.commitWrites();
        }
        super.dispose();
        this.hashedFields.clear();
        this.clearBuffer();
        if (this.F != null) {
            try {
                this.F.close();
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TBinaryFile", "dispose", Thread.currentThread(), exception, 3, "Error closing file: " + this.AppDriversObject.Description);
            }
        }
        if (this.TempFileName != null) {
            File file = new File(this.TempFileName);
            file.delete();
        }
    }

    @Override
    public synchronized boolean isValid() {
        return this.IsValid;
    }

    @Override
    public synchronized int makeEditableFile() throws IOException {
        URL uRL;
        if (this.FileName.trim().length() == 0) {
            this.IsValid = false;
            return 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[1024];
        boolean bl = false;
        if (((String)this.FormulaEvaluator.getFormulaValue("#DisableWriteBuffer", 0, 0)).equalsIgnoreCase("true")) {
            System.out.println("disabling write buffer for " + this.FileName);
        } else {
            this.WriteBuffer = new TWriteBuffer();
        }
        dosutil.formatURL(stringBuilder, new StringBuilder(this.FileName));
        if (bl) {
            System.out.println("Str1: " + stringBuilder);
        }
        if ((uRL = new URL(stringBuilder.toString())).getProtocol().toUpperCase().equals("FILE") && this.FileName.toUpperCase().indexOf(".ZIP") < 0 && this.FileName.toUpperCase().indexOf(".JAR") < 0) {
            this.IsLocal = true;
            if (this.getMode() == 1) {
                new TFile(this.FileName).validatePathToFile(true);
            }
            try {
                this.F = new RandomAccessFile(this.FileName, this.AccessMode);
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TBinaryFile", "makeEditableFile", Thread.currentThread(), null, 4, "Error: File not found: " + this.FileName);
            }
        } else {
            int n;
            this.IsLocal = false;
            this.IsWriteable = false;
            File file = dosutil.createTempFile("tmp");
            this.TempFileName = file.getPath();
            if (bl) {
                System.out.println("TempFileName: " + this.TempFileName);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(dosutil.getInputStream(this.FileName));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            do {
                if ((n = bufferedInputStream.read(byArray)) <= 0) continue;
                bufferedOutputStream.write(byArray, 0, n);
            } while (n > 0);
            bufferedInputStream.close();
            bufferedOutputStream.close();
            this.F = new RandomAccessFile(this.TempFileName, this.AccessMode);
        }
        this.getFileHeader();
        this.RecsToBuffer = (int)Math.floor(this.MaxReadBufferSize / this.RecordSize);
        this.FileBuffer = new byte[this.RecordSize * this.RecsToBuffer];
        this.RecordCount = this.initializeRecordCount();
        return 0;
    }

    public void initializeBuffer() {
        this.RecsToBuffer = (int)Math.floor(this.MaxReadBufferSize / this.RecordSize);
        this.FileBuffer = new byte[this.RecordSize * this.RecsToBuffer];
        this.RecordCount = this.initializeRecordCount();
    }

    @Override
    public synchronized int updateSourceFile() {
        try {
            long l = this.F.getFilePointer();
            this.F.close();
            this.F = new RandomAccessFile(this.FileName, this.AccessMode);
            this.F.seek(l);
        }
        catch (Exception exception) {
            System.out.println("TBinaryFile,updateSourceFile: " + this.FileName + " " + exception.toString());
        }
        return 0;
    }

    @Override
    public synchronized boolean verifySaveChanges() {
        return true;
    }

    @Override
    public synchronized void f_create() {
        try {
            this.clearBuffer();
            this.F.setLength(0L);
            this.RecordCount = 0;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    @Override
    public synchronized int getRecordCount() {
        int n;
        Object v = hPutFieldTime.get(this.FileNameUpperCase);
        if (v != null && ((Date)v).getTime() > this.RecordCountInitialized.getTime()) {
            n = this.RecordCount;
            this.RecordCount = this.initializeRecordCount();
        }
        if (this.MainWin.isRunningOnServer() ? !this.bGetRecordCountFromFilesize : !this.bGetRecordCountFromFilesize) {
            return this.RecordCount;
        }
        n = this.initializeRecordCount();
        if (n != this.RecordCount) {
            String string = "TBinaryFile[" + this.Instance + "]: Error: " + this.FileName + " r1=" + this.RecordCount + " r2=" + n;
            this.MainWin.appendToLog("TBinaryFile", "getRecordCount", Thread.currentThread(), null, 4, string);
            this.RecordCount = n;
        }
        return n;
    }

    public synchronized int initializeRecordCount() {
        boolean bl = false;
        this.RecordCountInitialized = new Date();
        if (this.RecordSize == 0) {
            return 0;
        }
        if (this.WriteBuffer == null) {
            try {
                String string;
                int n;
                double d;
                if (bl) {
                    System.out.println("F.length: " + this.F.length() + ", HeaderSize: " + this.HeaderSize + ", RecordSize: " + this.RecordSize);
                    int n2 = (int)((this.F.length() - (long)this.HeaderSize) / (long)this.RecordSize);
                    System.out.println("getRecordCount = " + n2);
                }
                if ((d = (double)(this.F.length() - (long)this.HeaderSize) / (double)this.RecordSize) != (double)(n = (int)d) && !(string = "File size is not a multiple of the record size in " + this.FileName).equalsIgnoreCase(this.LastRecordCountErrMsg)) {
                    System.out.println(string);
                    this.LastRecordCountErrMsg = string;
                }
                return n;
            }
            catch (Exception exception) {}
        } else {
            Object object;
            int n = -1;
            int n3 = -1;
            for (int i = 0; i < this.WriteBuffer.arBufferedWrites.size(); ++i) {
                object = (TWriteBufferObj)this.WriteBuffer.arBufferedWrites.get(i);
                n = Math.max(n, ((TWriteBufferObj)object).getFileOffset() + ((TWriteBufferObj)object).getDataSize());
            }
            try {
                n3 = (int)Math.max((long)n, this.F.length());
            }
            catch (Exception exception) {
                object = "Error in getRecordCount for " + this.FileName + ": " + exception.toString();
                if (!((String)object).equalsIgnoreCase(this.LastRecordCountErrMsg)) {
                    System.out.println((String)object);
                    this.LastRecordCountErrMsg = object;
                }
                if (!this.FileName.toUpperCase().startsWith("LOG_")) {
                    this.MainWin.appendToLog("TBinaryFile", "getRecordCount", Thread.currentThread(), null, 4, (String)object);
                }
                return 0;
            }
            if ((n3 - this.HeaderSize) % this.RecordSize != 0) {
                try {
                    String string = "Error: File size is not a multiple of the record size in " + this.FileName + " Size: " + n3 + " HeaderSz: " + this.HeaderSize + " RecordSz: " + this.RecordSize + " FileSz: " + this.F.length() + " Struct=" + this.AppDriversObject.DriverID;
                    if (!string.equalsIgnoreCase(this.LastRecordCountErrMsg)) {
                        System.out.println(string);
                        System.out.println("Size1=" + n + " Size2=" + n3 + " File length=" + this.F.length());
                        System.out.println("If this message is generated during creation of a collection, make sure the filename in the driver params of ");
                        System.out.println("the original driver are not being passed to the driver used for the collection/");
                        System.out.println("See the driver source of the Aspect6 nvsize.dta for an example of overriding the filename");
                        new Throwable().printStackTrace();
                        this.LastRecordCountErrMsg = string;
                    }
                    if (!this.FileName.toUpperCase().startsWith("LOG_")) {
                        this.MainWin.appendToLog("TBinaryFile", "getRecordCount", Thread.currentThread(), null, 4, string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (n3 - this.HeaderSize) / this.RecordSize;
        }
        return 0;
    }

    public synchronized int getBufferOffset(int n, int n2) {
        boolean bl = true;
        if (this.BufferStartRec >= 0 && this.BufferStartRec <= n && this.BufferStartRec + this.RecsToBuffer > n) {
            bl = false;
        }
        if (bl) {
            this.BufferStartRec = n;
            int n3 = this.getRecordCount() - this.RecsToBuffer;
            if (this.BufferStartRec > n3) {
                this.BufferStartRec = n3;
                if (this.BufferStartRec + this.RecsToBuffer <= n) {
                    this.BufferStartRec = n - this.RecsToBuffer + 1;
                }
            }
            if (this.BufferStartRec < 0) {
                this.BufferStartRec = 0;
            }
            try {
                this.F.seek(this.HeaderSize + this.BufferStartRec * this.RecordSize);
                this.F.read(this.FileBuffer);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            ++this.PerformanceMark.cUpdated;
        } else {
            ++this.PerformanceMark.cCached;
        }
        return (n - this.BufferStartRec) * this.RecordSize + n2;
    }

    public synchronized void setWriteOffset(int n, int n2) {
        this.BufferStartRec = -1;
        if (this.F == null) {
            return;
        }
        long l = this.HeaderSize + n * this.RecordSize + n2;
        try {
            if (this.F.getFilePointer() != l) {
                this.F.seek(l);
            }
        }
        catch (Exception exception) {
            System.out.println("TBinaryFile.setWriteOffset: " + exception.toString() + " in file named " + this.FileName);
            new Throwable().printStackTrace();
        }
    }

    public synchronized void seek(long l) {
        if (this.F == null) {
            return;
        }
        try {
            this.F.seek(l);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public synchronized int read(byte[] byArray) {
        if (this.F == null) {
            return 0;
        }
        try {
            return this.F.read(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return 0;
        }
    }

    public synchronized void write(byte[] byArray) {
        if (this.F == null) {
            return;
        }
        try {
            this.F.write(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static void write(RandomAccessFile randomAccessFile, byte[] byArray) {
        try {
            randomAccessFile.write(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    @Override
    public synchronized void clearBuffer() {
        this.clearWriteBuffer();
        this.BufferStartRec = -1;
        this.hashedFields.clear();
        this.HashEmpty = true;
    }

    @Override
    public synchronized void clearWriteBuffer() {
        if (this.WriteBuffer != null) {
            this.WriteBuffer.commitWrites();
        }
    }

    @Override
    public synchronized int initializeNewRecord(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        boolean bl2 = false;
        long l = new Date().getTime();
        int n3 = this.getRecordCount();
        if (this.AppDriversObject != null && this.AppDriversObject.InsertMode == 0) {
            if (l - this.tLastInitializeNewRecord < 30000L && this.bLastInitializeNewRecordAppend) {
                n2 = n3;
                bl2 = true;
            } else {
                for (n = 0; !bl2 && n < n3; ++n) {
                    if (!this.isDeleted(n)) continue;
                    n2 = n;
                    bl2 = true;
                }
                this.clearBuffer();
            }
        }
        if (!bl2) {
            n2 = n3;
        }
        this.tLastInitializeNewRecord = l;
        this.bLastInitializeNewRecordAppend = n2 == n3;
        this.intNewRecordSeed = n2;
        this.putRecord(n2, new byte[this.RecordSize]);
        if (bl) {
            for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
                Object object;
                Object object2;
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
                if (tDriverStructRecord.IsVirtual || tDriverStructRecord.DefaultOnInsert.length() <= 0) continue;
                stringBuilder.setLength(0);
                if (this.FormulaEvaluator != null && tDriverStructRecord.DefaultOnInsert.length() > 0 && (object2 = this.FormulaEvaluator.getFormulaValue(tDriverStructRecord.DefaultOnInsert, n2, 0)) != null) {
                    stringBuilder.append(TFormulaEvaluator.convertToString(object2));
                }
                if ((object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringBuilder.toString(), n2)) == null) {
                    System.out.println("Error converting " + tDriverStructRecord.FullID);
                }
                this.putField(tDriverStructRecord, n2, object);
            }
        }
        return n2;
    }

    @Override
    public synchronized Object getField(String string, int n) {
        if (this.F == null) {
            return null;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public synchronized Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (this.F == null) {
            return null;
        }
        if (tDriverStructRecord == null) {
            return null;
        }
        Object object = null;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        if (this.hProfileFieldReadCount != null) {
            if (this.hProfileFieldReadCount.containsKey(tDriverStructRecord.FullID)) {
                n2 = (Integer)this.hProfileFieldReadCount.get(tDriverStructRecord.FullID);
                n3 = (Integer)this.hProfileFieldReadMs.get(tDriverStructRecord.FullID);
            }
            this.hProfileFieldReadCount.put(tDriverStructRecord.FullID, new Integer(n2 + 1));
        }
        Date date = new Date();
        if (tDriverStructRecord.IsToken) {
            StringBuilder stringBuilder = new StringBuilder();
            TMainWin.Application.getTokenValue(stringBuilder, tDriverStructRecord.ID);
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringBuilder.toString(), 0);
            if (this.hProfileFieldReadMs != null) {
                this.hProfileFieldReadMs.put(tDriverStructRecord.FullID, new Integer(n3 + (int)(new Date().getTime() - date.getTime())));
            }
            return object;
        }
        if (this.WriteBuffer != null) {
            this.WriteBuffer.commitWrites();
        }
        ++this.PerformanceMark.cRead;
        if (!tDriverStructRecord.IsCalculated) {
            this.PerformanceMark.cReadBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        }
        ++tDriverStructRecord.cRead;
        if (!tDriverStructRecord.IsCalculated) {
            tDriverStructRecord.cReadBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        }
        if ((object = this.hashedFields.get(string = Integer.toString(n) + "|" + tDriverStructRecord.FullID)) != null) {
            ++this.PerformanceMark.cCached;
            this.PerformanceMark.cReadMs = (int)((long)this.PerformanceMark.cReadMs + (new Date().getTime() - date.getTime()));
            ++tDriverStructRecord.cCached;
            tDriverStructRecord.cReadMs = (int)((long)tDriverStructRecord.cReadMs + (new Date().getTime() - date.getTime()));
            if (this.hProfileFieldReadMs != null) {
                this.hProfileFieldReadMs.put(tDriverStructRecord.FullID, new Integer(n3 + (int)(new Date().getTime() - date.getTime())));
            }
            return object;
        }
        if (!tDriverStructRecord.IsVirtual && !tDriverStructRecord.IsCalculated) {
            switch (tDriverStructRecord.FieldType) {
                case 1: {
                    object = new Boolean(this.getBool(n, tDriverStructRecord.Offset));
                    break;
                }
                case 2: {
                    object = new Integer(charutil.unsignedByteToInt(this.getByte(n, tDriverStructRecord.Offset)));
                    break;
                }
                case 3: 
                case 24: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getChars(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 26: {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = new String(this.getChars(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    if (string2 != null && string2.trim().length() > 0) {
                        string2 = charutil.decrypt(string2, "");
                    }
                    object = string2;
                    break;
                }
                case 22: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getBinaryData(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 4: {
                    object = new Integer(this.getShort(n, tDriverStructRecord.Offset));
                    break;
                }
                case 5: {
                    object = new Integer(charutil.unsignedShortToInt(this.getShort(n, tDriverStructRecord.Offset)));
                    break;
                }
                case 6: {
                    object = new Integer(this.getInt(n, tDriverStructRecord.Offset));
                    break;
                }
                case 7: {
                    object = new Integer(this.getInt(n, tDriverStructRecord.Offset));
                    break;
                }
                case 8: {
                    object = new Float(this.getFloat(n, tDriverStructRecord.Offset));
                    break;
                }
                case 9: {
                    object = new Double(this.getDouble(n, tDriverStructRecord.Offset));
                    break;
                }
                case 10: 
                case 13: 
                case 18: {
                    GregorianCalendar gregorianCalendar = this.getDate(n, tDriverStructRecord.Offset);
                    object = new Date(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 21: {
                    object = new Date(this.getLong(n, tDriverStructRecord.Offset));
                    break;
                }
                case 11: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getPString(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 12: {
                    object = new Double(this.getReal(n, tDriverStructRecord.Offset));
                    break;
                }
                case 15: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getPString(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 19: {
                    object = new Boolean(this.getBoolean(n, tDriverStructRecord.Offset));
                    break;
                }
                case 25: {
                    object = new Boolean(this.getBoolYN(n, tDriverStructRecord.Offset));
                    break;
                }
                case 20: {
                    StringBuilder stringBuilder = new StringBuilder();
                    object = new String(this.getChars(stringBuilder, n, tDriverStructRecord.Offset, tDriverStructRecord.ArraySize));
                    break;
                }
                case 16: {
                    int n4;
                    byte by = this.getByte(n, tDriverStructRecord.Offset);
                    int n5 = by & 0x7F;
                    if (by < 0) {
                        n5 |= 0x80;
                    }
                    if ((n5 & 1 << (n4 = tDriverStructRecord.ArrayIndex % 8)) > 0) {
                        object = new Boolean("true");
                        break;
                    }
                    object = new Boolean("false");
                    break;
                }
                default: {
                    object = new String("Error");
                }
            }
        }
        if (tDriverStructRecord.IsCalculated) {
            object = this.calculateField(tDriverStructRecord, n);
        }
        if (this.BufferOn && object != null && !tDriverStructRecord.NoBuffer) {
            if (this.hashedFields.size() > 20000) {
                this.hashedFields.clear();
            }
            this.hashedFields.put(string, object);
            this.HashEmpty = false;
        }
        this.PerformanceMark.cReadMs = (int)((long)this.PerformanceMark.cReadMs + (new Date().getTime() - date.getTime()));
        tDriverStructRecord.cReadMs = (int)((long)tDriverStructRecord.cReadMs + (new Date().getTime() - date.getTime()));
        if (this.hProfileFieldReadMs != null) {
            this.hProfileFieldReadMs.put(tDriverStructRecord.FullID, new Integer(n3 + (int)(new Date().getTime() - date.getTime())));
        }
        return object;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public synchronized int putField(String string, int n, Object object) {
        if (this.F == null) {
            return 0;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            this.MainWin.appendToLog("TBinaryFile", "putField", Thread.currentThread(), new Throwable(), 4, "Invalid field pointer writing value: " + objectutil.convertToString(object) + " FieldID=" + string);
            return 0;
        }
        return this.putField(tDriverStructRecord, n, object);
    }

    @Override
    public synchronized int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        if (this.F == null) {
            return 0;
        }
        if (tDriverStructRecord == null) {
            this.MainWin.appendToLog("TBinaryFile", "putField", Thread.currentThread(), new Throwable(), 4, "Invalid field pointer writing value: " + objectutil.convertToString(object));
            return 0;
        }
        this.RecordCount = Math.max(this.RecordCount, n + 1);
        this.RecordCountInitialized = new Date();
        hPutFieldTime.put(this.FileNameUpperCase, this.RecordCountInitialized);
        ++this.countPutField;
        if (tDriverStructRecord.IsToken) {
            String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            TMainWin.Application.setTokenValue(tDriverStructRecord.ID, string);
            return 1;
        }
        if (tDriverStructRecord.IsVirtual) {
            return 0;
        }
        if (object == null) {
            return 0;
        }
        if (this.undoManager != null && this.undoManager.isRecording()) {
            System.out.println("Recordundoevent");
            this.recordUndoEvent(tDriverStructRecord, n, this.getField(tDriverStructRecord, n), object);
        }
        ++this.PerformanceMark.cWrite;
        this.PerformanceMark.cWriteBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        ++tDriverStructRecord.cWrite;
        tDriverStructRecord.cWriteBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        Date date = new Date();
        this.clearBuffer();
        switch (tDriverStructRecord.FieldType) {
            case 1: {
                this.putBool(n, tDriverStructRecord.Offset, (Boolean)object);
                break;
            }
            case 2: {
                this.putByte(n, tDriverStructRecord.Offset, ((Integer)object).byteValue());
                break;
            }
            case 24: {
                this.putCharsNull(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 3: {
                this.putChars(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 26: {
                if (!(object instanceof String)) {
                    System.out.println("Class cast error writing field: " + tDriverStructRecord.FullID);
                    break;
                }
                String string = (String)object;
                if (string.trim().length() > 0) {
                    string = charutil.encrypt(string, "");
                }
                this.putChars(n, tDriverStructRecord.Offset, string, tDriverStructRecord.ArraySize);
                break;
            }
            case 22: {
                this.putBinaryData(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 4: 
            case 5: {
                this.putShort(n, tDriverStructRecord.Offset, ((Integer)object).shortValue());
                break;
            }
            case 6: 
            case 7: {
                this.putInt(n, tDriverStructRecord.Offset, (Integer)object);
                break;
            }
            case 8: {
                if (object instanceof Float) {
                    this.putFloat(n, tDriverStructRecord.Offset, ((Float)object).floatValue());
                    break;
                }
                this.putFloat(n, tDriverStructRecord.Offset, ((Double)object).floatValue());
                break;
            }
            case 9: {
                if (object instanceof Double) {
                    this.putDouble(n, tDriverStructRecord.Offset, (Double)object);
                    break;
                }
                if (object instanceof Long) {
                    this.putDouble(n, tDriverStructRecord.Offset, ((Long)object).doubleValue());
                    break;
                }
                this.MainWin.appendToLog("TBinaryFile", "putField", Thread.currentThread(), null, 4, "Value is of wrong type when writing field - " + tDriverStructRecord.FullID + "[" + object.getClass().getName() + "]");
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                this.calendar.setTime((Date)object);
                this.putDate(n, tDriverStructRecord.Offset, this.calendar);
                break;
            }
            case 21: {
                this.putLong(n, tDriverStructRecord.Offset, ((Date)object).getTime());
                break;
            }
            case 11: 
            case 15: {
                this.putPString(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 12: {
                this.putReal(n, tDriverStructRecord.Offset, (Double)object);
                break;
            }
            case 19: {
                this.putBoolean(n, tDriverStructRecord.Offset, (Boolean)object);
                break;
            }
            case 25: {
                this.putBoolYN(n, tDriverStructRecord.Offset, (Boolean)object);
                break;
            }
            case 20: {
                this.putChars(n, tDriverStructRecord.Offset, (String)object, tDriverStructRecord.ArraySize);
                break;
            }
            case 16: {
                byte by = this.getByte(n, tDriverStructRecord.Offset);
                int n2 = by & 0x7F;
                if (by < 0) {
                    n2 |= 0x80;
                }
                int n3 = tDriverStructRecord.ArrayIndex % 8;
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                } else if (object instanceof Integer && (Integer)object > 0) {
                    bl = true;
                }
                n2 = bl ? (n2 |= 1 << n3) : (n2 &= ~(1 << n3));
                by = (byte)(n2 & 0x7F);
                if ((n2 & 0x80) > 0) {
                    by = (byte)(by | 0x80);
                }
                this.putByte(n, tDriverStructRecord.Offset, by);
                break;
            }
            default: {
                System.out.println("Error in TBinaryFile.putField(" + tDriverStructRecord.FullID + ")");
            }
        }
        this.Modified = true;
        this.PerformanceMark.cWriteMs = (int)((long)this.PerformanceMark.cWriteMs + (new Date().getTime() - date.getTime()));
        tDriverStructRecord.cWriteMs = (int)((long)tDriverStructRecord.cWriteMs + (new Date().getTime() - date.getTime()));
        return 1;
    }

    @Override
    public synchronized byte[] getRecord(int n) {
        byte[] byArray = new byte[this.RecordSize];
        try {
            this.F.seek(this.HeaderSize + n * this.RecordSize);
            this.F.read(byArray);
        }
        catch (Exception exception) {
            String string = "Error reading record " + n;
            if (this.AppDriversObject != null) {
                string = string + " from " + this.AppDriversObject.Description;
            }
            this.MainWin.appendToLog("TBinaryFile", "getRecord", Thread.currentThread(), exception, 4, string);
        }
        return byArray;
    }

    @Override
    public synchronized void putRecord(int n, byte[] byArray) {
        try {
            this.F.seek(this.HeaderSize + n * this.RecordSize);
            this.F.write(byArray);
            this.clearBuffer();
            this.Modified = true;
            this.RecordCount = Math.max(this.RecordCount, n + 1);
            this.RecordCountInitialized = new Date();
            hPutFieldTime.put(this.FileNameUpperCase, this.RecordCountInitialized);
        }
        catch (Exception exception) {
            String string = "Error writing record " + n;
            if (this.AppDriversObject != null) {
                string = string + " from " + this.AppDriversObject.Description;
            }
            this.MainWin.appendToLog("TBinaryFile", "putRecord", Thread.currentThread(), exception, 4, string);
        }
    }

    public synchronized boolean getBoolean(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        byte by = this.FileBuffer[n3];
        return by != 0;
    }

    public synchronized void putBoolean(int n, int n2, boolean bl) {
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.writeBoolean(bl);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putBoolean: " + exception.toString());
            }
        } else {
            byte[] byArray = new byte[1];
            if (bl) {
                byArray[0] = 1;
            }
            this.WriteBuffer.addData(n, n2, byArray);
        }
    }

    public synchronized boolean getBool(int n, int n2) {
        short s = this.getShort(n, n2);
        return s != 0;
    }

    public synchronized void putBool(int n, int n2, boolean bl) {
        int n3 = 0;
        if (bl) {
            n3 = 1;
        }
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.writeShort(n3);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putBool: " + exception.toString());
            }
        } else {
            byte[] byArray = new byte[2];
            if (bl) {
                byArray[1] = 1;
            }
            this.WriteBuffer.addData(n, n2, byArray);
        }
    }

    public synchronized boolean getBoolYN(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        byte by = this.FileBuffer[n3];
        return (char)by != 'N' && (char)by != 'n';
    }

    public synchronized void putBoolYN(int n, int n2, boolean bl) {
        int n3 = 78;
        if (bl) {
            n3 = 89;
        }
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.writeByte((byte)n3);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putByte: " + exception.toString());
            }
        } else {
            byte[] byArray = new byte[]{(byte)n3};
            this.WriteBuffer.addData(n, n2, byArray);
        }
    }

    public synchronized byte getByte(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        if (n3 >= 0) {
            return this.FileBuffer[n3];
        }
        return 0;
    }

    public synchronized void putByte(int n, int n2, byte by) {
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.writeByte(by);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putByte: " + exception.toString());
            }
        } else {
            byte[] byArray = new byte[]{by};
            this.WriteBuffer.addData(n, n2, byArray);
        }
    }

    public synchronized String getChars(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = this.getBufferOffset(n, n2);
        int n5 = 0;
        stringBuilder.setLength(0);
        int n6 = n4;
        while (n5 < n3 && this.FileBuffer[n6] != 0) {
            stringBuilder.append((char)this.FileBuffer[n6]);
            ++n5;
            ++n6;
        }
        return stringBuilder.toString();
    }

    public synchronized void putChars(int n, int n2, String string, int n3) {
        block7: {
            if (string == null) {
                return;
            }
            if (this.WriteBuffer == null) {
                int n4 = string.length();
                try {
                    this.setWriteOffset(n, n2);
                    if (n4 < n3) {
                        this.F.writeBytes(string);
                        this.F.write(this.arCharBuffer, 0, n3 - n4);
                        break block7;
                    }
                    String string2 = string.substring(0, n3);
                    this.F.writeBytes(string2);
                }
                catch (Exception exception) {
                    this.MainWin.appendToLog("TBinaryFile", "putChars", Thread.currentThread(), exception, 4, "Error writing record " + n + " of " + this.getRecordCount() + " in " + this.AppDriversObject.DriverID + " value=" + string);
                }
            } else {
                byte[] byArray = new byte[n3];
                for (int i = 0; i < string.length() && i < n3; ++i) {
                    byArray[i] = (byte)string.charAt(i);
                }
                this.WriteBuffer.addData(n, n2, byArray);
            }
        }
    }

    public synchronized void putCharsNull(int n, int n2, String string, int n3) {
        block7: {
            if (string == null) {
                return;
            }
            if (this.WriteBuffer == null) {
                int n4 = string.length();
                try {
                    this.setWriteOffset(n, n2);
                    if (n4 < n3) {
                        this.F.writeBytes(string);
                        this.F.write(this.arCharBuffer, 0, n3 - n4);
                        break block7;
                    }
                    String string2 = string.substring(0, n3 - 1);
                    this.F.writeBytes(string2);
                    this.F.write(this.arCharBuffer, 0, 1);
                }
                catch (Exception exception) {
                    this.MainWin.appendToLog("TBinaryFile", "putChars", Thread.currentThread(), exception, 4, "Error writing record " + n + " of " + this.getRecordCount() + " in " + this.AppDriversObject.DriverID + " value=" + string);
                }
            } else {
                byte[] byArray = new byte[n3];
                for (int i = 0; i < string.length() && i < n3; ++i) {
                    byArray[i] = (byte)string.charAt(i);
                }
                byArray[byArray.length - 1] = 0;
                this.WriteBuffer.addData(n, n2, byArray);
            }
        }
    }

    public synchronized String getBinaryData(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = this.getBufferOffset(n, n2);
        int n5 = 0;
        stringBuilder.setLength(0);
        int n6 = n4;
        while (n5 < n3) {
            stringBuilder.append((char)this.FileBuffer[n6]);
            ++n5;
            ++n6;
        }
        return stringBuilder.toString();
    }

    public synchronized void putBinaryData(int n, int n2, String string, int n3) {
        block7: {
            if (string == null) {
                return;
            }
            if (this.WriteBuffer == null) {
                int n4 = string.length();
                try {
                    this.setWriteOffset(n, n2);
                    if (n4 < n3) {
                        this.F.writeBytes(string);
                        this.F.write(this.arCharBuffer, 0, n3 - n4);
                        break block7;
                    }
                    String string2 = string.substring(0, n3 - 1);
                    this.F.writeBytes(string2);
                }
                catch (Exception exception) {
                    System.out.println("TBinaryFile.putChars: " + exception.toString());
                }
            } else {
                byte[] byArray = new byte[n3];
                for (int i = 0; i < string.length() && i < n3; ++i) {
                    byArray[i] = (byte)string.charAt(i);
                }
                this.WriteBuffer.addData(n, n2, byArray);
            }
        }
    }

    public synchronized String getPString(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = this.getBufferOffset(n, n2);
        int n5 = this.FileBuffer[n4];
        if (n5 < 0) {
            n5 += 129;
        }
        if (n5 > n3 - 1) {
            n5 = n3 - 1;
        }
        String string = new String(this.FileBuffer, n4 + 1, n5);
        charutil.strcpy(stringBuilder, string);
        return string;
    }

    public synchronized void putPString(int n, int n2, String string, int n3) {
        byte[] byArray = new byte[n3];
        byte[] byArray2 = string.getBytes();
        int n4 = Array.getLength(byArray2);
        byArray[0] = (byte)n3;
        if (n4 < n3) {
            byArray[0] = (byte)n4;
        }
        for (int i = 1; i < n3; ++i) {
            byArray[i] = 0;
            if (i >= n4 + 1) continue;
            byArray[i] = byArray2[i - 1];
        }
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.write(byArray);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putPString: " + exception.toString());
            }
        } else {
            this.WriteBuffer.addData(n, n2, byArray);
        }
    }

    public synchronized GregorianCalendar getDate(int n, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = this.getBufferOffset(n, n2);
        short s = ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3);
        short s2 = ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 2);
        short s4 = ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 4);
        short s5 = ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 6);
        short s6 = ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 8);
        short s7 = ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3 + 10);
        if (s < 100) {
            s = s < 50 ? (short)(s + 2000) : (short)(s + 1900);
        }
        if (s < 0) {
            s = 0;
        }
        if (s2 > 0) {
            s2 = (short)(s2 - 1);
        }
        if (s2 > 11) {
            s2 = 0;
        }
        if (s2 < 0) {
            s2 = 0;
        }
        if (s4 < 1) {
            s4 = 1;
        }
        if (s5 > 23) {
            s5 = 0;
        }
        if (s5 < 0) {
            s5 = 0;
        }
        if (s6 > 59) {
            s6 = 0;
        }
        if (s6 < 0) {
            s6 = 0;
        }
        if (s7 > 59) {
            s7 = 0;
        }
        if (s7 < 0) {
            s7 = 0;
        }
        gregorianCalendar.setLenient(false);
        gregorianCalendar.clear();
        gregorianCalendar.set(s, s2, s4, s5, s6, s7);
        boolean bl = true;
        try {
            if (gregorianCalendar.get(1) > gregorianCalendar.getMaximum(1) || gregorianCalendar.get(1) < gregorianCalendar.getMinimum(1)) {
                bl = false;
            }
            if (gregorianCalendar.get(2) > gregorianCalendar.getMaximum(2) || gregorianCalendar.get(2) < gregorianCalendar.getMinimum(2)) {
                bl = false;
            }
            if (gregorianCalendar.get(5) > gregorianCalendar.getMaximum(5) || gregorianCalendar.get(5) < gregorianCalendar.getMinimum(5)) {
                bl = false;
            }
            if (gregorianCalendar.get(11) > gregorianCalendar.getMaximum(11) || gregorianCalendar.get(11) < gregorianCalendar.getMinimum(11)) {
                bl = false;
            }
            if (gregorianCalendar.get(12) > gregorianCalendar.getMaximum(12) || gregorianCalendar.get(12) < gregorianCalendar.getMinimum(12)) {
                bl = false;
            }
            if (gregorianCalendar.get(13) > gregorianCalendar.getMaximum(13) || gregorianCalendar.get(13) < gregorianCalendar.getMinimum(13)) {
                bl = false;
            }
        }
        catch (Exception exception) {
            gregorianCalendar.clear();
        }
        if (!bl) {
            gregorianCalendar.clear();
        }
        return gregorianCalendar;
    }

    public synchronized void putDate(int n, int n2, GregorianCalendar gregorianCalendar) {
        byte[] byArray = new byte[12];
        ByteBuffer.wrap(this.ARShortBuffer).order(ByteOrder.LITTLE_ENDIAN).putShort((short)gregorianCalendar.get(1));
        System.arraycopy(this.ARShortBuffer, 0, byArray, 0, 2);
        ByteBuffer.wrap(this.ARShortBuffer).order(ByteOrder.LITTLE_ENDIAN).putShort((short)(gregorianCalendar.get(2) + 1));
        System.arraycopy(this.ARShortBuffer, 0, byArray, 2, 2);
        ByteBuffer.wrap(this.ARShortBuffer).order(ByteOrder.LITTLE_ENDIAN).putShort((short)gregorianCalendar.get(5));
        System.arraycopy(this.ARShortBuffer, 0, byArray, 4, 2);
        ByteBuffer.wrap(this.ARShortBuffer).order(ByteOrder.LITTLE_ENDIAN).putShort((short)gregorianCalendar.get(11));
        System.arraycopy(this.ARShortBuffer, 0, byArray, 6, 2);
        ByteBuffer.wrap(this.ARShortBuffer).order(ByteOrder.LITTLE_ENDIAN).putShort((short)gregorianCalendar.get(12));
        System.arraycopy(this.ARShortBuffer, 0, byArray, 8, 2);
        ByteBuffer.wrap(this.ARShortBuffer).order(ByteOrder.LITTLE_ENDIAN).putShort((short)gregorianCalendar.get(13));
        System.arraycopy(this.ARShortBuffer, 0, byArray, 10, 2);
        if (this.WriteBuffer == null) {
            try {
                this.setWriteOffset(n, n2);
                this.F.write(byArray);
            }
            catch (Exception exception) {
                this.setWriteOffset(n, n2);
                byte[] byArray2 = new byte[12];
                for (int i = 0; i < 12; ++i) {
                    byArray2[i] = 0;
                }
                try {
                    this.write(byArray2);
                }
                catch (Exception exception2) {}
            }
        } else {
            this.WriteBuffer.addData(n, n2, byArray);
        }
    }

    public synchronized int getInt(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        return ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt(n3);
    }

    public synchronized void putInt(int n, int n2, int n3) {
        ByteBuffer.wrap(this.ARIntBuffer).order(ByteOrder.LITTLE_ENDIAN).putInt(n3);
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.write(this.ARIntBuffer);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        } else {
            this.WriteBuffer.addData(n, n2, this.ARIntBuffer);
        }
    }

    public synchronized short getShort(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        return ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getShort(n3);
    }

    public synchronized short getShort() {
        byte[] byArray = new byte[2];
        try {
            this.F.read(byArray);
            return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getShort(0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static short getShort(RandomAccessFile randomAccessFile) {
        try {
            byte[] byArray = new byte[2];
            randomAccessFile.read(byArray);
            return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getShort(0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public synchronized void putShort(int n, int n2, short s) {
        ByteBuffer.wrap(this.ARShortBuffer).order(ByteOrder.LITTLE_ENDIAN).putShort(s);
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.write(this.ARShortBuffer);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putShort: " + exception.toString());
            }
        } else {
            this.WriteBuffer.addData(n, n2, this.ARShortBuffer);
        }
    }

    public static void putShort(RandomAccessFile randomAccessFile, short s) {
        try {
            byte[] byArray = new byte[2];
            ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).putShort(s);
            randomAccessFile.write(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
    }

    public synchronized long getLong(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        return ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getLong(n3);
    }

    public synchronized void putLong(int n, int n2, long l) {
        ByteBuffer.wrap(this.ARLongBuffer).order(ByteOrder.LITTLE_ENDIAN).putLong(l);
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.write(this.ARLongBuffer);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putLong: " + exception.toString());
            }
        } else {
            this.WriteBuffer.addData(n, n2, this.ARLongBuffer);
        }
    }

    public synchronized float getFloat(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        return ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getFloat(n3);
    }

    public synchronized float getFloat() {
        byte[] byArray = new byte[4];
        try {
            this.F.read(byArray);
            return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getFloat(0);
        }
        catch (Exception exception) {
            System.out.println("TBinaryFile.putFloat: " + exception.toString());
            return 0.0f;
        }
    }

    public static float getFloat(RandomAccessFile randomAccessFile) {
        try {
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray);
            return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getFloat(0);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return 0.0f;
        }
    }

    public synchronized void putFloat(int n, int n2, float f) {
        ByteBuffer.wrap(this.ARFloatBuffer).order(ByteOrder.LITTLE_ENDIAN).putFloat(f);
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.write(this.ARFloatBuffer);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        } else {
            this.WriteBuffer.addData(n, n2, this.ARFloatBuffer);
        }
    }

    public static void putFloat(RandomAccessFile randomAccessFile, float f) {
        try {
            byte[] byArray = new byte[4];
            ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).putFloat(f);
            randomAccessFile.write(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private synchronized double twoto(int n) {
        double d;
        try {
            d = 1.0;
            for (int i = 1; i <= Math.abs(n); ++i) {
                d = 2.0 * d;
            }
            if (n < 0) {
                d = 1.0 / d;
            }
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    public synchronized double getReal(int n, int n2) {
        double d;
        int n3 = this.getBufferOffset(n, n2);
        int[] nArray = new int[6];
        boolean bl = false;
        for (int i = 0; i < 6; ++i) {
            nArray[i] = this.FileBuffer[n3 + i];
            if (nArray[i] < 0) {
                nArray[i] = 128 + (this.FileBuffer[n3 + i] & 0x7F);
            }
            if (!bl) continue;
            System.out.print("ar[" + i + "]=" + nArray[i] + "  ");
        }
        if (bl) {
            System.out.println();
        }
        double d2 = 0.00390625;
        if (bl) {
            System.out.println("c=" + d2);
        }
        if (nArray[0] == 0) {
            d = 0.0;
        } else {
            double d3 = 1.0 + 2.0 * (((((double)nArray[1] * d2 + (double)nArray[2]) * d2 + (double)nArray[3]) * d2 + (double)nArray[4]) * d2 + (double)(nArray[5] & 0x7F)) * d2;
            if (bl) {
                System.out.println("x=" + d3);
            }
            if (nArray[5] > 127) {
                d3 = -d3;
            }
            d = d3 * this.twoto((short)nArray[0] - 129);
            if (bl) {
                System.out.println("Num1=" + d);
            }
        }
        return d;
    }

    public synchronized void putReal(int n, int n2, double d) {
        int n3;
        short[] sArray = new short[6];
        byte[] byArray = new byte[8];
        int[] nArray = new int[8];
        short[] sArray2 = new short[4];
        byte[] byArray2 = new byte[6];
        boolean bl = false;
        ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).putDouble(0, d);
        ShortBuffer shortBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        sArray2[0] = shortBuffer.get(0);
        sArray2[1] = shortBuffer.get(1);
        sArray2[2] = shortBuffer.get(2);
        sArray2[3] = shortBuffer.get(3);
        for (n3 = 0; n3 < 8; n3 = (int)((short)(n3 + 1))) {
            nArray[n3] = byArray[n3];
            if (nArray[n3] >= 0) continue;
            nArray[n3] = 128 + (byArray[n3] & 0x7F);
        }
        if (bl) {
            for (n3 = 0; n3 < 8; n3 = (int)((short)(n3 + 1))) {
                System.out.print("ArX[" + n3 + "]=" + byArray[n3] + ", ");
            }
            System.out.println();
            for (n3 = 0; n3 < 8; n3 = (int)((short)(n3 + 1))) {
                System.out.print("ArX2[" + n3 + "]=" + nArray[n3] + ", ");
            }
            System.out.println();
            for (n3 = 0; n3 < 4; n3 = (int)((short)(n3 + 1))) {
                System.out.print("ArT4[" + n3 + "]=" + sArray2[n3] + ", ");
            }
            System.out.println();
        }
        for (n3 = 0; n3 < 6; n3 = (int)((short)(n3 + 1))) {
            sArray[n3] = 0;
        }
        if (d != 0.0) {
            int n4 = 894;
            int n5 = (int)Math.floor(sArray2[3] / 16) & 0x7FF;
            if (n5 >= n4 && n5 <= n4 + 255) {
                sArray[0] = (short)(n5 - n4);
                for (n3 = 5; n3 > 0; n3 = (int)((short)(n3 - 1))) {
                    int n6 = nArray[n3 + 1];
                    if (n6 < 0) {
                        n6 = 128 + (nArray[n3 + 1] & 0x7F);
                    }
                    int n7 = nArray[n3];
                    if (n6 < 0) {
                        n7 = 128 + (nArray[n3] & 0x7F);
                    }
                    sArray[n3] = (short)(n6 * 8 & 0xF8 | n7 / 32 & 7);
                }
                sArray[5] = d < 0.0 ? (short)(sArray[5] | 0x80) : (short)(sArray[5] & 0x7F);
            }
        }
        for (n3 = 0; n3 < 6; n3 = (int)((short)(n3 + 1))) {
            byArray2[n3] = (byte)sArray[n3];
        }
        if (bl) {
            for (n3 = 0; n3 < 6; n3 = (int)((short)(n3 + 1))) {
                System.out.print("arReal[" + n3 + "]=" + sArray[n3] + ", ");
            }
            for (n3 = 0; n3 < 6; n3 = (int)((short)(n3 + 1))) {
                System.out.print("arByte[" + n3 + "]=" + byArray2[n3] + ", ");
            }
            System.out.println();
        }
        if (this.WriteBuffer == null) {
            try {
                this.setWriteOffset(n, n2);
                this.F.write(byArray2);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putReal: " + exception.toString());
            }
        } else {
            this.WriteBuffer.addData(n, n2, byArray2);
        }
    }

    public synchronized double getDouble(int n, int n2) {
        int n3 = this.getBufferOffset(n, n2);
        return ByteBuffer.wrap(this.FileBuffer).order(ByteOrder.LITTLE_ENDIAN).getDouble(n3);
    }

    public synchronized void putDouble(int n, int n2, double d) {
        ByteBuffer.wrap(this.ARDoubleBuffer).order(ByteOrder.LITTLE_ENDIAN).putDouble(d);
        if (this.WriteBuffer == null) {
            this.setWriteOffset(n, n2);
            try {
                this.F.write(this.ARDoubleBuffer);
            }
            catch (Exception exception) {
                System.out.println("TBinaryFile.putDouble: " + exception.toString());
            }
        } else {
            this.WriteBuffer.addData(n, n2, this.ARDoubleBuffer);
        }
    }

    @Override
    public synchronized void swapRecords(int n, int n2) {
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (tDriverStructRecord.IsVirtual) continue;
            Object object = this.getField(tDriverStructRecord, n);
            Object object2 = this.getField(tDriverStructRecord, n2);
            this.putField(tDriverStructRecord, n, object2);
            this.putField(tDriverStructRecord, n2, object);
        }
    }

    @Override
    public synchronized void packRecords(StringBuilder stringBuilder) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        System.out.println("Packing records: " + this.FileName);
        if (this.undoManager != null) {
            bl2 = this.undoManager.getUndoRecording();
            this.undoManager.setUndoRecording(false);
            this.undoManager.clear();
        }
        int n4 = this.getRecordCount();
        while (n < n4 && !bl) {
            if (this.isDeleted(n, stringBuilder)) {
                if (n2 <= n) {
                    n2 = n + 1;
                }
                while (n2 < n4 && this.isDeleted(n2, stringBuilder)) {
                    ++n2;
                }
                if (n2 < n4) {
                    this.swapRecords(n, n2);
                    n3 = n++;
                } else {
                    bl = true;
                }
            } else {
                n3 = n++;
            }
            Thread.yield();
        }
        if (n4 == this.getRecordCount()) {
            try {
                this.F.setLength(this.HeaderSize + (n3 + 1) * this.RecordSize);
            }
            catch (Exception exception) {
                System.out.println("Exception in packRecords: " + exception.toString());
            }
        }
        if (this.undoManager != null) {
            this.undoManager.setUndoRecording(bl2);
        }
    }

    private class TWriteBufferObj
    implements Comparable {
        int iRecord;
        int iOffset;
        byte[] arData;

        TWriteBufferObj(int n, int n2, byte[] byArray) {
            this.iRecord = n;
            this.iOffset = n2;
            this.arData = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.arData, 0, byArray.length);
        }

        public int getDataSize() {
            return this.arData.length;
        }

        public int getFileOffset() {
            return TBinaryFile.this.HeaderSize + this.iRecord * TBinaryFile.this.RecordSize + this.iOffset;
        }

        public int compareTo(Object object) {
            int n;
            int n2 = this.getFileOffset();
            if (n2 < (n = ((TWriteBufferObj)object).getFileOffset())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            String string = "Record: " + this.iRecord + " Offset: " + this.iOffset + " Data len: " + this.arData.length;
            return string;
        }
    }

    private class TWriteBuffer {
        ArrayList arBufferedWrites = new ArrayList();

        public void addData(int n, int n2, byte[] byArray) {
            TWriteBufferObj tWriteBufferObj = new TWriteBufferObj(n, n2, byArray);
            int n3 = Collections.binarySearch(this.arBufferedWrites, tWriteBufferObj);
            if (n3 < 0) {
                this.arBufferedWrites.add(Math.abs(n3 + 1), tWriteBufferObj);
            } else {
                TWriteBufferObj tWriteBufferObj2 = (TWriteBufferObj)this.arBufferedWrites.get(n3);
                System.arraycopy(byArray, 0, tWriteBufferObj2.arData, 0, byArray.length);
            }
        }

        public void commitWrites() {
            boolean bl = false;
            boolean bl2 = false;
            if (this.arBufferedWrites.size() == 0) {
                return;
            }
            if (!TBinaryFile.this.IsWriteable) {
                if (this.arBufferedWrites.size() > 0) {
                    System.out.println("TBinaryFile commitWrites DriverID:" + TBinaryFile.this.AppDriversObject.DriverID + " is read-only count=" + this.arBufferedWrites.size());
                    new Throwable().printStackTrace();
                }
                return;
            }
            Date date = new Date();
            TBinaryFile.this.countCommitWrite++;
            byte[] byArray = new byte[32768];
            int n = TBinaryFile.this.HeaderSize;
            int n2 = 0;
            if (bl) {
                System.out.println("commitWrites. Count=" + this.arBufferedWrites.size());
            }
            int n3 = 0;
            for (int i = 0; n3 == 0 && i < this.arBufferedWrites.size(); ++i) {
                int n4 = n + n2;
                TWriteBufferObj tWriteBufferObj = (TWriteBufferObj)this.arBufferedWrites.get(i);
                int n5 = tWriteBufferObj.getFileOffset();
                if (n4 == n5 && n2 + tWriteBufferObj.getDataSize() < byArray.length) {
                    System.arraycopy(tWriteBufferObj.arData, 0, byArray, n2, tWriteBufferObj.arData.length);
                    n2 += tWriteBufferObj.arData.length;
                    continue;
                }
                if (n2 > 0) {
                    try {
                        if (bl) {
                            System.out.println("Writing " + n2 + " bytes at " + n);
                        }
                        TBinaryFile.this.F.seek(n);
                        TBinaryFile.this.F.write(byArray, 0, n2);
                        TBinaryFile.this.countBufferedWrites++;
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        if (bl) {
                            System.out.println("Error in TBinaryFile commitWrites1: " + exception.toString());
                        }
                        ++n3;
                        new Throwable().printStackTrace();
                    }
                }
                System.arraycopy(tWriteBufferObj.arData, 0, byArray, 0, tWriteBufferObj.arData.length);
                n = n5;
                n2 = tWriteBufferObj.arData.length;
            }
            if (bl) {
                System.out.println("writing remaining data byte=" + n2);
            }
            if (n2 > 0) {
                try {
                    if (bl) {
                        System.out.println("Writing " + n2 + " bytes at " + n);
                    }
                    TBinaryFile.this.F.seek(n);
                    TBinaryFile.this.F.write(byArray, 0, n2);
                    TBinaryFile.this.countBufferedWrites++;
                    bl2 = true;
                }
                catch (Exception exception) {
                    System.out.println("Error in TBinaryFile commitWrites2: " + exception.toString() + " Filename=" + TBinaryFile.this.FileName);
                    new Throwable().printStackTrace();
                }
            }
            this.arBufferedWrites.clear();
            if (bl2) {
                TBinaryFile.this.hashedFields.clear();
                TBinaryFile.this.HashEmpty = true;
                TBinaryFile.this.clearBuffer();
            }
            TBinaryFile.this.PerformanceMark.cWriteMs = (int)((long)TBinaryFile.this.PerformanceMark.cWriteMs + (new Date().getTime() - date.getTime()));
        }
    }
}

