/*
 * Decompiled with CFR 0.152.
 */
package drivers.network;

import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import drivers.network.TNetworkMonitorWebAddressWrapper;
import java.util.ArrayList;
import java.util.Hashtable;
import utility.netutil;

public class TNetworkMonitorWebAddressWriter {
    private TAspectDriver DrvNetMonitorSites = null;
    private TDriverStructRecord DSRecNetMonitorSitesURL = null;
    private TDriverStructRecord DSRecNetMonitorSitesHostName = null;
    private TDriverStructRecord DSRecNetMonitorSitesIPAddress = null;
    private TDriverStructRecord DSRecNetMonitorSitesLastAccess = null;
    private TDriverStructRecord DSRecNetMonitorSitesAccessCount = null;
    private TDriverStructRecord DSRecNetMonitorSitesBlockedAccessCount = null;
    private TDriverStructRecord DSRecNetMonitorSitesKiloBytes = null;
    private TDriverStructRecord DSRecNetMonitorSitesBlocked = null;
    private Hashtable hashWebAddress = new Hashtable();
    private ArrayList arWebAddressesToWrite = new ArrayList();
    private boolean Terminate = false;
    private boolean IsRunning = false;

    public TNetworkMonitorWebAddressWriter() {
        this.DrvNetMonitorSites = new TAspectDriver("NetMonitorWebsites", 1, false, true, "");
        this.DSRecNetMonitorSitesURL = this.DrvNetMonitorSites.getDriverStruct().getField("url");
        this.DSRecNetMonitorSitesHostName = this.DrvNetMonitorSites.getDriverStruct().getField("HostName");
        this.DSRecNetMonitorSitesIPAddress = this.DrvNetMonitorSites.getDriverStruct().getField("IPAddress");
        this.DSRecNetMonitorSitesLastAccess = this.DrvNetMonitorSites.getDriverStruct().getField("LastAccess");
        this.DSRecNetMonitorSitesAccessCount = this.DrvNetMonitorSites.getDriverStruct().getField("AccessCount");
        this.DSRecNetMonitorSitesBlockedAccessCount = this.DrvNetMonitorSites.getDriverStruct().getField("BlockedAccessCount");
        this.DSRecNetMonitorSitesKiloBytes = this.DrvNetMonitorSites.getDriverStruct().getField("KiloBytes");
        this.DSRecNetMonitorSitesBlocked = this.DrvNetMonitorSites.getDriverStruct().getField("BlockConnection");
        this.initializeCollection();
    }

    public void dispose() {
        this.Terminate = true;
        this.DrvNetMonitorSites.dispose();
        this.hashWebAddress.clear();
        this.arWebAddressesToWrite.clear();
    }

    public void start() {
        if (!this.IsRunning) {
            this.Terminate = false;
            new TWriteWebAddresses().start();
        }
    }

    public void terminate() {
        this.Terminate = true;
    }

    public void initializeCollection() {
        this.hashWebAddress.clear();
        for (int i = 0; i < this.DrvNetMonitorSites.getRecordCount(); ++i) {
            String string = (String)this.DrvNetMonitorSites.getField(this.DSRecNetMonitorSitesURL, i);
            if (this.hashWebAddress.contains(string)) continue;
            this.hashWebAddress.put(string, new Integer(i));
        }
    }

    public synchronized TNetworkMonitorWebAddressWrapper updateList(TNetworkMonitorWebAddressWrapper tNetworkMonitorWebAddressWrapper, int n) {
        if (n == 0) {
            this.arWebAddressesToWrite.add(tNetworkMonitorWebAddressWrapper);
            return null;
        }
        if (n == 1) {
            if (tNetworkMonitorWebAddressWrapper == null) {
                if (this.arWebAddressesToWrite.size() > 0) {
                    this.arWebAddressesToWrite.remove(0);
                }
            } else {
                int n2 = this.arWebAddressesToWrite.indexOf(tNetworkMonitorWebAddressWrapper);
                if (n2 >= 0) {
                    this.arWebAddressesToWrite.remove(n2);
                }
            }
            return null;
        }
        if (n == 2 && this.arWebAddressesToWrite.size() > 0) {
            return (TNetworkMonitorWebAddressWrapper)this.arWebAddressesToWrite.get(0);
        }
        return null;
    }

    public int findMatchingAddressInCollection(String string) {
        Object v = this.hashWebAddress.get(string);
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    private class TWriteWebAddresses
    extends Thread {
        public TWriteWebAddresses() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            TNetworkMonitorWebAddressWriter.this.IsRunning = true;
            int n = 0;
            int n2 = 0;
            TNetworkMonitorWebAddressWriter.this.Terminate = false;
            while (!TNetworkMonitorWebAddressWriter.this.Terminate) {
                TNetworkMonitorWebAddressWrapper tNetworkMonitorWebAddressWrapper = TNetworkMonitorWebAddressWriter.this.updateList(null, 2);
                if (tNetworkMonitorWebAddressWrapper != null) {
                    double d;
                    int n3 = TNetworkMonitorWebAddressWriter.this.findMatchingAddressInCollection(tNetworkMonitorWebAddressWrapper.WebAddress);
                    if (n3 < 0) {
                        n3 = TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.initializeNewRecord(1, 0);
                        d = 0.0;
                        TNetworkMonitorWebAddressWriter.this.hashWebAddress.put(tNetworkMonitorWebAddressWrapper.WebAddress, new Integer(n3));
                        ((TAbstractDriver)((TNetworkMonitorWebAddressWriter)TNetworkMonitorWebAddressWriter.this).DrvNetMonitorSites.F).getWhoIsForRecord(n3);
                    } else {
                        n = (Integer)TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.getField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesAccessCount, n3);
                        n2 = (Integer)TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.getField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesBlockedAccessCount, n3);
                        d = (Double)TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.getField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesKiloBytes, n3);
                        ((TAbstractDriver)((TNetworkMonitorWebAddressWriter)TNetworkMonitorWebAddressWriter.this).DrvNetMonitorSites.F).getWhoIsForRecord(TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.getAbsoluteDiskIndex(n3));
                    }
                    TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesURL, n3, (Object)tNetworkMonitorWebAddressWrapper.WebAddress);
                    if (netutil.isValidIPAddress(tNetworkMonitorWebAddressWrapper.WebAddress)) {
                        String string = (String)TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.getField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesHostName, n3);
                        if (string.length() == 0) {
                            string = netutil.getHostName(tNetworkMonitorWebAddressWrapper.WebAddress);
                            TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesHostName, n3, (Object)string);
                        }
                        TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesIPAddress, n3, (Object)tNetworkMonitorWebAddressWrapper.WebAddress);
                    } else {
                        TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesHostName, n3, (Object)tNetworkMonitorWebAddressWrapper.WebAddress);
                        String string = (String)TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.getField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesIPAddress, n3);
                        if (string.length() == 0) {
                            string = netutil.getIPAddress(tNetworkMonitorWebAddressWrapper.WebAddress);
                            TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesIPAddress, n3, (Object)string);
                        }
                    }
                    TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesLastAccess, n3, (Object)tNetworkMonitorWebAddressWrapper.PacketTime);
                    if (tNetworkMonitorWebAddressWrapper.AccessGranted) {
                        TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesAccessCount, n3, (Object)new Integer(n + 1));
                    } else {
                        TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesBlockedAccessCount, n3, (Object)new Integer(n2 + 1));
                    }
                    TNetworkMonitorWebAddressWriter.this.DrvNetMonitorSites.putField(TNetworkMonitorWebAddressWriter.this.DSRecNetMonitorSitesKiloBytes, n3, (Object)new Double(d + (double)(tNetworkMonitorWebAddressWrapper.PacketSize / 1000)));
                    TNetworkMonitorWebAddressWriter.this.updateList(tNetworkMonitorWebAddressWrapper, 1);
                    Thread.yield();
                    continue;
                }
                Thread.yield();
            }
            System.out.println("WebAddressWriter finished");
            TNetworkMonitorWebAddressWriter.this.IsRunning = false;
        }
    }
}

