/*
 * Decompiled with CFR 0.152.
 */
package drivers.other;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.charutil;
import utility.dateutil;
import utility.memory;
import utility.objectutil;
import utility.sql.TSqlDatabase;

public class TOdbcDatabase
extends TAbstractDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    TSqlDatabase SqlDb = null;
    String[] arKeyFields = null;
    String sKeyFields = "";
    ArrayList KeyValuesColl = new ArrayList();
    String dbName = "";
    String dbHost = "";
    String dbPort = "";
    String dbTable = "";
    String dbUser = "";
    String dbPassword = "";
    String dbUrl = "";
    String dbFilter = "";
    String sWhere = "";
    private int DriverType = -1;
    private Hashtable hashedFields = new Hashtable();
    private String sOrderBy = "";
    private boolean bInvalidKeys = false;
    private boolean bInvalidKeysWarningIssued = false;
    private boolean IsValid = true;
    Hashtable hashPrepPutStmt = new Hashtable();
    Hashtable hashPrepGetStmt = new Hashtable();

    public TOdbcDatabase(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl, int n2) {
        super(tApplication, tAppDriversObject, n, bl);
        this.DriverType = n2;
        String string = charutil.replaceChar(this.AppDriversObject.FileName.toString(), ' ', '\n');
        this.dbName = charutil.replaceChar(charutil.getParamValue(string, "Name", '|'), '\n', ' ');
        this.dbHost = charutil.replaceChar(charutil.getParamValue(string, "Host", '|'), '\n', ' ');
        this.dbPort = charutil.replaceChar(charutil.getParamValue(string, "Port", '|'), '\n', ' ');
        this.dbTable = charutil.replaceChar(charutil.getParamValue(string, "Table", '|'), '\n', ' ');
        this.dbUser = charutil.replaceChar(charutil.getParamValue(string, "User", '|'), '\n', ' ');
        this.dbPassword = charutil.replaceChar(charutil.getParamValue(string, "Pass", '|'), '\n', ' ');
        this.dbFilter = charutil.replaceChar(charutil.getParamValue(string, "Filter", '|'), '\n', ' ');
        this.dbUrl = charutil.replaceChar(charutil.getParamValue(string, "Url", '|'), '\n', ' ');
        System.out.println("dbName=" + this.dbName);
        System.out.println("dbHost=" + this.dbHost);
        System.out.println("dbPort=" + this.dbPort);
        System.out.println("dbTable=" + this.dbTable);
        System.out.println("dbUser=" + this.dbUser);
        System.out.println("dbPassword=" + this.dbPassword);
        System.out.println("dbFilter=" + this.dbFilter);
        System.out.println("dbUrl=" + this.dbUrl);
        if (this.dbFilter.trim().length() > 0) {
            this.sWhere = " Where " + this.dbFilter + " ";
        }
        switch (this.AppDriversObject.FileType) {
            case 29: {
                this.SqlDb = new TSqlDatabase(this.dbName, 0, this.dbUser, this.dbPassword);
                break;
            }
            case 30: {
                this.SqlDb = new TSqlDatabase(this.dbHost, this.dbPort, this.dbName, 1, this.dbUser, this.dbPassword, this.dbUrl);
                break;
            }
            case 37: {
                this.SqlDb = new TSqlDatabase(2, this.AppDriversObject.FileName.toString());
            }
        }
        this.sKeyFields = "";
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (!tDriverStructRecord.KeyField) continue;
            if (this.sKeyFields.length() > 0) {
                this.sKeyFields = this.sKeyFields + ",";
            }
            this.sKeyFields = this.sKeyFields + "\"" + tDriverStructRecord.ID + "\"";
        }
        if (this.sKeyFields.length() > 0) {
            this.arKeyFields = charutil.getSubStringArray(this.sKeyFields, ',', true);
        } else {
            this.arKeyFields = new String[0];
            MainWin.appendToLog("TOdbcDatabase", "init", Thread.currentThread(), null, 4, "No key fields defined for table \"" + this.dbTable + "\" in database \"" + this.dbName + "\"");
        }
    }

    @Override
    public synchronized void dispose() {
        this.KeyValuesColl.clear();
        this.hashedFields.clear();
        this.SqlDb.dispose();
    }

    @Override
    public synchronized int makeEditableFile() throws IOException {
        if (this.SqlDb.connect()) {
            System.out.println("TOdbcDatabase.makeEditableFile connect=true");
            this.IsValid = true;
            StringBuilder stringBuilder = new StringBuilder();
            MainWin.appendToLog("TOdbcDatabase", "makeEditableFile", Thread.currentThread(), null, 3, "makeEditableFile calling getFieldNames()");
            String[] stringArray = this.SqlDb.getFieldNames(this.dbTable);
            if (stringArray == null) {
                MainWin.appendToLog("TOdbcDatabase", "makeEditableFile", Thread.currentThread(), null, 3, "makeEditableFile getFieldNames is null");
                this.IsValid = false;
                return 0;
            }
            MainWin.appendToLog("TOdbcDatabase", "makeEditableFile", Thread.currentThread(), null, 3, "makeEditableFile getFieldNames is not null,  Len=" + stringArray.length);
            for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                if (tDriverStructRecord.IsVirtual || tDriverStructRecord.IsCalculated) continue;
                boolean bl = false;
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equalsIgnoreCase(tDriverStructRecord.ID)) continue;
                        bl = true;
                    }
                }
                if (bl) {
                    stringBuilder.append(",\"" + tDriverStructRecord.ID + "\"");
                }
                if (bl) continue;
                if (this.AppDriversObject.DriverID.toString().toUpperCase().startsWith("POS")) {
                    MainWin.appendToLog("TOdbcDatabase", "makeEditableFile", Thread.currentThread(), null, 4, "Cannot locate field \"" + tDriverStructRecord.ID + "\" in table \"" + this.dbTable + "\" in database \"" + this.dbName + "\" and not creating one because it appears to be a POS driver");
                    return 0;
                }
                System.out.println("adding new field named \"" + tDriverStructRecord.ID + "\" to database \"" + this.dbName + "\"");
                this.SqlDb.addColumn(this.dbTable, tDriverStructRecord.ID, tDriverStructRecord.FieldType, tDriverStructRecord.ArraySize);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(0);
            }
            this.sOrderBy = stringBuilder.toString();
            this.getKeyValuesCollection();
            return 1;
        }
        System.out.println("TOdbcDatabase.makeEditableFile connect=false");
        return 0;
    }

    @Override
    public boolean isValid() {
        System.out.println("TOdbcDatabase.isValid = " + this.IsValid);
        return this.IsValid;
    }

    public boolean keysDefined() {
        return this.arKeyFields != null && this.arKeyFields.length > 0;
    }

    @Override
    public int getRecordCount() {
        return this.KeyValuesColl.size();
    }

    private void getKeyValuesCollection() {
        this.KeyValuesColl.clear();
        String string = "select ";
        if (this.arKeyFields.length == 0) {
            String string2 = this.DriverStruct.getDriverStructRecord((int)0).ID;
            string = this.DriverType == 37 ? string + "\"" + string2 + "\" from " + this.dbTable + this.sWhere + " order by " + this.sOrderBy : (this.DriverType == 30 ? string + string2 + " from " + this.dbTable + this.sWhere + " order by " + this.sOrderBy : string + "\"" + string2 + "\" from \"" + this.dbTable + "\"" + this.sWhere + " order by " + this.sOrderBy);
        } else if (this.DriverType == 30) {
            for (int i = 0; i < this.arKeyFields.length; ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + this.arKeyFields[i];
            }
            string = string + " from " + this.dbTable + this.sWhere;
        } else {
            for (int i = 0; i < this.arKeyFields.length; ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + "\"" + this.arKeyFields[i] + "\"";
            }
            string = this.DriverType == 37 ? string + " from " + this.dbTable + this.sWhere : string + " from \"" + this.dbTable + "\"" + this.sWhere;
        }
        try {
            int n = 0;
            Statement statement = this.SqlDb.createStatement();
            statement.executeQuery(string);
            ResultSet resultSet = statement.getResultSet();
            if (resultSet != null) {
                int n2 = resultSet.getMetaData().getColumnCount();
                int n3 = 0;
                while (resultSet.next()) {
                    TValuesObj tValuesObj = new TValuesObj(resultSet, n2, n3);
                    ++n3;
                    int n4 = Collections.binarySearch(this.KeyValuesColl, tValuesObj);
                    if (n4 < 0) {
                        this.KeyValuesColl.add(Math.abs(n4 + 1), tValuesObj);
                        continue;
                    }
                    ++n;
                }
            } else {
                MainWin.appendToLog("TOdbcDatabase", "getKeyValuesCollection", Thread.currentThread(), null, 4, "Error: Got null resultset in getKeyValuesCollection in database " + this.dbTable);
            }
            statement.close();
            if (n > 0) {
                MainWin.appendToLog("TOdbcDatabase", "getKeyValuesCollection", Thread.currentThread(), null, 4, "Warning: Keys do not define unique records in table \"" + this.dbTable + "\" in database \"" + this.dbName + "\" (" + n + " duplicate records)");
                this.bInvalidKeys = true;
            }
        }
        catch (Exception exception) {
            MainWin.appendToLog("TOdbcDatabase", "getKeyValuesCollection", Thread.currentThread(), exception, 4, "Error in getValuesColl in table \"" + this.dbTable + "\" in database \"" + this.dbName + "\". " + exception.toString());
        }
    }

    @Override
    public synchronized void clearBuffer() {
        this.hashedFields.clear();
    }

    public boolean isKeyField(String string) {
        for (int i = 0; i < this.arKeyFields.length; ++i) {
            if (!this.arKeyFields[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized int initializeNewRecord(boolean bl) {
        int n;
        String[] stringArray;
        int n2 = 0;
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            stringArray = (String[])this.DriverStruct.FieldColl.get(i);
            if (!stringArray.KeyField && (stringArray.DefaultOnInsert.length() <= 0 || !bl)) continue;
            ++n2;
        }
        if (n2 == 0) {
            MainWin.appendToLog("TOdbcDatabase", "initializeNewRecord", Thread.currentThread(), null, 4, "Error adding record to database.  No fields to initialize in " + this.dbName);
            return this.KeyValuesColl.size();
        }
        TValuesObj tValuesObj = new TValuesObj();
        stringArray = new String[n2];
        Object[] objectArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
            if (!tDriverStructRecord.KeyField && (tDriverStructRecord.DefaultOnInsert.length() <= 0 || !bl)) continue;
            stringArray[n3] = tDriverStructRecord.ID;
            objectArray[n3] = "";
            if (this.FormulaEvaluator != null && tDriverStructRecord.DefaultOnInsert.length() > 0) {
                Object object = this.FormulaEvaluator.getFormulaValue(tDriverStructRecord.DefaultOnInsert, this.KeyValuesColl.size(), 0);
                objectArray[n3] = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            }
            for (int i = 0; i < this.arKeyFields.length; ++i) {
                if (!this.arKeyFields[i].equalsIgnoreCase(tDriverStructRecord.ID)) continue;
                tValuesObj.KeyValues[i] = objectArray[n3];
            }
            ++n3;
        }
        this.SqlDb.addRecord(this.dbTable, stringArray, objectArray);
        n = Collections.binarySearch(this.KeyValuesColl, tValuesObj);
        if (n < 0) {
            this.KeyValuesColl.add(Math.abs(n + 1), tValuesObj);
        } else {
            MainWin.appendToLog("TOdbcDatabase", "initializeNewRecord", Thread.currentThread(), null, 4, "Duplicate key found in initializeNewRecord in " + this.dbTable);
        }
        return this.KeyValuesColl.size() - 1;
    }

    @Override
    public synchronized int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        int n2;
        String string;
        if (this.bInvalidKeys) {
            MainWin.appendToLog("TOdbcDatabase", "putField", Thread.currentThread(), null, 4, "Cannot write to table \"" + this.dbTable + "\" because keys are not unique in " + this.dbName);
            return 0;
        }
        if (this.arKeyFields.length == 0) {
            MainWin.appendToLog("TOdbcDatabase", "putField", Thread.currentThread(), null, 4, "Cannot write to table \"" + this.dbTable + "\" because no key fields are defined in " + this.dbName);
            return 0;
        }
        if (this.Mode != 1) {
            MainWin.appendToLog("TOdbcDatabase", "putField", Thread.currentThread(), null, 4, "Cannot write to table \"" + this.dbTable + "\" because database \"" + this.dbName + "\" opened in read-only mode");
            return 0;
        }
        if (tDriverStructRecord == null) {
            MainWin.appendToLog("TOdbcDatabase", "putField", Thread.currentThread(), null, 4, "Invalid field pointer writing value: " + objectutil.convertToString(object) + " in table \"" + this.dbTable + "\" in database \"" + this.dbName + "\"");
        }
        if (tDriverStructRecord.IsToken) {
            String string2 = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            TMainWin.Application.setTokenValue(tDriverStructRecord.ID, string2);
            return 1;
        }
        if (tDriverStructRecord.IsVirtual) {
            return 0;
        }
        if (object == null) {
            return 0;
        }
        TValuesObj tValuesObj = (TValuesObj)this.KeyValuesColl.get(n);
        PreparedStatement preparedStatement = (PreparedStatement)this.hashPrepPutStmt.get(tDriverStructRecord.ID);
        if (preparedStatement == null) {
            string = "update " + this.dbTable + " set " + "\"" + tDriverStructRecord.ID + "\"" + "=? where ";
            for (n2 = 0; n2 < this.arKeyFields.length; ++n2) {
                if (n2 > 0) {
                    string = string + " and ";
                }
                string = string + "(\"" + this.arKeyFields[n2] + "\"" + "=?)";
            }
            if (this.dbFilter.length() > 0) {
                string = string + " AND " + this.dbFilter;
            }
            preparedStatement = this.SqlDb.prepareStatement(string);
            this.hashPrepPutStmt.put(tDriverStructRecord.ID, preparedStatement);
        }
        try {
            string = "";
            string = object instanceof Date ? dateutil.formatDate((Date)object, "MM-dd-yyyy HH:mm:ss") : objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            preparedStatement.setObject(1, string);
            for (n2 = 0; n2 < this.arKeyFields.length; ++n2) {
                preparedStatement.setObject(n2 + 2, tValuesObj.KeyValues[n2]);
            }
            n2 = preparedStatement.executeUpdate();
            this.clearBuffer();
            this.Modified = true;
        }
        catch (Exception exception) {
            MainWin.appendToLog("TOdbcDatabase", "putField", Thread.currentThread(), exception, 4, "Error in putField");
        }
        return 1;
    }

    @Override
    public synchronized Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord == null) {
            return null;
        }
        Object object = null;
        if (tDriverStructRecord.IsToken) {
            String string = TMainWin.Application.getTokenValue(tDriverStructRecord.ID);
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, 0);
            return object;
        }
        String string = Integer.toString(n) + "|" + tDriverStructRecord.ID;
        object = this.hashedFields.get(string);
        if (object != null) {
            return object;
        }
        if (!tDriverStructRecord.IsVirtual && !tDriverStructRecord.IsCalculated) {
            Object object2;
            if (this.isKeyField(tDriverStructRecord.ID)) {
                TValuesObj tValuesObj = (TValuesObj)this.KeyValuesColl.get(n);
                object = tDriverStructRecord.FieldType == 10 || tDriverStructRecord.FieldType == 13 || tDriverStructRecord.FieldType == 18 || tDriverStructRecord.FieldType == 21 ? (tValuesObj.getKeyValue(tDriverStructRecord.ID).length() > 0 ? dateutil.parseDate(tValuesObj.getKeyValue(tDriverStructRecord.ID), "yyyy-MM-dd HH:mm:ss") : new Date(0L)) : objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, tValuesObj.getKeyValue(tDriverStructRecord.ID), n);
                return object;
            }
            PreparedStatement preparedStatement = (PreparedStatement)this.hashPrepGetStmt.get(tDriverStructRecord.ID);
            if (preparedStatement == null) {
                object2 = "";
                object2 = this.arKeyFields.length == 0 ? (this.DriverType == 37 ? "select \"" + tDriverStructRecord.ID + "\" from " + this.dbTable + this.sWhere + " order by " + this.sOrderBy : (this.DriverType == 30 ? "select " + tDriverStructRecord.ID + " from " + this.dbTable + this.sWhere + " order by " + this.sOrderBy : "select \"" + tDriverStructRecord.ID + "\" from " + "\"" + this.dbTable + "\"" + this.sWhere + " order by " + this.sOrderBy)) : (this.DriverType == 37 ? "select " + this.sKeyFields + "," + "\"" + tDriverStructRecord.ID + "\"" + " from " + this.dbTable + this.sWhere + " order by " + this.sKeyFields : (this.DriverType == 30 ? "select " + charutil.removeChar(this.sKeyFields, '\"') + "," + tDriverStructRecord.ID + " from " + this.dbTable + this.sWhere + " order by " + this.sKeyFields : "select " + this.sKeyFields + "," + "\"" + tDriverStructRecord.ID + "\"" + " from " + "\"" + this.dbTable + "\"" + this.sWhere + " order by " + this.sKeyFields));
                if (this.DriverType == 30) {
                    object2 = charutil.replaceChar((String)object2, '\"', '\'');
                }
                preparedStatement = this.SqlDb.prepareStatement((String)object2);
                this.hashPrepGetStmt.put(tDriverStructRecord.ID, preparedStatement);
            }
            try {
                object2 = preparedStatement.executeQuery();
                if (object2 != null) {
                    Object object3;
                    int n2 = object2.getMetaData().getColumnCount();
                    int n3 = 0;
                    while (object2.next()) {
                        object3 = new TValuesObj((ResultSet)object2, n2, n3);
                        ++n3;
                        int n4 = Collections.binarySearch(this.KeyValuesColl, object3);
                        if (n4 >= 0) {
                            Object object4 = null;
                            if (tDriverStructRecord.FieldType == 10 || tDriverStructRecord.FieldType == 13 || tDriverStructRecord.FieldType == 18 || tDriverStructRecord.FieldType == 21) {
                                if (((TValuesObj)object3).FieldValue.length() > 0) {
                                    object4 = dateutil.parseDate(((TValuesObj)object3).FieldValue, "yyyy-MM-dd HH:mm:ss");
                                }
                                if (object4 == null) {
                                    object4 = new Date(0L);
                                }
                            } else {
                                object4 = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, ((TValuesObj)object3).FieldValue, n4);
                            }
                            this.hashedFields.put(Integer.toString(n4) + "|" + tDriverStructRecord.ID, object4);
                            if (n4 != n) continue;
                            object = object4;
                            continue;
                        }
                        System.out.println("Error in getField.  Cannot find record for " + ((TValuesObj)object3).toString() + " Collection size: " + this.KeyValuesColl.size() + " Index=" + n4);
                        for (int i = 0; i < this.KeyValuesColl.size(); ++i) {
                            System.out.println("\t" + i + "\t" + ((TValuesObj)this.KeyValuesColl.get(i)).toString());
                        }
                    }
                    if (object == null) {
                        object3 = "Error reading odbc field in table:" + this.dbTable + " ID:" + tDriverStructRecord.ID + " Record=" + n;
                        MainWin.appendToLog("TOdbcDatabase", "getField", Thread.currentThread(), null, 4, (String)object3);
                    }
                    return object;
                }
            }
            catch (Exception exception) {
                MainWin.appendToLog("TOdbcDatabase", "getField", Thread.currentThread(), exception, 4, "Error in SQL getField in " + this.dbTable);
            }
            return null;
        }
        if (tDriverStructRecord.IsCalculated && (object = this.calculateField(tDriverStructRecord, n)) == null) {
            object = objectutil.getErrorValue(tDriverStructRecord.FieldType);
            System.out.println("********* set dbase field to " + object.toString() + " for " + tDriverStructRecord.ID + " R=" + n);
        }
        if (this.BufferOn && object != null && !tDriverStructRecord.NoBuffer) {
            if (memory.getAvailableMemory() < 10000000L) {
                this.hashedFields.clear();
            } else {
                this.hashedFields.put(string, object);
            }
        }
        return object;
    }

    @Override
    public synchronized void packRecords(StringBuilder stringBuilder) {
        if (this.Mode != 1) {
            MainWin.appendToLog("TOdbcDatabase", "putField", Thread.currentThread(), null, 4, "Cannot pack records in database named " + this.dbName + " opened in read-only mode");
            return;
        }
        int n = 0;
        while (n < this.KeyValuesColl.size()) {
            if (this.isDeleted(n, stringBuilder)) {
                TValuesObj tValuesObj = (TValuesObj)this.KeyValuesColl.get(n);
                this.SqlDb.deleteRecord(this.dbTable, this.arKeyFields, tValuesObj.getKeyValues());
                this.KeyValuesColl.remove(n);
                continue;
            }
            ++n;
        }
    }

    private class TValuesObj
    implements Comparable {
        String[] KeyValues;
        String FieldValue;
        int dbIndex;

        TValuesObj(ResultSet resultSet, int n, int n2) {
            this.KeyValues = new String[TOdbcDatabase.this.arKeyFields.length];
            this.FieldValue = "";
            this.dbIndex = -1;
            this.dbIndex = n2;
            try {
                if (!TOdbcDatabase.this.keysDefined()) {
                    this.FieldValue = resultSet.getString(1);
                    if (this.FieldValue == null) {
                        this.FieldValue = "";
                    }
                } else {
                    int n3;
                    for (n3 = 0; n3 < TOdbcDatabase.this.arKeyFields.length; ++n3) {
                        this.KeyValues[n3] = resultSet.getString(n3 + 1);
                        if (this.KeyValues[n3] != null) continue;
                        this.KeyValues[n3] = "";
                    }
                    if (n > TOdbcDatabase.this.arKeyFields.length) {
                        this.FieldValue = resultSet.getString(TOdbcDatabase.this.arKeyFields.length + 1);
                        if (this.FieldValue == null) {
                            this.FieldValue = "";
                        }
                    }
                    if (TOdbcDatabase.this.DriverType == 30) {
                        n3 = TOdbcDatabase.this.arKeyFields.length + 2;
                        while (n3 <= n) {
                            System.out.println("Additional value (" + n3 + ")=" + resultSet.getString(n3));
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error initializing TValuesObj: " + exception.toString());
            }
        }

        TValuesObj() {
            this.KeyValues = new String[TOdbcDatabase.this.arKeyFields.length];
            this.FieldValue = "";
            this.dbIndex = -1;
        }

        public String getKeyValue(String string) {
            for (int i = 0; i < TOdbcDatabase.this.arKeyFields.length; ++i) {
                if (!TOdbcDatabase.this.arKeyFields[i].equalsIgnoreCase(string)) continue;
                return this.KeyValues[i];
            }
            return null;
        }

        public String[] getKeyValues() {
            return this.KeyValues;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Index: " + this.dbIndex + "\t");
            stringBuilder.append("Keys: ");
            for (int i = 0; i < TOdbcDatabase.this.arKeyFields.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.KeyValues[i]);
            }
            stringBuilder.append(" FieldValue: " + this.FieldValue);
            return stringBuilder.toString();
        }

        public int compareTo(Object object) {
            if (!TOdbcDatabase.this.keysDefined()) {
                if (this.dbIndex < ((TValuesObj)object).dbIndex) {
                    return -1;
                }
                if (this.dbIndex > ((TValuesObj)object).dbIndex) {
                    return 1;
                }
                return 0;
            }
            for (int i = 0; i < TOdbcDatabase.this.arKeyFields.length; ++i) {
                int n = this.KeyValues[i].compareToIgnoreCase(((TValuesObj)object).KeyValues[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }
}

