/*
 * Decompiled with CFR 0.152.
 */
package extensions;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.InputStream;
import java.lang.reflect.Method;
import resources.TApplication;
import utility.charutil;
import utility.dosutil;

public class TClassLoader
extends ClassLoader {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTClassLoader");
    private TApplication Application = TMainWin.Application;

    public TClassLoader() {
        super(Aspect.MainWin.getClass().getClassLoader());
    }

    protected Class findClass(String string) {
        Object object;
        try {
            object = super.findClass(string);
            if (object != null) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = null;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = dosutil.splitPath(string);
        String string2 = stringArray[2];
        if (this.Debug) {
            MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 10, "Loading class: " + string);
        }
        if ((object = this.getClass().getResourceAsStream(string)) != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(stringArray[1] + stringArray[2]);
            charutil.replace_char(stringBuilder, stringBuilder, '/', '.');
            charutil.replace_char(stringBuilder, stringBuilder, '\\', '.');
            if (stringBuilder.charAt(0) == '.') {
                stringBuilder.deleteCharAt(0);
            }
            string2 = stringBuilder.toString();
            if (this.Debug) {
                MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 10, "Class found in program archive.");
            }
        }
        if (object == null) {
            stringBuilder.setLength(0);
            stringBuilder.append("/");
            stringBuilder.append(string);
            charutil.replace_char(stringBuilder, stringBuilder, '.', '/');
            stringBuilder.append(".class");
            if (this.Debug) {
                MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 10, "Trying to locate class in resource as " + stringBuilder.toString());
            }
            if ((object = this.getClass().getResourceAsStream(stringBuilder.toString())) != null) {
                string2 = string;
                if (this.Debug) {
                    MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 10, "Class found in program archive.");
                }
            }
        }
        if (object == null && (object = dosutil.getInputStream(string)) != null && this.Debug) {
            MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 10, "Class found using absolute file name.");
        }
        if (object == null) {
            dosutil.get_current_dir(stringBuilder);
            dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
            stringBuilder.append(string);
            object = dosutil.getInputStream(stringBuilder.toString());
            if (object != null && this.Debug) {
                MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 10, "Class found in executable directory.");
            }
        }
        if (object == null) {
            this.Application.getTokenValue(stringBuilder, "{homedir}");
            dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
            stringBuilder.append(string);
            object = dosutil.getInputStream(stringBuilder.toString());
            if (object != null && this.Debug) {
                MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 10, "Class found in home directory.");
            }
        }
        if (object != null) {
            byte[] byArray = new byte[2048];
            byte[] byArray2 = new byte[]{};
            int n = 0;
            try {
                Class<?> clazz;
                int n2;
                do {
                    if ((n2 = ((InputStream)object).read(byArray)) <= 0) continue;
                    byArray2 = (byte[])charutil.arrayGrow(byArray2, byArray2.length + n2);
                    System.arraycopy(byArray, 0, byArray2, n, n2);
                    n += n2;
                } while (n2 > 0);
                if (this.Debug) {
                    MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 3, "calling defineClass with ClassName=" + string2);
                }
                if ((clazz = this.defineClass(string2, byArray2, 0, n, Aspect.MainWin.getClass().getProtectionDomain())) != null) {
                    return clazz;
                }
            }
            catch (Exception exception) {
                MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), exception, 4, "Error loading class: " + string);
            }
        }
        MainWin.appendToLog("TClassLoader", "findClass", Thread.currentThread(), null, 4, "Class named '" + string + "' was not found.");
        return null;
    }

    public Class loadClass(String string) {
        try {
            return super.loadClass(string);
        }
        catch (Exception exception) {
            System.out.println("TClassLoader.loadClass(): " + exception.toString());
            return null;
        }
    }

    public Object executeMethod(Class clazz, String string) {
        Object object = null;
        try {
            Method method = clazz.getDeclaredMethod(string, new Class[0]);
            object = method.invoke(clazz.newInstance(), new Object[0]);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
        return object;
    }

    public Object executeMethod(Class clazz, String string, String[] stringArray) {
        Object object = null;
        Class[] classArray = new Class[]{String[].class};
        Object[] objectArray = new Object[]{stringArray};
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            object = method.invoke(clazz.newInstance(), objectArray);
        }
        catch (Exception exception) {
            MainWin.appendToLog("TClassLoader", "execMethod", Thread.currentThread(), null, 4, exception.toString() + " Class=" + clazz + " Method=" + string);
            return null;
        }
        return object;
    }
}

