/*
 * Decompiled with CFR 0.152.
 */
package investing.DataSeries;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import investing.DataSeries.DataSeriesInfo;
import investing.DataSeries.TCorrelationResult;
import investing.DataSeries.TDataSeriesObj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.statistics;

public class DataSeriesUtilityOriginal {
    private static TMainWin MainWin = Aspect.MainWin;
    private static ArrayList LastFredSeriesValues = null;
    private static String LastFredSeriesID = "";
    private static long LastFredSeriesDt1 = 0L;
    private static long LastFredSeriesDt2 = 0L;
    private static ArrayList LastAlphaVantageSeriesValues = null;
    private static String LastAlphaVantageSeriesID = "";
    private static long LastAlphaVantageSeriesDt1 = 0L;
    private static long LastAlphaVantageSeriesDt2 = 0L;

    public static ArrayList getDataSeriesValues(String string) {
        Date date = new Date(0L);
        Date date2 = new Date();
        return DataSeriesUtilityOriginal.getDataSeriesValues(string, date, date2, true);
    }

    public static ArrayList getDataSeriesValues(String string, Date date, Date date2) {
        return DataSeriesUtilityOriginal.getDataSeriesValues(string, date, date2, false);
    }

    public static ArrayList getDataSeriesValues(String string, Date date, Date date2, boolean bl) {
        if (DataSeriesInfo.isFredDataSeries(string)) {
            return DataSeriesUtilityOriginal.getFredDataSeriesValues(string, date, date2, bl);
        }
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            return DataSeriesUtilityOriginal.getAlphaVantageDataSeriesValues(string, date, date2, bl);
        }
        DataSeriesInfo.FredSeriesID = "";
        DataSeriesInfo.AlphaVantageSeriesID = "";
        if (DataSeriesInfo.isFredDataSeries(string, true)) {
            return DataSeriesUtilityOriginal.getFredDataSeriesValues(string, date, date2, bl);
        }
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            return DataSeriesUtilityOriginal.getAlphaVantageDataSeriesValues(string, date, date2, bl);
        }
        System.out.println("Series is neither Fred or AlphaVantage: [" + string + "]");
        return null;
    }

    public static ArrayList addMissingDates(ArrayList arrayList) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        Date date = new Date();
        Date date2 = new Date();
        for (int i = 1; i < arrayList.size(); ++i) {
            long l = ((TDataSeriesObj)arrayList.get((int)(i - 1))).Date;
            long l2 = ((TDataSeriesObj)arrayList.get((int)i)).Date;
            date.setTime(l);
            date2.setTime(l2);
            gregorianCalendar.setTime(date);
            gregorianCalendar.set(11, 0);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            gregorianCalendar.add(5, 1);
            gregorianCalendar2.setTime(date2);
            gregorianCalendar2.set(11, 0);
            gregorianCalendar2.set(12, 0);
            gregorianCalendar2.set(13, 0);
            gregorianCalendar2.set(14, 0);
            if (gregorianCalendar.getTime().getTime() == gregorianCalendar2.getTime().getTime()) continue;
            TDataSeriesObj tDataSeriesObj = (TDataSeriesObj)arrayList.get(i - 1);
            TDataSeriesObj tDataSeriesObj2 = new TDataSeriesObj(gregorianCalendar.getTime(), tDataSeriesObj.Open, tDataSeriesObj.High, tDataSeriesObj.Low, tDataSeriesObj.Close, tDataSeriesObj.Adjusted_Close, 0L, 0.0, 0.0);
            arrayList.add(i, tDataSeriesObj2);
            tDataSeriesObj2.IsAddedDate = true;
        }
        return arrayList;
    }

    public static ArrayList addDatesToCurrent(ArrayList arrayList) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date());
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        gregorianCalendar.add(5, -1);
        if (arrayList.size() == 0) {
            return arrayList;
        }
        TDataSeriesObj tDataSeriesObj = (TDataSeriesObj)arrayList.get(arrayList.size() - 1);
        long l = tDataSeriesObj.Date;
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(new Date(l));
        gregorianCalendar2.set(11, 0);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        gregorianCalendar2.set(14, 0);
        while (gregorianCalendar2.getTime().getTime() < gregorianCalendar.getTime().getTime()) {
            gregorianCalendar2.add(5, 1);
            arrayList.add(new TDataSeriesObj(gregorianCalendar2.getTime(), tDataSeriesObj));
        }
        return arrayList;
    }

    public static ArrayList getFredDataSeriesValues(String string, Date date, Date date2, boolean bl) {
        String string2;
        if (LastFredSeriesID.equalsIgnoreCase(string) && date.getTime() == LastFredSeriesDt1 && date2.getTime() == LastFredSeriesDt2) {
            return LastFredSeriesValues;
        }
        ArrayList<TDataSeriesObj> arrayList = new ArrayList<TDataSeriesObj>();
        String string3 = DataSeriesInfo.getFredFilename(string);
        if (!dosutil.fileExists(string3)) {
            if (!bl) {
                return arrayList;
            }
            string2 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Fred_Time_Series,\"SeriesID=" + string + "\",false)");
            System.out.println("getFredDataSeriesValues updated1 series: " + string);
        } else if (bl && dateutil.date(dosutil.fileModified(string3)).getTime() < dateutil.date(date2).getTime()) {
            string2 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Fred_Time_Series,\"SeriesID=" + string + "\",false)");
            System.out.println("getFredDataSeriesValues updated1 series: " + string);
            System.out.println("Modified1=" + dateutil.formatDate(dosutil.fileModified(string3), "MM-dd-yyyy HH:mm:ss") + " Modified2=" + dateutil.formatDate(date2, "MM-dd-yyyy HH:mm:ss"));
        }
        string2 = TAsciiInput.getEntireFile(string3);
        if (!string2.endsWith("\r\n")) {
            string2 = string2 + "\r\n";
        }
        int n = string2.indexOf(10) + 1;
        int n2 = string2.indexOf(10, n);
        boolean bl2 = false;
        double d = 0.0;
        int n3 = 0;
        while (!bl2 && n2 > 0) {
            String string4 = string2.substring(n, n2 - 2);
            int n4 = string4.indexOf(9);
            if (n4 >= 0) {
                String string5;
                int n5 = string4.indexOf(9, n4 + 1);
                if (n5 > 0 && (string5 = string4.substring(0, n4)).length() == 10) {
                    Date date3 = dateutil.parseDate(string5, "yyyy-MM-dd");
                    if (date3.getTime() >= date.getTime() && date3.getTime() <= date2.getTime()) {
                        try {
                            String string6 = string4.substring(n4 + 1, n5).trim();
                            double d2 = d;
                            if (string6.length() > 0 && !string6.equals(".")) {
                                d = d2 = Double.parseDouble(string6);
                            }
                            arrayList.add(new TDataSeriesObj(date3, d2));
                        }
                        catch (Exception exception) {}
                    } else if (date3.getTime() > date2.getTime()) {
                        bl2 = true;
                    }
                }
                ++n3;
            }
            n = n2 + 1;
            n2 = string2.indexOf(10, n2 + 1);
        }
        LastFredSeriesValues = arrayList;
        LastFredSeriesID = string;
        LastFredSeriesDt1 = date.getTime();
        LastFredSeriesDt2 = date2.getTime();
        return arrayList;
    }

    public static ArrayList getAlphaVantageDataSeriesValues(String string, Date date, Date date2, boolean bl) {
        String string2;
        if (LastAlphaVantageSeriesID.equalsIgnoreCase(string) && date.getTime() == LastAlphaVantageSeriesDt1 && date2.getTime() == LastAlphaVantageSeriesDt2) {
            return LastAlphaVantageSeriesValues;
        }
        ArrayList<TDataSeriesObj> arrayList = new ArrayList<TDataSeriesObj>();
        String string3 = DataSeriesInfo.getAlphaVantageFilename(string);
        if (!dosutil.fileExists(string3)) {
            if (!bl) {
                return arrayList;
            }
            string2 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Alpha_Vantage_Stock_Quote,\"SeriesID=" + string + "\",false)");
            System.out.println("getAlphaVantageDataSeriesValues updated series: " + string);
        } else if (bl && dateutil.date(dosutil.fileModified(string3)).getTime() < dateutil.date(date2).getTime()) {
            string2 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Alpha_Vantage_Stock_Quote,\"SeriesID=" + string + "\",false)");
            System.out.println("getAlphaVantageDataSeriesValues updated series: " + string);
        }
        string2 = TAsciiInput.getEntireFile(string3);
        if (!string2.endsWith("\r\n")) {
            string2 = string2 + "\r\n";
        }
        int n = string2.indexOf(10) + 1;
        int n2 = string2.indexOf(10, n);
        boolean bl2 = false;
        double d = 0.0;
        int n3 = 0;
        int[] nArray = new int[8];
        while (!bl2 && n2 > 0) {
            String string4 = string2.substring(n, n2 - 2);
            nArray[0] = string4.indexOf(44);
            for (int i = 1; i < 8; ++i) {
                nArray[i] = string4.indexOf(44, nArray[i - 1] + 1);
            }
            if (nArray[7] > 0) {
                Date date3;
                String string5 = string4.substring(0, nArray[0]);
                if (string5.charAt(4) == '-' && (date3 = dateutil.parseDate(string4.substring(0, nArray[0]), "yyyy-MM-dd")).getTime() >= date.getTime() && date3.getTime() <= date2.getTime()) {
                    double d2 = Double.parseDouble(string4.substring(nArray[0] + 1, nArray[1]));
                    double d3 = Double.parseDouble(string4.substring(nArray[1] + 1, nArray[2]));
                    double d4 = Double.parseDouble(string4.substring(nArray[2] + 1, nArray[3]));
                    double d5 = Double.parseDouble(string4.substring(nArray[3] + 1, nArray[4]));
                    double d6 = Double.parseDouble(string4.substring(nArray[4] + 1, nArray[5]));
                    long l = Long.parseLong(string4.substring(nArray[5] + 1, nArray[6]));
                    double d7 = Double.parseDouble(string4.substring(nArray[6] + 1, nArray[7]));
                    double d8 = 0.0;
                    arrayList.add(0, new TDataSeriesObj(date3, d2, d3, d4, d5, d6, l, d7, d8));
                }
                ++n3;
            }
            n = n2 + 1;
            n2 = string2.indexOf(10, n2 + 1);
        }
        LastAlphaVantageSeriesValues = arrayList;
        LastAlphaVantageSeriesID = string;
        LastAlphaVantageSeriesDt1 = date.getTime();
        LastAlphaVantageSeriesDt2 = date2.getTime();
        return arrayList;
    }

    public static ArrayList getCorrelations(String string, String[] stringArray, String string2, Date date, Date date2, int n, int n2, boolean bl, int n3, double d, int n4) {
        Object object;
        Comparable<Date> comparable;
        Cloneable cloneable;
        ArrayList arrayList = DataSeriesUtilityOriginal.getDataSeriesValues(string, date, date2);
        if (n4 != 0) {
            arrayList = DataSeriesUtilityOriginal.addMissingDates(arrayList);
        }
        ArrayList<TDataSeriesObj> arrayList2 = new ArrayList<TDataSeriesObj>();
        Hashtable<Long, Date> hashtable = null;
        if (string2.trim().length() > 1) {
            cloneable = DataSeriesUtilityOriginal.getDataSeriesValues(string2, date, new Date());
            if (cloneable != null) {
                cloneable = DataSeriesUtilityOriginal.addMissingDates((ArrayList)cloneable);
                System.out.println("getCorrelations got index series for " + string2 + " Count=" + ((ArrayList)cloneable).size());
                hashtable = new Hashtable<Long, Date>();
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    comparable = (TDataSeriesObj)((ArrayList)cloneable).get(i);
                    hashtable.put(new Long(((TDataSeriesObj)comparable).Date), (Date)comparable);
                }
            } else {
                System.out.println("getCorrelations: Unable to get series for index: " + string2);
            }
        }
        cloneable = new GregorianCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        comparable = new Date();
        Date date3 = new Date();
        long l = 0L;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray.length > 100 && (i + 1) % 100 == 0) {
                System.out.println("getCorrelations " + (i + 1) + " of " + stringArray.length + " result count=" + arrayList2.size());
            }
            if (!string.equals(stringArray[i]) && stringArray[i].trim().length() > 0) {
                ArrayList arrayList3 = DataSeriesUtilityOriginal.getDataSeriesValues(stringArray[i], date, date2);
                if (arrayList3.size() > 0) {
                    l = ((TDataSeriesObj)arrayList3.get((int)0)).Date;
                }
                if (arrayList3 != null) {
                    Comparable comparable2;
                    arrayList3 = DataSeriesUtilityOriginal.addMissingDates(arrayList3);
                    double[] dArray = new double[arrayList.size()];
                    object = new double[arrayList.size()];
                    int n5 = 0;
                    long l2 = 0L;
                    int n6 = 0;
                    for (int j = 0; j < arrayList.size() && n6 < arrayList3.size(); ++j) {
                        TDataSeriesObj tDataSeriesObj = (TDataSeriesObj)arrayList.get(j);
                        comparable2 = (TDataSeriesObj)arrayList3.get(n6);
                        if (Math.abs(tDataSeriesObj.Date - comparable2.Date) <= 14400000L) {
                            int n7 = n6 - n3;
                            if (n7 >= 0) {
                                Comparable<Double> comparable3;
                                Number number;
                                if (hashtable == null) {
                                    if (n4 == 0) {
                                        dArray[n5] = tDataSeriesObj.Close;
                                        comparable2 = (TDataSeriesObj)arrayList3.get(n7);
                                        object[n5] = comparable2.Close;
                                        if (l2 == 0L) {
                                            l2 = tDataSeriesObj.Date;
                                        }
                                        ++n5;
                                    } else {
                                        number = DataSeriesUtilityOriginal.getCAGR(arrayList, j, n4);
                                        if (number != null && (comparable3 = DataSeriesUtilityOriginal.getCAGR(arrayList3, n7, n4)) != null) {
                                            dArray[n5] = (Double)number;
                                            object[n5] = (Double)comparable3;
                                            if (l2 == 0L) {
                                                l2 = tDataSeriesObj.Date;
                                            }
                                            ++n5;
                                        }
                                    }
                                } else {
                                    number = new Long(tDataSeriesObj.Date);
                                    if (hashtable.containsKey(number)) {
                                        comparable3 = (TDataSeriesObj)hashtable.get(number);
                                        double d2 = ((TDataSeriesObj)comparable3).Close;
                                        if (d2 != 0.0) {
                                            if (n4 == 0) {
                                                dArray[n5] = tDataSeriesObj.Close / d2;
                                                comparable2 = (TDataSeriesObj)arrayList3.get(n7);
                                                object[n5] = comparable2.Close / d2;
                                                if (l2 == 0L) {
                                                    l2 = tDataSeriesObj.Date;
                                                }
                                                ++n5;
                                            } else {
                                                Double d3;
                                                Double d4 = DataSeriesUtilityOriginal.getCAGR(arrayList, j, n4, d2);
                                                if (d4 != null && (d3 = DataSeriesUtilityOriginal.getCAGR(arrayList3, n7, n4, d2)) != null) {
                                                    dArray[n5] = d4;
                                                    object[n5] = d3;
                                                    if (l2 == 0L) {
                                                        l2 = tDataSeriesObj.Date;
                                                    }
                                                    ++n5;
                                                }
                                            }
                                        }
                                    } else {
                                        System.out.println("getCorrelations hashIndex does not contain key: arCompare=" + stringArray[i] + " " + tDataSeriesObj.Date + " " + new Date(tDataSeriesObj.Date));
                                    }
                                }
                            }
                        } else if (tDataSeriesObj.Date > l) {
                            // empty if block
                        }
                        if (j >= arrayList.size() - 1) continue;
                        tDataSeriesObj = (TDataSeriesObj)arrayList.get(j + 1);
                        while (comparable2.Date < tDataSeriesObj.Date && n6 < arrayList3.size()) {
                            if (++n6 >= arrayList3.size()) continue;
                            comparable2 = (TDataSeriesObj)arrayList3.get(n6);
                        }
                    }
                    double d5 = 0.0;
                    if (n5 < 10) {
                        System.out.println("Count=" + n5 + " _CompareTo[i]=" + stringArray[i] + " arSeries,size=" + arrayList.size());
                    }
                    if (n5 <= 0) continue;
                    d5 = statistics.correlation(dArray, (double[])object, n5, bl);
                    if (Double.isNaN(d5)) {
                        d5 = 0.0;
                    }
                    if (!(Math.abs(d5) >= d)) continue;
                    comparable2 = new TCorrelationResult(stringArray[i], d5, n5, l2);
                    String string3 = stringArray[i].toUpperCase();
                    int n8 = Collections.binarySearch(arrayList2, comparable2);
                    arrayList2.add(Math.abs(n8 + 1), (TDataSeriesObj)comparable2);
                    continue;
                }
                System.out.println("getCorrelations arCompare is null for " + stringArray[i]);
                continue;
            }
            System.out.println("getCorrelations arCompare is length is 0 for i=" + i);
        }
        if (n2 <= 0) {
            return arrayList2;
        }
        ArrayList<TCorrelationResult> arrayList4 = new ArrayList<TCorrelationResult>();
        int n9 = 0;
        if (n >= 0) {
            for (int i = 0; i < arrayList2.size() && (n9 < n2 || n2 < 0); ++n9, ++i) {
                object = (TCorrelationResult)arrayList2.get(i);
                if (!(((TCorrelationResult)object).Correlation > 0.0)) break;
                arrayList4.add((TCorrelationResult)object);
            }
        }
        n9 = 0;
        if (n <= 0) {
            int n10;
            for (int i = n10 = Math.max(0, arrayList2.size() - n2); i < arrayList2.size() && (n9 < n2 || n2 < 0); ++n9, ++i) {
                TCorrelationResult tCorrelationResult = (TCorrelationResult)arrayList2.get(i);
                if (!(tCorrelationResult.Correlation < 0.0)) break;
                arrayList4.add(tCorrelationResult);
            }
        }
        return arrayList4;
    }

    public static void getValueRatios(TAspectDriver tAspectDriver, String string, String string2) {
        String[] stringArray;
        System.out.println("getValueRatios SeriesID=" + string + " CompareID=" + string2);
        String string3 = (String)TFormulaEvaluator.eval("getCollection(Investing_Value_Comparison_Selected_Series_IDs_by_ID,true,\"coll=getValueComparisonSeriesIDs|CompareID=" + string2 + "\",\"\",\",\",keys)");
        System.out.println("SeriesIDs=" + string3);
        if (string3.toUpperCase().indexOf(string.toUpperCase()) < 0) {
            string3 = string + "," + string3;
        }
        if ((stringArray = charutil.getSubStringArray(string3, ',', true)) == null) {
            MainWin.appendToLog("DataSeriesUtility", "getValueRatios", Thread.currentThread(), null, 4, "Error: getValueRatios: No Series ID's to compare");
            return;
        }
        Date date = dateutil.parseDate("01-01-1901", "MM-dd-yyyy");
        Date date2 = new Date();
        ArrayList arrayList = DataSeriesUtilityOriginal.getDataSeriesValues(string, date, date2);
        DataSeriesUtilityOriginal.addMissingDates(arrayList);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            int n;
            int n2;
            int n3;
            long l;
            Object object2;
            boolean bl = false;
            long l2 = DataSeriesInfo.getFileModified(stringArray[i]);
            if (l2 > 0L) {
                object2 = TMainWin.Application.getTokenValue("Temporary_Files") + "ratio_" + string + "_" + stringArray[i] + "_0.csv";
                if (dosutil.fileExists((String)object2) && (l = dosutil.fileModified((String)object2).getTime()) > l2) {
                    bl = true;
                }
            }
            object2 = DataSeriesUtilityOriginal.getDataSeriesValues(stringArray[i], date, date2);
            DataSeriesUtilityOriginal.addMissingDates((ArrayList)object2);
            l = ((TDataSeriesObj)arrayList.get((int)0)).Date;
            long l3 = ((TDataSeriesObj)((ArrayList)object2).get((int)0)).Date;
            long l4 = Math.max(l, l3);
            long l5 = dateutil.parseDate("01-01-1990", "MM-dd-yyyy").getTime();
            l4 = Math.max(l4, l5);
            for (n3 = 0; n3 < arrayList.size() && ((TDataSeriesObj)arrayList.get((int)n3)).Date < l4; ++n3) {
            }
            for (n2 = 0; n2 < ((ArrayList)object2).size() && ((TDataSeriesObj)((ArrayList)object2).get((int)n2)).Date < l4; ++n2) {
            }
            int n4 = arrayList.size() - n3;
            int n5 = ((ArrayList)object2).size() - n2;
            int n6 = n4;
            double[] dArray = new double[n6];
            double[] dArray2 = new double[n6];
            StringBuilder[] stringBuilderArray = new StringBuilder[100];
            for (n = 0; n < stringBuilderArray.length; ++n) {
                stringBuilderArray[n] = new StringBuilder();
            }
            n = stringArray[i].equalsIgnoreCase(string) ? 1 : 0;
            int n7 = 0;
            double d = 0.0;
            Date date3 = new Date();
            for (int j = 0; j < n6; ++j) {
                object = (TDataSeriesObj)arrayList.get(n3);
                double d2 = ((TDataSeriesObj)object).Adjusted_Close;
                if (n != 0) {
                    d = 1.0;
                } else if (n2 < ((ArrayList)object2).size()) {
                    d = ((TDataSeriesObj)((ArrayList)object2).get((int)n2)).Adjusted_Close;
                }
                double d3 = d;
                if (d3 != 0.0) {
                    dArray[j] = d2 / d3;
                }
                if (j > 0) {
                    int n8 = (int)Math.floor((double)j / 365.0) + 1;
                    n7 = Math.max(n7, n8);
                    if (!bl) {
                        for (int k = 0; k < n8; ++k) {
                            int n9 = Math.max(j - (k + 1) * 365, 0);
                            int n10 = j;
                            int n11 = n10 - n9 + 1;
                            System.arraycopy(dArray, n9, dArray2, 0, n11);
                            double d4 = statistics.mean(dArray2, n11);
                            double d5 = statistics.stddev(dArray2, n11);
                            if (k >= stringBuilderArray.length) continue;
                            date3.setTime(((TDataSeriesObj)object).Date);
                            stringBuilderArray[k].append(dateutil.formatDate(date3, "MM-dd-yyyy"));
                            stringBuilderArray[k].append(",");
                            stringBuilderArray[k].append(Double.toString(dArray[j]));
                            stringBuilderArray[k].append(",");
                            stringBuilderArray[k].append(Double.toString(d4));
                            stringBuilderArray[k].append(",");
                            stringBuilderArray[k].append(Double.toString(d5));
                            stringBuilderArray[k].append("\r\n");
                        }
                    }
                }
                ++n3;
                ++n2;
                if (bl || j % 1000 != 0) continue;
                System.out.println("Calculating ratio to " + stringArray[i] + " " + j + " of " + n6);
            }
            String string4 = i == 0 ? "Primary" : stringArray[i];
            object = "Compare_Adjusted_Close_" + stringArray[i];
            String string5 = "Compare Adjusted Close " + string4;
            tAspectDriver.addField((String)object, "Description=" + string5 + ",FieldType=Number,FormatPattern=###.00");
            String string6 = "lookup(Investing_Consolidated_Adjusted_Close_by_Date_Number,dateNumber(Date),0,\"coll=ConsolidatedDataSeriesFieldValue|FieldID=Adjusted_Close|SeriesID=" + stringArray[i] + "\")";
            tAspectDriver.setFieldAttributes((String)object, "\"Formula=" + string6 + "\"");
            object = "Compare_Adjusted_Close_" + stringArray[i] + "NormalizedX4";
            string5 = "Compare Adjusted Close " + string4 + " (Normalized*4)";
            tAspectDriver.addField((String)object, "Description=" + string5 + ",FieldType=Number,FormatPattern=###.00");
            string6 = "normalize(Compare_Adjusted_Close_" + stringArray[i] + ",false)*4";
            tAspectDriver.setFieldAttributes((String)object, "\"Formula=" + string6 + "\"");
            string4 = i == 0 ? "Dollar" : stringArray[i];
            for (int j = 0; j < n7; ++j) {
                String string7 = TMainWin.Application.getTokenValue("Temporary_Files") + "ratio_" + string + "_" + stringArray[i] + "_" + j + ".csv";
                if (!bl) {
                    TAsciiOutput.writeContent(string7, stringBuilderArray[j].toString());
                }
                object = "Compare_" + i + "_" + j + "_Ratio";
                string5 = "Compare " + string4 + " " + (j + 1) + " Ratio";
                tAspectDriver.addField((String)object, "Description=" + string5 + ",FieldType=Number,FormatPattern=###.000000000");
                string6 = "lookup(Investing_Value_Comparison_Results_Ratio,Date_Text,0,\"Filename=" + string7 + "\")";
                tAspectDriver.setFieldAttributes((String)object, "\"Formula=" + string6 + "\"");
                object = "Compare_" + i + "_" + j + "_Ratio_Average";
                string5 = "Compare " + string4 + " " + (j + 1) + " Ratio Average";
                tAspectDriver.addField((String)object, "Description=" + string5 + ",FieldType=Number,FormatPattern=###.000000000");
                string6 = "lookup(Investing_Value_Comparison_Results_Ratio_Average,Date_Text,0,\"Filename=" + string7 + "\")";
                tAspectDriver.setFieldAttributes((String)object, "\"Formula=" + string6 + "\"");
                object = "Compare_" + i + "_" + j + "_Ratio_StdDev";
                string5 = "Compare " + string4 + " " + (j + 1) + " Ratio StdDev";
                tAspectDriver.addField((String)object, "Description=" + string5 + ",FieldType=Number,FormatPattern=###.000000000");
                string6 = "lookup(Investing_Value_Comparison_Results_Ratio_StdDev,Date_Text,0,\"Filename=" + string7 + "\")";
                tAspectDriver.setFieldAttributes((String)object, "\"Formula=" + string6 + "\"");
                object = "Compare_" + i + "_" + j + "_Ratio_Number_StdDev";
                string5 = "Compare " + string4 + " " + (j + 1) + " Ratio Number StdDev";
                tAspectDriver.addField((String)object, "Description=" + string5 + ",FieldType=Number,FormatPattern=###.000000000");
                string6 = "lookup(Investing_Value_Comparison_Results_Number_of_StdDev_From_Mean,Date_Text,0,\"Filename=" + string7 + "\")";
                tAspectDriver.setFieldAttributes((String)object, "\"Formula=" + string6 + "\"");
            }
        }
        String string8 = TMainWin.Application.getTokenValue("Temporary_Files") + "ratio_debug_" + string + ".csv";
        tAspectDriver.DriverStruct.write_to_file(string8);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean createSeriesWithAllDates(String var0, boolean var1_1, int var2_2, boolean var3_3) {
        block30: {
            block29: {
                var4_4 = DataSeriesInfo.isFredDataSeries(var0);
                var5_5 = DataSeriesInfo.isAlphaVantageDataSeries(var0);
                if (!var4_4 && !var5_5) {
                    System.out.println("createSeriesWithAllDates: Error: Series is neither Fred or AlphaVantage: " + var0);
                    return false;
                }
                if (var1_1) {
                    if (var4_4) {
                        System.out.println("DataSeriesUtility updating dependent Fred driver: " + var0);
                        var6_6 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Fred_Time_Series,\"SeriesID=" + var0 + "\",false)");
                    } else {
                        System.out.println("DataSeriesUtility updating dependent AlphaVantage driver: " + var0);
                        var6_6 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Alpha_Vantage_Stock_Quote,\"SeriesID=" + var0 + "\",false)");
                    }
                }
                var6_6 = DataSeriesUtilityOriginal.getDataSeriesValues(var0, new Date(0L), new Date());
                DataSeriesUtilityOriginal.addMissingDates((ArrayList)var6_6);
                if (var3_3) {
                    DataSeriesUtilityOriginal.addDatesToCurrent((ArrayList)var6_6);
                }
                var7_7 = new StringBuilder();
                var8_8 = new GregorianCalendar();
                var9_9 = 0;
                if (!var4_4) break block29;
                var7_7.append(TDataSeriesObj.getFredHeader() + "\r\n");
                for (var10_10 = 0; var10_10 < var6_6.size(); ++var10_10) {
                    var11_12 = (TDataSeriesObj)var6_6.get(var10_10);
                    var12_13 = false;
                    switch (var2_2) {
                        case 0: {
                            var12_13 = true;
                            break;
                        }
                        case 1: {
                            var8_8.setTime(new Date(var11_12.Date));
                            var12_13 = var8_8.get(7) == 2;
                            break;
                        }
                        case 2: {
                            var8_8.setTime(new Date(var11_12.Date));
                            var12_13 = var8_8.get(5) == 1;
                            break;
                        }
                        case 3: {
                            var8_8.setTime(new Date(var11_12.Date));
                            if (var8_8.get(5) != 1) break;
                            if (var8_8.get(2) == 0) ** GOTO lbl-1000
                            if (var8_8.get(2) == 3) ** GOTO lbl-1000
                            if (var8_8.get(2) == 6) ** GOTO lbl-1000
                            if (var8_8.get(2) == 9) lbl-1000:
                            // 4 sources

                            {
                                v0 = true;
                            } else {
                                v0 = false;
                            }
                            var12_13 = v0;
                            break;
                        }
                        case 4: {
                            var8_8.setTime(new Date(var11_12.Date));
                            if (var8_8.get(2) == 0) {
                                if (var8_8.get(5) == 1) {
                                    v1 = true;
                                    break;
                                }
                            }
                            v1 = var12_13 = false;
                        }
                    }
                    if (!var12_13 && var10_10 != var6_6.size() - 1) continue;
                    var7_7.append(var11_12.toFredString() + "\r\n");
                    ++var9_9;
                }
                break block30;
            }
            var7_7.append(TDataSeriesObj.getAlphaVantageHeader() + "\r\n");
            for (var10_10 = var6_6.size() - 1; var10_10 >= 0; --var10_10) {
                var11_12 = (TDataSeriesObj)var6_6.get(var10_10);
                var12_14 = false;
                switch (var2_2) {
                    case 0: {
                        var12_14 = true;
                        break;
                    }
                    case 1: {
                        var8_8.setTime(new Date(var11_12.Date));
                        var12_14 = var8_8.get(7) == 2;
                        break;
                    }
                    case 2: {
                        var8_8.setTime(new Date(var11_12.Date));
                        var12_14 = var8_8.get(5) == 1;
                        break;
                    }
                    case 3: {
                        var8_8.setTime(new Date(var11_12.Date));
                        if (var8_8.get(5) != 1) break;
                        if (var8_8.get(2) == 0) ** GOTO lbl-1000
                        if (var8_8.get(2) == 3) ** GOTO lbl-1000
                        if (var8_8.get(2) == 6) ** GOTO lbl-1000
                        if (var8_8.get(2) == 9) lbl-1000:
                        // 4 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        var12_14 = v2;
                        break;
                    }
                    case 4: {
                        var8_8.setTime(new Date(var11_12.Date));
                        if (var8_8.get(2) == 0) {
                            if (var8_8.get(5) == 1) {
                                v3 = true;
                                break;
                            }
                        }
                        v3 = var12_14 = false;
                    }
                }
                if (!var12_14 && var10_10 != 0) continue;
                var7_7.append(var11_12.toAlphaVantageString() + "\r\n");
                ++var9_9;
            }
        }
        var10_11 = new String[]{"", "w", "m", "q", "y"};
        var11_12 = "c:\\aspect7\\temporary_files\\" + var0 + "_dates_added" + var10_11[var2_2] + ".$$$";
        System.out.println("createSeriesWithAllDates write " + var9_9 + " records to " + (String)var11_12);
        TAsciiOutput.writeContent((String)var11_12, var7_7.toString());
        return true;
    }

    public static Double getCAGR(ArrayList arrayList, int n, int n2) {
        int n3 = n2 * 365;
        if (n - n3 < 0) {
            return null;
        }
        double d = ((TDataSeriesObj)arrayList.get((int)n)).Close;
        double d2 = ((TDataSeriesObj)arrayList.get((int)(n - n3))).Close;
        if (d2 == 0.0) {
            return new Double(0.0);
        }
        double d3 = Math.pow(d / d2, 1.0 / (double)n2) - 1.0;
        return new Double(d3);
    }

    public static Double getCAGR(ArrayList arrayList, int n, int n2, double d) {
        int n3 = n2 * 365;
        if (n - n3 < 0) {
            return null;
        }
        double d2 = ((TDataSeriesObj)arrayList.get((int)n)).Close;
        double d3 = ((TDataSeriesObj)arrayList.get((int)(n - n3))).Close;
        if (d3 == 0.0) {
            return new Double(0.0);
        }
        double d4 = Math.pow((d2 /= d) / (d3 /= d), 1 / n2) - 1.0;
        return new Double(d4);
    }

    public static String getCAGRforAllYears(String string) {
        int n;
        String string2 = DataSeriesInfo.getSeriesFilename(string);
        String string3 = TMainWin.Application.getTokenValue("temporary_files") + "cagr_all_years_" + string + ".csv";
        if (!dosutil.fileExists(string2)) {
            DataSeriesInfo.updateDependentDriver(string);
            if (!dosutil.fileExists(string2)) {
                System.out.println("Error: getCAGRforAllYears: Unrecognized SeriesID: " + string);
                return "";
            }
        }
        if (dosutil.fileExists(string3) && dosutil.fileModified(string3).getTime() > dosutil.fileModified(string2).getTime()) {
            return string3;
        }
        ArrayList arrayList = DataSeriesUtilityOriginal.getDataSeriesValues(string);
        DataSeriesUtilityOriginal.addMissingDates(arrayList);
        TDataSeriesObj tDataSeriesObj = (TDataSeriesObj)arrayList.get(0);
        Date date = new Date(tDataSeriesObj.Date);
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            n4 = n;
            tDataSeriesObj = (TDataSeriesObj)arrayList.get(n);
            if (tDataSeriesObj.Adjusted_Close != 0.0) break;
        }
        for (n = n4; n < arrayList.size(); ++n) {
            tDataSeriesObj = (TDataSeriesObj)arrayList.get(n);
            gregorianCalendar.setTime(new Date(tDataSeriesObj.Date));
            if (gregorianCalendar.get(2) != 0 || gregorianCalendar.get(5) != 1) continue;
            int n5 = gregorianCalendar.get(1);
            if (n2 == 0) {
                n2 = n5;
            }
            n3 = n5;
            hashtable.put(new Integer(n5), new Double(tDataSeriesObj.Adjusted_Close));
        }
        tDataSeriesObj = (TDataSeriesObj)arrayList.get(arrayList.size() - 1);
        Date date2 = new Date(tDataSeriesObj.Date);
        Double d = new Double(tDataSeriesObj.Adjusted_Close);
        System.out.println("iYear1=" + n2 + " iYear2=" + n3);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i <= n3; ++i) {
            Comparable<Date> comparable;
            for (int j = i + 1; j <= n3; ++j) {
                comparable = dateutil.parseDate("01-01-" + Integer.toString(i));
                Date date3 = dateutil.parseDate("01-01-" + Integer.toString(j));
                Double d2 = (Double)hashtable.get(new Integer(i));
                Double d3 = (Double)hashtable.get(new Integer(j));
                System.out.println("y1=" + i + " y2=" + j + " dt1=" + dateutil.formatDate(comparable, "MM-dd-yyyy") + " dt2=" + dateutil.formatDate(date3, "MM-dd-yyyy"));
                stringBuilder.append(string + "," + dateutil.formatDate(comparable, "MM-dd-yyyy") + "," + dateutil.formatDate(date3, "MM-dd-yyyy") + "," + d2.toString() + "," + d3.toString() + "\r\n");
            }
            Date date4 = dateutil.parseDate("01-01-" + Integer.toString(i));
            comparable = (Double)hashtable.get(new Integer(i));
            stringBuilder.append(string + "," + dateutil.formatDate(date4, "MM-dd-yyyy") + "," + dateutil.formatDate(date2, "MM-dd-yyyy") + "," + ((Double)comparable).toString() + "," + d.toString() + "\r\n");
        }
        TAsciiOutput.writeContent(string3, stringBuilder.toString());
        return string3;
    }
}

