/*
 * Decompiled with CFR 0.152.
 */
package metrics;

import aspect.Aspect;
import aspect.TMainWin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Timer;
import metrics.TMetricMeasurement;
import resources.TApplication;
import utility.TFile;
import utility.charutil;
import utility.security.TPasswordService;

public class TMetricMeasurementQueue
implements ActionListener {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private String Filename = null;
    private long TimeLastFlush = 0L;
    private RandomAccessFile F = null;
    private DateFormat dateFormat = DateFormat.getInstance();
    private StringBuilder LogBuffer = new StringBuilder();
    private Timer CallbackTimer = null;

    public TMetricMeasurementQueue() {
        ((SimpleDateFormat)this.dateFormat).applyPattern("yyyyMMdd");
        this.Filename = this.getLogFilename(new Date());
        this.openLogFile();
        this.CallbackTimer = new Timer(60000, this);
        this.CallbackTimer.start();
    }

    public String getLogFilename(Date date) {
        String string = this.dateFormat.format(date);
        string = this.Application.getHomeDir() + "aspectlogs/metrics_" + string + ".txt";
        return string;
    }

    public boolean openLogFile() {
        if (this.F != null) {
            try {
                this.F.close();
                this.F = null;
            }
            catch (Exception exception) {
                System.out.println("Error closing log file: " + exception.toString());
            }
        }
        if (this.Filename == null) {
            System.out.println("Error: Filename not initialized");
            return false;
        }
        try {
            new TFile(this.Filename).validatePathToFile(true);
            this.F = new RandomAccessFile(this.Filename, "rwd");
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error opening log file: " + this.Filename);
            System.out.println(exception.toString());
            return false;
        }
    }

    public String tokenize(String string) {
        String string2 = string;
        string2 = charutil.replaceAllSubstrings(string2, "\"", "%22");
        string2 = charutil.replaceAllSubstrings(string2, "\"", "%2c");
        string2 = charutil.replaceAllSubstrings(string2, "\r", "%13");
        string2 = charutil.replaceAllSubstrings(string2, "\n", "%10");
        return string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.LogBuffer.length() == 0) {
            return;
        }
        this.flushBuffer();
    }

    public synchronized void flushBuffer() {
        this.TimeLastFlush = new Date().getTime();
        if (this.LogBuffer.length() == 0) {
            return;
        }
        try {
            this.F.seek(this.F.length());
            this.F.writeBytes(this.LogBuffer.toString() + "\r\n");
        }
        catch (Exception exception) {
            System.out.println("Error writing to log file: " + exception.toString());
        }
        this.LogBuffer.setLength(0);
    }

    public void recordMetricMeasurement(TMetricMeasurement tMetricMeasurement) {
        String string = this.getLogFilename(tMetricMeasurement.Time);
        if (!string.equals(this.Filename)) {
            this.flushBuffer();
            this.Filename = string;
            this.openLogFile();
        }
        String string2 = TPasswordService.generateSalt(8);
        string2 = string2 + ",true";
        string2 = string2 + "," + tMetricMeasurement.MetricID;
        string2 = string2 + "," + tMetricMeasurement.DataType;
        string2 = string2 + "," + Long.toString(tMetricMeasurement.Time.getTime());
        string2 = string2 + "," + this.tokenize(tMetricMeasurement.Result);
        if (this.LogBuffer.length() > 0) {
            this.LogBuffer.append("\r\n");
        }
        this.LogBuffer.append(string2);
        if (new Date().getTime() - this.TimeLastFlush > 60000L) {
            this.flushBuffer();
        }
    }
}

