/*
 * Decompiled with CFR 0.152.
 */
package multimedia;

import java.awt.Component;
import java.net.URL;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.Time;
import javax.swing.JFrame;
import utility.dosutil;

public class JMFPlayer
extends Thread
implements ControllerListener {
    Player player = null;
    JFrame ParentFrame = null;
    Component VisualComponent = null;
    Component ControlComponent = null;
    String MediaFileName = "";
    URL MediaURL = null;
    boolean Loop = false;
    static boolean Closed = false;

    public JMFPlayer(String string, boolean bl) {
        super("JMFPlayer");
        this.ParentFrame = new JMFMediaFrame(string);
        this.ParentFrame.setSize(400, 200);
        this.ParentFrame.setLocationRelativeTo(null);
        this.ParentFrame.setDefaultCloseOperation(2);
        this.Loop = bl;
        this.MediaFileName = string;
        try {
            this.MediaURL = new URL(dosutil.formatURL(this.MediaFileName));
        }
        catch (Exception exception) {
            System.out.println("JMFPlayer: " + exception.toString());
        }
    }

    @Override
    public void run() {
        try {
            this.player = Manager.createPlayer((URL)this.MediaURL);
            this.player.addControllerListener((ControllerListener)this);
            this.player.start();
        }
        catch (Exception exception) {
            System.out.println("JMFPlayer: " + exception.toString());
        }
    }

    public void dispose() {
        System.out.println("Closing player");
        Closed = true;
        this.player.close();
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof RealizeCompleteEvent) {
            this.VisualComponent = this.player.getVisualComponent();
            if (this.VisualComponent != null) {
                this.ParentFrame.getContentPane().add("Center", this.VisualComponent);
            }
            if ((this.ControlComponent = this.player.getControlPanelComponent()) != null) {
                this.ParentFrame.getContentPane().add("South", this.ControlComponent);
            }
            this.ParentFrame.pack();
            this.ParentFrame.setLocationRelativeTo(null);
            this.ParentFrame.setVisible(true);
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            if (this.Loop) {
                try {
                    this.player.setMediaTime(new Time(0L));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.player.start();
            } else {
                this.ParentFrame.setVisible(false);
                this.ParentFrame.dispose();
            }
        }
    }

    public class JMFMediaFrame
    extends JFrame {
        public JMFMediaFrame(String string) {
            super(string);
        }

        @Override
        public void dispose() {
            JMFPlayer.this.dispose();
            super.dispose();
        }
    }
}

