/*
 * Decompiled with CFR 0.152.
 */
package networking.dnsserver;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import drivers.network.TNetworkMonitorDnsLogWrapper;
import drivers.network.TNetworkMonitorDnsLogWriter;
import drivers.network.TNetworkMonitorWebAddressWrapper;
import drivers.network.TNetworkMonitorWebAddressWriter;
import extensions.SwingWorker;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.IllegalBlockingModeException;
import java.util.ArrayList;
import java.util.Date;
import networking.dnsserver.TDnsAddressEntry;
import networking.dnsserver.TDnsPacket;
import networking.dnsserver.TDnsPacketContent;
import networking.dnsserver.TDnsServerListenerInterface;
import utility.netutil;

public class TDnsServerSocket
extends Thread {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    private static TDnsServerSocket DnsServerSocket = null;
    private static int cHandlingRequest = 0;
    private DatagramPacket FirstRequest = null;
    private ArrayList arBlockedAddresses = new ArrayList();
    private ArrayList arListeners = new ArrayList();
    private boolean ExitThread = false;
    TNetworkMonitorWebAddressWriter WebAddressWriter;
    TNetworkMonitorDnsLogWriter DnsLogWriter;

    public TDnsServerSocket() {
        this.setPriority(1);
        DnsServerSocket = this;
        this.getRealDomainNameServer();
    }

    public boolean isBlockedName(String string) {
        if (this.arBlockedAddresses == null) {
            return false;
        }
        if (this.Debug) {
            System.out.print("isBlockedName(" + string + ")");
        }
        String string2 = null;
        long l = 0L;
        boolean bl = false;
        if (netutil.isValidIPAddress(string)) {
            bl = true;
            l = netutil.ipaddrToLong(string);
            if (this.Debug) {
                System.out.print(" by IP Address = ");
            }
        }
        string2 = string.toUpperCase();
        for (int i = 0; i < this.arBlockedAddresses.size(); ++i) {
            TDnsAddressEntry tDnsAddressEntry = (TDnsAddressEntry)this.arBlockedAddresses.get(i);
            if (bl && l >= tDnsAddressEntry.IPRangeStart && l <= tDnsAddressEntry.IPRangeEnd) {
                if (this.Debug) {
                    System.out.println("true");
                }
                return true;
            }
            if (tDnsAddressEntry.UrlName == null || string2.indexOf(tDnsAddressEntry.UrlName) < 0) continue;
            if (this.Debug) {
                System.out.println("true");
            }
            return true;
        }
        if (this.Debug) {
            System.out.println("false");
        }
        return false;
    }

    public void notifyListenersRequestReceived(final String string, final int n, final String string2, final boolean bl, final Date date) {
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                return null;
            }

            @Override
            public void finished() {
                for (int i = 0; i < TDnsServerSocket.this.arListeners.size(); ++i) {
                    ((TDnsServerListenerInterface)TDnsServerSocket.this.arListeners.get(i)).dnsRequestReceived(string, n, string2);
                }
                TDnsServerSocket.this.WebAddressWriter.updateList(new TNetworkMonitorWebAddressWrapper(string2, 0, date, bl), 0);
                TNetworkMonitorDnsLogWrapper tNetworkMonitorDnsLogWrapper = new TNetworkMonitorDnsLogWrapper();
                tNetworkMonitorDnsLogWrapper.setTime(date);
                tNetworkMonitorDnsLogWrapper.setRequestorIPAddress(string);
                tNetworkMonitorDnsLogWrapper.setHostRequested(string2);
                tNetworkMonitorDnsLogWrapper.setAccessGranted(bl);
                TDnsServerSocket.this.DnsLogWriter.updateList(tNetworkMonitorDnsLogWrapper, 0);
                String string3 = bl ? "DNS [granted] " + string2 : "DNS [blocked] " + string2;
                if (netutil.isValidIPAddress(string2)) {
                    string3 = string3 + " (" + netutil.getHostName(string2) + ")";
                }
            }
        };
        swingWorker.start();
    }

    public void closeSocket() {
        this.ExitThread = true;
    }

    public String getRealDomainNameServer() {
        TAspectDriver tAspectDriver = new TAspectDriver("Network_Monitor_Settings", 1, false, true, "");
        String string = (String)tAspectDriver.getFieldAbsolute("Domain_Name_Server", 0);
        if (string == null || string.length() == 0) {
            MainWin.appendToLog("TDnsServerSocket", "getRealDomainNameServer", Thread.currentThread(), null, 4, "A domain name server has not been defined.");
            return "";
        }
        if (!netutil.isValidIPAddress(string)) {
            string = netutil.getIPAddress(string);
        }
        return string;
    }

    public void readBlockedWebsites() {
        TAspectDriver tAspectDriver = new TAspectDriver("NetMonitorWebsites", 1, false, true, "");
        TDriverStructRecord tDriverStructRecord = tAspectDriver.getDriverStruct().getField("url");
        TDriverStructRecord tDriverStructRecord2 = tAspectDriver.getDriverStruct().getField("BlockConnection");
        TDriverStructRecord tDriverStructRecord3 = tAspectDriver.getDriverStruct().getField("HostName");
        TDriverStructRecord tDriverStructRecord4 = tAspectDriver.getDriverStruct().getField("IPAddress");
        for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
            String string = (String)tAspectDriver.getField(tDriverStructRecord, i);
            Boolean bl = (Boolean)tAspectDriver.getField(tDriverStructRecord2, i);
            if (!bl.booleanValue()) continue;
            if (netutil.isValidIPAddress(string)) {
                this.arBlockedAddresses.add(new TDnsAddressEntry("", string, true));
                continue;
            }
            this.arBlockedAddresses.add(new TDnsAddressEntry(string, "", true));
        }
        tAspectDriver.dispose();
    }

    public void readBlockedIPs() {
        TAspectDriver tAspectDriver = new TAspectDriver("IPIdentities", 1, false, true, "");
        TDriverStructRecord tDriverStructRecord = tAspectDriver.getDriverStruct().getField("IPAddress");
        TDriverStructRecord tDriverStructRecord2 = tAspectDriver.getDriverStruct().getField("WhoIsNetRange");
        TDriverStructRecord tDriverStructRecord3 = tAspectDriver.getDriverStruct().getField("BlockConnection");
        for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
            Boolean bl;
            String string = (String)tAspectDriver.getField(tDriverStructRecord, i);
            String string2 = (String)tAspectDriver.getField(tDriverStructRecord2, i);
            if (string2.trim().length() != 0) {
                string = string2;
            }
            if (!(bl = (Boolean)tAspectDriver.getField(tDriverStructRecord3, i)).booleanValue()) continue;
            this.arBlockedAddresses.add(new TDnsAddressEntry("", string, true));
        }
    }

    public void readBlockedAddresses() {
        this.arBlockedAddresses.clear();
        this.readBlockedIPs();
        this.readBlockedWebsites();
    }

    @Override
    public void run() {
        InetAddress inetAddress = null;
        DatagramSocket datagramSocket = null;
        Object var3_3 = null;
        TDnsPacket tDnsPacket = null;
        DatagramPacket datagramPacket = new DatagramPacket(new byte[1024], 1024);
        int n = 0;
        boolean bl = false;
        MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), null, 3, "Starting DNS name server.");
        try {
            inetAddress = InetAddress.getByName(this.getRealDomainNameServer());
            datagramSocket = new DatagramSocket(53, InetAddress.getLocalHost());
            datagramSocket.setSoTimeout(100);
        }
        catch (Exception exception) {
            MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), exception, 4, "Error opening name server socket.");
            this.ExitThread = true;
        }
        if (datagramSocket == null) {
            return;
        }
        if (TMainWin.Application.getTokenValue("$DnsServerStatus").equalsIgnoreCase("Running")) {
            MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), null, 3, "Domain name server is already running.");
            return;
        }
        TMainWin.Application.setTokenValue("$DnsServerStatus", "Running");
        TMainWin.Application.setTokenValue("$DnsServerRefresh", "true");
        this.DnsLogWriter = new TNetworkMonitorDnsLogWriter();
        this.DnsLogWriter.start();
        this.WebAddressWriter = new TNetworkMonitorWebAddressWriter();
        this.WebAddressWriter.start();
        do {
            Object object;
            String string;
            bl = false;
            do {
                try {
                    datagramSocket.receive(datagramPacket);
                    bl = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Thread.yield();
                }
                catch (PortUnreachableException portUnreachableException) {
                    MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), portUnreachableException, 4, "Unreachable port when waiting for name server packet.");
                    this.ExitThread = true;
                }
                catch (IOException iOException) {
                    MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), iOException, 4, "I/O error when waiting for name server packet.");
                    this.ExitThread = true;
                }
                catch (IllegalBlockingModeException illegalBlockingModeException) {
                    MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), illegalBlockingModeException, 4, "Blocking mode exception when waiting for name server packet.");
                    this.ExitThread = true;
                }
            } while (!this.ExitThread && !bl);
            if (this.ExitThread) continue;
            ++n;
            InetAddress inetAddress2 = datagramPacket.getAddress();
            int n2 = datagramPacket.getPort();
            String string2 = TDnsServerSocket.getDnsRequestUrl(datagramPacket);
            tDnsPacket = new TDnsPacket(datagramPacket);
            if (this.Debug) {
                System.out.println("\n====================================");
                System.out.println("[" + n + "] Query received: " + string2);
                System.out.println("====================================");
                tDnsPacket.outputPacketForDebugging();
            }
            if ((string = string2.toUpperCase()).indexOf(netutil.getLocalHostName().toUpperCase()) >= 0) {
                System.out.println("[" + n + "] Query set to local network: " + string2);
                tDnsPacket.clearContents();
                tDnsPacket.setResponseFields();
                object = new TDnsPacketContent();
                ((TDnsPacketContent)object).setContentSection(0);
                ((TDnsPacketContent)object).setContentName(string2);
                ((TDnsPacketContent)object).setContentType(1);
                ((TDnsPacketContent)object).setContentClass(1);
                tDnsPacket.addContent((TDnsPacketContent)object);
                ((TDnsPacketContent)object).setContentSection(1);
                ((TDnsPacketContent)object).setContentTtl(65535L);
                ((TDnsPacketContent)object).setContentData(netutil.getLocalIP());
                tDnsPacket.addContent((TDnsPacketContent)object);
                ((TDnsPacketContent)object).setContentSection(2);
                ((TDnsPacketContent)object).setContentData(netutil.getLocalIP());
                tDnsPacket.addContent((TDnsPacketContent)object);
                if (this.Debug) {
                    tDnsPacket.outputPacketForDebugging();
                }
                try {
                    datagramSocket.send(tDnsPacket.getDatagramPacket(new InetSocketAddress(inetAddress2, n2)));
                }
                catch (Exception exception) {
                    MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), exception, 4, "Error returning dns packet to sender.");
                }
                continue;
            }
            if (this.isBlockedName(string2)) {
                if (this.Debug) {
                    System.out.println("\n====================================");
                    System.out.println("Sending loopback response");
                    System.out.println("====================================");
                } else {
                    System.out.println("[" + n + "] Query blocked: " + string2);
                }
                this.notifyListenersRequestReceived(inetAddress2.getHostAddress(), n2, string2, false, new Date());
                tDnsPacket.clearContents();
                tDnsPacket.setResponseFields();
                object = new TDnsPacketContent();
                ((TDnsPacketContent)object).setContentSection(0);
                ((TDnsPacketContent)object).setContentName(string2);
                ((TDnsPacketContent)object).setContentType(1);
                ((TDnsPacketContent)object).setContentClass(1);
                tDnsPacket.addContent((TDnsPacketContent)object);
                ((TDnsPacketContent)object).setContentSection(1);
                ((TDnsPacketContent)object).setContentTtl(65535L);
                ((TDnsPacketContent)object).setContentData("127.0.0.1");
                tDnsPacket.addContent((TDnsPacketContent)object);
                ((TDnsPacketContent)object).setContentSection(2);
                ((TDnsPacketContent)object).setContentData("127.0.0.1");
                tDnsPacket.addContent((TDnsPacketContent)object);
                if (this.Debug) {
                    tDnsPacket.outputPacketForDebugging();
                }
                try {
                    datagramSocket.send(tDnsPacket.getDatagramPacket(new InetSocketAddress(inetAddress2, n2)));
                }
                catch (Exception exception) {
                    MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), exception, 4, "Error returning dns packet to sender.");
                }
                continue;
            }
            System.out.println("[" + n + "] Query received: " + string2);
            object = new THandleRequest(datagramPacket, inetAddress);
            ((Thread)object).start();
        } while (!this.ExitThread);
        datagramSocket.close();
        TMainWin.Application.setTokenValue("$DnsServerStatus", "Idle");
        TMainWin.Application.setTokenValue("$DnsServerRefresh", "true");
        this.DnsLogWriter.terminate();
        this.DnsLogWriter.dispose();
        this.WebAddressWriter.terminate();
        this.WebAddressWriter.dispose();
        while (cHandlingRequest > 0) {
            Thread.yield();
        }
        MainWin.appendToLog("TDnsServerSocket", "run", Thread.currentThread(), null, 3, "DNS name server has stopped.");
        DnsServerSocket = null;
    }

    public static String getDnsRequestUrl(DatagramPacket datagramPacket) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = datagramPacket.getLength();
        if (n >= 13) {
            int n2;
            byte[] byArray = datagramPacket.getData();
            int n3 = 12;
            do {
                if ((n2 = byArray[n3] >= 0 ? byArray[n3] : byArray[n3] + 256) <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('.');
                }
                for (int i = 0; i < n2 && n3 + i + 1 < n; ++i) {
                    stringBuilder.append((char)byArray[n3 + i + 1]);
                }
            } while (n2 != 0 && (n3 += n2 + 1) < n);
        }
        return stringBuilder.toString();
    }

    public static TDnsServerSocket getInstance() {
        return DnsServerSocket;
    }

    public static void startDNSServer() {
        if (DnsServerSocket != null) {
            MainWin.appendToLog("TDnsServerSocket", "startDNSServer", Thread.currentThread(), null, 3, "DNS Server is already started.");
            return;
        }
        DnsServerSocket = new TDnsServerSocket();
        DnsServerSocket.readBlockedAddresses();
        DnsServerSocket.start();
    }

    public static void stopDNSServer() {
        if (DnsServerSocket == null) {
            MainWin.appendToLog("TDnsServerSocket", "startDNSServer", Thread.currentThread(), null, 3, "DNS Server is not running.");
            return;
        }
        DnsServerSocket.closeSocket();
        DnsServerSocket = null;
    }

    public static void updateBlockedAddresses() {
        if (DnsServerSocket == null) {
            return;
        }
        DnsServerSocket.readBlockedAddresses();
    }

    public class THandleRequest
    extends Thread {
        InetAddress RealDNSServerInetAddr;
        DatagramSocket socket;
        DatagramPacket RequestPacket;

        public THandleRequest(DatagramPacket datagramPacket, InetAddress inetAddress) {
            super("THandleRequest");
            this.setPriority(1);
            this.RealDNSServerInetAddr = inetAddress;
            this.RequestPacket = datagramPacket;
            cHandlingRequest++;
        }

        @Override
        public void run() {
            boolean bl;
            int n = 0;
            do {
                try {
                    this.socket = new DatagramSocket(10400 + n, InetAddress.getLocalHost());
                    this.socket.setSoTimeout(10000);
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                    ++n;
                }
            } while (!bl && n < 500);
            if (bl) {
                String string;
                boolean bl2;
                boolean bl3;
                TDnsPacketContent tDnsPacketContent;
                int n2;
                SocketAddress socketAddress = this.RequestPacket.getSocketAddress();
                InetAddress inetAddress = this.RequestPacket.getAddress();
                int n3 = this.RequestPacket.getPort();
                DatagramPacket datagramPacket = new DatagramPacket(this.RequestPacket.getData(), this.RequestPacket.getOffset(), this.RequestPacket.getLength(), this.RealDNSServerInetAddr, 53);
                try {
                    this.socket.send(datagramPacket);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DatagramPacket datagramPacket2 = new DatagramPacket(new byte[1024], 1024);
                try {
                    this.socket.receive(datagramPacket2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TDnsPacket tDnsPacket = new TDnsPacket(datagramPacket2);
                if (TDnsServerSocket.this.Debug) {
                    System.out.println("\n====================================");
                    System.out.println("Response from wild blue");
                    System.out.println("====================================");
                    tDnsPacket.outputPacketForDebugging();
                }
                ArrayList arrayList = tDnsPacket.getContents();
                tDnsPacket.clearContents();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    tDnsPacketContent = (TDnsPacketContent)arrayList.get(n2);
                    if (tDnsPacketContent.getContentSection() != 0) continue;
                    tDnsPacket.addContent(tDnsPacketContent);
                }
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    tDnsPacketContent = (TDnsPacketContent)arrayList.get(n2);
                    if (tDnsPacketContent.getContentSection() != 1) continue;
                    bl3 = TDnsServerSocket.this.isBlockedName(tDnsPacketContent.getContentData());
                    bl2 = TDnsServerSocket.this.isBlockedName(tDnsPacketContent.getContentName());
                    if (!bl3 && !bl2) {
                        tDnsPacket.addContent(tDnsPacketContent);
                        TDnsServerSocket.this.notifyListenersRequestReceived(inetAddress.getHostAddress(), n3, tDnsPacketContent.getContentData(), true, new Date());
                        continue;
                    }
                    string = bl3 ? tDnsPacketContent.getContentName() : tDnsPacketContent.getContentData();
                    TDnsServerSocket.this.notifyListenersRequestReceived(inetAddress.getHostAddress(), n3, tDnsPacketContent.getContentData(), false, new Date());
                }
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    tDnsPacketContent = (TDnsPacketContent)arrayList.get(n2);
                    if (tDnsPacketContent.getContentSection() != 2) continue;
                    bl3 = TDnsServerSocket.this.isBlockedName(tDnsPacketContent.getContentData());
                    bl2 = TDnsServerSocket.this.isBlockedName(tDnsPacketContent.getContentName());
                    if (!bl3 && !bl2) {
                        tDnsPacket.addContent(tDnsPacketContent);
                        continue;
                    }
                    string = bl3 ? tDnsPacketContent.getContentName() : tDnsPacketContent.getContentData();
                }
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    tDnsPacketContent = (TDnsPacketContent)arrayList.get(n2);
                    if (tDnsPacketContent.getContentSection() != 3) continue;
                    bl3 = TDnsServerSocket.this.isBlockedName(tDnsPacketContent.getContentData());
                    bl2 = TDnsServerSocket.this.isBlockedName(tDnsPacketContent.getContentName());
                    if (!bl3 && !bl2) {
                        tDnsPacket.addContent(tDnsPacketContent);
                        continue;
                    }
                    string = bl3 ? tDnsPacketContent.getContentName() : tDnsPacketContent.getContentData();
                }
                if (TDnsServerSocket.this.Debug) {
                    System.out.println("\n====================================");
                    System.out.println("Audited packet to be returned to sender");
                    System.out.println("====================================");
                    tDnsPacket.outputPacketForDebugging();
                }
                try {
                    DatagramPacket datagramPacket3 = new DatagramPacket(datagramPacket2.getData(), datagramPacket2.getOffset(), datagramPacket2.getLength(), socketAddress);
                    this.socket.send(datagramPacket3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket.close();
            }
            cHandlingRequest--;
        }
    }
}

