/*
 * Decompiled with CFR 0.152.
 */
package pub;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TFileChooser;
import controls.TProgressBar;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;

public class TParagon
extends Thread {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTParagon");
    String[][] arREFeatureName = new String[][]{{"A", "Feature_To_Show"}, {"B", "Feature_Heat_Source_1"}, {"C", "Feature_Heat_Source_2"}, {"E", "Feature_Main_Floor_Room"}, {"F", "Feature_Lower_Level_Rooms"}, {"G", "Feature_Upper_Level_Rooms"}, {"H", "Feature_Bedrooms"}, {"I", "Feature_Dining_Area"}, {"J", "Feature_Bathrooms"}, {"K", "Feature_Water_Header"}, {"L", "Feature_Fireplace"}, {"M", "Feature_Basement/Crawl"}, {"N", "Feature_Foundation"}, {"O", "Feature_Construction"}, {"P", "Feature_Siding"}, {"P", "Feature_Q"}, {"R", "Feature_Style"}, {"S", "Feature_Garage"}, {"T", "Feature_Outbuilding"}, {"U", "Feature_Terrain"}, {"V", "Feature_Handicap"}, {"W", "Feature_Water/Sewer"}, {"X", "Feature_Appliance/Equip"}, {"Y", "Feature_Extras"}, {"Z", "Feature_Sid(s)"}, {"ZA", "Feature_Cov/Res/Ease"}, {"ZB", "Feature_Road_Frontage"}, {"ZC", "Feature_Road_Surface"}, {"ZD", "Feature_Trees"}, {"ZE", "Feature_Surface_Water"}, {"ZF", "Feature_Irrigation"}, {"ZG", "Feature_Fencing"}, {"ZH", "Feature_Adjacent_Owners"}, {"ZI", "Feature_Sign_Property"}, {"ZJ", "Feature_Age"}, {"ZK", "Feature_Insulation"}, {"ZL", "Feature_View"}, {"ZM", "Feature_Documents"}};

    public TParagon() {
        super("TParagon");
    }

    public String getImportFilename() {
        String string = "";
        TFileChooser tFileChooser = new TFileChooser();
        String string2 = TMainWin.Application.parse_tokens("{homedir}MontanaMagic\\paragon.txt");
        tFileChooser.setSelectedFile(new File(string2));
        int n = tFileChooser.showOpenDialog(null);
        switch (n) {
            case 1: {
                break;
            }
            case 0: {
                string = tFileChooser.getFileName();
                break;
            }
        }
        return string;
    }

    private void addPicturesInDirectory(File file, ArrayList arrayList) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.addPicturesInDirectory(fileArray[i], arrayList);
                    continue;
                }
                arrayList.add(fileArray[i].getPath());
            }
        }
    }

    private ArrayList makePictureCollection() {
        ArrayList arrayList = new ArrayList();
        File file = new File(TMainWin.Application.getTokenValue("ParagonDirectory") + "pictures\\");
        MainWin.appendToLog("TParagonDriver", "makePictureCollection", Thread.currentThread(), null, 3, "Adding pictures from " + file);
        if (file != null) {
            this.addPicturesInDirectory(file, arrayList);
        }
        return arrayList;
    }

    private String cleanupGeoCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        stringBuilder.append(string);
        charutil.remove_char(stringBuilder, stringBuilder, '-');
        int n = stringBuilder.indexOf("/");
        if (n == 0) {
            n = stringBuilder.indexOf(",");
        }
        if (n == 0) {
            n = stringBuilder.indexOf("&");
        }
        if (n == 0) {
            n = stringBuilder.indexOf(" ");
        }
        if (n == 0) {
            n = stringBuilder.indexOf("+");
        }
        if (n > 0) {
            stringBuilder.setLength(n);
        }
        if (stringBuilder.length() > 17) {
            stringBuilder.setLength(17);
        }
        while (stringBuilder.length() < 17) {
            stringBuilder.append("0");
        }
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) >= '0' && stringBuilder.charAt(i) <= '9') continue;
            stringBuilder.setLength(0);
        }
        String string2 = stringBuilder.toString();
        if (string2.equals("00000000000000000")) {
            string2 = "";
        }
        return string2;
    }

    public String cleanupFeatures(String string, String string2, String string3) {
        String string4 = string2.toUpperCase();
        String string5 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        int n4 = TMainWin.Application.getTokenValueAsInt("MontanaMagic_Features_MaxColumns");
        if (!(string4.equals("LD") || string4.equals("RE") || string4.equals("CI") || string4.equals("MF"))) {
            MainWin.appendToLog("TParagon", "cleanupFeatures", Thread.currentThread(), null, 4, "The features for MLS #" + string3 + " cannot be read because the property class is invalid.");
            return string5;
        }
        String[] stringArray = charutil.getSubStringArray(string.trim(), ' ', true);
        if (stringArray != null) {
            int n5;
            string5 = "<table width=100%><tr valign='top'><td>";
            TFeatureCodeColl tFeatureCodeColl = new TFeatureCodeColl();
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                if (!stringArray[n5].startsWith("{") || !stringArray[n5].endsWith("}") || stringArray[n5].startsWith("{A")) continue;
                tFeatureCodeColl.add(new TFeatureCode(stringArray[n5], string4));
            }
            n = Math.max(10, tFeatureCodeColl.countLines() / n4);
            int n6 = 0;
            for (n5 = 0; n5 < tFeatureCodeColl.size(); ++n5) {
                if (string5.length() < 1200 - "</ul></td></tr></table>".length() - 1) {
                    TFeatureCode tFeatureCode = (TFeatureCode)tFeatureCodeColl.get(n5);
                    if (tFeatureCode.StartsNewCategory) {
                        if (n3 < n4 && (n6 += 2) >= n) {
                            string5 = string5 + "</td><td>";
                            ++n3;
                            n6 = 0;
                        }
                        if (n6 > 2) {
                            string5 = string5 + "<br>";
                        }
                        string5 = string5 + tFeatureCode.getCategory();
                    }
                    string5 = string5 + tFeatureCode.getCode();
                    ++n2;
                    ++n6;
                    continue;
                }
                if (!bl) continue;
                System.out.println("Features overflowed in " + string3);
                bl = false;
            }
            tFeatureCodeColl.clear();
        }
        string5 = string5 + "</ul></td></tr></table>";
        if (n2 == 0) {
            string5 = "<h2>No features have been listed for this property</h2>";
        }
        return string5;
    }

    @Override
    public void run() {
        int n;
        TProgressBar tProgressBar = null;
        ArrayList<Integer> arrayList = null;
        ArrayList arrayList2 = null;
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[8];
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        char c = '\t';
        String string = TMainWin.Application.parse_tokens("{homedir}MontanaMagic\\paragon.txt");
        TAspectDriver tAspectDriver = new TAspectDriver("MLSListings", 1, false, true, "");
        tAspectDriver.setUndoRecording(false);
        MainWin.appendToLog("TParagon", "importParagonData", Thread.currentThread(), null, 3, "Importing " + string);
        gregorianCalendar.setTime(new Date());
        TDriverStructRecord tDriverStructRecord = tAspectDriver.DriverStruct.getField("MLS_No");
        tDriverStructRecordArray[0] = tAspectDriver.DriverStruct.getField("Picture1");
        tDriverStructRecordArray[1] = tAspectDriver.DriverStruct.getField("Picture2");
        tDriverStructRecordArray[2] = tAspectDriver.DriverStruct.getField("Picture3");
        tDriverStructRecordArray[3] = tAspectDriver.DriverStruct.getField("Picture4");
        tDriverStructRecordArray[4] = tAspectDriver.DriverStruct.getField("Picture5");
        tDriverStructRecordArray[5] = tAspectDriver.DriverStruct.getField("Picture6");
        tDriverStructRecordArray[6] = tAspectDriver.DriverStruct.getField("Picture7");
        tDriverStructRecordArray[7] = tAspectDriver.DriverStruct.getField("Picture8");
        arrayList2 = this.makePictureCollection();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (n = 0; n < tAspectDriver.getRecordCount(); ++n) {
            hashtable.put(((Integer)tAspectDriver.getField(tDriverStructRecord, n)).toString(), new Integer(n));
        }
        TAsciiInput tAsciiInput = new TAsciiInput(dosutil.formatURL(string), c);
        tAsciiInput.setRespectQuotes(false);
        tProgressBar = new TProgressBar("Importing...", tAsciiInput.getSize());
        while (tAsciiInput.get_string(stringBuilder) > 0) {
            if (Debug && n4 > 100) {
                System.out.print("Line " + n4 + " len= " + stringBuilder.length() + " String=" + stringBuilder.substring(0, 50));
                System.out.println(" end of string: " + stringBuilder.substring(stringBuilder.length() - 50));
            }
            charutil.replace_char(stringBuilder, stringBuilder, '\"', '\'');
            String[] stringArray = charutil.getSubStringArray(stringBuilder, c, true);
            if (++n4 % 100 == 0) {
                MainWin.appendToLog("TParagon", "importParagonData", Thread.currentThread(), null, 3, "Importing record #" + n4);
            }
            if (stringArray != null && stringArray.length > 0) {
                String string2;
                int n7;
                if (stringArray[0].equalsIgnoreCase("COMPANY CODE")) {
                    if (arrayList != null) {
                        arrayList.clear();
                    } else {
                        arrayList = new ArrayList<Integer>();
                    }
                    n2 = -1;
                    n3 = -1;
                    for (n = 0; n < stringArray.length; ++n) {
                        stringBuilder.setLength(0);
                        if (stringArray[n].equalsIgnoreCase("ORIG $")) {
                            stringBuilder.append("ORIG$");
                        } else if (stringArray[n].equalsIgnoreCase("Parcel #")) {
                            stringBuilder.append("Parcel#");
                        } else if (stringArray[n].equalsIgnoreCase("Point Pd")) {
                            stringBuilder.append("Points_PD");
                        } else if (stringArray[n].equalsIgnoreCase("Possess")) {
                            stringBuilder.append("Posession");
                        } else if (stringArray[n].equalsIgnoreCase("TypeLstAgr")) {
                            stringBuilder.append("TypLstAgr");
                        } else {
                            stringBuilder.append(stringArray[n]);
                        }
                        charutil.replace_char(stringBuilder, stringBuilder, ' ', '_');
                        charutil.replace_char(stringBuilder, stringBuilder, '-', '_');
                        charutil.remove_char(stringBuilder, stringBuilder, '/');
                        charutil.remove_char(stringBuilder, stringBuilder, ':');
                        charutil.remove_char(stringBuilder, stringBuilder, '\'');
                        charutil.remove_char(stringBuilder, stringBuilder, '(');
                        charutil.remove_char(stringBuilder, stringBuilder, ')');
                        charutil.remove_char(stringBuilder, stringBuilder, '?');
                        charutil.remove_char(stringBuilder, stringBuilder, '$');
                        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "#", "No");
                        n7 = tAspectDriver.DriverStruct.getFieldIndex(stringBuilder.toString());
                        arrayList.add(new Integer(n7));
                        if (n7 < 0) {
                            MainWin.appendToLog("TParagonDriver", "importParagonData", Thread.currentThread(), null, 4, "Cannot locate field named >" + stringBuilder + "<");
                        }
                        if (stringArray[n].equalsIgnoreCase("MLS #")) {
                            n2 = n;
                            continue;
                        }
                        if (!stringArray[n].equalsIgnoreCase("Class")) continue;
                        n3 = n;
                    }
                    if (n3 < 0) {
                        MainWin.appendToLog("TParagon", "importParagonData", Thread.currentThread(), null, 4, "Features will not be imported because the property class field was not found in the Paragon file.");
                    }
                } else if (n2 >= 0 && stringArray.length > n2 && charutil.ival(string2 = stringArray[n2]) > 0) {
                    int n8;
                    Object object = hashtable.get(string2);
                    if (object != null) {
                        n8 = (Integer)object;
                        ++n5;
                    } else {
                        n8 = tAspectDriver.initializeNewRecord();
                        hashtable.put(string2, new Integer(n8));
                        ++n6;
                    }
                    if (stringArray.length > arrayList.size()) {
                        MainWin.appendToLog("TParagonDriver", "importParagonData", Thread.currentThread(), null, 4, "Too many fields on line " + n4);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        Date date;
                        if (n >= arrayList.size() || (object = arrayList.get(n)) == null || (n7 = ((Integer)object).intValue()) < 0) continue;
                        TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)tAspectDriver.DriverStruct.FieldColl.get(n7);
                        if (tDriverStructRecord2.FullID.equalsIgnoreCase("Geo_Code")) {
                            stringArray[n] = this.cleanupGeoCode(stringArray[n]);
                        } else if (tDriverStructRecord2.FullID.equalsIgnoreCase("Features")) {
                            if (n3 >= 0) {
                                stringArray[n] = this.cleanupFeatures(stringArray[n], stringArray[n3], string2);
                            }
                        } else if (tDriverStructRecord2.FullID.equalsIgnoreCase("Lst_Date") && (date = dateutil.parseDate(stringArray[n])) != null) {
                            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                            gregorianCalendar2.setTime(date);
                            if (gregorianCalendar2.get(1) > gregorianCalendar.get(1)) {
                                gregorianCalendar2.set(1, gregorianCalendar.get(1));
                                stringArray[n] = dateutil.formatDate(gregorianCalendar2, "MM/dd/yyyy");
                            }
                        }
                        object = objectutil.convertStringToFieldType(tDriverStructRecord2.FieldType, stringArray[n], n8);
                        tAspectDriver.putField(tDriverStructRecord2, n8, object);
                    }
                    n7 = 0;
                    for (n = 0; n7 < 8 && n < arrayList2.size(); ++n) {
                        if (((String)arrayList2.get(n)).indexOf(stringArray[n2]) <= 0) continue;
                        if (tDriverStructRecordArray[n7] != null) {
                            tAspectDriver.putField(tDriverStructRecordArray[n7], n8, arrayList2.get(n));
                        }
                        ++n7;
                    }
                }
            }
            tProgressBar.increment();
        }
        tProgressBar.dispose();
        arrayList.clear();
        arrayList = null;
        hashtable.clear();
        hashtable = null;
        arrayList2.clear();
        arrayList2 = null;
        tAsciiInput.dispose();
        tAspectDriver.dispose();
        MainWin.appendToLog("TParagonDriver", "importParagonData", Thread.currentThread(), null, 3, "Updated " + n5 + " records");
        MainWin.appendToLog("TParagonDriver", "importParagonData", Thread.currentThread(), null, 3, "Imported " + n6 + " records");
    }

    public static void importParagonData() {
        TParagon tParagon = new TParagon();
        tParagon.start();
        while (tParagon.isAlive()) {
            Thread.yield();
        }
    }

    public static void importParagonDataThread() {
        TParagon tParagon = new TParagon();
        tParagon.start();
    }

    private class TFeatureCodeColl
    extends ArrayList {
        int cCategories = 0;

        @Override
        public boolean add(TFeatureCode tFeatureCode) {
            if (this.size() == 0) {
                tFeatureCode.StartsNewCategory = true;
                ++this.cCategories;
            } else {
                TFeatureCode tFeatureCode2 = (TFeatureCode)this.get(this.size() - 1);
                if (!tFeatureCode.getCategory().equals(tFeatureCode2.getCategory())) {
                    tFeatureCode.StartsNewCategory = true;
                    ++this.cCategories;
                }
            }
            return super.add(tFeatureCode);
        }

        @Override
        public void clear() {
            super.clear();
            this.cCategories = 0;
        }

        public int countLines() {
            return super.size() + 2 * this.cCategories;
        }
    }

    private class TFeatureCode {
        String strCode = "";
        StringBuilder strCategory = new StringBuilder();
        String strPropertyClass = "";
        boolean StartsNewCategory = false;

        public TFeatureCode(String string, String string2) {
            this.strPropertyClass = string2;
            this.strCode = string.substring(1, string.length() - 1).toUpperCase();
            this.strCategory.setLength(0);
            this.strCategory.append(this.strCode.charAt(0));
            if (this.strCode.length() > 1 && this.strCode.charAt(1) > '9') {
                this.strCategory.append(this.strCode.charAt(1));
            }
        }

        public String getCode() {
            return "{$" + this.strPropertyClass + this.strCode + "}";
        }

        public String getCategory() {
            return "{$$" + this.strPropertyClass + this.strCategory + "}";
        }
    }
}

