/*
 * Decompiled with CFR 0.152.
 */
package reportwin;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TInternalFrame;
import controls.TPanel;
import controls.htmlviewer.THtmlEditorPane;
import controls.htmlviewer.THtmlViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.InternalFrameEvent;
import resources.TAppActionObject;
import resources.TAppReportsObject;
import resources.TApplication;
import scrollwin.TScrollWin;
import utility.charutil;

public class TReportWin
extends TInternalFrame
implements HyperlinkListener {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTReportWin");
    private TAppReportsObject AppReportsObj = null;
    private String strContent = "";

    public TReportWin(TAppReportsObject tAppReportsObject) {
        super(tAppReportsObject.Description);
        this.AppReportsObj = tAppReportsObject;
        this.setFrameIcon(new ImageIcon(this.MainWin.getSmallLogo()));
        this.strContent = this.Application.parse_tokens(charutil.removeQuotes(tAppReportsObject.Template));
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.Application.setTokenValue("$ReportWinID", this.AppReportsObj.ReportID);
        this.Application.AppAction.enableActionType(11, true);
        this.Application.AppAction.enableActionType(15, true);
        boolean bl = true;
        if (this.MainWin.getWindowCount() == 1) {
            bl = false;
        }
        this.Application.AppAction.enableActionType(13, bl);
        this.Application.AppAction.enableActionType(14, bl);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        if (TMainWin.Desktop.DesktopPanel != null) {
            TMainWin.Desktop.moveToBack(TMainWin.Desktop.getContentPanel());
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public void createAndShowGUI() {
        JComponent jComponent;
        this.getContentPane().setLayout(new BorderLayout());
        if (this.AppReportsObj.MenuID.length() > 0) {
            jComponent = this.Application.AppMenu.createMainMenu(this.Application.parse_tokens(this.AppReportsObj.MenuID));
            this.setJMenuBar((JMenuBar)jComponent);
        }
        block8: for (int i = 0; i < 4; ++i) {
            if (this.AppReportsObj.ToolbarID[i] == null || this.AppReportsObj.ToolbarID[i].length() <= 0 || (jComponent = this.Application.AppToolbar.makeToolbar(this, this.AppReportsObj.ToolbarID[i])) == null) continue;
            ((JToolBar)jComponent).setFloatable(false);
            switch (i) {
                case 0: {
                    this.getContentPane().add((Component)jComponent, "North");
                    continue block8;
                }
                case 1: {
                    this.getContentPane().add((Component)jComponent, "South");
                    continue block8;
                }
                case 2: {
                    ((JToolBar)jComponent).setOrientation(1);
                    this.getContentPane().add((Component)jComponent, "West");
                    continue block8;
                }
                case 3: {
                    ((JToolBar)jComponent).setOrientation(1);
                    this.getContentPane().add((Component)jComponent, "East");
                }
            }
        }
        TPanel tPanel = new TPanel();
        tPanel.setLayout(new BoxLayout(tPanel, 3));
        THtmlViewer tHtmlViewer = new THtmlViewer(new THtmlEditorPane("text/html", ""));
        tHtmlViewer.addListener(this);
        tHtmlViewer.setText(this.strContent, false, true);
        tHtmlViewer.setPreferredSize(new Dimension(500, 500));
        tPanel.add(tHtmlViewer);
        this.getContentPane().add((Component)tPanel, "Center");
        this.pack();
        TMainWin.Desktop.add(this);
        try {
            Rectangle rectangle = TMainWin.Desktop.getBounds();
            int n = (int)((double)rectangle.width * 0.1);
            int n2 = (int)((double)rectangle.height * 0.1);
            rectangle.x = TScrollWin.NewFrameLocation;
            rectangle.width -= n * 2;
            rectangle.y = TScrollWin.NewFrameLocation;
            rectangle.height -= n2 * 2;
            if (rectangle.x + rectangle.width > TMainWin.Desktop.getWidth() || rectangle.y + rectangle.height > TMainWin.Desktop.getHeight()) {
                rectangle.x = 0;
                rectangle.y = 0;
            }
            TScrollWin.NewFrameLocation = rectangle.x + TScrollWin.FrameDistance;
            this.setBounds(rectangle);
            this.setSize(rectangle.width, rectangle.height);
            this.setSelected(true);
            this.setMaximizable(this.AppReportsObj.Can_Maximize);
            this.setResizable(this.AppReportsObj.Can_Resize);
            if (this.isMaximizable() && this.AppReportsObj.MaximizeOnOpen) {
                this.setMaximum(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setVisible(true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (hyperlinkEvent.getURL() == null) {
            this.MainWin.appendToLog("THtmlViewer", "getLinkContent", Thread.currentThread(), null, 3, "Invalid hyperlink");
            return;
        }
        String string = hyperlinkEvent.getURL().toString();
        if (!string.toUpperCase().startsWith("HTTP://")) {
            return;
        }
        final String string2 = string.substring(7);
        Thread thread = new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string;
                        String[] stringArray;
                        if (string2.toUpperCase().startsWith("ACTION.")) {
                            String string2 = string2.substring(7);
                            TAppActionObject tAppActionObject = ((TReportWin)TReportWin.this).Application.AppAction.getAppActionObject(string2);
                            if (tAppActionObject != null) {
                                Aspect.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
                            }
                        } else if (string2.toUpperCase().startsWith("SCRIPT.")) {
                            String string3 = string2.substring(7);
                            Aspect.MainWin.executeScript(string3);
                        } else if (string2.toUpperCase().startsWith("DIALOG.")) {
                            String string4 = string2.substring(7);
                            String[] stringArray2 = charutil.getSubStringArray(string4, '?', true);
                            if (stringArray2 != null && stringArray2.length > 0) {
                                String string5 = stringArray2[0];
                                int n = 0;
                                if (stringArray2.length > 1) {
                                    n = charutil.ival(stringArray2[1]);
                                }
                                TMainWin.executeDialog(string5, n);
                            }
                        } else if (string2.toUpperCase().startsWith("DRIVERCMD.") && (stringArray = charutil.getSubStringArray(string = string2.substring(10), ',', true)) != null) {
                            if (stringArray.length == 1) {
                                Aspect.MainWin.executeDriverCommand(stringArray[0], "");
                            } else {
                                Aspect.MainWin.executeDriverCommand(stringArray[0], stringArray[1]);
                            }
                        }
                    }
                });
            }
        };
        thread.setPriority(1);
        thread.start();
    }
}

