/*
 * Decompiled with CFR 0.152.
 */
package resources;

import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import resources.TAppBase;
import resources.TAppDisplaysObject;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.charutil;

public class TAppDisplays
extends TAppBase {
    private TAspectDriver FDisplays = null;

    public TAppDisplays(TApplication tApplication) {
        super(tApplication);
    }

    @Override
    public Object create_resource_object(String string, TApplication tApplication, int n, int n2, long l, long l2, StringBuilder stringBuilder, String[] stringArray) {
        return new TAppDisplaysObject(string, tApplication, n, n2, l, l2, stringBuilder, stringArray);
    }

    @Override
    public String getResourceDescription() {
        return "Displays";
    }

    @Override
    public String getResourceName() {
        return "AppDisplaysFile";
    }

    @Override
    public int required_fields() {
        return 104;
    }

    public boolean openDisplaysFile() {
        if (this.FDisplays != null) {
            this.FDisplays.dispose();
        }
        TAppDriversObject tAppDriversObject = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.Application.AppDrivers != null) {
            this.Application.parse_tokens(stringBuilder, "{Driver_Binary_Displays}");
            tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(stringBuilder.toString());
            if (tAppDriversObject != null) {
                this.FDisplays = new TAspectDriver(this.Application, tAppDriversObject, 1, false, "");
                this.FDisplays.setUndoRecording(false);
                return true;
            }
        }
        return false;
    }

    public void updateLocalDisplays() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        String string = "Updating Displays ";
        if (this.FDisplays == null) {
            this.openDisplaysFile();
        }
        if (this.FDisplays != null) {
            String string2;
            int n;
            TDriverStructRecord tDriverStructRecord = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Used");
            TDriverStructRecord tDriverStructRecord2 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Description");
            TDriverStructRecord tDriverStructRecord3 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_DriverID");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (n = 0; n < this.FDisplays.getRecordCount(); ++n) {
                boolean bl = (Boolean)this.FDisplays.F.getField(tDriverStructRecord, n);
                if (!bl) continue;
                string2 = (String)this.FDisplays.getField(tDriverStructRecord2, n);
                String string3 = (String)this.FDisplays.getField(tDriverStructRecord3, n);
                String string4 = string2 + "|" + string3;
                if (hashtable.contains(string4)) continue;
                hashtable.put(string4, string4);
            }
            for (n = 0; n < this.ResourceColl.size(); ++n) {
                TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.ResourceColl.get(n);
                string2 = tAppDisplaysObject.Description + "|" + tAppDisplaysObject.DriverID;
                if (hashtable.contains(string2)) continue;
                int n2 = this.FDisplays.F.getRecordCount();
                tAppDisplaysObject.writeToFile(this.FDisplays.F, n2);
            }
        }
    }

    public boolean isPredefineDisplay(String string, String string2) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.ResourceColl.size(); ++i) {
            TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.ResourceColl.get(i);
            if (charutil.strcmpi(tAppDisplaysObject.Description, string) != 0 || charutil.strcmpi(tAppDisplaysObject.DriverID, string2) != 0) continue;
            bl = true;
        }
        return bl;
    }

    public boolean deleteDisplay(String string, String string2) {
        if (this.Application.AppDisplays.isPredefineDisplay(string, string2)) {
            JOptionPane.showMessageDialog(null, "There is a pre-defined display that cannot be deleted.", "Information...", 1);
            return false;
        }
        this.writeDisplayRecords(string, string2, null, false);
        return true;
    }

    public ArrayList getDisplayNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.FDisplays == null) {
            this.openDisplaysFile();
        }
        TDriverStructRecord tDriverStructRecord = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Description");
        TDriverStructRecord tDriverStructRecord2 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_DriverID");
        TDriverStructRecord tDriverStructRecord3 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Used");
        for (int i = 0; i < this.FDisplays.F.getRecordCount(); ++i) {
            String string2;
            String string3;
            boolean bl = (Boolean)this.FDisplays.F.getField(tDriverStructRecord3, i);
            if (!bl || !(string3 = (String)this.FDisplays.F.getField(tDriverStructRecord2, i)).trim().equalsIgnoreCase(string.trim()) || arrayList.contains(string2 = (String)this.FDisplays.F.getField(tDriverStructRecord, i))) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public ArrayList getDisplayRecords(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        ArrayList<TAppDisplaysObject> arrayList = null;
        ArrayList<TAppDisplaysObject> arrayList2 = null;
        ArrayList<TAppDisplaysObject> arrayList3 = null;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = "";
        String string4 = "";
        int n = 0;
        boolean bl2 = this.Application.getTokenValueAsBool("DebugTAppDisplays");
        if (bl2) {
            this.MainWin.appendToLog("TAppDisplays", "getDisplayRecords", Thread.currentThread(), null, 10, "Getting display records.  Driver=" + string2 + "  Name=" + string + "  UsePredefined=" + bl);
        }
        if (bl) {
            arrayList2 = new ArrayList<TAppDisplaysObject>();
            for (int i = 0; i < this.ResourceColl.size(); ++i) {
                TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.ResourceColl.get(i);
                if (charutil.strcmpi(tAppDisplaysObject.Description, string) != 0 || charutil.strcmpi(tAppDisplaysObject.DriverID, string2) != 0) continue;
                arrayList2.add(tAppDisplaysObject);
            }
            return arrayList2;
        }
        if (this.FDisplays == null) {
            this.openDisplaysFile();
        }
        if (this.FDisplays != null) {
            if (string != null) {
                n = string.length();
            }
            TDriverStructRecord tDriverStructRecord = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Description");
            TDriverStructRecord tDriverStructRecord2 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_DriverID");
            TDriverStructRecord tDriverStructRecord3 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Used");
            TDriverStructRecord tDriverStructRecord4 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_IsDefault");
            for (int i = 0; i < this.FDisplays.F.getRecordCount(); ++i) {
                boolean bl3;
                String string5;
                boolean bl4 = (Boolean)this.FDisplays.F.getField(tDriverStructRecord3, i);
                if (!bl4 || !(string5 = (String)this.FDisplays.F.getField(tDriverStructRecord2, i)).trim().equalsIgnoreCase(string2.trim())) continue;
                String string6 = (String)this.FDisplays.F.getField(tDriverStructRecord, i);
                if (n > 0) {
                    if (!string6.equalsIgnoreCase(string)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<TAppDisplaysObject>();
                    }
                    arrayList.add(new TAppDisplaysObject(this.FDisplays.F, i));
                    continue;
                }
                if (arrayList3 == null || string4.equalsIgnoreCase(string6)) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<TAppDisplaysObject>();
                        string4 = string6;
                    }
                    arrayList3.add(new TAppDisplaysObject(this.FDisplays.F, i));
                }
                if (!(bl3 = ((Boolean)this.FDisplays.F.getField(tDriverStructRecord4, i)).booleanValue()) || arrayList2 != null && !string3.equalsIgnoreCase(string6)) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                    string3 = string6;
                }
                arrayList2.add(new TAppDisplaysObject(this.FDisplays.F, i));
            }
        }
        stringBuilder.setLength(0);
        if (n > 0) {
            stringBuilder.append(string);
            return arrayList;
        }
        if (arrayList2 != null) {
            stringBuilder.append(string3);
            return arrayList2;
        }
        stringBuilder.append(string4);
        return arrayList3;
    }

    public void writeDisplayRecords(String string, String string2, ArrayList arrayList, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        Boolean bl2 = new Boolean(false);
        boolean bl3 = false;
        bl3 = this.Application.getTokenValueAsBool("DebugTAppDisplays");
        if (bl3) {
            this.MainWin.appendToLog("TAppDisplays", "writeDisplayRecords", Thread.currentThread(), null, 10, "Writing display records.  Driver=" + string2 + "  Name=" + string + "  MakeDefault=" + bl);
        }
        if (arrayList != null) {
            n2 = arrayList.size();
        }
        if (this.FDisplays == null) {
            this.openDisplaysFile();
        }
        if (this.FDisplays != null) {
            TAppDisplaysObject tAppDisplaysObject;
            int n3;
            if (bl3) {
                System.out.println("\n-----------------------------------");
                System.out.println("TAppDisplays.writeDisplayRecords: " + string);
                System.out.println("-----------------------------------");
            }
            for (n3 = 0; n3 < n2; ++n3) {
                tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(n3);
                tAppDisplaysObject.Description.setLength(0);
                tAppDisplaysObject.Description.append(string);
                if (bl) {
                    tAppDisplaysObject.IsDefault = true;
                }
                if (!bl3) continue;
                System.out.println("Item " + n3 + " Field: " + tAppDisplaysObject.StructureFieldID);
            }
            TDriverStructRecord tDriverStructRecord = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Description");
            TDriverStructRecord tDriverStructRecord2 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_DriverID");
            TDriverStructRecord tDriverStructRecord3 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_Used");
            TDriverStructRecord tDriverStructRecord4 = this.FDisplays.getDriverStructRecord("Aspect_Displays_Resource_IsDefault");
            for (n3 = 0; n3 < this.FDisplays.F.getRecordCount(); ++n3) {
                boolean bl4 = (Boolean)this.FDisplays.F.getField(tDriverStructRecord3, n3);
                if (bl4) {
                    String string3 = (String)this.FDisplays.F.getField(tDriverStructRecord2, n3);
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    String string4 = (String)this.FDisplays.F.getField(tDriverStructRecord, n3);
                    if (string4.trim().equalsIgnoreCase(string.trim())) {
                        if (n < n2) {
                            tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(n);
                            tAppDisplaysObject.writeToFile(this.FDisplays.F, n3);
                            ++n;
                            continue;
                        }
                        this.FDisplays.F.putField(tDriverStructRecord3, n3, (Object)bl2);
                        continue;
                    }
                    if (!bl) continue;
                    this.FDisplays.F.putField(tDriverStructRecord4, n3, (Object)bl2);
                    continue;
                }
                if (n >= n2) continue;
                tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(n);
                this.FDisplays.F.putField(tDriverStructRecord3, n3, (Object)Boolean.TRUE);
                tAppDisplaysObject.writeToFile(this.FDisplays.F, n3);
                ++n;
            }
            while (n < n2) {
                tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(n);
                tAppDisplaysObject.writeToFile(this.FDisplays.F, this.FDisplays.F.getRecordCount());
                ++n;
            }
        }
    }
}

