/*
 * Decompiled with CFR 0.152.
 */
package scripts;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;

public class TExecScriptDriver
extends TAbstractDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTExecScriptDriver");
    int ModifiedCount = 0;
    private Hashtable hashVariables = new Hashtable();

    public TExecScriptDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        this.getFormulaEvaluator().ExecScriptDriver = this;
    }

    @Override
    public void dispose() {
        this.hashVariables.clear();
        super.dispose();
    }

    @Override
    public int getRecordCount() {
        return 1;
    }

    @Override
    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        return false;
    }

    @Override
    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        return true;
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord == null) {
            return null;
        }
        return this.hashVariables.get(tDriverStructRecord.ID);
    }

    public TDriverStructRecord addDSRec(String string, Object object) {
        TDriverStructRecord tDriverStructRecord = null;
        if (object instanceof Double) {
            tDriverStructRecord = this.DriverStruct.getField("InitializeDouble");
        } else if (object instanceof Date) {
            tDriverStructRecord = this.DriverStruct.getField("InitializeDate");
        } else if (object instanceof String) {
            tDriverStructRecord = this.DriverStruct.getField("InitializeString");
        } else if (object instanceof Boolean) {
            tDriverStructRecord = this.DriverStruct.getField("InitializeBool");
        } else if (MainWin != null) {
            MainWin.appendToLog("TExecScriptDriver", "addDSRec", Thread.currentThread(), null, 4, "Invalid type (" + object.getClass().getName() + ") for variable " + string + " in execute script");
        } else {
            System.out.println("Invalid type (" + object.getClass().getName() + ") for variable " + string + " in execute script");
        }
        if (tDriverStructRecord != null) {
            tDriverStructRecord = new TDriverStructRecord(tDriverStructRecord);
            tDriverStructRecord.ID = string.toUpperCase();
            tDriverStructRecord.FullID = string.toUpperCase();
            tDriverStructRecord.Description = string.toUpperCase();
            this.DriverStruct.FieldColl.add(tDriverStructRecord);
            this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            this.DriverStruct.HashDescriptions.put(tDriverStructRecord.FullID, new Integer(this.DriverStruct.FieldColl.size() - 1));
            if (this.Debug) {
                MainWin.appendToLog("TExecScriptDriver", "addDSRec", Thread.currentThread(), null, 10, "Defined fields in script driver:");
                for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                    tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                    MainWin.appendToLog("TExecScriptDriver", "addDSRec", Thread.currentThread(), null, 10, "DSRec[" + i + "] = " + tDriverStructRecord.FullID);
                }
                MainWin.appendToLog("TExecScriptDriver", "addDSRec", Thread.currentThread(), null, 10, "Defined fields in hash collection:");
                Enumeration enumeration = this.DriverStruct.HashFields.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    int n = (Integer)this.DriverStruct.HashFields.get(string2);
                    MainWin.appendToLog("TExecScriptDriver", "addDSRec", Thread.currentThread(), null, 10, "Key: " + string2 + " Value: " + n);
                }
            }
        } else {
            MainWin.appendToLog("TExecScriptDriver", "addDSRec", Thread.currentThread(), null, 4, "Unable to find initialization field for variable named " + string + " in execute script.");
        }
        return tDriverStructRecord;
    }

    @Override
    public synchronized int putField(String string, int n, Object object) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            tDriverStructRecord = this.addDSRec(string, object);
        }
        return this.putField(tDriverStructRecord, n, object);
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        if (tDriverStructRecord == null) {
            return 0;
        }
        if (this.hashVariables.containsKey(tDriverStructRecord.ID)) {
            if (object.equals(this.hashVariables.get(tDriverStructRecord.ID))) {
                return 1;
            }
            this.hashVariables.remove(tDriverStructRecord.ID);
        }
        this.hashVariables.put(tDriverStructRecord.ID, object);
        ++this.ModifiedCount;
        return 1;
    }

    public Hashtable getScriptDriverValues() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        TDriverStruct tDriverStruct = this.getDriverStruct();
        for (int i = 0; i < tDriverStruct.getFieldCount(); ++i) {
            String string = tDriverStruct.getFieldID(i);
            Object object = this.getField(string, 0);
            if (object == null) continue;
            hashtable.put(string, object);
        }
        return hashtable;
    }
}

