/*
 * Decompiled with CFR 0.152.
 */
package scrollwin;

import aspect.TMainWin;
import controls.TInternalFrame;
import controls.TMenuBar;
import controls.TToolBar;
import drivers.aspect.TAspectDriver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyVetoException;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import resources.TAppDriversObject;
import resources.TAppTablesObject;
import resources.TApplication;
import scrollwin.filtertree.TScrollFilterTree;
import scrollwin.subtotaltree.TScrollSubtotalTree;
import scrollwin.table.TScrollTable;
import scrollwin.table.TScrollTableModel;
import scrollwin.table.TScrollTablePanel;
import scrollwin.toolbar.TScrollToolbar;
import utility.charutil;
import utility.objectutil;

public class TScrollWin
extends TInternalFrame
implements Printable {
    public static int NewFrameLocation = 0;
    public static int FrameDistance = 20;
    public static boolean EnableScrollWinPaint = true;
    private TMainWin MainWin;
    private boolean Debug;
    public int WindowID;
    private JDesktopPane Desktop;
    private TScrollFilterTree FilterTree = null;
    private TScrollSubtotalTree SubtotalTree = null;
    private TApplication Application;
    public TScrollTablePanel TablePanel;
    private TScrollTable Table;
    private TAppDriversObject AppDriversObject;
    private TAspectDriver AspectDriver;
    private int NumberOfPages = 1;

    public TScrollWin(TMainWin tMainWin, String string, JDesktopPane jDesktopPane, TApplication tApplication, TAppDriversObject tAppDriversObject, TAspectDriver tAspectDriver, int n) {
        super(string);
        if (!tAspectDriver.isWriteable()) {
            super.setTitle(string + " (Read-Only)");
        }
        this.MainWin = tMainWin;
        this.setFrameIcon(new ImageIcon(this.MainWin.getSmallLogo()));
        this.Debug = TMainWin.Application.getTokenValueAsBool("DebugTScrollWin");
        this.WindowID = n;
        this.Desktop = jDesktopPane;
        this.Application = tApplication;
        this.AppDriversObject = tAppDriversObject;
        this.AspectDriver = tAspectDriver;
        this.setOpaque(false);
        this.MainWin.appendToLog("TScrollWin", "init", Thread.currentThread(), null, 5, "Open " + this.AppDriversObject.Description.toString());
    }

    public void createAndShowGUI() {
        JSplitPane jSplitPane = null;
        JSplitPane jSplitPane2 = null;
        JScrollPane jScrollPane = null;
        JScrollPane jScrollPane2 = null;
        boolean bl = false;
        TAppTablesObject tAppTablesObject = this.AspectDriver.getAppTablesObject();
        if (tAppTablesObject == null) {
            this.AspectDriver.loadDisplay("");
            tAppTablesObject = this.AspectDriver.getAppTablesObject();
        }
        if (tAppTablesObject.MenuID.length() > 0) {
            TMenuBar tMenuBar = this.Application.AppMenu.createMainMenu(this.Application.parse_tokens(tAppTablesObject.MenuID));
            this.setJMenuBar(tMenuBar);
        }
        this.TablePanel = new TScrollTablePanel(this.MainWin, this, this.Application, this.AppDriversObject, this.AspectDriver);
        this.Table = this.TablePanel.Table;
        block9: for (int i = 0; i < 5; ++i) {
            TScrollToolbar tScrollToolbar;
            if (tAppTablesObject.ToolbarID[i] == null || tAppTablesObject.ToolbarID[i].length() <= 0 || (tScrollToolbar = this.Application.AppToolbar.makeToolbar(this, tAppTablesObject.ToolbarID[i])) == null) continue;
            tScrollToolbar.setFloatable(false);
            switch (i) {
                case 0: {
                    this.getContentPane().add((Component)tScrollToolbar, "North");
                    continue block9;
                }
                case 1: {
                    this.getContentPane().add((Component)tScrollToolbar, "South");
                    continue block9;
                }
                case 2: {
                    tScrollToolbar.setOrientation(1);
                    this.getContentPane().add((Component)tScrollToolbar, "West");
                    continue block9;
                }
                case 3: {
                    tScrollToolbar.setOrientation(1);
                    this.getContentPane().add((Component)tScrollToolbar, "East");
                    continue block9;
                }
                case 4: {
                    tScrollToolbar.setOrientation(1);
                    this.TablePanel.add((Component)tScrollToolbar, "West");
                }
            }
        }
        if (this.AspectDriver.DriverStruct.HasTreeNodes || this.AspectDriver.DriverStruct.HasSubtotals) {
            jSplitPane = new JSplitPane();
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerSize(7);
            this.getContentPane().add((Component)jSplitPane, "Center");
            jSplitPane.setRightComponent(this.TablePanel);
            if (this.AspectDriver.DriverStruct.HasTreeNodes) {
                this.FilterTree = this.Table.initializeFilterTree();
                this.FilterTree.setBackground(new Color(tAppTablesObject.TreeBackground));
                this.FilterTree.addTreeSelectionListener(new FilterTreeListener());
                this.FilterTree.expandRow(0);
                this.AspectDriver.setScrollFilterTree(this.FilterTree);
                jScrollPane2 = new JScrollPane(this.FilterTree);
                jScrollPane2.setBackground(new Color(tAppTablesObject.TreeBackground));
            }
            if (this.AspectDriver.DriverStruct.HasSubtotals) {
                this.SubtotalTree = this.Table.initializeSubtotalTree();
                this.SubtotalTree.setBackground(new Color(tAppTablesObject.TreeBackground));
                this.SubtotalTree.addTreeSelectionListener(new SubtotalTreeListener());
                this.SubtotalTree.expandRow(0);
                this.AspectDriver.setScrollSubtotalTree(this.SubtotalTree);
                jScrollPane = new JScrollPane(this.SubtotalTree);
                jScrollPane.setBackground(new Color(tAppTablesObject.TreeBackground));
            }
            if (this.FilterTree != null && this.SubtotalTree != null) {
                jSplitPane2 = new JSplitPane(0, true);
                jSplitPane2.setResizeWeight(0.5);
                jSplitPane2.setOneTouchExpandable(true);
                jSplitPane2.setDividerSize(7);
                jSplitPane.setLeftComponent(jSplitPane2);
                jSplitPane2.setTopComponent(jScrollPane2);
                jSplitPane2.setBottomComponent(jScrollPane);
            } else if (this.FilterTree != null) {
                jSplitPane.setLeftComponent(jScrollPane2);
            } else if (this.SubtotalTree != null) {
                jSplitPane.setLeftComponent(jScrollPane);
            }
        } else {
            this.getContentPane().add((Component)this.TablePanel, "Center");
        }
        if (this.SubtotalTree != null) {
            if (!this.SubtotalTree.showDetails()) {
                this.AspectDriver.AspectDriverFilter.removeFromFilteredList(0);
            }
            this.AspectDriver.AspectDriverFilter.addSubtotalsToFilteredList();
        }
        this.Desktop.add(this);
        try {
            Rectangle rectangle = this.Desktop.getBounds();
            int n = (int)((double)rectangle.width * 0.1);
            int n2 = (int)((double)rectangle.height * 0.1);
            rectangle.x = NewFrameLocation;
            rectangle.width -= n * 2;
            rectangle.y = NewFrameLocation;
            rectangle.height -= n2 * 2;
            if (rectangle.x + rectangle.width > TMainWin.Desktop.getWidth() || rectangle.y + rectangle.height > TMainWin.Desktop.getHeight()) {
                rectangle.x = 0;
                rectangle.y = 0;
            }
            NewFrameLocation = rectangle.x + FrameDistance;
            if (tAppTablesObject.WindowW != 0) {
                rectangle.x = tAppTablesObject.WindowX;
                rectangle.width = tAppTablesObject.WindowW;
            }
            if (tAppTablesObject.WindowH != 0) {
                rectangle.y = tAppTablesObject.WindowY;
                rectangle.height = tAppTablesObject.WindowH;
            }
            this.setBounds(rectangle);
            this.setSize(rectangle.width, rectangle.height);
            this.setSelected(true);
            this.setMaximizable(tAppTablesObject.CanMaximize);
            this.setResizable(tAppTablesObject.CanResize);
            this.setBackground(new Color(tAppTablesObject.TableBackground));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (jSplitPane != null) {
            jSplitPane.setDividerLocation(0.25);
        }
        if (jSplitPane2 != null) {
            jSplitPane2.setDividerLocation(0.7);
        }
        this.setVisible(true);
        if (this.isMaximizable() && tAppTablesObject.MaximizeOnOpen) {
            this.setMaximum(true);
        }
        this.TablePanel.initializeDividers();
        if (this.Table.getRowCount() > 0) {
            this.Table.setRowSelectionInterval(0, 0);
        }
        this.Table.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        this.MainWin.appendToLog("TScrollWin", "dispose", Thread.currentThread(), null, 6, "Close " + this.AppDriversObject.Description.toString());
        if (!TMainWin.IsClosing) {
            Component[] componentArray = this.getContentPane().getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof TToolBar) {
                    ((TToolBar)componentArray[i]).dispose();
                    this.getContentPane().remove(componentArray[i]);
                    continue;
                }
                if (!(componentArray[i] instanceof JMenuBar)) continue;
                this.getContentPane().remove(componentArray[i]);
            }
        }
        this.Table.shutDownTable();
        super.dispose();
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.Application.setTokenValue("$ScrollWinID", Integer.toString(this.WindowID));
        if (!this.Application.getTokenValue("$ScrollWinFileID").equals(this.AppDriversObject.DriverID.toString())) {
            this.Application.setTokenValue("$ScrollWinFileID", this.AppDriversObject.DriverID.toString());
        }
        this.Application.setTokenValue("$ScrollWinDisplayName", this.AspectDriver.AspectDriverFilter.DisplayName.toString());
        this.Application.setTokenValue("$ScrollWinDisplayAutoResize", Boolean.toString(this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj.AutoResize));
        this.Application.setTokenValue("$ScrollWinDisplayAdvancedFilter", this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj.AdvancedFilter);
        this.Application.AppAction.enableDriverCommands(this.Table.getSupportedDriverCommands());
        this.MainWin.enableMainWinToolbarDriverCommands(true, this.Table.getSupportedDriverCommands());
        this.Application.AppAction.enableActionType(11, true);
        this.Application.AppAction.enableActionType(15, true);
        boolean bl = true;
        if (this.MainWin.getWindowCount() == 1) {
            bl = false;
        }
        this.Application.AppAction.enableActionType(13, bl);
        this.Application.AppAction.enableActionType(14, bl);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.MainWin.ScrollWinClosed(this, this.WindowID);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.Table.shutDownTable();
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        if (TMainWin.Desktop.DesktopPanel != null) {
            TMainWin.Desktop.moveToBack(TMainWin.Desktop.getContentPanel());
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public boolean isInDialog() {
        TScrollTableModel tScrollTableModel = this.Table.getTableModel();
        return tScrollTableModel.D != null && tScrollTableModel.D.isVisible();
    }

    public int getID() {
        return this.WindowID;
    }

    public String getFileID() {
        return this.AppDriversObject.DriverID.toString();
    }

    @Override
    public void paint(Graphics graphics) {
        if (EnableScrollWinPaint) {
            super.paint(graphics);
        }
    }

    @Override
    public void update(Graphics graphics) {
        super.update(graphics);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        TPagePrinter tPagePrinter = new TPagePrinter(graphics, pageFormat, n);
        return tPagePrinter.print();
    }

    public class TPagePrinter {
        TScrollTable table;
        TableModel tableModel;
        TableColumnModel ColumnModel;
        Graphics g;
        PageFormat pageFormat;
        double FontRatio;
        float PrintFontSize;
        int[] x;
        int PageWidth;
        int PageHeight;
        int NumColumns;
        int pageIndex;

        public TPagePrinter(Graphics graphics, PageFormat pageFormat, int n) {
            this.g = graphics;
            this.pageFormat = pageFormat;
            this.pageIndex = n;
            this.table = TScrollWin.this.TablePanel.Table;
            this.tableModel = this.table.getModel();
            this.ColumnModel = this.table.getColumnModel();
            this.NumColumns = this.ColumnModel.getColumnCount();
            this.x = new int[this.NumColumns];
            this.g.translate((int)this.pageFormat.getImageableX(), (int)this.pageFormat.getImageableY());
            if (this.pageFormat.getOrientation() == 1) {
                this.PageWidth = (int)this.pageFormat.getImageableWidth();
                this.PageHeight = (int)this.pageFormat.getImageableHeight();
            } else {
                this.PageWidth = (int)this.pageFormat.getImageableWidth();
                this.PageHeight = (int)this.pageFormat.getImageableHeight();
            }
            this.g.setClip(0, 0, this.PageWidth, this.PageHeight);
        }

        public void getFontToFit() {
            int n = 0;
            for (int i = 0; i < this.NumColumns; ++i) {
                n += this.ColumnModel.getColumn(i).getWidth();
            }
            double d = (double)this.PageWidth / (double)n;
            if (d > 1.0) {
                Font font = this.table.getFont();
                return;
            }
            Font font = this.table.getFont();
            Graphics graphics = this.table.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = fontMetrics.stringWidth("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
            this.PrintFontSize = font.getSize();
            boolean bl = false;
            do {
                Font font2 = font.deriveFont(1, this.PrintFontSize);
                this.g.setFont(font2);
                FontMetrics fontMetrics2 = this.g.getFontMetrics();
                int n3 = fontMetrics2.stringWidth("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
                this.FontRatio = (double)n3 / (double)n2;
                if (this.FontRatio > d * 1.0) {
                    this.PrintFontSize = (float)((double)this.PrintFontSize - 0.25);
                    continue;
                }
                bl = true;
            } while (!bl && this.PrintFontSize > 1.0f);
        }

        public int printTitle(int n) {
            int n2 = n;
            Font font = this.table.getFont();
            this.g.setFont(font.deriveFont(1, font.getSize() + 2));
            this.g.setColor(Color.black);
            FontMetrics fontMetrics = this.g.getFontMetrics();
            this.g.drawString(TScrollWin.this.getTitle(), 0, n2 += this.g.getFontMetrics().getAscent());
            return n2 += fontMetrics.getHeight() * 1;
        }

        public int printColumnHeaders(int n) {
            String[] stringArray;
            String string;
            TableColumn tableColumn;
            int n2;
            int n3 = n;
            int n4 = 1;
            for (n2 = 0; n2 < this.NumColumns; ++n2) {
                tableColumn = this.ColumnModel.getColumn(n2);
                string = (String)tableColumn.getHeaderValue();
                stringArray = charutil.getSubStringArray(string, '\n', true);
                if (stringArray == null) continue;
                n4 = Math.max(n4, stringArray.length);
            }
            String[] stringArray2 = new String[n4];
            this.g.setFont(this.table.getFont().deriveFont(1, this.PrintFontSize));
            FontMetrics fontMetrics = this.g.getFontMetrics();
            int n5 = fontMetrics.getHeight();
            n3 += fontMetrics.getAscent();
            boolean bl = false;
            this.x[0] = 0;
            int n6 = 0;
            do {
                int n7;
                if (this.x[n6] + (n7 = (int)((double)(tableColumn = this.ColumnModel.getColumn(n6)).getWidth() * this.FontRatio)) <= this.PageWidth) {
                    if (n6 + 1 < this.NumColumns) {
                        this.x[n6 + 1] = this.x[n6] + n7;
                    }
                    if ((stringArray = charutil.getSubStringArray(string = (String)tableColumn.getHeaderValue(), '\n', true)) != null) {
                        int n8 = 0;
                        for (n2 = n4 - 1; n2 >= 0; --n2) {
                            if (n8 < stringArray.length) {
                                stringArray2[n2] = stringArray[n8];
                                ++n8;
                                continue;
                            }
                            stringArray2[n2] = "";
                        }
                        for (n2 = 0; n2 < n4; ++n2) {
                            this.g.drawString(stringArray2[n2], this.x[n6], n3 + n2 * n5);
                        }
                    }
                } else {
                    bl = true;
                }
                if (++n6 >= this.NumColumns) continue;
                this.x[n6] = this.x[n6 - 1] + n7;
            } while (n6 < this.NumColumns && !bl);
            return n3 += n4 * n5;
        }

        public int printColums(int n) {
            int n2 = n;
            this.g.setFont(this.table.getFont().deriveFont(this.PrintFontSize));
            FontMetrics fontMetrics = this.g.getFontMetrics();
            int n3 = fontMetrics.getHeight();
            int n4 = (int)((double)n3 * 1.0);
            int n5 = (this.PageHeight - n2) / n4;
            TScrollWin.this.NumberOfPages = Math.max((int)Math.ceil((double)this.table.getRowCount() / (double)n5), 1);
            int n6 = this.pageIndex * n5;
            int n7 = Math.min(this.table.getRowCount(), n6 + n5);
            Rectangle rectangle = this.g.getClipBounds();
            for (int i = n6; i < n7; ++i) {
                for (int j = 0; j < this.NumColumns; ++j) {
                    int n8 = this.table.getColumnModel().getColumn(j).getModelIndex();
                    Object object = this.tableModel.getValueAt(i, n8);
                    String string = objectutil.convertToString(object);
                    if (j < this.NumColumns - 1) {
                        this.g.setClip(0, rectangle.y, this.x[j + 1] - 10, rectangle.height);
                    } else {
                        this.g.setClip(0, rectangle.y, rectangle.width, rectangle.height);
                    }
                    this.g.setColor(Color.black);
                    this.g.drawString(string, this.x[j], n2);
                }
                n2 += n3;
            }
            this.g.setClip(rectangle);
            return n2;
        }

        public int print() {
            int n = 0;
            this.getFontToFit();
            if (this.pageIndex >= TScrollWin.this.NumberOfPages) {
                return 1;
            }
            n = this.printTitle(n);
            n = this.printColumnHeaders(n);
            n = this.printColums(n);
            return 0;
        }
    }

    public class SubtotalTreeListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        }
    }

    public class FilterTreeListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        }
    }
}

