/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.filtertree;

import controls.TCheckBox;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import scrollwin.filtertree.TScrollFilterTreeNodeEvent;
import scrollwin.filtertree.TScrollFilterTreeNodeListenerInterface;
import utility.charutil;

public class TScrollFilterTreeNode
extends DefaultMutableTreeNode
implements Comparable,
ChangeListener {
    public String DriverID = "";
    private ArrayList arListeners = null;
    public String Description = "";
    public TDriverStructRecord DSRec = null;
    public int Record = 0;
    public Object Value = null;
    public TCheckBox CheckBox = null;
    public String ParentDescription = "";

    public TScrollFilterTreeNode(String string, boolean bl) {
        super(string.replace('\\', ' '));
        this.Description = string.replace('\\', ' ');
        this.DSRec = null;
        this.Record = -1;
        this.Value = null;
        this.CheckBox = new TCheckBox(this.Description);
        this.CheckBox.setToolTipText(charutil.wrapAsHtml(this.Description));
        this.CheckBox.setSelected(bl);
        this.CheckBox.addChangeListener(this);
    }

    public TScrollFilterTreeNode(String string, String string2, TDriverStructRecord tDriverStructRecord, boolean bl) {
        super(string2.replace('\\', ' '));
        this.DriverID = string;
        this.Description = string2.replace('\\', ' ');
        this.DSRec = tDriverStructRecord;
        this.Record = -1;
        this.Value = null;
        this.CheckBox = new TCheckBox(this.Description);
        this.CheckBox.setToolTipText(charutil.wrapAsHtml(this.Description));
        this.CheckBox.setSelected(bl);
        this.CheckBox.addChangeListener(this);
    }

    public TScrollFilterTreeNode(String string, String string2, TDriverStructRecord tDriverStructRecord, int n, Object object, boolean bl, String string3) {
        super(string2.replace('\\', ' '));
        this.DriverID = string;
        this.Description = string2.replace('\\', ' ');
        this.DSRec = tDriverStructRecord;
        this.Record = n;
        this.Value = object;
        this.ParentDescription = string3;
        this.CheckBox = new TCheckBox(this.Description);
        this.CheckBox.setToolTipText(charutil.wrapAsHtml(this.Description));
        this.CheckBox.setSelected(bl);
        this.CheckBox.addChangeListener(this);
    }

    public TScrollFilterTreeNode(TScrollFilterTreeNode tScrollFilterTreeNode) {
        this.DriverID = tScrollFilterTreeNode.DriverID;
        this.Description = tScrollFilterTreeNode.Description;
        if (tScrollFilterTreeNode.DSRec != null) {
            this.DSRec = new TDriverStructRecord(tScrollFilterTreeNode.DSRec);
        }
        this.Record = tScrollFilterTreeNode.Record;
        this.Value = tScrollFilterTreeNode.Value;
        this.CheckBox = new TCheckBox(this.Description);
        this.CheckBox.setToolTipText(charutil.wrapAsHtml(this.Description));
        this.CheckBox.setSelected(tScrollFilterTreeNode.isSelected());
        this.CheckBox.addChangeListener(this);
        if (tScrollFilterTreeNode.arListeners != null) {
            this.arListeners = new ArrayList();
            for (int i = 0; i < tScrollFilterTreeNode.arListeners.size(); ++i) {
                this.arListeners.add(tScrollFilterTreeNode.arListeners.get(i));
            }
        }
    }

    public void dispose() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ((TScrollFilterTreeNode)enumeration.nextElement()).dispose();
        }
        if (this.arListeners != null) {
            while (this.arListeners.size() > 0) {
                this.arListeners.remove(0);
            }
        }
    }

    public void addListener(TScrollFilterTreeNodeListenerInterface tScrollFilterTreeNodeListenerInterface) {
        if (this.arListeners == null) {
            this.arListeners = new ArrayList();
        }
        this.arListeners.add(tScrollFilterTreeNodeListenerInterface);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.arListeners != null) {
            TScrollFilterTreeNodeEvent tScrollFilterTreeNodeEvent = new TScrollFilterTreeNodeEvent(this);
            for (int i = 0; i < this.arListeners.size(); ++i) {
                ((TScrollFilterTreeNodeListenerInterface)this.arListeners.get(i)).filterTreeNodeChanged(tScrollFilterTreeNodeEvent);
            }
        }
    }

    public boolean isSelected() {
        return this.CheckBox.isSelected();
    }

    public int compareTo(Object object) {
        int n = this.ParentDescription.compareToIgnoreCase(((TScrollFilterTreeNode)object).ParentDescription);
        if (n == 0) {
            n = this.Description.compareToIgnoreCase(((TScrollFilterTreeNode)object).Description);
        }
        return n;
    }

    public void selectAllParents(boolean bl) {
        TScrollFilterTreeNode tScrollFilterTreeNode = this;
        do {
            if ((tScrollFilterTreeNode = (TScrollFilterTreeNode)tScrollFilterTreeNode.getParent()) == null) continue;
            tScrollFilterTreeNode.CheckBox.setSelected(bl);
        } while (tScrollFilterTreeNode != null);
    }

    public void selectAllSiblings(boolean bl) {
        TScrollFilterTreeNode tScrollFilterTreeNode = (TScrollFilterTreeNode)this.getParent();
        if (tScrollFilterTreeNode != null) {
            Enumeration<TreeNode> enumeration = tScrollFilterTreeNode.children();
            while (enumeration.hasMoreElements()) {
                TScrollFilterTreeNode tScrollFilterTreeNode2 = (TScrollFilterTreeNode)enumeration.nextElement();
                if (tScrollFilterTreeNode2.equals(this)) continue;
                tScrollFilterTreeNode2.CheckBox.setSelected(bl);
            }
        }
    }

    public void selectAllChildren(boolean bl) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TScrollFilterTreeNode tScrollFilterTreeNode = (TScrollFilterTreeNode)enumeration.nextElement();
            tScrollFilterTreeNode.CheckBox.setSelected(bl);
            tScrollFilterTreeNode.selectAllChildren(bl);
        }
    }

    public boolean hasSelectedElement() {
        boolean bl = false;
        for (int i = 0; !bl && i < this.getChildCount(); ++i) {
            TScrollFilterTreeNode tScrollFilterTreeNode = (TScrollFilterTreeNode)this.getChildAt(i);
            bl = tScrollFilterTreeNode.CheckBox.isSelected() ? true : tScrollFilterTreeNode.hasSelectedElement();
        }
        return bl;
    }
}

