/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import aspect.TMainWin;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.border.MatteBorder;
import resources.TActionObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.objectutil;

public class TScrollToolbarCheckBox
extends JCheckBox
implements TScrollToolbarControlInterface {
    private TApplication Application = TMainWin.Application;
    private TAppToolbarObject AppToolbarObject;

    public TScrollToolbarCheckBox(TScrollToolbar tScrollToolbar, TAppToolbarObject tAppToolbarObject, TActionObject tActionObject) {
        super(tActionObject);
        this.AppToolbarObject = tAppToolbarObject;
        if (!this.AppToolbarObject.DisplayText) {
            this.setText("");
        } else if (this.AppToolbarObject.LabelText.length() > 0) {
            this.setText(this.AppToolbarObject.LabelText);
        }
        if (!this.AppToolbarObject.FontName.equalsIgnoreCase("default") || this.AppToolbarObject.FontSize != 0 || this.AppToolbarObject.FontStyle != 0) {
            objectutil.setFont(this, this.AppToolbarObject.FontName, this.AppToolbarObject.FontSize, this.AppToolbarObject.FontStyle);
            this.setForeground(new Color(this.AppToolbarObject.FontColor));
        }
        if (this.AppToolbarObject.LeftMargin > 0) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, this.AppToolbarObject.LeftMargin, 0, 0, tScrollToolbar.getBackground());
            this.setBorder(BorderFactory.createCompoundBorder(matteBorder, this.getBorder()));
        }
        if (this.AppToolbarObject.AssociatedToken.length() > 0 && this.Application.getTokenValueAsBool(this.AppToolbarObject.AssociatedToken)) {
            this.setSelected(true);
        }
        this.addActionListener(tScrollToolbar.getToolbarListener());
    }

    @Override
    public boolean isTokenControl() {
        return false;
    }

    @Override
    public void update(String string, String string2) {
        if (string2.equalsIgnoreCase("true")) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }

    @Override
    public String getTokenID() {
        return this.AppToolbarObject.AssociatedToken;
    }

    @Override
    public String getControlValue() {
        if (this.isSelected()) {
            return "true";
        }
        return "false";
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return this.AppToolbarObject;
    }
}

