/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import aspect.TMainWin;
import collections.TComboBoxColl;
import controls.TComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.border.MatteBorder;
import resources.TActionObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scrollwin.TScrollWin;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.objectutil;

public class TScrollToolbarDisplaySelection
extends TComboBox
implements TScrollToolbarControlInterface {
    private TApplication Application = TMainWin.Application;
    private TAppToolbarObject AppToolbarObject;
    private Component Parent;

    public TScrollToolbarDisplaySelection(TScrollToolbar tScrollToolbar, TAppToolbarObject tAppToolbarObject, TActionObject tActionObject, Component component, TComboBoxColl tComboBoxColl, int n) {
        super(tComboBoxColl, n);
        this.AppToolbarObject = tAppToolbarObject;
        this.Parent = component;
        Dimension dimension = this.AppToolbarObject.Width != 0 && this.AppToolbarObject.Height != 0 ? new Dimension(this.AppToolbarObject.Width, this.AppToolbarObject.Height) : new Dimension(200, 20);
        if (!this.AppToolbarObject.FontName.equalsIgnoreCase("default") || this.AppToolbarObject.FontSize != 0 || this.AppToolbarObject.FontStyle != 0) {
            objectutil.setFont(this, this.AppToolbarObject.FontName, this.AppToolbarObject.FontSize, this.AppToolbarObject.FontStyle);
            this.setForeground(new Color(this.AppToolbarObject.FontColor));
        }
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        if (this.AppToolbarObject.LeftMargin > 0) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, this.AppToolbarObject.LeftMargin, 0, 0, tScrollToolbar.getBackground());
            this.setBorder(BorderFactory.createCompoundBorder(matteBorder, this.getBorder()));
        }
    }

    @Override
    public boolean isTokenControl() {
        return true;
    }

    public void update() {
        String string = this.Application.getTokenValue("$ScrollWinFileID");
        if (string.length() == 0) {
            return;
        }
        Action action = this.getAction();
        this.setAction(null);
        String string2 = this.Application.getTokenValue("Collection_Display_Names");
        String string3 = this.Application.getTokenValue("$ScrollWinDisplayName");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("parse(Aspect_Displays_Resource_DriverID)=" + string);
        TComboBoxColl tComboBoxColl = this.Application.AppCollections.getCollection(string2, stringBuilder, null, false, "", "");
        this.setComboBoxColl(tComboBoxColl, string3);
        this.setAction(action);
    }

    @Override
    public void update(String string, String string2) {
        Action action = this.getAction();
        this.setAction(null);
        if (string2.length() > 0) {
            if (string.equalsIgnoreCase("$ScrollWinDisplayName") || string.equalsIgnoreCase("$ScrollWinFileID")) {
                if (this.Parent instanceof TMainWin) {
                    this.update();
                } else if (this.Parent instanceof TScrollWin && ((TScrollWin)this.Parent).isSelected()) {
                    this.update();
                }
            } else if (string.equalsIgnoreCase("$ScrollWinUpdateDisplayCollections")) {
                this.update();
            }
        }
        this.setAction(action);
    }

    @Override
    public String getTokenID() {
        return this.AppToolbarObject.AssociatedToken;
    }

    @Override
    public String getControlValue() {
        return (String)this.getSelectedKey();
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return this.AppToolbarObject;
    }
}

