/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import java.awt.Color;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import resources.TAppActionObject;
import resources.TAppToolbarObject;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.objectutil;

public class TScrollToolbarLabel
extends JLabel
implements TScrollToolbarControlInterface {
    private TAppToolbarObject AppToolbarObject;
    private TAppActionObject AppActionObject;

    public TScrollToolbarLabel(TScrollToolbar tScrollToolbar, TAppToolbarObject tAppToolbarObject, TAppActionObject tAppActionObject) {
        Serializable serializable;
        this.AppToolbarObject = tAppToolbarObject;
        this.AppActionObject = tAppActionObject;
        if (this.AppToolbarObject.LabelText.length() > 0) {
            this.setText(this.AppToolbarObject.LabelText);
        } else if (tAppActionObject != null) {
            this.setText(tAppActionObject.Description);
        }
        objectutil.setFont(this, this.AppToolbarObject.FontName, this.AppToolbarObject.FontSize, this.AppToolbarObject.FontStyle);
        this.setForeground(new Color(this.AppToolbarObject.FontColor));
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        if (this.AppToolbarObject.Width != 0 && this.AppToolbarObject.Height != 0) {
            serializable = new Dimension(this.AppToolbarObject.Width, this.AppToolbarObject.Height);
            this.setPreferredSize((Dimension)serializable);
            this.setMaximumSize((Dimension)serializable);
        }
        if (this.AppToolbarObject.LeftMargin > 0) {
            serializable = BorderFactory.createMatteBorder(0, this.AppToolbarObject.LeftMargin, 0, 0, tScrollToolbar.getBackground());
            this.setBorder(BorderFactory.createCompoundBorder((Border)((Object)serializable), this.getBorder()));
        }
    }

    @Override
    public boolean isTokenControl() {
        return false;
    }

    @Override
    public void update(String string, String string2) {
    }

    @Override
    public String getTokenID() {
        return "";
    }

    @Override
    public String getControlValue() {
        return "";
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return this.AppToolbarObject;
    }

    public void setHorizontalTextAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setHorizontalAlignment(0);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(4);
                break;
            }
            case 4: {
                this.setHorizontalAlignment(10);
                break;
            }
            case 5: {
                this.setHorizontalAlignment(11);
            }
        }
    }

    public void setVerticalTextAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setVerticalAlignment(0);
                break;
            }
            case 1: {
                this.setVerticalAlignment(1);
                break;
            }
            case 2: {
                this.setVerticalAlignment(3);
            }
        }
    }

    public void setHorizontalIconAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setHorizontalTextPosition(0);
                break;
            }
            case 1: {
                this.setHorizontalTextPosition(4);
                break;
            }
            case 2: {
                this.setHorizontalTextPosition(2);
                break;
            }
            case 4: {
                this.setHorizontalTextPosition(11);
                break;
            }
            case 5: {
                this.setHorizontalTextPosition(10);
            }
        }
    }

    public void setVerticalIconAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setVerticalTextPosition(0);
                break;
            }
            case 1: {
                this.setVerticalTextPosition(3);
                break;
            }
            case 2: {
                this.setVerticalTextPosition(1);
            }
        }
    }
}

