/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import aspect.Aspect;
import aspect.TMainWin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import resources.TActionObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.TFormulaEvaluator;
import utility.objectutil;

public class TScrollToolbarScriptButton
extends JButton
implements TScrollToolbarControlInterface {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private TAppToolbarObject AppToolbarObject;

    public TScrollToolbarScriptButton(TScrollToolbar tScrollToolbar, TAppToolbarObject tAppToolbarObject, TActionObject tActionObject) {
        super(tActionObject);
        Object object;
        Object object2;
        boolean bl = false;
        this.AppToolbarObject = tAppToolbarObject;
        this.setMargin(new Insets(0, 0, 0, 0));
        if (this.AppToolbarObject.Width != 0 && this.AppToolbarObject.Height != 0) {
            object2 = new Dimension(this.AppToolbarObject.Width, this.AppToolbarObject.Height);
            this.setPreferredSize((Dimension)object2);
            this.setMinimumSize((Dimension)object2);
        }
        if (this.AppToolbarObject.ImageName.length() > 0) {
            object2 = new TFormulaEvaluator().getFormulaValue(this.AppToolbarObject.ImageName, 0, 0);
            object = objectutil.convertToString(object2);
            tActionObject.setIcon(this.Application.parse_tokens((String)object), "");
        }
        if ((object2 = this.getIcon()) != null) {
            ((ImageIcon)object2).setImageObserver(this);
            ((ImageIcon)object2).getImage().flush();
            bl = true;
        }
        if (!this.AppToolbarObject.DisplayText) {
            if (object2 != null) {
                this.setText("");
            }
        } else if (this.AppToolbarObject.LabelText.length() > 0) {
            this.setText(this.AppToolbarObject.LabelText);
        }
        if (!this.AppToolbarObject.FontName.equalsIgnoreCase("default") || this.AppToolbarObject.FontSize != 0 || this.AppToolbarObject.FontStyle != 0) {
            objectutil.setFont(this, this.AppToolbarObject.FontName, this.AppToolbarObject.FontSize, this.AppToolbarObject.FontStyle);
            this.setForeground(new Color(this.AppToolbarObject.FontColor));
        }
        if (this.AppToolbarObject.LeftMargin > 0) {
            object = BorderFactory.createMatteBorder(0, this.AppToolbarObject.LeftMargin, 0, 0, tScrollToolbar.getBackground());
            this.setBorder(BorderFactory.createCompoundBorder((Border)object, this.getBorder()));
        }
        if (!bl && this.getText().trim().length() == 0) {
            this.MainWin.appendToLog("TScrollToolbarScriptButton", "init", Thread.currentThread(), null, 4, "Toolbar button with ID " + this.AppToolbarObject.UnparsedID + " has neither a text label or icon.");
            this.setText("Unlabelled button");
        }
    }

    @Override
    public boolean isTokenControl() {
        return false;
    }

    @Override
    public void update(String string, String string2) {
    }

    @Override
    public String getTokenID() {
        return this.AppToolbarObject.AssociatedToken;
    }

    @Override
    public String getControlValue() {
        return "";
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return this.AppToolbarObject;
    }

    public void setHorizontalTextAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setHorizontalAlignment(0);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(4);
                break;
            }
            case 4: {
                this.setHorizontalAlignment(10);
                break;
            }
            case 5: {
                this.setHorizontalAlignment(11);
            }
        }
    }

    public void setVerticalTextAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setVerticalAlignment(0);
                break;
            }
            case 1: {
                this.setVerticalAlignment(1);
                break;
            }
            case 2: {
                this.setVerticalAlignment(3);
            }
        }
    }

    public void setHorizontalIconAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setHorizontalTextPosition(0);
                break;
            }
            case 1: {
                this.setHorizontalTextPosition(4);
                break;
            }
            case 2: {
                this.setHorizontalTextPosition(2);
                break;
            }
            case 4: {
                this.setHorizontalTextPosition(11);
                break;
            }
            case 5: {
                this.setHorizontalTextPosition(10);
            }
        }
    }

    public void setVerticalIconAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: {
                this.setVerticalTextPosition(0);
                break;
            }
            case 1: {
                this.setVerticalTextPosition(3);
                break;
            }
            case 2: {
                this.setVerticalTextPosition(1);
            }
        }
    }
}

