/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import aspect.TMainWin;
import java.awt.Color;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import resources.TActionObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.objectutil;

public class TScrollToolbarTokenLabel
extends JLabel
implements TScrollToolbarControlInterface {
    private TApplication Application = TMainWin.Application;
    private TAppToolbarObject AppToolbarObject;
    private TActionObject ActionObject;

    public TScrollToolbarTokenLabel(TScrollToolbar tScrollToolbar, TAppToolbarObject tAppToolbarObject, TActionObject tActionObject) {
        Serializable serializable;
        this.AppToolbarObject = tAppToolbarObject;
        this.ActionObject = tActionObject;
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        if (this.AppToolbarObject.Width != 0 && this.AppToolbarObject.Height != 0) {
            serializable = new Dimension(this.AppToolbarObject.Width, this.AppToolbarObject.Height);
            this.setPreferredSize((Dimension)serializable);
            this.setMaximumSize((Dimension)serializable);
        }
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        if (!this.AppToolbarObject.FontName.equalsIgnoreCase("default") || this.AppToolbarObject.FontSize != 0 || this.AppToolbarObject.FontStyle != 0) {
            objectutil.setFont(this, this.AppToolbarObject.FontName, this.AppToolbarObject.FontSize, this.AppToolbarObject.FontStyle);
            this.setForeground(new Color(this.AppToolbarObject.FontColor));
        }
        if (this.AppToolbarObject.Width != 0 && this.AppToolbarObject.Height != 0) {
            serializable = new Dimension(this.AppToolbarObject.Width, this.AppToolbarObject.Height);
            this.setPreferredSize((Dimension)serializable);
            this.setMaximumSize((Dimension)serializable);
        }
        if (this.AppToolbarObject.LeftMargin > 0) {
            serializable = BorderFactory.createMatteBorder(0, this.AppToolbarObject.LeftMargin, 0, 0, tScrollToolbar.getBackground());
            this.setBorder(BorderFactory.createCompoundBorder((Border)((Object)serializable), this.getBorder()));
        }
        this.update();
    }

    @Override
    public boolean isTokenControl() {
        return true;
    }

    public void update() {
        this.update("", this.Application.getTokenValue(this.AppToolbarObject.AssociatedToken));
    }

    @Override
    public void update(String string, String string2) {
        this.setText(string2);
    }

    @Override
    public String getTokenID() {
        return this.AppToolbarObject.AssociatedToken;
    }

    @Override
    public String getControlValue() {
        return "";
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return this.AppToolbarObject;
    }
}

