/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.objectutil;

public class TDriverMerge {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDriverMerge");
    boolean AppendNewRecords = false;
    TAspectDriver DestDriver = null;
    String DestFilter = "";
    TAspectDriver SrcDriver = null;
    String SrcFilter = "";
    String strKeyFields = "";
    String strFieldsToMerge = "";
    String strAliasFields = "";
    boolean NewRecordsOnly = false;
    String strLogDriverID = "";
    private static String CounterName = null;

    public TDriverMerge(boolean bl, TAspectDriver tAspectDriver, String string, TAspectDriver tAspectDriver2, String string2, String string3, String string4, String string5, boolean bl2) {
        this.AppendNewRecords = bl;
        this.DestDriver = tAspectDriver;
        this.DestFilter = string.trim();
        this.SrcDriver = tAspectDriver2;
        this.SrcFilter = string2.trim();
        this.strKeyFields = string3;
        this.strFieldsToMerge = string4;
        this.strAliasFields = string5;
        this.NewRecordsOnly = bl2;
    }

    public TDriverMerge(boolean bl, TAspectDriver tAspectDriver, String string, TAspectDriver tAspectDriver2, String string2, String string3, String string4, boolean bl2) {
        this.AppendNewRecords = bl;
        this.DestDriver = tAspectDriver;
        this.DestFilter = string.trim();
        this.SrcDriver = tAspectDriver2;
        this.SrcFilter = string2.trim();
        this.strKeyFields = string3;
        this.strFieldsToMerge = string4;
        this.NewRecordsOnly = bl2;
    }

    public TDriverMerge(boolean bl, TAspectDriver tAspectDriver, TAspectDriver tAspectDriver2, String string, String string2, boolean bl2) {
        this.AppendNewRecords = bl;
        this.DestDriver = tAspectDriver;
        this.SrcDriver = tAspectDriver2;
        this.strKeyFields = string;
        this.strFieldsToMerge = string2;
        this.NewRecordsOnly = bl2;
    }

    public TDriverMerge(boolean bl, TAspectDriver tAspectDriver, TAspectDriver tAspectDriver2, String string, boolean bl2) {
        this.AppendNewRecords = bl;
        this.DestDriver = tAspectDriver;
        this.SrcDriver = tAspectDriver2;
        this.strKeyFields = string;
        this.NewRecordsOnly = bl2;
    }

    public static void counterAddEvent(String string, String string2) {
        if (CounterName == null) {
            CounterName = "DRIVERMERGE";
            TFormulaEvaluator.counterCreate(CounterName, 3600000L);
        }
        TFormulaEvaluator.counterAddEvent(CounterName, string, string2);
    }

    public void setLogDriverID(String string) {
        this.strLogDriverID = string;
    }

    public boolean verifyDrivers() {
        if (this.DestDriver == null) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Destination driver is not defined.");
            return false;
        }
        if (!this.DestDriver.isWriteable()) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Unable to write to destination driver.");
            return false;
        }
        if (this.SrcDriver == null) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Source driver is not defined.");
            return false;
        }
        return true;
    }

    public Hashtable getSrcFields() {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = charutil.getSubStringArray(this.strAliasFields, '|', true);
        boolean bl = false;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[n], '=', true);
                if (stringArray2 == null) continue;
                if (stringArray2.length == 2) {
                    hashtable.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Invalid alias field definition in '" + stringArray[n] + "'");
                bl = true;
            }
        }
        if (bl) {
            hashtable.clear();
            return null;
        }
        for (n = 0; n < this.SrcDriver.DriverStruct.FieldColl.size(); ++n) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.SrcDriver.DriverStruct.FieldColl.get(n);
            if (hashtable.containsKey(tDriverStructRecord.ID)) continue;
            hashtable.put(tDriverStructRecord.FullID, tDriverStructRecord.FullID);
        }
        return hashtable;
    }

    public ArrayList getKeyFields(Hashtable hashtable) {
        String[] stringArray = charutil.getSubStringArray(this.strKeyFields, '|', true);
        boolean bl = false;
        if (stringArray == null) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: No key fields specified.");
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.DestDriver.getDriverStructRecord(stringArray[i]) == null) {
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Key field named '" + stringArray[i] + "' is not defined in the destination driver");
                bl = true;
            }
            if (!hashtable.containsKey(stringArray[i])) {
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Key field named '" + stringArray[i] + "' is not defined in the source driver");
                bl = true;
            }
            if (bl) continue;
            arrayList.add(stringArray[i]);
        }
        if (bl) {
            arrayList.clear();
            return null;
        }
        return arrayList;
    }

    public ArrayList getFieldsToMerge(ArrayList arrayList, Hashtable hashtable) {
        int n;
        String string;
        Enumeration enumeration;
        String[] stringArray = charutil.getSubStringArray(this.strFieldsToMerge, '|', true);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        if (stringArray == null) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (arrayList.contains(string)) continue;
                arrayList2.add(string);
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                if (arrayList.contains(stringArray[n])) continue;
                arrayList2.add(stringArray[n]);
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            string = (String)arrayList2.get(n);
            if (this.DestDriver.getDriverStructRecord(string) == null) {
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Merge field named '" + string + "' is not defined in destination driver with Driver ID=" + this.DestDriver.AppDriverObj.DriverID);
                bl = true;
            }
            if (hashtable.containsKey(string)) continue;
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Error merging drivers: Merge field named '" + string + "' is not defined in source driver with Driver ID=" + this.SrcDriver.AppDriverObj.DriverID);
            System.out.println("Fields include:");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                System.out.println(k.toString() + "\t" + hashtable.get(k));
            }
            bl = true;
        }
        if (bl) {
            arrayList2.clear();
            return null;
        }
        return arrayList2;
    }

    public String merge() {
        int n;
        Object object;
        int n2;
        TKeyValues tKeyValues;
        String string;
        int n3;
        String string2;
        NumberFormat numberFormat = NumberFormat.getInstance();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        long l = new Date().getTime();
        if (this.Debug) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "Merge drivers:");
            if (this.DestDriver.AppDriverObj != null) {
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "Dest driver:" + this.DestDriver.AppDriverObj.DriverID);
            } else {
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "Dest driver:No Driver ID available");
            }
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "Source driver:" + this.SrcDriver.AppDriverObj.DriverID);
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "Append = " + this.AppendNewRecords);
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "DestFilter = '" + this.DestFilter + "'");
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "SrcFilter = '" + this.SrcFilter + "'");
            String[] stringArray = charutil.getSubStringArray(this.strKeyFields, '|', false);
            if (stringArray != null) {
                string2 = "";
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    string2 = string2 + stringArray[n3];
                    if (n3 >= stringArray.length - 1) continue;
                    string2 = string2 + ", ";
                }
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "KeyFields = '" + string2 + "'");
            }
            if ((stringArray = charutil.getSubStringArray(this.strFieldsToMerge, '|', false)) != null) {
                string2 = "";
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    string2 = string2 + stringArray[n3];
                    if (n3 >= stringArray.length - 1) continue;
                    string2 = string2 + ", ";
                }
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "FieldsToMerge = '" + string2 + "'");
            }
            if ((stringArray = charutil.getSubStringArray(this.strAliasFields, '|', false)) != null) {
                string2 = "";
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    string2 = string2 + stringArray[n3];
                    if (n3 >= stringArray.length - 1) continue;
                    string2 = string2 + ", ";
                }
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "AliasFields = '" + string2 + "'");
            }
        }
        if (!this.verifyDrivers()) {
            return "Error merging drivers: Drivers are invalid or cannot write to destination";
        }
        this.DestDriver.setUndoRecording(false);
        Hashtable hashtable = this.getSrcFields();
        if (hashtable == null) {
            return "No source fields defined";
        }
        ArrayList arrayList = this.getKeyFields(hashtable);
        if (arrayList == null) {
            return "No keyfields defined";
        }
        ArrayList arrayList2 = this.getFieldsToMerge(arrayList, hashtable);
        if (arrayList2 == null) {
            return "No fields to merge defined";
        }
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[arrayList.size()];
        TDriverStructRecord[] tDriverStructRecordArray2 = new TDriverStructRecord[arrayList.size()];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            string2 = (String)arrayList.get(n3);
            tDriverStructRecordArray[n3] = this.DestDriver.getDriverStructRecord(string2);
            string = (String)hashtable.get(string2);
            tDriverStructRecordArray2[n3] = this.SrcDriver.getDriverStructRecord(string);
        }
        TDriverStructRecord[] tDriverStructRecordArray3 = new TDriverStructRecord[arrayList2.size()];
        TDriverStructRecord[] tDriverStructRecordArray4 = new TDriverStructRecord[arrayList2.size()];
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            string2 = (String)arrayList2.get(n3);
            tDriverStructRecordArray3[n3] = this.DestDriver.getDriverStructRecord(string2);
            string = (String)hashtable.get(string2);
            tDriverStructRecordArray4[n3] = this.SrcDriver.getDriverStructRecord(string);
        }
        ArrayList<TKeyValues> arrayList3 = new ArrayList<TKeyValues>();
        int n8 = this.DestDriver.getRecordCount();
        if (this.Debug) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "Destination record count = " + n8);
        }
        for (int i = 0; i < n8; ++i) {
            if (this.DestFilter.length() != 0 && !this.DestDriver.isInFilter(i, this.DestFilter)) continue;
            tKeyValues = new TKeyValues(i);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                string2 = (String)arrayList.get(n2);
                object = this.DestDriver.getField(tDriverStructRecordArray[n2], i);
                tKeyValues.addKeyValue(string2, objectutil.convertFieldTypeToString(tDriverStructRecordArray[n2].FieldType, object));
            }
            n = Collections.binarySearch(arrayList3, tKeyValues);
            if (n < 0) {
                arrayList3.add(Math.abs(n + 1), tKeyValues);
                continue;
            }
            arrayList3.add(n, tKeyValues);
        }
        if (this.Debug && arrayList3.size() == 0 && !this.AppendNewRecords) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "No records in the destination driver match the filter: [" + this.DestFilter + "]");
        }
        TMergeLog tMergeLog = null;
        if (this.strLogDriverID.length() > 0) {
            tMergeLog = new TMergeLog(this.strLogDriverID, this.SrcDriver.getDriverID(), TMainWin.Application.parse_tokens(this.SrcDriver.FileName.toString()), this.DestDriver.getDriverID(), TMainWin.Application.parse_tokens(this.DestDriver.FileName.toString()));
        }
        n8 = this.SrcDriver.getRecordCount();
        if (this.Debug) {
            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, "Source record count = " + n8);
        }
        Long l2 = new Date().getTime();
        for (int i = 0; i < n8; ++i) {
            if (this.SrcFilter.length() == 0 || this.SrcDriver.isInFilter(i, this.SrcFilter)) {
                Object object2;
                TKeyValues tKeyValues2;
                tKeyValues = new TKeyValues(i);
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    string2 = (String)arrayList.get(n2);
                    object = this.SrcDriver.getField(tDriverStructRecordArray2[n2], i);
                    tKeyValues.addKeyValue(string2, objectutil.convertFieldTypeToString(tDriverStructRecordArray2[n2].FieldType, object));
                }
                n = Collections.binarySearch(arrayList3, tKeyValues);
                if (n >= 0) {
                    if (!this.NewRecordsOnly) {
                        boolean bl = false;
                        while (!bl) {
                            if (--n < 0) {
                                bl = true;
                                continue;
                            }
                            tKeyValues2 = (TKeyValues)arrayList3.get(n);
                            if (tKeyValues2.compareTo(tKeyValues) == 0) continue;
                            bl = true;
                        }
                        boolean bl2 = false;
                        while (!bl2) {
                            if (++n < arrayList3.size()) {
                                tKeyValues2 = (TKeyValues)arrayList3.get(n);
                                if (tKeyValues2.compareTo(tKeyValues) == 0) {
                                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                                        Object object3;
                                        if (tDriverStructRecordArray3[n2].IsCalculated) continue;
                                        object = this.SrcDriver.getField(tDriverStructRecordArray4[n2], i);
                                        string2 = objectutil.convertFieldTypeToString(tDriverStructRecordArray4[n2].FieldType, object);
                                        object2 = objectutil.convertStringToFieldType(tDriverStructRecordArray3[n2].FieldType, string2, this.DestDriver.getAbsoluteDiskIndex(tKeyValues2.RecordNumber));
                                        boolean bl3 = false;
                                        if (tDriverStructRecordArray3[n2].IsToken) {
                                            bl3 = true;
                                        } else {
                                            object3 = this.DestDriver.getField(tDriverStructRecordArray3[n2], tKeyValues2.RecordNumber);
                                            string = objectutil.convertFieldTypeToString(tDriverStructRecordArray3[n2].FieldType, object3);
                                            if (!string2.equalsIgnoreCase(string)) {
                                                bl3 = true;
                                            }
                                        }
                                        if (bl3) {
                                            this.DestDriver.putField(tDriverStructRecordArray3[n2], tKeyValues2.RecordNumber, object2);
                                            if (tMergeLog == null) continue;
                                            object3 = this.DestDriver.getField(tDriverStructRecordArray3[n2], tKeyValues2.RecordNumber);
                                            string = objectutil.convertFieldTypeToString(tDriverStructRecordArray3[n2].FieldType, object3);
                                            tMergeLog.writeToLog("Merge", tKeyValues2, tDriverStructRecordArray3[n2].ID, string, string2, this.DestDriver.getAbsoluteDiskIndex(tKeyValues2.RecordNumber));
                                            continue;
                                        }
                                        if (tMergeLog == null) continue;
                                        object3 = this.DestDriver.getField(tDriverStructRecordArray3[n2], tKeyValues2.RecordNumber);
                                        string = objectutil.convertFieldTypeToString(tDriverStructRecordArray3[n2].FieldType, object3);
                                        tMergeLog.writeToLog("Merge (No Difference)", tKeyValues2, tDriverStructRecordArray3[n2].ID, string, string2, this.DestDriver.getAbsoluteDiskIndex(tKeyValues2.RecordNumber));
                                    }
                                    ++n4;
                                    continue;
                                }
                                bl2 = true;
                                continue;
                            }
                            bl2 = true;
                        }
                    }
                } else if (this.AppendNewRecords) {
                    int n9 = this.DestDriver.initializeNewRecord();
                    int n10 = this.DestDriver.addToFilterList(n9);
                    tKeyValues2 = new TKeyValues(n10);
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        string2 = (String)arrayList.get(n2);
                        object = this.SrcDriver.getField(tDriverStructRecordArray2[n2], i);
                        String string3 = objectutil.convertFieldTypeToString(tDriverStructRecordArray2[n2].FieldType, object);
                        object2 = objectutil.convertStringToFieldType(tDriverStructRecordArray[n2].FieldType, string3, tKeyValues2.RecordNumber);
                        this.DestDriver.putField(tDriverStructRecordArray[n2], tKeyValues2.RecordNumber, object2);
                        tKeyValues2.addKeyValue(string2, string3);
                        if (tMergeLog == null) continue;
                        tMergeLog.writeToLog("Append", tKeyValues2, tDriverStructRecordArray[n2].ID, "", objectutil.convertToString(object2), this.DestDriver.getAbsoluteDiskIndex(tKeyValues2.RecordNumber));
                    }
                    arrayList3.add(Math.abs(n + 1), tKeyValues2);
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        if (tDriverStructRecordArray3[n2].IsCalculated) continue;
                        if (tDriverStructRecordArray4[n2] == null) {
                            MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 4, "Source field is undefined while merging to fieldID: " + tDriverStructRecordArray3[n2].ID);
                        }
                        object = this.SrcDriver.getField(tDriverStructRecordArray4[n2], i);
                        string2 = objectutil.convertFieldTypeToString(tDriverStructRecordArray4[n2].FieldType, object);
                        object2 = objectutil.convertStringToFieldType(tDriverStructRecordArray3[n2].FieldType, string2, tKeyValues2.RecordNumber);
                        this.DestDriver.putField(tDriverStructRecordArray3[n2], tKeyValues2.RecordNumber, object2);
                        if (tMergeLog == null) continue;
                        tMergeLog.writeToLog("Append", tKeyValues2, tDriverStructRecordArray3[n2].ID, "", objectutil.convertToString(object2), this.DestDriver.getAbsoluteDiskIndex(tKeyValues2.RecordNumber));
                    }
                    ++n5;
                }
            }
            if (this.Debug) {
                System.out.println("Merging " + i + " of " + n8);
            }
            if (n8 > 1000 && new Date().getTime() - l2 > 5000L) {
                String string4 = "Merging " + this.SrcDriver.AppDriverObj.DriverID.toString() + " to " + this.DestDriver.AppDriverObj.DriverID.toString() + " Record " + i + " of " + n8;
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, string4);
                l2 = new Date().getTime();
            }
            if ((n7 = (int)Math.floor((double)((int)((double)i)) / (double)n8 * 100.0)) > n6) {
                n6 = n7;
            }
            Thread.yield();
        }
        if (tMergeLog != null) {
            tMergeLog.dispose();
        }
        hashtable.clear();
        arrayList3.clear();
        arrayList.clear();
        arrayList2.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TMainWin.Application.setTokenValue("$ActivityLogLastWrite", "");
            }
        });
        TDriverMerge.counterAddEvent("Merge", "SourceDriver=" + this.SrcDriver.AppDriverObj.DriverID + "&SourceDriverParams=" + this.SrcDriver.strDriverParams + "&DestDriver=" + this.DestDriver.AppDriverObj.DriverID + "&DestDriverParams=" + this.DestDriver.strDriverParams + "&Records=" + n8 + "&Merged=" + n4 + "&Added=" + n5 + "&ElapsedTime=" + (new Date().getTime() - l));
        return "Ok. Merged: " + n4 + " records.  Added: " + n5 + " records of " + n8;
    }

    class TMergeLog {
        TAspectDriver LogDriver = null;
        TDriverStructRecord DSRecLogSrcDriverID = null;
        TDriverStructRecord DSRecLogDestDriverID = null;
        TDriverStructRecord DSRecLogSrcFilename = null;
        TDriverStructRecord DSRecLogDestFilename = null;
        TDriverStructRecord DSRecLogAction = null;
        TDriverStructRecord DSRecLogKeyFields = null;
        TDriverStructRecord DSRecLogFieldID = null;
        TDriverStructRecord DSRecLogOrigValue = null;
        TDriverStructRecord DSRecLogNewValue = null;
        TDriverStructRecord DSRecLogDestRecord = null;
        String SrcDriverID = "";
        String DestDriverID = "";
        String SrcFilename = "";
        String DestFilename = "";

        public TMergeLog(String string, String string2, String string3, String string4, String string5) {
            this.SrcDriverID = string2;
            this.DestDriverID = string4;
            this.SrcFilename = string3;
            this.DestFilename = string5;
            if (string.length() > 0) {
                String[] stringArray = charutil.getSubStringArray(TDriverMerge.this.strLogDriverID, '^', true);
                if (stringArray != null) {
                    String string6 = "";
                    if (stringArray.length > 1) {
                        string6 = stringArray[1];
                    }
                    this.LogDriver = new TAspectDriver(stringArray[0], 1, false, true, string6);
                    if (this.LogDriver.isValid()) {
                        this.DSRecLogSrcDriverID = this.LogDriver.getDriverStructRecord("SourceDriverID");
                        this.DSRecLogDestDriverID = this.LogDriver.getDriverStructRecord("DestDriverID");
                        this.DSRecLogSrcFilename = this.LogDriver.getDriverStructRecord("SourceFilename");
                        this.DSRecLogDestFilename = this.LogDriver.getDriverStructRecord("DestFilename");
                        this.DSRecLogAction = this.LogDriver.getDriverStructRecord("Action");
                        this.DSRecLogKeyFields = this.LogDriver.getDriverStructRecord("KeyFields");
                        this.DSRecLogFieldID = this.LogDriver.getDriverStructRecord("FieldID");
                        this.DSRecLogOrigValue = this.LogDriver.getDriverStructRecord("OriginalValue");
                        this.DSRecLogNewValue = this.LogDriver.getDriverStructRecord("NewValue");
                        this.DSRecLogDestRecord = this.LogDriver.getDriverStructRecord("DestRecord");
                    } else {
                        MainWin.appendToLog("TDriverMerge", "TMergeLog.init", Thread.currentThread(), null, 4, "The log driver for the merge is invalid.  ID=" + stringArray[0] + " Param=" + string6);
                        this.LogDriver.dispose();
                        this.LogDriver = null;
                    }
                } else {
                    TMainWin tMainWin = MainWin;
                    Thread thread = Thread.currentThread();
                    StringBuilder stringBuilder = new StringBuilder().append("The log driver for the merge is invalid.  ID=").append(this.LogDriver.getDriverID()).append(" Filename=");
                    MainWin;
                    tMainWin.appendToLog("TDriverMerge", "TMergeLog.init", thread, null, 4, stringBuilder.append(TMainWin.Application.parse_tokens(this.LogDriver.FileName.toString())).toString());
                }
            }
        }

        public void dispose() {
            if (this.LogDriver != null) {
                this.LogDriver.dispose();
            }
        }

        public void writeToLog(String string, TKeyValues tKeyValues, String string2, String string3, String string4, int n) {
            if (this.LogDriver == null) {
                return;
            }
            int n2 = this.LogDriver.initializeNewRecord();
            this.LogDriver.putField(this.DSRecLogSrcDriverID, n2, (Object)this.SrcDriverID);
            this.LogDriver.putField(this.DSRecLogDestDriverID, n2, (Object)this.DestDriverID);
            this.LogDriver.putField(this.DSRecLogSrcFilename, n2, (Object)this.SrcFilename);
            this.LogDriver.putField(this.DSRecLogDestFilename, n2, (Object)this.DestFilename);
            this.LogDriver.putField(this.DSRecLogAction, n2, (Object)string);
            this.LogDriver.putField(this.DSRecLogKeyFields, n2, (Object)tKeyValues.toString());
            this.LogDriver.putField(this.DSRecLogFieldID, n2, (Object)string2);
            this.LogDriver.putField(this.DSRecLogOrigValue, n2, (Object)string3);
            this.LogDriver.putField(this.DSRecLogNewValue, n2, (Object)string4);
            this.LogDriver.putField(this.DSRecLogDestRecord, n2, (Object)n);
        }
    }

    class TKeyValues
    implements Comparable {
        Hashtable hashValues = new Hashtable();
        int RecordNumber = -1;

        public TKeyValues(int n) {
            this.RecordNumber = n;
        }

        public void addKeyValue(String string, String string2) {
            this.hashValues.put(string, string2.trim());
        }

        public String toString() {
            Enumeration enumeration = this.hashValues.keys();
            StringBuilder stringBuilder = new StringBuilder();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuilder.append(string + "=" + (String)this.hashValues.get(string));
                if (!enumeration.hasMoreElements()) continue;
                stringBuilder.append(" / ");
            }
            return stringBuilder.toString();
        }

        public int compareTo(Object object) {
            Enumeration enumeration = this.hashValues.keys();
            TKeyValues tKeyValues = (TKeyValues)object;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.hashValues.get(string);
                String string3 = (String)tKeyValues.hashValues.get(string);
                if (string2 == null) {
                    return -1;
                }
                if (string3 == null) {
                    return 1;
                }
                int n = string2.compareTo(string3);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }
}

