/*
 * Decompiled with CFR 0.152.
 */
package utility.asciifiles;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import scripts.TExecScript;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.ftp.TFtpClient;

public class TAsciiInput {
    public TMainWin MainWin = Aspect.MainWin;
    private String FileName;
    private String EntryName = null;
    private InputStream inputstream = null;
    private URL url = null;
    private long CurrentLine;
    private long CurrentField;
    private boolean IsValid;
    private boolean IsJar = false;
    private boolean IsZip = false;
    private boolean Debug = false;
    private boolean SuppressErrors = false;
    private char Delimiter = (char)44;
    private File TempFile = null;
    private boolean RespectQuotes = true;

    public TAsciiInput() {
        this.FileName = "";
        this.CurrentLine = 0L;
        this.CurrentField = 0L;
        this.IsValid = false;
        this.Delimiter = (char)44;
    }

    public TAsciiInput(String string) {
        this.parseFileName(string);
        this.CurrentLine = 0L;
        this.CurrentField = 0L;
        this.IsValid = false;
        this.Delimiter = '\u0000';
        this.open_stream();
    }

    public TAsciiInput(String string, char c) {
        this.parseFileName(string);
        this.CurrentLine = 0L;
        this.CurrentField = 0L;
        this.IsValid = false;
        this.Delimiter = c;
        this.open_stream();
    }

    public TAsciiInput(String string, char c, boolean bl) {
        this.parseFileName(string);
        this.CurrentLine = 0L;
        this.CurrentField = 0L;
        this.IsValid = false;
        this.Delimiter = c;
        this.SuppressErrors = bl;
        this.open_stream();
    }

    public void parseFileName(String string) {
        CharSequence charSequence;
        int n = -1;
        this.FileName = dosutil.formatURL(string);
        if (this.FileName.toUpperCase().startsWith("HTTPS") && this.MainWin != null) {
            String string2 = TMainWin.Application.getTokenValue("AspectServerIP1");
            charSequence = TMainWin.Application.getTokenValue("AspectServerIP2");
            if (this.FileName.toUpperCase().startsWith("HTTPS://" + string2)) {
                this.FileName = charutil.replaceAllSubstrings(this.FileName, "HTTPS://" + string2, "HTTP://" + (String)charSequence);
            }
        }
        if (this.FileName.toUpperCase().startsWith("HTTP://") || this.FileName.toUpperCase().startsWith("HTTPS://") || this.FileName.toUpperCase().startsWith("FTP://")) {
            this.FileName = charutil.replaceAllSubstrings(this.FileName, " ", "%20");
        }
        this.EntryName = null;
        this.IsJar = false;
        this.IsZip = false;
        try {
            this.url = new URL(this.FileName);
            n = string.toUpperCase().indexOf(".JAR");
            int n2 = string.toUpperCase().indexOf(".ZIP");
            if (n >= 0 && (n2 < 0 || n < n2)) {
                n2 = string.toUpperCase().indexOf(".JAR", n + 1);
                if (n2 > 0 || !string.toUpperCase().endsWith(".JAR")) {
                    this.IsJar = true;
                }
            } else if (!(string.toUpperCase().startsWith("HTTP") || string.toUpperCase().startsWith("FTP") || (n = string.toUpperCase().indexOf(".ZIP")) < 0 || (n2 = string.toUpperCase().indexOf(".ZIP", n + 1)) <= 0 && string.toUpperCase().endsWith(".ZIP"))) {
                this.IsZip = true;
            }
            if (this.IsJar || this.IsZip) {
                while (string.charAt(n) != '/' && string.charAt(n) != '\\') {
                    ++n;
                }
                this.FileName = string.substring(0, n);
                this.EntryName = string.substring(this.FileName.length() + 1, string.length());
                if (string.toUpperCase().startsWith("FILE:")) {
                    this.FileName = charutil.replaceChar(this.FileName, '\\', '/');
                    charSequence = new StringBuilder(this.FileName.substring(5, this.FileName.length()));
                    if (((StringBuilder)charSequence).toString().startsWith("////")) {
                        ((StringBuilder)charSequence).deleteCharAt(0);
                        ((StringBuilder)charSequence).deleteCharAt(0);
                    } else {
                        while (((StringBuilder)charSequence).length() > 0 && ((StringBuilder)charSequence).charAt(0) == '/') {
                            ((StringBuilder)charSequence).deleteCharAt(0);
                        }
                    }
                    this.FileName = ((StringBuilder)charSequence).toString();
                    this.FileName = charutil.replaceChar(this.FileName, '/', '\\');
                }
            }
        }
        catch (Exception exception) {
            Aspect.MainWin.appendToLog("TAsciiInput", "parseFileName", Thread.currentThread(), exception, 4, "Error opening file [1]: " + this.FileName);
        }
    }

    public void open(String string) {
        if (this.inputstream != null) {
            this.close();
        }
        this.parseFileName(string);
        this.open_stream();
    }

    public void close() {
        if (this.inputstream != null) {
            try {
                this.inputstream.close();
                this.inputstream = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.TempFile != null) {
            this.TempFile.delete();
        }
    }

    public void dispose() {
        this.close();
    }

    public String getFilename() {
        return this.FileName;
    }

    public URL getURL() {
        return this.url;
    }

    private void open_stream() {
        try {
            if (this.IsJar) {
                if (new File(this.FileName).exists()) {
                    JarFile jarFile = new JarFile(this.FileName);
                    JarEntry jarEntry = jarFile.getJarEntry(this.EntryName);
                    if (jarEntry == null) {
                        jarEntry = jarFile.getJarEntry(charutil.replaceChar(this.EntryName, '/', '\\'));
                    }
                    this.inputstream = jarFile.getInputStream(jarEntry);
                } else {
                    this.inputstream = this.getClass().getResourceAsStream("/" + this.EntryName);
                }
                if (this.inputstream != null) {
                    this.IsValid = true;
                }
            } else if (this.IsZip) {
                if (new File(this.FileName).exists()) {
                    ZipFile zipFile = new ZipFile(this.FileName);
                    ZipEntry zipEntry = zipFile.getEntry(this.EntryName);
                    if (zipEntry == null) {
                        zipEntry = zipFile.getEntry(charutil.replaceChar(this.EntryName, '/', '\\'));
                    }
                    if (zipEntry == null) {
                        zipEntry = zipFile.getEntry(charutil.replaceChar(this.EntryName, '\\', '/'));
                    }
                    this.inputstream = zipFile.getInputStream(zipEntry);
                    if (this.inputstream != null) {
                        this.IsValid = true;
                    }
                }
            } else {
                Object object;
                String string;
                String string2;
                String string3;
                if (this.FileName.toUpperCase().startsWith("FILE://") && !new File(string3 = this.FileName.substring(7)).exists()) {
                    if (!this.SuppressErrors) {
                        Aspect.MainWin.appendToLog("TAsciiInput", "open_stream", Thread.currentThread(), null, 4, "Error opening file [2]: " + this.FileName);
                        System.out.println("Error opening: " + this.FileName);
                    }
                    return;
                }
                if (this.FileName.toUpperCase().startsWith("FTP") && this.FileName.indexOf("@") > 0) {
                    int n = this.FileName.indexOf("@");
                    string2 = this.FileName.substring(6, n);
                    string = this.FileName.substring(n + 1);
                    String string4 = "";
                    String string5 = "";
                    object = "";
                    String string6 = "";
                    n = string2.indexOf(":");
                    if (n > 0) {
                        string4 = string2.substring(0, n);
                        string5 = string2.substring(n + 1);
                    }
                    if ((n = string.indexOf("/")) > 0) {
                        object = string.substring(0, n);
                        string6 = string.substring(n);
                    }
                    this.TempFile = dosutil.createTempFile("$$$");
                    TFtpClient.transferFile((String)object, string4, string5, false, this.TempFile.getAbsolutePath(), string6, 1);
                    this.url = new URL("file:/" + this.TempFile.getAbsolutePath());
                }
                HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                };
                string2 = "";
                string = "";
                if (this.FileName.indexOf("@") > 0) {
                    int n = this.FileName.indexOf("//");
                    int n2 = this.FileName.indexOf("@");
                    object = this.FileName.substring(n + 2, n2);
                    n = ((String)object).indexOf(":");
                    string2 = ((String)object).substring(0, n);
                    string = ((String)object).substring(n + 1);
                }
                Authenticator.setDefault(new MyAuthenticator(string2, string));
                HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
                TrustManager[] trustManagerArray = new TrustManager[]{new MyTrustManager()};
                SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
                sSLContext.init(null, trustManagerArray, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                object = this.url.openConnection();
                ((URLConnection)object).setConnectTimeout(30000);
                ((URLConnection)object).setReadTimeout(30000);
                this.inputstream = new BufferedInputStream(((URLConnection)object).getInputStream());
                this.IsValid = true;
            }
        }
        catch (Exception exception) {
            this.IsValid = false;
            String string = this.FileName;
            if (this.IsJar || this.IsZip) {
                string = string + " Archive entry:" + this.EntryName;
            }
            if (this.SuppressErrors) {
                if (exception.toString().toUpperCase().indexOf("NULLPOINTER") < 0 && exception.toString().toUpperCase().indexOf("FILENOTFOUND") < 0) {
                    Aspect.MainWin.appendToLog("TAsciiInput", "open_stream", Thread.currentThread(), exception, 4, "Error opening file [3]: " + string);
                }
            }
            if (Aspect.MainWin == null) {
                System.out.println("Error in open_stream(): " + exception.toString());
            }
            if (exception.toString().indexOf("No route to host") >= 0) {
                Aspect.MainWin.appendToLog("TAsciiInput", "open_stream", Thread.currentThread(), null, 4, "Error opening file [4]: " + string);
            }
            if (exception.toString().indexOf("Connection refused") >= 0) {
                Aspect.MainWin.appendToLog("TAsciiInput", "open_stream", Thread.currentThread(), null, 4, "Error opening file [5]: " + string);
            }
            Aspect.MainWin.appendToLog("TAsciiInput", "open_stream", Thread.currentThread(), null, 4, "Error opening file [4]: " + string);
        }
    }

    public InputStream getInputStream() {
        return this.inputstream;
    }

    public boolean isValid() {
        return this.IsValid;
    }

    public int getSize() {
        int n = -1;
        if (this.IsValid) {
            try {
                n = this.inputstream.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void setRespectQuotes(boolean bl) {
        this.RespectQuotes = bl;
    }

    public byte[] get_entire_file() {
        if (!this.IsValid) {
            this.MainWin.appendToLog("TAsciiInput", "getEntireFile", Thread.currentThread(), null, 4, "TAsciiInput.get_entire_file(" + this.FileName + ") returns null because stream is not valid");
            return null;
        }
        String string = this.FileName.toUpperCase();
        if (!(string.startsWith("HTTP://") || string.startsWith("HTTPS://") || string.startsWith("FTP://") || this.IsJar || this.IsZip)) {
            byte[] byArray;
            File file;
            String string2 = string;
            if (string.startsWith("FILE://")) {
                string2 = string.substring(7);
            }
            if ((file = new File(string2)).exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
                    randomAccessFile.seek(0L);
                    byArray = new byte[(int)file.length()];
                    randomAccessFile.read(byArray);
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    byArray = new byte[]{};
                }
            } else {
                byArray = new byte[]{};
            }
            return byArray;
        }
        byte[] byArray = new byte[65536];
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 0;
        try {
            do {
                byte[] byArray3;
                if ((n2 = this.inputstream.read(byArray)) < 0) continue;
                if (byArray2 == null) {
                    byArray2 = new byte[n2];
                    byArray3 = byArray2;
                } else {
                    byArray3 = (byte[])charutil.arrayGrow(byArray2, byArray2.length + n2);
                }
                byArray2 = byArray3;
                System.arraycopy(byArray, 0, byArray2, n, n2);
                n += n2;
            } while (n2 >= 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        return byArray2;
    }

    public int get_string(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        byte[] byArray = new byte[1];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        stringBuilder2.setLength(0);
        try {
            int n;
            do {
                if ((n = this.inputstream.read(byArray)) <= 0) continue;
                bl = true;
                if (this.RespectQuotes && byArray[0] == 34) {
                    boolean bl4 = bl3 = !bl3;
                }
                if (!(bl3 || byArray[0] != 10 && byArray[0] != 13)) {
                    if (byArray[0] == 13) {
                        this.inputstream.read(byArray);
                    }
                    bl2 = true;
                }
                if (bl2) continue;
                stringBuilder2.append((char)byArray[0]);
            } while (n > 0 && !bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
            return -1;
        }
        stringBuilder.setLength(0);
        stringBuilder.append(stringBuilder2.toString());
        if (bl) {
            return 1;
        }
        return -1;
    }

    public ArrayList getAllLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = this.get_entire_file();
        if (byArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by == 34) {
                bl = !bl;
                stringBuilder.append((char)by);
                continue;
            }
            if (!bl && by == 10) continue;
            if (!bl && by == 13) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append((char)by);
        }
        return arrayList;
    }

    public static byte[] getBytes(String string) {
        String string2 = string.toUpperCase();
        if (string2.startsWith("FILE://")) {
            string2 = string2.substring(7);
        }
        string2 = charutil.removeChar(string2, '\r');
        string2 = charutil.removeChar(string2, '\n');
        string2 = charutil.replaceChar(string2, '/', '\\');
        File file = new File(string2 = string2.trim());
        if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
                randomAccessFile.seek(0L);
                byte[] byArray = new byte[(int)file.length()];
                randomAccessFile.read(byArray);
                randomAccessFile.close();
                return byArray;
            }
            catch (Exception exception) {
                System.out.println("TAsciiInput.getBytes: " + exception.toString());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Aspect.MainWin.appendToLog("TAsciiInput", "getBytes", Thread.currentThread(), outOfMemoryError, 4, "Error: OutofMemory in getBytes. Size=" + file.length() + " MemAvail=" + Runtime.getRuntime().freeMemory() + " " + string);
                Aspect.MainWin.appendToLog("TAsciiInput", "getBytes", Thread.currentThread(), outOfMemoryError, 4, "Error: OutofMemory in getBytes. Filename=" + string);
                Aspect.MainWin.dumpState("TAsciiInput.getBytes()", "outOfMemory");
                return new byte[0];
            }
        } else {
            System.out.println("TAsciiInput.getEntireFile: File not found: [" + string2 + "]");
        }
        return new byte[0];
    }

    public static String getEntireFile(String string) {
        String string2 = string.toUpperCase();
        if (!(string2.startsWith("HTTP://") || string2.startsWith("HTTPS://") || string2.startsWith("FTP://") || string2.indexOf(".ZIP") >= 0 || string2.indexOf(".JAR") >= 0)) {
            if (string2.startsWith("FILE://")) {
                string2 = string2.substring(7);
            }
            string2 = charutil.removeChar(string2, '\r');
            string2 = charutil.removeChar(string2, '\n');
            string2 = charutil.replaceChar(string2, '/', '\\');
            string2 = string2.trim();
            File file = new File(string2);
            String string3 = "";
            if (file.exists()) {
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(dosutil.getInputStream(string2));
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    do {
                        if ((n = bufferedInputStream.read(byArray)) <= 0) continue;
                        for (int i = 0; i < n; ++i) {
                            stringBuilder.append((char)byArray[i]);
                        }
                    } while (n > 0);
                    bufferedInputStream.close();
                    string3 = stringBuilder.toString();
                }
                catch (Exception exception) {
                    System.out.println("TAsciiInput.getEntireFile: " + exception.toString());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    stringBuilder.setLength(0);
                    Aspect.MainWin.appendToLog("TAsciiInput", "getEntireFile", Thread.currentThread(), outOfMemoryError, 4, "Error: OutofMemory in getBytes. Size=" + file.length() + " MemAvail=" + Runtime.getRuntime().freeMemory() + " " + string);
                    System.out.println("Error: OutofMemory in getBytes. Size=" + file.length() + " MemAvail=" + Runtime.getRuntime().freeMemory() + " " + string);
                    Aspect.MainWin.dumpState("TAsciiInput.getEntireFile()", "outOfMemory");
                    return "";
                }
            } else {
                System.out.println("TAsciiInput.getEntireFile: File not found: [" + string2 + "]");
            }
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        TAsciiInput tAsciiInput = new TAsciiInput(string, '\u0000');
        byte[] byArray = tAsciiInput.get_entire_file();
        if (byArray != null) {
            stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
        }
        tAsciiInput.dispose();
        return stringBuilder.toString();
    }

    public static String getContentUsingHttp(String string) {
        try {
            int n;
            int n2;
            URL uRL = new URL(string);
            String[] stringArray = new String[7];
            stringArray[0] = uRL.getHost();
            stringArray[1] = uRL.getPath();
            if (stringArray[1].length() == 0) {
                stringArray[1] = "/";
            }
            stringArray[2] = uRL.getQuery();
            if (stringArray[2] == null) {
                stringArray[2] = "";
            }
            stringArray[3] = (n2 = uRL.getPort()) >= 0 ? Integer.toString(n2) : "80";
            stringArray[4] = "120000";
            stringArray[5] = "false";
            if (uRL.getProtocol().toUpperCase().startsWith("HTTPS")) {
                stringArray[5] = "true";
            }
            stringArray[6] = "";
            int n3 = string.indexOf(64);
            if (n3 > 0 && (n = string.indexOf("//")) < n3) {
                stringArray[6] = string.substring(n + 2, n3);
            }
            TExecScript tExecScript = new TExecScript("Aspect_Core_Http_Get", null, null);
            tExecScript.setParameters(stringArray);
            tExecScript.executeScript();
            return TFormulaEvaluator.convertToString(tExecScript.getScriptResult());
        }
        catch (Exception exception) {
            System.out.println("Error in getContentUsingHttp: " + exception.toString());
            return null;
        }
    }

    public static String getContent(String string) {
        String string2 = "";
        TAsciiInput tAsciiInput = new TAsciiInput(string, '\u0000');
        if (tAsciiInput.isValid()) {
            byte[] byArray = tAsciiInput.get_entire_file();
            if (byArray != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append((char)byArray[i]);
                }
                string2 = stringBuilder.toString();
            } else {
                string2 = "";
            }
        } else {
            string2 = TAsciiInput.getContentUsingHttp(string);
        }
        tAsciiInput.dispose();
        return string2;
    }

    public static int getFieldCount(String string, char c) {
        String[] stringArray;
        StringBuilder stringBuilder;
        int n;
        int n2 = -1;
        TAsciiInput tAsciiInput = new TAsciiInput(string, c);
        if (tAsciiInput.isValid() && (n = tAsciiInput.get_string(stringBuilder = new StringBuilder())) == 1 && (stringArray = charutil.getSubStringArray(stringBuilder, c, false)) != null) {
            n2 = stringArray.length;
        }
        tAsciiInput.dispose();
        return n2;
    }

    class MyAuthenticator
    extends Authenticator {
        String strUser = "";
        String strPassword = "";

        private MyAuthenticator(String string, String string2) {
            this.strUser = string;
            this.strPassword = string2;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.strUser, this.strPassword.toCharArray());
        }
    }

    private class MyTrustManager
    implements X509TrustManager {
        private MyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }
}

