/*
 * Decompiled with CFR 0.152.
 */
package utility.asciifiles;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import utility.TFile;
import utility.charutil;

public class TAsciiOutput {
    private TMainWin MainWin = Aspect.MainWin;
    private String FileName;
    private OutputStreamWriter FOutput;
    private long CurrentLine;
    private long CurrentField;
    private char Delimiter;
    private boolean IsValid;
    private String ErrMsg = "";

    public TAsciiOutput(String string, char c, boolean bl) {
        this.init(string, c, bl, "");
    }

    public void init(String string, char c, boolean bl, String string2) {
        this.FileName = string;
        this.IsValid = true;
        this.CurrentLine = 0L;
        this.CurrentField = 0L;
        this.Delimiter = c;
        new TFile(this.FileName).validatePathToFile(true);
        try {
            this.FOutput = string2.length() == 0 ? new FileWriter(this.FileName, bl) : new OutputStreamWriter((OutputStream)new FileOutputStream(this.FileName), string2);
        }
        catch (Exception exception) {
            this.IsValid = false;
            this.MainWin.appendToLog("TAsciiOutput", "init", Thread.currentThread(), exception, 3, "Error opening output file: " + this.FileName);
            this.ErrMsg = exception.toString();
        }
    }

    public void dispose() {
        try {
            this.FOutput.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.IsValid;
    }

    public void writeString(String string) {
        this.writeString(string, false);
    }

    public void writeString(String string, boolean bl) {
        int n = 1;
        boolean bl2 = false;
        if (bl) {
            string = '\"' + string + '\"';
        }
        bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (bl2 || c != this.Delimiter) continue;
            ++n;
        }
        if (n > 1) {
            StringBuilder stringBuilder = new StringBuilder(string);
            charutil.remove_char(stringBuilder, stringBuilder, '\"');
            string = bl ? '\"' + stringBuilder.toString() + '\"' : stringBuilder.toString();
        }
        try {
            if (this.CurrentField > 0L && this.Delimiter != '\u0000') {
                this.FOutput.write(this.Delimiter);
            }
            this.FOutput.write(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.CurrentField;
    }

    public void writeString(StringBuilder stringBuilder, boolean bl) {
        this.writeString(stringBuilder.toString(), bl);
    }

    public void writeBool(boolean bl) {
        this.writeString(new Boolean(bl).toString(), false);
    }

    public void writeInt(int n) {
        this.writeString(new Integer(n).toString(), false);
    }

    public void write_crlf() {
        try {
            this.FOutput.write("\r\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.CurrentField = 0L;
        ++this.CurrentLine;
    }

    public void writeData(String string) {
        try {
            TFile tFile = new TFile(this.FileName);
            tFile.validatePathToFile(true);
            FileOutputStream fileOutputStream = new FileOutputStream(tFile);
            byte[] byArray = new byte[string.length()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static void writeContent(String string, String string2) {
        TAsciiOutput tAsciiOutput = new TAsciiOutput(string, '\u0000', false);
        tAsciiOutput.writeData(string2);
        tAsciiOutput.dispose();
    }
}

