/*
 * Decompiled with CFR 0.152.
 */
package utility.backoffice;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.backoffice.invutil;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;

public class TInvoiceDetail {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    String StoreID = "";
    String StoreDir = "";
    TAspectDriver FInvoiceDetail = null;
    boolean Debug = false;
    TDriverStructRecord DSRecInvoiceID = null;
    TDriverStructRecord DSRecVendorID = null;
    TDriverStructRecord DSRecItemID = null;
    TDriverStructRecord DSRecQuantity = null;
    TDriverStructRecord DSRecSize_Prefix = null;
    TDriverStructRecord DSRecSize_Unit = null;
    TDriverStructRecord DSRecExtended_Price = null;
    TDriverStructRecord DSRecInvoice_Date = null;
    TDriverStructRecord DSRecInvoice_Number = null;
    long LastAccess = 0L;
    long LastDt = 0L;
    long LastDtRangeStart = 0L;
    long LastDtRangeEnd = 0L;
    String LastState = "";
    String FilespecExpression = "";
    long Interval = 5000L;
    Hashtable hashStartRecord = new Hashtable();
    private static Hashtable hDefaultPriceColl = new Hashtable();
    private static Hashtable hDefaultPriceCollLastUpdated = new Hashtable();
    private static TComboBoxColl DefaultPriceColl = null;

    public TInvoiceDetail(String string) {
        this.StoreID = string.toUpperCase();
        this.StoreDir = dosutil.addTrailingSlash((String)TFormulaEvaluator.eval("lookup(\"Aspect_BackOffice_Store_Directory_By_ID\",\"" + string + "\")"));
        this.FilespecExpression = "getFilespecState(\"" + this.StoreDir + "invoice_detail*.bin" + "\")";
    }

    public String getFilespecState() {
        String string = (String)new TFormulaEvaluator().getFormulaValue(this.FilespecExpression);
        return string;
    }

    public boolean driverIsOpen() {
        return this.FInvoiceDetail != null;
    }

    public void concatenateFiles(Date date, Date date2) {
        String string = this.StoreDir + "invoicedetail.$$$";
        try {
            Object object;
            String string2;
            int n;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
            randomAccessFile.setLength(0L);
            System.out.println("TInvoiceDetail contatenateFiles dtStart=" + dateutil.formatDate(date, "MM-dd-yyyy") + " dtEnd=" + dateutil.formatDate(date2, "MM-dd-yyyy"));
            ArrayList<String> arrayList = new ArrayList<String>();
            TComboBoxColl tComboBoxColl = TInvoiceDetail.Application.AppCollections.getCollection("Aspect_BackOffice_Lookup_Invoice_Date_Entered_By_Date", "", "StoreID=" + this.StoreID);
            for (n = 0; n < tComboBoxColl.size(); ++n) {
                string2 = tComboBoxColl.getKeyOfIndex(n);
                object = dateutil.parseDate(string2, "MM-dd-yyyy");
                if (((Date)object).getTime() < date.getTime() || ((Date)object).getTime() > date2.getTime() || arrayList.contains(string2 = tComboBoxColl.getValueOfIndex(n))) continue;
                arrayList.add(string2);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string2 = this.StoreDir + "invoice_detail." + arrayList.get(n) + ".bin";
                if (!dosutil.fileExists(string2)) continue;
                object = new RandomAccessFile(string2, "r");
                ((RandomAccessFile)object).seek(0L);
                byte[] byArray = new byte[(int)((RandomAccessFile)object).length()];
                ((RandomAccessFile)object).read(byArray);
                ((RandomAccessFile)object).close();
                randomAccessFile.write(byArray);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("TInvoiceDetail: Error in concatenateFiles: " + exception.toString());
        }
    }

    public void openDriver(Date date, Date date2) {
        System.out.println("TInvoiceDetail openDriver called dtStart=" + dateutil.formatDate(date, "MM-dd-yyyy") + " dtEnd=" + dateutil.formatDate(date2, "MM-dd-yyyy"));
        this.closeDriver();
        this.LastState = this.getFilespecState();
        this.LastDtRangeStart = date.getTime();
        this.LastDtRangeEnd = date2.getTime();
        this.concatenateFiles(date, date2);
        TAppDriversObject tAppDriversObject = TInvoiceDetail.Application.AppDrivers.getAppDriversObject("Aspect_Back_Office_Invoice_Detail_Concatenated");
        this.FInvoiceDetail = new TAspectDriver(Application, tAppDriversObject, 0, true, "StoreID=" + this.StoreID);
        this.filterDriver();
        this.hashStartRecord.clear();
        this.DSRecInvoiceID = this.FInvoiceDetail.getDriverStructRecord("InvoiceID");
        this.DSRecItemID = this.FInvoiceDetail.getDriverStructRecord("ItemID");
        this.DSRecVendorID = this.FInvoiceDetail.getDriverStructRecord("VendorID");
        this.DSRecQuantity = this.FInvoiceDetail.getDriverStructRecord("Quantity");
        this.DSRecSize_Prefix = this.FInvoiceDetail.getDriverStructRecord("Size_Prefix");
        this.DSRecSize_Unit = this.FInvoiceDetail.getDriverStructRecord("Size_Unit");
        this.DSRecExtended_Price = this.FInvoiceDetail.getDriverStructRecord("Extended_Price");
        this.DSRecInvoice_Date = this.FInvoiceDetail.getDriverStructRecord("Invoice_Date");
        this.DSRecInvoice_Number = this.FInvoiceDetail.getDriverStructRecord("Invoice_Number");
    }

    public void closeDriver() {
        if (this.driverIsOpen()) {
            this.FInvoiceDetail.dispose();
            this.FInvoiceDetail = null;
        }
    }

    public boolean filterDriver() {
        if (this.Debug) {
            System.out.println("TInvoiceDetail: Filter driver");
        }
        if (!this.driverIsOpen()) {
            return false;
        }
        this.FInvoiceDetail.clearBuffer();
        String[] stringArray = new String[]{"ItemID", "-Invoice_Date"};
        if (this.FInvoiceDetail == null) {
            return false;
        }
        this.FInvoiceDetail.setActiveFilter("true", false);
        this.FInvoiceDetail.setSortOptions(stringArray, true);
        return true;
    }

    public synchronized double calcPrice(String string, Date date, double d, double d2, double d3, String string2, TAspectDriver tAspectDriver) {
        String[] stringArray;
        Object object;
        String string3;
        int n;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        Date date2 = gregorianCalendar.getTime();
        if (this.Debug) {
            System.out.println("calcPrice Item: " + invutil.getItemName(string, this.StoreID) + " Dt: " + dateutil.formatDate(date2, "MM-dd-yyyy") + " Qty: " + invutil.formatQty(d, d3, string2, this.StoreID));
        }
        long l = new Date().getTime();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        gregorianCalendar2.set(11, 0);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        gregorianCalendar2.set(14, 0);
        gregorianCalendar.setTime(date2);
        gregorianCalendar.add(5, -90);
        gregorianCalendar.set(5, 1);
        Date date3 = gregorianCalendar.getTime();
        gregorianCalendar.setTime(date2);
        long l2 = new Date().getTime();
        while (gregorianCalendar.getTime().getTime() < l2 && gregorianCalendar.get(5) != 1) {
            gregorianCalendar.add(5, 1);
        }
        Date date4 = gregorianCalendar.getTime();
        if (l - this.LastAccess > this.Interval) {
            if (!this.getFilespecState().equals(this.LastState)) {
                this.openDriver(date3, date4);
            }
        } else if (date3.getTime() < this.LastDtRangeStart || date4.getTime() > this.LastDtRangeEnd) {
            this.openDriver(date3, date4);
        }
        this.LastAccess = l;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        boolean bl = false;
        int n2 = this.FInvoiceDetail.getRecordCount();
        if (this.Debug) {
            System.out.println("\tRecord Count=" + n2);
        }
        int n3 = n = this.hashStartRecord.containsKey(string3 = string.toUpperCase()) ? (Integer)this.hashStartRecord.get(string3) : 0;
        if (this.Debug) {
            System.out.println("\tStart record=" + n);
        }
        for (int i = n; i < n2; ++i) {
            String string4 = (String)this.FInvoiceDetail.getField(this.DSRecItemID, i);
            if (string4.equalsIgnoreCase(string)) {
                double d7;
                double d8;
                if (!bl) {
                    bl = true;
                    if (!this.hashStartRecord.containsKey(string3)) {
                        this.hashStartRecord.put(string3, new Integer(i));
                    }
                }
                if ((object = (Date)this.FInvoiceDetail.getField(this.DSRecInvoice_Date, i)) == null) {
                    MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "Error in calcPrice(" + string + "," + date2 + "," + d + "," + d3 + "," + string2 + ")");
                    return 0.0;
                }
                stringArray = new GregorianCalendar();
                stringArray.setTime((Date)object);
                stringArray.set(11, 0);
                stringArray.set(12, 0);
                stringArray.set(13, 0);
                stringArray.set(14, 0);
                if (stringArray.getTime().getTime() > gregorianCalendar2.getTime().getTime()) continue;
                String string5 = (String)this.FInvoiceDetail.getField(this.DSRecInvoiceID, i);
                double d9 = (Double)this.FInvoiceDetail.getField(this.DSRecQuantity, i);
                double d10 = (Double)this.FInvoiceDetail.getField(this.DSRecSize_Prefix, i);
                String string6 = (String)this.FInvoiceDetail.getField(this.DSRecSize_Unit, i);
                double d11 = (Double)this.FInvoiceDetail.getField(this.DSRecExtended_Price, i);
                if (!(d9 > 0.0)) continue;
                if (this.Debug) {
                    System.out.println("\tInvoice Detail Date: " + dateutil.formatDate((Date)object, "MM-dd-yyyy") + " Qty: " + invutil.formatQty(d9, d10, string6, this.StoreID) + " ExtPrice: " + d11);
                }
                double d12 = d8 = invutil.convertSize(string, this.StoreID, d9, d10, string6, d3, string2).doubleValue();
                if (d8 == 0.0) {
                    String string7 = (String)this.FInvoiceDetail.getField(this.DSRecInvoice_Number, i);
                    MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "Error: calcPrice Could not convert " + invutil.formatQty(d9, d10, string6, this.StoreID) + " to " + invutil.formatQty(d, d3, string2, this.StoreID) + " in invoice #" + string7 + " on " + dateutil.formatDate((Date)object, "MM-dd-yyyy"));
                    return 0.0;
                }
                double d13 = 0.0;
                if (d4 < d2) {
                    d7 = Math.min(d8, d2 - d4);
                    d4 += d7;
                    d8 -= d7;
                    d13 = d7;
                }
                d7 = d11 / d12;
                double d14 = Math.min(d8, d - d5);
                d5 += d14;
                d6 += d14 * d7;
                if (tAspectDriver != null) {
                    int n4 = tAspectDriver.initializeNewRecord();
                    tAspectDriver.putFieldAbsolute("ItemID", n4, (Object)string);
                    tAspectDriver.putFieldAbsolute("InvoiceID", n4, (Object)string5);
                    tAspectDriver.putFieldAbsolute("VendorID", n4, this.FInvoiceDetail.getField(this.DSRecVendorID, i));
                    tAspectDriver.putFieldAbsolute("Invoice_Number", n4, this.FInvoiceDetail.getField(this.DSRecInvoice_Number, i));
                    tAspectDriver.putFieldAbsolute("Date", n4, object);
                    tAspectDriver.putFieldAbsolute("Purchased_Quantity", n4, (Object)new Double(d9));
                    tAspectDriver.putFieldAbsolute("Purchased_Size_Prefix", n4, (Object)new Double(d10));
                    tAspectDriver.putFieldAbsolute("Purchased_Size_Unit", n4, (Object)string6);
                    tAspectDriver.putFieldAbsolute("Standardized_Quantity", n4, (Object)new Double(d12));
                    tAspectDriver.putFieldAbsolute("Standardized_Size_Prefix", n4, (Object)new Double(d3));
                    tAspectDriver.putFieldAbsolute("Standardized_Size_Unit", n4, (Object)string2);
                    tAspectDriver.putFieldAbsolute("Extended_Price", n4, (Object)new Double(d11));
                    tAspectDriver.putFieldAbsolute("On_Hand_Qty", n4, (Object)new Double(d2));
                    tAspectDriver.putFieldAbsolute("Add_To_On_Hand_Quantity", n4, (Object)new Double(d13));
                    tAspectDriver.putFieldAbsolute("On_Hand_Accounted_For", n4, (Object)new Double(d4));
                    tAspectDriver.putFieldAbsolute("Quantity_To_Price", n4, (Object)new Double(d));
                    tAspectDriver.putFieldAbsolute("Add_To_Quantity", n4, (Object)new Double(d14));
                    tAspectDriver.putFieldAbsolute("Quantity_Accounted_For", n4, (Object)new Double(d5));
                    tAspectDriver.putFieldAbsolute("Add_To_Extended_Price", n4, (Object)new Double(d14 * d7));
                    tAspectDriver.putFieldAbsolute("Cumulative_Extended_Price", n4, (Object)new Double(d6));
                }
                if (this.Debug) {
                    System.out.println("\tConverted Qty: " + d8 + " Unit Price: " + d7 + " QtyToAdd: " + d14 + " QtyAccountedFor: " + d5 + " TotalExtPrice: " + d6);
                }
                if (!(d14 < d8) && !(d5 >= d)) continue;
                break;
            }
            if (bl) break;
        }
        long l3 = new Date().getTime() - l;
        if (d5 == 0.0) {
            DefaultPriceColl = (TComboBoxColl)hDefaultPriceColl.get(this.StoreID);
            if (DefaultPriceColl == null) {
                DefaultPriceColl = TInvoiceDetail.Application.AppCollections.getCollection("Aspect_BackOffice_Lookup_Default_Price_Fields", null, null, false, "StoreID=" + this.StoreID, "");
                hDefaultPriceColl.put(this.StoreID, DefaultPriceColl);
                hDefaultPriceCollLastUpdated.put(this.StoreID, new Date());
            } else {
                object = (Date)hDefaultPriceCollLastUpdated.get(this.StoreID);
                if (object != null) {
                    if (new Date().getTime() - ((Date)object).getTime() > 60000L) {
                        if (TFormulaEvaluator.getCache().collectionStateChanged("Aspect_BackOffice_Lookup_Default_Price_Fields", "true", "StoreID=" + this.StoreID, Application.getAspectHashID())) {
                            DefaultPriceColl.dispose();
                            DefaultPriceColl = TInvoiceDetail.Application.AppCollections.getCollection("Aspect_BackOffice_Lookup_Default_Price_Fields", null, null, false, "StoreID=" + this.StoreID, "");
                            hDefaultPriceColl.put(this.StoreID, DefaultPriceColl);
                        }
                        hDefaultPriceCollLastUpdated.put(this.StoreID, new Date());
                    }
                } else {
                    System.out.println("Error: Cannot determine time last updated DefaultPriceColl");
                }
            }
            object = (String)DefaultPriceColl.getValueOfKey(string);
            stringArray = charutil.getSubStringArray((String)object, '|', false);
            if (stringArray == null) {
                MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "Invalid value for default price fields.  ItemID: " + string + " Field: " + (String)object);
                return 0.0;
            }
            if (stringArray.length != 3) {
                MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "Invalid value for default price fields.  ItemID: " + string + " Field: " + (String)object);
                return 0.0;
            }
            double d15 = 1.0;
            double d16 = charutil.dval(stringArray[0]);
            String string8 = stringArray[1];
            double d17 = charutil.dval(stringArray[2]);
            if (d16 == 0.0 || string8.length() == 0 || d17 == 0.0) {
                MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "Unable to get default price for item: " + string + " s=" + (String)object);
                MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "InvoicePrefix=" + charutil.formatNumber(d16, "#.####") + " for item: " + string);
                MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "InvoiceSize=" + string8 + " for item: " + string);
                MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "InvoiceExtPrice=" + charutil.formatNumber(d17, "#.####") + " for item: " + string);
                return 0.0;
            }
            double d18 = invutil.convertSize(string, this.StoreID, d15, d16, string8, d3, string2);
            if (d18 == 0.0) {
                MainWin.appendToLog("TInvoiceDetail", "calcPrice", Thread.currentThread(), null, 4, "Unable to convert size for default price from " + invutil.formatQty(d15, d16, string8, this.StoreID) + " to " + invutil.formatQty(d, d3, string2, this.StoreID) + " for item: " + string);
                return 0.0;
            }
            if (tAspectDriver != null) {
                int n5 = tAspectDriver.initializeNewRecord();
                tAspectDriver.putFieldAbsolute("ItemID", n5, (Object)string);
                tAspectDriver.putFieldAbsolute("InvoiceID", n5, (Object)"");
                tAspectDriver.putFieldAbsolute("VendorID", n5, (Object)"");
                tAspectDriver.putFieldAbsolute("Invoice_Number", n5, (Object)"Default Price");
                tAspectDriver.putFieldAbsolute("Date", n5, (Object)date2);
                tAspectDriver.putFieldAbsolute("Purchased_Quantity", n5, (Object)new Double(1.0));
                tAspectDriver.putFieldAbsolute("Purchased_Size_Prefix", n5, (Object)new Double(d16));
                tAspectDriver.putFieldAbsolute("Purchased_Size_Unit", n5, (Object)string8);
                tAspectDriver.putFieldAbsolute("Standardized_Quantity", n5, (Object)new Double(d18));
                tAspectDriver.putFieldAbsolute("Standardized_Size_Prefix", n5, (Object)new Double(d3));
                tAspectDriver.putFieldAbsolute("Standardized_Size_Unit", n5, (Object)string2);
                tAspectDriver.putFieldAbsolute("Extended_Price", n5, (Object)new Double(d17));
                tAspectDriver.putFieldAbsolute("On_Hand_Qty", n5, (Object)new Double(0.0));
                tAspectDriver.putFieldAbsolute("Add_To_On_Hand_Quantity", n5, (Object)new Double(0.0));
                tAspectDriver.putFieldAbsolute("On_Hand_Accounted_For", n5, (Object)new Double(0.0));
                tAspectDriver.putFieldAbsolute("Quantity_To_Price", n5, (Object)new Double(d));
                tAspectDriver.putFieldAbsolute("Add_To_Quantity", n5, (Object)new Double(d18));
                tAspectDriver.putFieldAbsolute("Quantity_Accounted_For", n5, (Object)new Double(d18));
                tAspectDriver.putFieldAbsolute("Add_To_Extended_Price", n5, (Object)new Double(d17));
                tAspectDriver.putFieldAbsolute("Cumulative_Extended_Price", n5, (Object)new Double(d17));
            }
            return d17 / d18;
        }
        if (d5 > 0.0) {
            if (this.Debug) {
                System.out.println("\tPrice=" + d6 / d5 + " Elapsed: " + l3);
            }
            return d6 / d5;
        }
        if (this.Debug) {
            System.out.println("\tPrice=0 Elapsed: " + l3);
        }
        return 0.0;
    }
}

