/*
 * Decompiled with CFR 0.152.
 */
package utility.backoffice;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCache;
import collections.TComboBoxColl;
import drivers.aspect.TAspectDriver;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import resources.TApplication;
import utility.TDriverMerge;
import utility.TFormulaEvaluator;
import utility.backoffice.TInventoryMetrics;
import utility.backoffice.TInvoiceDetail;
import utility.backoffice.TTopItemInfo;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;

public class invutil {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static final String[] arSizeTypeName = new String[]{"Undefined", "Volume", "Weight", "Each", "Custom"};
    private static Hashtable hSizeTypeColl = new Hashtable();
    private static Hashtable hSizeFactorColl = new Hashtable();
    private static Hashtable hItemConversionsColl = new Hashtable();
    private static Hashtable hCustomConversionsColl = new Hashtable();
    private static Hashtable hRecordedConversions = new Hashtable();
    private static Hashtable hInventoryItemCalcLegitColl = new Hashtable();
    private static Hashtable hMenuItemDetailCalcLegitColl = new Hashtable();
    private static Hashtable hMenuItemYieldColl = new Hashtable();
    private static Hashtable hLastUpdate = new Hashtable();
    private static Hashtable hSizesModified = new Hashtable();
    private static Hashtable hConversionsModified = new Hashtable();
    private static Hashtable hItemConversionsModified = new Hashtable();
    private static int Interval = 60000;
    private static TInventoryMetrics InventoryMetrics = new TInventoryMetrics();
    private static String CounterName = null;
    private static Hashtable hashItemRecordType = new Hashtable();
    private static Hashtable hConvertSizeErrorMsg = new Hashtable();
    public static Hashtable hashConvertSize = new Hashtable();
    public static Hashtable hashConvertPrice = new Hashtable();
    private static Hashtable hInvoiceDetail = new Hashtable();
    public static Hashtable hashCalcPrice = new Hashtable();

    public static String getItemName(String string, String string2) {
        return (String)TFormulaEvaluator.eval("lookup(\"Aspect_BackOffice_Lookup_Inventory_Item_Name_by_ID\",\"" + string + "\",0,\"StoreID=" + string2 + "\")") + " [" + string + "]";
    }

    public static int getItemRecordtype(String string, String string2) {
        String string3 = string2.toUpperCase().substring(0, 4) + "_" + string.toUpperCase();
        if (hashItemRecordType.containsKey(string3)) {
            Integer n = (Integer)hashItemRecordType.get(string3);
            return n;
        }
        String string4 = (String)TFormulaEvaluator.eval("lookup(\"Aspect_BackOffice_Inventory_Item_Record_Type_by_ID\",\"" + string + "\",0,\"StoreID=" + string2 + "\")");
        int n = charutil.ival(string4);
        hashItemRecordType.put(string3, new Integer(n));
        return n;
    }

    public static String getSizeDescription(String string, String string2) {
        return (String)TFormulaEvaluator.eval("lookup(\"Aspect_BackOffice_Sizes_With_Select\",\"" + string + "\",0,\"StoreID=" + string2 + "\")");
    }

    public static String formatQty(double d, double d2, String string, String string2) {
        String string3 = invutil.getSizeDescription(string, string2);
        boolean bl = false;
        if (string3.indexOf(34) >= 0) {
            bl = true;
            string3 = charutil.replaceChar(string3, '\"', '\u0000');
        }
        if (d == 0.0) {
            String string4 = (String)TFormulaEvaluator.eval("formatQty(\"\",\"\"," + Double.toString(d2) + ",\"#.##\",\"" + string3 + "\",\"true\")");
            if (bl) {
                string4 = charutil.replaceChar(string4, '\u0000', '\"');
            }
            return string4;
        }
        String string5 = (String)TFormulaEvaluator.eval("formatQty(" + Double.toString(d) + ",\"0.00000\"," + Double.toString(d2) + ",\"#.##\",\"" + string3 + "\",\"true\")");
        if (bl) {
            string5 = charutil.replaceChar(string5, '\u0000', '\"');
        }
        return string5;
    }

    public static void sizesModified(String string) {
        System.out.println("invutil.sizesModified(" + string + ")");
        hSizesModified.put(string.toUpperCase(), Boolean.TRUE);
        hashConvertSize.clear();
        hashConvertPrice.clear();
        hashCalcPrice.clear();
    }

    public static void conversionsModified(String string) {
        System.out.println("invutil.conversionsModified(" + string + ")");
        hConversionsModified.put(string.toUpperCase(), Boolean.TRUE);
        System.out.println("Clearing size and price hashtables in invutil");
        hashConvertSize.clear();
        hashConvertPrice.clear();
        hashCalcPrice.clear();
    }

    public static void itemConversionsModified(String string) {
        System.out.println("invutil.itemConversionsModified(" + string + ")");
        hItemConversionsModified.put(string.toUpperCase(), Boolean.TRUE);
        System.out.println("Clearing size and price hashtables in invutil");
        hashConvertSize.clear();
        hashConvertPrice.clear();
        hashCalcPrice.clear();
    }

    public static void invoiceDetailsModified() {
        System.out.println("Clearing price hashtables in invutil");
        hashCalcPrice.clear();
    }

    public static void recordErrorInConvertSize(String string, String string2) {
        if (!hConvertSizeErrorMsg.containsKey(string.toUpperCase())) {
            MainWin.appendToLog("invutil", "recordErrorInConvertSize", Thread.currentThread(), null, 4, string2);
            hConvertSizeErrorMsg.put(string.toUpperCase(), string);
        }
    }

    public static Double convertSize(String string, String string2, double d, double d2, String string3, double d3, String string4) {
        String string5 = (string + "_" + string2 + "_" + Double.toString(d) + "_" + Double.toString(d2) + "_" + string3 + "_" + Double.toString(d3) + "_" + string4).toUpperCase();
        Object v = hashConvertSize.get(string5);
        if (v != null) {
            return (Double)v;
        }
        Double d4 = invutil.convertSizeSub(string, string2, d, d2, string3, d3, string4);
        if (d4.isNaN()) {
            MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, "Error: isNan for ItemID=" + string + " Qty1=" + d + " Prefix1=" + d2 + " Size1=" + string3 + " Prefix2=" + d3 + " Size2=" + string4);
            d4 = new Double(0.0);
        }
        if (d4.isInfinite()) {
            MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, "Error: isInfinite for ItemID=" + string + " Qty1=" + d + " Prefix1=" + d2 + " Size1=" + string3 + " Prefix2=" + d3 + " Size2=" + string4);
            d4 = new Double(0.0);
        }
        hashConvertSize.put(string5, d4);
        return d4;
    }

    public static Double convertSizeSub(String string, String string2, double d, double d2, String string3, double d3, String string4) {
        String string5;
        String string6;
        int n;
        String string7;
        int n2;
        Object object;
        Serializable serializable;
        Object object2;
        InventoryMetrics.setMetric(TInventoryMetrics.CCONVERTSIZE, 1.0);
        if (string2.trim().length() == 0) {
            InventoryMetrics.setMetric(TInventoryMetrics.CMISSINGSTOREID, 1.0);
            invutil.recordErrorInConvertSize(string, "Error in convertSize: Missing StoreID.");
            return new Double(0.0);
        }
        if (d2 == 0.0) {
            InventoryMetrics.setMetric(TInventoryMetrics.CMISSINGPREFIX1, 1.0);
            invutil.recordErrorInConvertSize(string, "Error in convertSize: Missing Prefix1.  ItemID: " + string);
            return new Double(0.0);
        }
        if (string3.equals("0") || string3.trim().length() == 0) {
            InventoryMetrics.setMetric(TInventoryMetrics.CMISSINGSIZE1, 1.0);
            invutil.recordErrorInConvertSize(string, "Error in convertSize: Missing Size1.  ItemID: " + string);
            return new Double(0.0);
        }
        if (d3 == 0.0) {
            InventoryMetrics.setMetric(TInventoryMetrics.CMISSINGPREFIX2, 1.0);
            invutil.recordErrorInConvertSize(string, "Error in convertSize: Missing Prefix2.  ItemID: " + string);
            return new Double(0.0);
        }
        if (string4.equals("0") || string4.trim().length() == 0) {
            InventoryMetrics.setMetric(TInventoryMetrics.CMISSINGSIZE2, 1.0);
            invutil.recordErrorInConvertSize(string, "Error in convertSize: Missing Size2.  ItemID: " + string);
            return new Double(0.0);
        }
        boolean bl = false;
        if (string.equalsIgnoreCase("1855")) {
            bl = true;
        }
        long l = new Date().getTime();
        if (bl) {
            System.out.println("convertSize Item=" + invutil.getItemName(string, string2) + " StoreID=" + string2 + invutil.formatQty(d, d2, string3, string2) + " " + invutil.formatQty(0.0, d3, string4, string2));
        }
        String string8 = string2.toUpperCase();
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        if (string3.equalsIgnoreCase(string4)) {
            double d8 = d * d2 / d3;
            if (bl) {
                System.out.println(invutil.formatQty(d8, d3, string4, string2) + " = " + invutil.formatQty(d, d2, string3, string2) + " Elapsed: " + (new Date().getTime() - l));
            }
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
            return new Double(d8);
        }
        long l2 = new Date().getTime();
        boolean bl2 = true;
        Date date = (Date)hLastUpdate.get(string8);
        if (date != null) {
            bl2 = l2 - date.getTime() > (long)Interval;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (bl2) {
            object2 = TFormulaEvaluator.getCache();
            bl3 = ((TCache)object2).collectionStateChanged("Aspect_BackOffice_Lookup_Size_Types", "true", "StoreID=" + string8, Application.getAspectHashID());
            bl4 = ((TCache)object2).collectionStateChanged("Aspect_BackOffice_Lookup_Size_Factors", "true", "StoreID=" + string8, Application.getAspectHashID());
            bl5 = ((TCache)object2).collectionStateChanged("Aspect_BackOffice_Lookup_Item_Conversion_Factors", "true", "StoreID=" + string8, Application.getAspectHashID());
            bl6 = ((TCache)object2).collectionStateChanged("Aspect_BackOffice_Lookup_Custom_Conversion_Factors", "true", "StoreID=" + string8, Application.getAspectHashID());
        }
        object2 = (string2 + "|" + string + "|" + string3 + "|" + string4).toUpperCase();
        Hashtable<Object, Double> hashtable = (Hashtable<Object, Double>)hRecordedConversions.get(string8);
        if (hashtable != null) {
            if (!(bl3 || bl4 || bl5 || bl6)) {
                if (!(hSizesModified.containsKey(string2.toUpperCase()) || hConversionsModified.containsKey(string2.toUpperCase()) || hItemConversionsModified.containsKey(string2.toUpperCase()))) {
                    if (hashtable != null) {
                        serializable = (Double)hashtable.get(object2);
                        if (serializable != null) {
                            double d9 = (Double)serializable;
                            double d10 = d * d2 * d9 / d3;
                            long l3 = new Date().getTime() - l;
                            if (bl) {
                                System.out.println("Multiplier=" + d9 + " Qty2=" + d10 + " Elapsed: " + l3);
                            }
                            InventoryMetrics.setMetric(TInventoryMetrics.CCONVERSIONUSEDCACHE, 1.0);
                            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                            return new Double(d10);
                        }
                        object = (string2 + "|" + string + "|" + string4 + "|" + string3).toUpperCase();
                        serializable = (Double)hashtable.get(object);
                        if (serializable != null) {
                            double d11 = 1.0 / (Double)serializable;
                            double d12 = d * d2 * d11 / d3;
                            long l4 = new Date().getTime() - l;
                            if (bl) {
                                System.out.println("Multiplier=" + d11 + " Qty2=" + d12 + " Elapsed: " + l4);
                            }
                            InventoryMetrics.setMetric(TInventoryMetrics.CCONVERSIONUSEDCACHE, 1.0);
                            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                            return new Double(d12);
                        }
                    }
                } else {
                    hashtable.clear();
                    hashtable = null;
                }
            } else {
                hashtable.clear();
                hashtable = null;
            }
        }
        serializable = null;
        object = null;
        TComboBoxColl tComboBoxColl = null;
        TComboBoxColl tComboBoxColl2 = null;
        if (bl2) {
            if (!bl3) {
                serializable = (TComboBoxColl)hSizeTypeColl.get(string8);
            }
            if (!bl4) {
                object = (TComboBoxColl)hSizeFactorColl.get(string8);
            }
            if (!bl5) {
                tComboBoxColl = (TComboBoxColl)hItemConversionsColl.get(string8);
            }
            if (!bl6) {
                tComboBoxColl2 = (TComboBoxColl)hCustomConversionsColl.get(string8);
            }
            hLastUpdate.put(string8, new Date());
        } else {
            if (!hSizesModified.containsKey(string2.toUpperCase())) {
                serializable = (TComboBoxColl)hSizeTypeColl.get(string8);
                object = (TComboBoxColl)hSizeFactorColl.get(string8);
            } else {
                hSizesModified.remove(string2.toUpperCase());
                if (hRecordedConversions.containsKey(string8)) {
                    hRecordedConversions.remove(string8);
                }
            }
            if (!hConversionsModified.containsKey(string2.toUpperCase())) {
                tComboBoxColl2 = (TComboBoxColl)hCustomConversionsColl.get(string8);
            } else {
                hConversionsModified.remove(string2.toUpperCase());
                if (hRecordedConversions.containsKey(string8)) {
                    hRecordedConversions.remove(string8);
                }
            }
            if (!hItemConversionsModified.containsKey(string2.toUpperCase())) {
                tComboBoxColl = (TComboBoxColl)hItemConversionsColl.get(string8);
            } else {
                hItemConversionsModified.remove(string2.toUpperCase());
                if (hRecordedConversions.containsKey(string8)) {
                    hRecordedConversions.remove(string8);
                }
            }
        }
        if (serializable == null) {
            if (bl) {
                System.out.println("Creating SizeTypeColl");
            }
            serializable = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Lookup_Size_Types", null, null, false, "StoreID=" + string8, "");
            hSizeTypeColl.put(string8, serializable);
            if (hRecordedConversions.containsKey(string8)) {
                hRecordedConversions.remove(string8);
            }
        }
        if (object == null) {
            if (bl) {
                System.out.println("Creating SizeFactorColl");
            }
            object = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Lookup_Size_Factors", null, null, false, "StoreID=" + string8, "");
            hSizeFactorColl.put(string8, object);
            if (hRecordedConversions.containsKey(string8)) {
                hRecordedConversions.remove(string8);
            }
        }
        if (tComboBoxColl == null) {
            if (bl) {
                System.out.println("Creating ItemConversionsColl");
            }
            tComboBoxColl = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Lookup_Item_Conversion_Factors", null, null, false, "StoreID=" + string8, "");
            hItemConversionsColl.put(string8, tComboBoxColl);
            if (hRecordedConversions.containsKey(string8)) {
                hRecordedConversions.remove(string8);
            }
        }
        if (tComboBoxColl2 == null) {
            if (bl) {
                System.out.println("Creating CustomConversionsColl");
            }
            tComboBoxColl2 = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Lookup_Custom_Conversion_Factors", null, null, false, "StoreID=" + string8, "");
            hCustomConversionsColl.put(string8, tComboBoxColl2);
            if (hRecordedConversions.containsKey(string8)) {
                hRecordedConversions.remove(string8);
            }
        }
        if (hashtable == null) {
            if (bl) {
                System.out.println("Creating hashRecordedConversions");
            }
            hashtable = new Hashtable<Object, Double>();
            hRecordedConversions.put(string8, hashtable);
        }
        if (string3.equalsIgnoreCase("19")) {
            n2 = 4;
        } else {
            string7 = (String)((TComboBoxColl)serializable).getValueOfKey(string3);
            if (string7 == null) {
                String string9 = "Error in conversion1 Item=[" + string + "] StoreID=" + string2 + " " + "convert [" + d + "][" + d2 + "][" + string3 + "] to [0][" + d3 + "][" + string4 + "]";
                string9 = string9 + ": Cannot locate type for size [" + string3 + "]";
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string9);
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, "SizeTypeColl=" + ((TComboBoxColl)serializable).toString());
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION1, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            n2 = charutil.ival(string7);
        }
        if (n2 < 1 || n2 > 4) {
            string7 = "Error in conversion2 Item=[" + string + "] StoreID=" + string2 + " " + "convert [" + d + "][" + d2 + "][" + string3 + "] to [0][" + d3 + "][" + string4 + "]";
            string7 = string7 + ": Type for size1 is invalid: [" + n2 + "]";
            MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string7);
            InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION2, 1.0);
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
            return new Double(0.0);
        }
        if (string4.equalsIgnoreCase("19")) {
            n = 4;
        } else {
            string6 = (String)((TComboBoxColl)serializable).getValueOfKey(string4);
            if (string6 == null) {
                String string10 = "Error in conversion3 Item=[" + string + "] StoreID=" + string2 + " " + "convert [" + d + "][" + d2 + "][" + string3 + "] to [0][" + d3 + "][" + string4 + "]";
                string10 = string10 + ": Cannot locate type for size [" + string4 + "]";
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string10);
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, "SizeTypeColl=" + ((TComboBoxColl)serializable).toString());
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION3, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            n = charutil.ival(string6);
        }
        if (n < 1 || n > 4) {
            string6 = "Error in conversion4 Item=[" + string + "] StoreID=" + string2 + " " + "convert [" + d + "][" + d2 + "][" + string3 + "] to [0][" + d3 + "][" + string4 + "]";
            string6 = string6 + ": Type for size1 is invalid: [" + n2 + "]";
            MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string6);
            InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION4, 1.0);
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
            return new Double(0.0);
        }
        if (n2 < 4) {
            string6 = (String)((TComboBoxColl)object).getValueOfKey(string3);
            if (string6 == null) {
                String string11 = "Error in conversion5 Item=[" + string + "] StoreID=" + string2 + " " + invutil.formatQty(d, d2, string3, string2) + " to " + invutil.formatQty(0.0, d3, string4, string2);
                string11 = string11 + " Cannot locate factor for size " + string3;
                invutil.recordErrorInConvertSize(string, string11);
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION5, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            d4 = charutil.dval(string6);
            string5 = (String)tComboBoxColl.getValueOfKey(string);
            if (string5 == null) {
                string5 = "Error in convertSize1(" + string + "," + d + "," + d2 + "," + string3 + "," + d3 + "," + string4 + ")";
                invutil.recordErrorInConvertSize(string, string5);
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION1, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            switch (n2) {
                case 1: {
                    d6 = charutil.dval(string5.substring(0, 11));
                    break;
                }
                case 2: {
                    d6 = charutil.dval(string5.substring(11, 22));
                    break;
                }
                case 3: {
                    d6 = charutil.dval(string5.substring(22, 33));
                }
            }
        } else if (string3.equalsIgnoreCase("19")) {
            string6 = (String)tComboBoxColl.getValueOfKey(string);
            if (string6 == null) {
                string6 = "Error in convertSize2(" + string + "," + d + "," + d2 + "," + string3 + "," + d3 + "," + string4 + ")";
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string6);
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION2, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            d6 = charutil.dval(string6.substring(33));
        } else {
            string6 = (String)tComboBoxColl2.getValueOfKey(string + "_" + string3);
            if (string6 == null) {
                String string12 = "Error in conversion6 Item=[" + string + "] StoreID=" + string2 + " " + invutil.formatQty(d, d2, string3, string2) + " to " + invutil.formatQty(0.0, d3, string4, string2);
                string12 = string12 + " Cannot locate conversion for size " + string3;
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string12);
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION6, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            d6 = charutil.dval(string6);
        }
        if (n < 4) {
            string6 = (String)((TComboBoxColl)object).getValueOfKey(string4);
            if (string6 == null) {
                string5 = "Error in conversion7 Item=[" + string + "] StoreID=" + string2 + " " + invutil.formatQty(d, d2, string3, string2) + " to " + invutil.formatQty(0.0, d3, string4, string2);
                string5 = string5 + " Cannot locate factor for size " + string4;
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string5);
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION7, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            d5 = charutil.dval(string6);
            string5 = (String)tComboBoxColl.getValueOfKey(string);
            switch (n) {
                case 1: {
                    d7 = charutil.dval(string5.substring(0, 11));
                    break;
                }
                case 2: {
                    d7 = charutil.dval(string5.substring(11, 22));
                    break;
                }
                case 3: {
                    d7 = charutil.dval(string5.substring(22, 33));
                }
            }
        } else if (string4.equalsIgnoreCase("19")) {
            string6 = (String)tComboBoxColl.getValueOfKey(string);
            d7 = charutil.dval(string6.substring(33));
        } else {
            string6 = (String)tComboBoxColl2.getValueOfKey(string + "_" + string4);
            if (string6 == null) {
                string5 = "Error in conversion8 Item=[" + string + "] StoreID=" + string2 + " " + invutil.formatQty(d, d2, string3, string2) + " to " + invutil.formatQty(0.0, d3, string4, string2);
                string5 = string5 + " Cannot locate conversion for size " + string4;
                MainWin.appendToLog("invutil", "convertSize", Thread.currentThread(), null, 4, string5);
                InventoryMetrics.setMetric(TInventoryMetrics.CERRORCONVERSION8, 1.0);
                InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
                return new Double(0.0);
            }
            d7 = charutil.dval(string6);
        }
        if (n2 == n) {
            if (d6 == 0.0) {
                d6 = 1.0;
            }
            if (d7 == 0.0) {
                d7 = 1.0;
            }
        }
        double d13 = d * d2 * d4;
        if (bl) {
            System.out.println("Type1=" + arSizeTypeName[n2] + " Factor1=" + d4 + " Conversion1=" + d6);
            System.out.println("Type2=" + arSizeTypeName[n] + " Factor2=" + d5 + " Conversion2=" + d7);
            System.out.println("n = Qty1 * Prefix1 * Factor1 = " + d + " * " + d2 + " * " + d4 + " = " + d13);
        }
        double d14 = d13 / (d6 / d7) / d3 / d5;
        if (bl) {
            System.out.println("Qty2 = n / (dConversion1/dConversion2) / Prefix2 / dFactor2 = " + d13 + " / (" + d6 + " / " + d7 + ") / " + d3 + " / " + d5 + " = " + d14);
            long l5 = new Date().getTime() - l;
            System.out.println(d14 + " " + d3 + "-" + invutil.getSizeDescription(string4, string2) + " = " + d + " " + d2 + "-" + invutil.getSizeDescription(string3, string2) + " Elapsed: " + l5);
            new Throwable().printStackTrace();
        }
        hashtable.put(object2, new Double(d14 * d3 / (d * d2)));
        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTSIZE, (double)(new Date().getTime() - l));
        return new Double(d14);
    }

    public static Double convertPrice(String string, String string2, double d, double d2, String string3, double d3, String string4) {
        String string5 = (string + "_" + string2 + "_" + Double.toString(d) + "_" + Double.toString(d2) + "_" + string3 + "_" + Double.toString(d3) + "_" + string4).toUpperCase();
        Object v = hashConvertPrice.get(string5);
        if (v != null) {
            return (Double)v;
        }
        Double d4 = invutil.convertPriceSub(string, string2, d, d2, string3, d3, string4);
        hashConvertPrice.put(string5, d4);
        return d4;
    }

    public static Double convertPriceSub(String string, String string2, double d, double d2, String string3, double d3, String string4) {
        InventoryMetrics.setMetric(TInventoryMetrics.CCONVERTPRICE, 1.0);
        long l = new Date().getTime();
        Double d4 = invutil.convertSize(string, string2, d, d2, string3, d3, string4);
        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECONVERTPRICE, (double)(new Date().getTime() - l));
        if (d4 == null) {
            return null;
        }
        if (d4 == 0.0) {
            return new Double(0.0);
        }
        return new Double(d * (1.0 / d4));
    }

    public static boolean calcLegitimateUsage(String string, String string2, double d, double d2, String string3, TAspectDriver tAspectDriver, ArrayList arrayList, TTopItemInfo tTopItemInfo) {
        Double d3;
        double d4;
        Object object;
        String string4;
        InventoryMetrics.setMetric(TInventoryMetrics.CCALCLEGITIMATEUSAGE, 1.0);
        boolean bl = false;
        int n = string3.indexOf(".");
        String string5 = string4 = n > 0 ? string3.substring(0, n) : string3;
        if (bl) {
            String string6 = "calcLegitimateUsage Item=" + invutil.getItemName(string, string2) + " " + invutil.formatQty(d, d2, string4, string2) + "[" + d + "][" + d2 + "][" + string4 + "]  Recurse count=";
            if (arrayList == null) {
                string6 = string6 + "0";
            } else {
                string6 = string6 + Long.toString(arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    string6 = string6 + "r[" + i + "]=" + (String)arrayList.get(i);
                }
            }
            System.out.println(string6);
        }
        if (d == 0.0) {
            if (bl) {
                System.out.println("Aborting because Qty = 0");
            }
            return true;
        }
        long l = new Date().getTime();
        String string7 = string2.toUpperCase();
        TComboBoxColl tComboBoxColl = null;
        TComboBoxColl tComboBoxColl2 = null;
        TComboBoxColl tComboBoxColl3 = null;
        if (arrayList == null) {
            long l2 = new Date().getTime();
            boolean bl2 = true;
            object = (Date)hLastUpdate.get(string7);
            if (object != null) {
                bl2 = l2 - ((Date)object).getTime() > (long)Interval;
            }
            tComboBoxColl = bl2 ? null : (TComboBoxColl)hInventoryItemCalcLegitColl.get(string7);
            tComboBoxColl2 = bl2 ? null : (TComboBoxColl)hMenuItemDetailCalcLegitColl.get(string7);
            TComboBoxColl tComboBoxColl4 = tComboBoxColl3 = bl2 ? null : (TComboBoxColl)hMenuItemYieldColl.get(string7);
            if (tComboBoxColl == null) {
                if (bl) {
                    System.out.println("Creating InventoryItemCalcLegitColl");
                }
                tComboBoxColl = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Inventory_Item_Calc_Legit_Values", null, null, false, "StoreID=" + string7, "");
                hInventoryItemCalcLegitColl.put(string7, tComboBoxColl);
            }
            if (tComboBoxColl2 == null) {
                if (bl) {
                    System.out.println("Creating MenuItemDetailCalcLegitColl");
                }
                tComboBoxColl2 = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Menu_Item_Detail_Calc Legit_Values", null, null, false, "StoreID=" + string7, "");
                hMenuItemDetailCalcLegitColl.put(string7, tComboBoxColl2);
            }
            if (tComboBoxColl3 == null) {
                if (bl) {
                    System.out.println("Creating MenuItemYieldColl");
                }
                tComboBoxColl3 = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Menu_Item_Yield", null, null, false, "StoreID=" + string7, "");
                hMenuItemYieldColl.put(string7, tComboBoxColl3);
            }
            hLastUpdate.put(string7, new Date());
        } else {
            tComboBoxColl = (TComboBoxColl)hInventoryItemCalcLegitColl.get(string7);
            tComboBoxColl2 = (TComboBoxColl)hMenuItemDetailCalcLegitColl.get(string7);
            tComboBoxColl3 = (TComboBoxColl)hMenuItemYieldColl.get(string7);
        }
        String string8 = (String)tComboBoxColl3.getValueOfKey(string);
        if (string8 == null) {
            MainWin.appendToLog("invutil", "calcLegitimateUsage", Thread.currentThread(), null, 4, "Cannot get yield for menu item: " + string);
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECALCLEGITIMATEUSAGE, (double)(new Date().getTime() - l));
            return false;
        }
        double d5 = charutil.dval(string8.substring(0, 11));
        object = string8.substring(11, 19).trim();
        if (bl) {
            System.out.println("Gross Prefix: " + d5 + " Sz: " + (String)object + " [" + invutil.getSizeDescription((String)object, string2) + "]");
        }
        if (bl) {
            System.out.println("Calling convertSize Qty=" + d + " Prefix=" + d2 + " Size=" + string4 + " GrossYieldPrefix=" + d5 + " GrossYieldSizeID=" + (String)object);
        }
        double d6 = d4 = (d3 = invutil.convertSize(string, string2, d, d2, string4, d5, (String)object)) == null ? 0.0 : d3;
        if (bl) {
            System.out.println("Factor=" + d4);
        }
        if (d4 == 0.0) {
            string8 = "Error calculating yield factor. MenuItem=" + invutil.getItemName(string, string2) + " Item=" + " Prefix1=" + d5 + " Size1=" + (String)object + " [" + invutil.getSizeDescription((String)object, string2) + "]";
            MainWin.appendToLog("invutil", "calcLegitimateUsage", Thread.currentThread(), null, 4, string8);
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECALCLEGITIMATEUSAGE, (double)(new Date().getTime() - l));
            return false;
        }
        String string9 = arrayList == null ? string : (String)arrayList.get(0);
        TTopItemInfo tTopItemInfo2 = null;
        tTopItemInfo2 = tTopItemInfo == null ? new TTopItemInfo(string, d, d2, string3, d3, d5, (String)object) : tTopItemInfo;
        int n2 = tAspectDriver.initializeNewRecord();
        tAspectDriver.putFieldAbsolute("Usage_Type", n2, (Object)new Integer(0));
        tAspectDriver.putFieldAbsolute("Top_Item_ID", n2, (Object)string9);
        tAspectDriver.putFieldAbsolute("Top_Item_Original_Qty", n2, (Object)tTopItemInfo2.OriginalQty);
        tAspectDriver.putFieldAbsolute("Top_Item_Original_Size_Prefix", n2, (Object)tTopItemInfo2.OriginalPrefix);
        tAspectDriver.putFieldAbsolute("Top_Item_Original_Size_Unit", n2, (Object)tTopItemInfo2.OriginalSizeID);
        tAspectDriver.putFieldAbsolute("Top_Item_Qty", n2, (Object)tTopItemInfo2.Qty);
        tAspectDriver.putFieldAbsolute("Top_Item_Size_Prefix", n2, (Object)tTopItemInfo2.Prefix);
        tAspectDriver.putFieldAbsolute("Top_Item_Size_Unit", n2, (Object)tTopItemInfo2.SizeID);
        tAspectDriver.putFieldAbsolute("Batch_Item_ID", n2, (Object)string);
        tAspectDriver.putFieldAbsolute("Inventory_Item_ID", n2, (Object)string);
        tAspectDriver.putFieldAbsolute("Quantity", n2, (Object)d);
        tAspectDriver.putFieldAbsolute("Size_Prefix", n2, (Object)d2);
        tAspectDriver.putFieldAbsolute("Size_Unit", n2, (Object)string3);
        if (bl) {
            System.out.println("MenuItemDetailCalcLegitColl size=" + tComboBoxColl2.size());
        }
        for (int i = 0; i < tComboBoxColl2.size(); ++i) {
            string8 = tComboBoxColl2.getKeyOfIndex(i);
            if (!string8.equalsIgnoreCase(string)) continue;
            string8 = tComboBoxColl2.getValueOfIndex(i);
            if (string8.length() < 30) {
                System.out.println("calcLegitimateUsage ItemID=" + string + " AStoreID=" + string2 + " s=" + string8 + " len=" + string8.length());
            }
            String string10 = string8.substring(0, 8).trim();
            double d7 = charutil.dval(string8.substring(8, 19));
            double d8 = charutil.dval(string8.substring(19, 30));
            String string11 = string8.substring(30).trim();
            if (bl) {
                System.out.println("s=" + string8);
            }
            if (bl) {
                System.out.println("Adding usage for: " + invutil.getItemName(string10, string2) + " Amount: " + invutil.formatQty(d7, d8, string11, string2) + " Prefix=" + d8 + " SizeID=" + string11);
            }
            if ((string8 = (String)tComboBoxColl.getValueOfKey(string10)) != null) {
                boolean bl3 = charutil.boolval(string8.substring(0, 1));
                double d9 = charutil.dval(string8.substring(1, 12));
                String string12 = string8.substring(12).trim();
                if (bl) {
                    System.out.println("sInventoryItemID=" + string10 + " bIsMenuItem=" + bl3);
                }
                if (bl3) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        arrayList.add(string.toUpperCase());
                    }
                    if (arrayList.contains(string10.toUpperCase())) {
                        string8 = "";
                        for (int j = 0; j < arrayList.size(); ++j) {
                            if (j > 0) {
                                string8 = string8 + ",";
                            }
                            string8 = string8 + (String)arrayList.get(j);
                        }
                        string8 = string8 + "," + string10.toUpperCase();
                        MainWin.appendToLog("invutil", "calcLegitimateUsage", Thread.currentThread(), null, 4, "Circular reference calculating legit usage for " + invutil.getItemName(string, string2) + " Recurse=" + string8);
                        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECALCLEGITIMATEUSAGE, (double)(new Date().getTime() - l));
                        return false;
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.addAll(arrayList);
                    arrayList2.add(string10.toUpperCase());
                    if (bl) {
                        System.out.println("\tAdding batch recipe " + invutil.getItemName(string10, string2) + "  Amount=(" + d7 + "/" + d4 + ")=" + d7 / d4 + " " + d8 + "-" + invutil.getSizeDescription(string11, string2));
                    }
                    invutil.calcLegitimateUsage(string10, string2, d7 * d4, d8, string11, tAspectDriver, arrayList2, tTopItemInfo2);
                    continue;
                }
                if (bl) {
                    System.out.println("\tCount Size: " + invutil.formatQty(0.0, d2, string12, string2) + " IsMenuItem=" + bl3 + " Ingredient ID: " + string10);
                }
                double d10 = (d3 = invutil.convertSize(string10, string2, d7, d8, string11, d9, string12)) == null ? 0.0 : d3 * d4;
                n2 = tAspectDriver.initializeNewRecord();
                string9 = arrayList == null ? string : (String)arrayList.get(0);
                tAspectDriver.putFieldAbsolute("Usage_Type", n2, (Object)new Integer(1));
                tAspectDriver.putFieldAbsolute("Top_Item_ID", n2, (Object)string9);
                tAspectDriver.putFieldAbsolute("Top_Item_Original_Qty", n2, (Object)tTopItemInfo2.OriginalQty);
                tAspectDriver.putFieldAbsolute("Top_Item_Original_Size_Prefix", n2, (Object)tTopItemInfo2.OriginalPrefix);
                tAspectDriver.putFieldAbsolute("Top_Item_Original_Size_Unit", n2, (Object)tTopItemInfo2.OriginalSizeID);
                tAspectDriver.putFieldAbsolute("Top_Item_Qty", n2, (Object)tTopItemInfo2.Qty);
                tAspectDriver.putFieldAbsolute("Top_Item_Size_Prefix", n2, (Object)tTopItemInfo2.Prefix);
                tAspectDriver.putFieldAbsolute("Top_Item_Size_Unit", n2, (Object)tTopItemInfo2.SizeID);
                tAspectDriver.putFieldAbsolute("Batch_Item_ID", n2, (Object)string);
                tAspectDriver.putFieldAbsolute("Inventory_Item_ID", n2, (Object)string10);
                if (bl) {
                    System.out.println("\tQuantity=" + d10);
                }
                tAspectDriver.putFieldAbsolute("Quantity", n2, (Object)d10);
                tAspectDriver.putFieldAbsolute("Size_Prefix", n2, (Object)d9);
                tAspectDriver.putFieldAbsolute("Size_Unit", n2, (Object)string12);
                if (!bl) continue;
                System.out.println("\tLegit Usage: " + invutil.formatQty(d10, d9, string12, string2) + " r=" + n2);
                continue;
            }
            MainWin.appendToLog("invutil", "calcLegitimateUsage", Thread.currentThread(), null, 4, "Cannot locate recipe ingredient in item list: " + invutil.getItemName(string10, string2));
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECALCLEGITIMATEUSAGE, (double)(new Date().getTime() - l));
            return false;
        }
        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECALCLEGITIMATEUSAGE, (double)(new Date().getTime() - l));
        return true;
    }

    public static double calcPrepCost(String string, String string2, Date date, double d, double d2, String string3, TAspectDriver tAspectDriver) {
        Object object;
        InventoryMetrics.setMetric(TInventoryMetrics.CCALCPREPCOST, 1.0);
        long l = new Date().getTime();
        String string4 = dateutil.formatDate(date, "MM-dd-yyyy");
        TAspectDriver tAspectDriver2 = null;
        if (tAspectDriver == null) {
            object = "StoreID=" + string + "|Date=" + string4;
            tAspectDriver2 = new TAspectDriver("Aspect_Back_Office_Legitimate_Usage_Temp_File_Buffer", 1, true, false, (String)object);
        }
        invutil.calcLegitimateUsage(string2, string, d, d2, string3, tAspectDriver2, null, null);
        object = tAspectDriver2.calcRangeTotals("Standard_Cost", true, "", -1, -1);
        Object object2 = object[1];
        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECALCPREPCOST, (double)(new Date().getTime() - l));
        return (double)object2;
    }

    public static double calcPrice(String string, String string2, Date date, double d, double d2, String string3, TAspectDriver tAspectDriver) {
        return invutil.calcPrice(string, string2, date, d, 0.0, d2, string3, tAspectDriver);
    }

    public static double calcPrice(String string, String string2, Date date, double d, double d2, double d3, String string3, TAspectDriver tAspectDriver) {
        int n;
        if (string2.equalsIgnoreCase("1855")) {
            // empty if block
        }
        if ((n = invutil.getItemRecordtype(string2, string)) != 1) {
            return 0.0;
        }
        if (!string2.equalsIgnoreCase("1855") && tAspectDriver == null) {
            String string4 = string + "_" + string2 + "_" + Long.toString(date.getTime()) + "_" + Double.toString(d) + "_" + Double.toString(d2) + "_" + Double.toString(d3) + "_" + string3;
            Object v = hashCalcPrice.get(string4);
            if (v != null) {
                return (Double)v;
            }
            double d4 = invutil.calcPriceSub(string, string2, date, d, d2, d3, string3, tAspectDriver);
            hashCalcPrice.put(string4, new Double(d4));
            return d4;
        }
        return invutil.calcPriceSub(string, string2, date, d, d2, d3, string3, tAspectDriver);
    }

    public static double calcPriceSub(String string, String string2, Date date, double d, double d2, double d3, String string3, TAspectDriver tAspectDriver) {
        InventoryMetrics.setMetric(TInventoryMetrics.CCALCPRICE, 1.0);
        long l = new Date().getTime();
        String string4 = string.toUpperCase();
        TInvoiceDetail tInvoiceDetail = (TInvoiceDetail)hInvoiceDetail.get(string4);
        if (tInvoiceDetail == null) {
            tInvoiceDetail = new TInvoiceDetail(string4.toUpperCase());
            hInvoiceDetail.put(string4, tInvoiceDetail);
        }
        double d4 = d != 0.0 ? d : 1.0;
        double d5 = tInvoiceDetail.calcPrice(string2, date, d4, d2, d3, string3, tAspectDriver);
        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSECALCPRICE, (double)(new Date().getTime() - l));
        return d5;
    }

    public static double getDefaultPurchasePrice(String string, String string2, String string3, double d, String string4) {
        InventoryMetrics.setMetric(TInventoryMetrics.CGETDEFAULTPURCHASEPRICE, 1.0);
        long l = new Date().getTime();
        TComboBoxColl tComboBoxColl = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Default_Purchase_Info", "", "StoreID=" + string);
        for (int i = 0; i < tComboBoxColl.size(); ++i) {
            TComboBoxColl.TComboBoxCollObj tComboBoxCollObj = (TComboBoxColl.TComboBoxCollObj)tComboBoxColl.get(i);
            if (!tComboBoxCollObj.KeyValue.equalsIgnoreCase(string2)) continue;
            String string5 = tComboBoxCollObj.Value;
            double d2 = -1.0;
            String string6 = "";
            double d3 = 0.0;
            String[] stringArray = charutil.getSubStringArray(string5, ',', true);
            for (int j = 0; j < stringArray.length; ++j) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[j], '|', true);
                if (d2 < 0.0 || stringArray2[0].equalsIgnoreCase(string3)) {
                    d2 = charutil.dval(stringArray2[1]);
                    string6 = stringArray2[2];
                    d3 = charutil.dval(stringArray2[3]);
                }
                if (stringArray2[0].equalsIgnoreCase(string3)) break;
            }
            if (d2 < 0.0) {
                return 0.0;
            }
            if (d2 == d && string6.equalsIgnoreCase(string4)) {
                return d3;
            }
            double d4 = invutil.convertPrice(string2, string, d3, d2, string6, d, string4);
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSEGETDEFAULTPURCHASEPRICE, (double)(new Date().getTime() - l));
            return d4;
        }
        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSEGETDEFAULTPURCHASEPRICE, (double)(new Date().getTime() - l));
        return 0.0;
    }

    public static String getDefaultPurchaseSize(String string, String string2, String string3) {
        InventoryMetrics.setMetric(TInventoryMetrics.CGETDEFAULTPURCHASESIZE, 1.0);
        long l = new Date().getTime();
        TComboBoxColl tComboBoxColl = invutil.Application.AppCollections.getCollection("Aspect_BackOffice_Default_Purchase_Info", "Record_Type=1", "StoreID=" + string);
        for (int i = 0; i < tComboBoxColl.size(); ++i) {
            TComboBoxColl.TComboBoxCollObj tComboBoxCollObj = (TComboBoxColl.TComboBoxCollObj)tComboBoxColl.get(i);
            if (!tComboBoxCollObj.KeyValue.equalsIgnoreCase(string2)) continue;
            String string4 = tComboBoxCollObj.Value;
            double d = -1.0;
            String string5 = "";
            String[] stringArray = charutil.getSubStringArray(string4, ',', true);
            for (int j = 0; j < stringArray.length; ++j) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[j], '|', true);
                System.out.println("getDefaultPurchaseSize j=" + j + " a[0]=" + stringArray[0]);
                if (d < 0.0 || stringArray2[0].equalsIgnoreCase(string3)) {
                    d = charutil.dval(stringArray2[1]);
                    string5 = stringArray2[2];
                }
                if (stringArray2[0].equalsIgnoreCase(string3)) break;
            }
            InventoryMetrics.setMetric(TInventoryMetrics.ELAPSEGETDEFAULTPURCHASESIZE, (double)(new Date().getTime() - l));
            if (d < 0.0) {
                return "";
            }
            return charutil.formatNumber(d, "###.00") + "|" + string5;
        }
        System.out.println("getDefaultPurchaseSize could not find item: " + string2);
        InventoryMetrics.setMetric(TInventoryMetrics.ELAPSEGETDEFAULTPURCHASESIZE, (double)(new Date().getTime() - l));
        return "";
    }

    public static boolean inventoryDataExists(String string, Date date) {
        String string2 = (String)TFormulaEvaluator.eval("lookup(\"Aspect_BackOffice_Store_Directory_By_ID\",\"" + string + "\")");
        String string3 = dateutil.formatDate(date, "MM-dd-yyyy");
        File file = new File(string2 + "physical_count." + string3 + ".bin");
        if (file.exists() && file.length() > 0L) {
            return true;
        }
        file = new File(string2 + "waste_count." + string3 + ".bin");
        if (file.exists() && file.length() > 0L) {
            return true;
        }
        file = new File(string2 + "prep_log." + string3 + ".bin");
        if (file.exists() && file.length() > 0L) {
            return true;
        }
        file = new File(string2 + "mix." + string3 + ".bin");
        if (file.exists() && file.length() > 0L) {
            return true;
        }
        String string4 = (String)TFormulaEvaluator.eval("lookup(\"Aspect_BackOffice_Lookup_Invoice_Number_By_Date\",\"" + string3 + "\",0,\"StoreID=" + string + "\")");
        return string4.trim().length() > 0;
    }

    public static String updatePerpetual(String string, Date date) {
        String string2 = dateutil.formatDate(date, "MM-dd-yyyy");
        String string3 = dateutil.formatDate(new Date(date.getTime() - 86400000L), "MM-dd-yyyy");
        String string4 = (String)TFormulaEvaluator.eval("lookup(\"Aspect_BackOffice_Store_Directory_By_ID\",\"" + string + "\")");
        String string5 = string4 + "inventory_summary." + string2 + ".bin";
        if (!dosutil.fileExists(string5)) {
            return "Error: Missing daily summary: " + string5;
        }
        string5 = string4 + "inventory_summary." + string3 + ".bin";
        if (!dosutil.fileExists(string5)) {
            return "Error: Missing daily summary: " + string5;
        }
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Back_Office_Daily_Inventory_Summary", 0, true, false, "StoreID=" + string + "|Date=" + string3 + "|NoDepend=true");
        tAspectDriver.setActiveFilter("isValidSize(Standard_Size_Prefix,Standard_Size_Unit)", true);
        int n = tAspectDriver.getAbsoluteRecordCount() - tAspectDriver.getRecordCount();
        if (n > 0) {
            System.out.println("Error: Invalid sizes found in " + n + " records in daily inventory summary for " + string3);
        }
        TAspectDriver tAspectDriver2 = new TAspectDriver("Aspect_Back_Office_Daily_Inventory_Summary", 1, true, false, "StoreID=" + string + "|Date=" + string2 + "|NoDepend=true");
        tAspectDriver2.setActiveFilter("true", true);
        String string6 = "Inventory_Item_ID";
        String string7 = "Previous_Day_Perpetual_Size_Prefix|Previous_Day_Perpetual_Size_Unit|Previous_Day_Perpetual_Quantity";
        String string8 = "Previous_Day_Perpetual_Size_Prefix=Standard_Size_Prefix|Previous_Day_Perpetual_Size_Unit=Standard_Size_Unit|Previous_Day_Perpetual_Quantity=Perpetual_To_Carry_Forward";
        TDriverMerge tDriverMerge = new TDriverMerge(false, tAspectDriver2, "", tAspectDriver, "", string6, string7, string8, false);
        long l = new Date().getTime();
        String string9 = tDriverMerge.merge();
        long l2 = new Date().getTime();
        String string10 = "updatePerpetual merge1: " + string9 + " [" + (l2 - l) + "ms]";
        MainWin.appendToLog("invutil", "updatePerpetual", Thread.currentThread(), null, 3, string10);
        string7 = "Previous_Day_Perpetual_Size_Prefix|Previous_Day_Perpetual_Size_Unit|Previous_Day_Perpetual_Quantity|Size_Prefix|Size_Unit";
        tDriverMerge = new TDriverMerge(true, tAspectDriver2, "", tAspectDriver, "", string6, string7, string8, true);
        l = new Date().getTime();
        String string11 = tDriverMerge.merge();
        l2 = new Date().getTime();
        string10 = "updatePerpetual merge2: " + string11 + " [" + (l2 - l) + "ms]";
        MainWin.appendToLog("invutil", "updatePerpetual", Thread.currentThread(), null, 3, string10);
        tAspectDriver.dispose();
        tAspectDriver2.dispose();
        return string9 + "\n" + string11;
    }

    public static TAspectDriver getInventoryMetricsDriver() {
        return InventoryMetrics.getMetricsDriver();
    }

    public static boolean setInventoryMetric(String string, double d) {
        return InventoryMetrics.setMetric(string, d);
    }

    public static void clearInventoryMetrics() {
        InventoryMetrics.clearMetrics();
    }
}

