/*
 * Decompiled with CFR 0.152.
 */
package utility.customers;

import java.util.Date;
import utility.TScriptSocket;
import utility.customers.TCustomerObj;
import utility.customers.THashCustomer;
import utility.notifications.TNotificationServer;

public class TCustomer {
    private static THashCustomer hashCustomer = null;

    public static boolean updateRecord(String string) {
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
            return true;
        }
        return hashCustomer.updateRecord(string);
    }

    public static String getOrganization(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return "Error: Missing HashID: " + string;
        }
        return tCustomerObj.Organization;
    }

    public static String getCompanyID(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return "Error: Missing HashID: " + string;
        }
        return tCustomerObj.CompanyID;
    }

    public static int getDiskIndex(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return -1;
        }
        return tCustomerObj.DiskIndex;
    }

    public static Date getDateOfInstallation(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return new Date(0L);
        }
        return new Date(tCustomerObj.DateOfInstllation);
    }

    public static Date getDateOfLastPayment(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return new Date(0L);
        }
        return new Date(tCustomerObj.DateOfLastPayment);
    }

    public static double getAmountOfLastPayment(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return 0.0;
        }
        return tCustomerObj.AmountOfLastPayment;
    }

    public static Date getAccessExceptionDate(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return new Date(0L);
        }
        return new Date(tCustomerObj.AccessExceptionDate);
    }

    public static boolean getIsSocketConnected(String string) {
        if (TNotificationServer.hashDirectSocket == null) {
            return false;
        }
        return TNotificationServer.hashDirectSocket.containsKey(string);
    }

    public static Date getSocketConnectTime(String string) {
        if (TNotificationServer.hashDirectSocket == null) {
            return new Date(0L);
        }
        String string2 = string.toUpperCase();
        if (TNotificationServer.hashDirectSocket.containsKey(string2)) {
            TScriptSocket tScriptSocket = (TScriptSocket)TNotificationServer.hashDirectSocket.get(string2);
            return new Date(tScriptSocket.tmOpened);
        }
        return new Date(0L);
    }

    public static boolean getIsSupport(String string) {
        TCustomerObj tCustomerObj;
        if (hashCustomer == null) {
            hashCustomer = new THashCustomer();
        }
        if ((tCustomerObj = hashCustomer.get(string.toUpperCase())) == null) {
            return false;
        }
        return tCustomerObj.IsSupport;
    }

    public static boolean getAllowAccess(String string) {
        if (TCustomer.getIsSupport(string)) {
            return true;
        }
        Date date = TCustomer.getDateOfLastPayment(string);
        Date date2 = TCustomer.getAccessExceptionDate(string);
        Date date3 = new Date();
        if (date2.getTime() >= date3.getTime()) {
            return true;
        }
        double d = TCustomer.getAmountOfLastPayment(string);
        Date date4 = date;
        long l = (date3.getTime() - date4.getTime()) / 1000L / 60L / 60L / 24L;
        return d >= 495.0 ? l < 370L : d > 0.0 && l < 35L;
    }
}

