/*
 * Decompiled with CFR 0.152.
 */
package utility.customers;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.files.TBinaryFile;
import java.util.Date;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.customers.TCustomerObj;

public class THashCustomer {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    Hashtable hashCustomer = new Hashtable();

    public THashCustomer() {
        this.updateCollection();
    }

    public TBinaryFile openCustomerDriver() {
        TAppDriversObject tAppDriversObject = THashCustomer.Application.AppDrivers.getAppDriversObject("Aspect_Support_Customer_Profile");
        TBinaryFile tBinaryFile = new TBinaryFile(Application, tAppDriversObject, 0, false);
        try {
            tBinaryFile.makeEditableFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tBinaryFile;
    }

    public TCustomerObj get(String string) {
        TCustomerObj tCustomerObj = (TCustomerObj)this.hashCustomer.get(string.toUpperCase());
        if (tCustomerObj != null) {
            return tCustomerObj;
        }
        TBinaryFile tBinaryFile = this.openCustomerDriver();
        int n = tBinaryFile.getRecordCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)tBinaryFile.getField("HashID", i);
            if (!string2.equalsIgnoreCase(string)) continue;
            tCustomerObj = new TCustomerObj();
            this.hashCustomer.put(string.toUpperCase(), tCustomerObj);
            tCustomerObj.DiskIndex = i;
            this.readCustomerRecord(tBinaryFile, tCustomerObj);
            tBinaryFile.dispose();
            return tCustomerObj;
        }
        tBinaryFile.dispose();
        return null;
    }

    public void updateCollection() {
        this.hashCustomer.clear();
        TBinaryFile tBinaryFile = this.openCustomerDriver();
        int n = tBinaryFile.getRecordCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = (Boolean)tBinaryFile.getField("used", i);
            if (!bl) continue;
            TCustomerObj tCustomerObj = new TCustomerObj();
            String string = (String)tBinaryFile.getField("HashID", i);
            this.hashCustomer.put(string.toUpperCase(), tCustomerObj);
            tCustomerObj.DiskIndex = i;
            this.readCustomerRecord(tBinaryFile, tCustomerObj);
        }
        tBinaryFile.dispose();
    }

    public boolean updateRecord(String string) {
        TBinaryFile tBinaryFile = this.openCustomerDriver();
        TCustomerObj tCustomerObj = (TCustomerObj)this.hashCustomer.get(string.toUpperCase());
        if (tCustomerObj != null) {
            this.readCustomerRecord(tBinaryFile, tCustomerObj);
            tBinaryFile.dispose();
            MainWin.appendToLog("THashCustomer", "updateRecord", Thread.currentThread(), null, 3, "Updated record for: " + string);
            return true;
        }
        int n = tBinaryFile.getRecordCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)tBinaryFile.getField("HashID", i);
            if (!string2.equalsIgnoreCase(string)) continue;
            tCustomerObj = new TCustomerObj();
            this.hashCustomer.put(string2.toUpperCase(), tCustomerObj);
            tCustomerObj.DiskIndex = i;
            this.readCustomerRecord(tBinaryFile, tCustomerObj);
            tBinaryFile.dispose();
            MainWin.appendToLog("THashCustomer", "updateRecord", Thread.currentThread(), null, 3, "Added new record for: " + string);
            return true;
        }
        tBinaryFile.dispose();
        MainWin.appendToLog("THashCustomer", "updateRecord", Thread.currentThread(), null, 3, "Unable to locate record for: " + string);
        return false;
    }

    public void readCustomerRecord(TBinaryFile tBinaryFile, TCustomerObj tCustomerObj) {
        tCustomerObj.HashID = (String)tBinaryFile.getField("HashID", tCustomerObj.DiskIndex);
        tCustomerObj.CompanyID = (String)tBinaryFile.getField("Company_ID", tCustomerObj.DiskIndex);
        tCustomerObj.Organization = (String)tBinaryFile.getField("Organization", tCustomerObj.DiskIndex);
        tCustomerObj.DateOfInstllation = ((Date)tBinaryFile.getField("Date_Added", tCustomerObj.DiskIndex)).getTime();
        tCustomerObj.DateOfLastPayment = ((Date)tBinaryFile.getField("Date_Of_Last_Payment", tCustomerObj.DiskIndex)).getTime();
        tCustomerObj.AmountOfLastPayment = (Double)tBinaryFile.getField("Amount_Of_Last_Payment", tCustomerObj.DiskIndex);
        tCustomerObj.AccessExceptionDate = ((Date)tBinaryFile.getField("AccessExceptionDate", tCustomerObj.DiskIndex)).getTime();
        tCustomerObj.IsSupport = tCustomerObj.CompanyID.toUpperCase().startsWith("5GIAV");
    }
}

