/*
 * Decompiled with CFR 0.152.
 */
package utility.firecracker;

public class X10Command {
    private String m_bits;
    private String m_description;
    private static final int[] HOUSE_CODES = new int[]{24576, 28672, 16384, 20480, 32768, 36864, 40960, 45056, 57344, 61440, 49152, 53248, 0, 4096, 8192, 12288};
    private static final int[] UNIT_CODES = new int[]{0, 16, 8, 24, 64, 80, 72, 88, 1024, 1040, 1032, 1048, 1088, 1104, 1096, 1112};

    public static X10Command makeOnCommand(char c, int n) {
        return new X10Command(X10Command.getHouseBits(c) | X10Command.getUnitBits(n) | 0, "" + c + n + "_ON");
    }

    public static X10Command makeOffCommand(char c, int n) {
        return new X10Command(X10Command.getHouseBits(c) | X10Command.getUnitBits(n) | 0x20, "" + c + n + "_OFF");
    }

    public static X10Command makeDimCommand(char c) {
        return new X10Command(X10Command.getHouseBits(c) | 0x98, c + "_DIM");
    }

    public static X10Command makeBrightCommand(char c) {
        return new X10Command(X10Command.getHouseBits(c) | 0x88, c + "_BRIGHT");
    }

    private X10Command(int n, String string) {
        int n2;
        this.m_description = string;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < 8; ++n2) {
            stringBuffer.append((n & 0x8000) != 0 ? (char)'1' : '0');
            n <<= 1;
        }
        stringBuffer.append(' ');
        for (n2 = 0; n2 < 8; ++n2) {
            stringBuffer.append((n & 0x8000) != 0 ? (char)'1' : '0');
            n <<= 1;
        }
        this.m_bits = stringBuffer.toString();
    }

    public String toString() {
        return this.m_description;
    }

    public String getBits() {
        return this.m_bits;
    }

    private static int getHouseBits(char c) {
        if (c < 'A' || c > 'P') {
            throw new IllegalArgumentException();
        }
        return HOUSE_CODES[c - 65];
    }

    private static int getUnitBits(int n) {
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException();
        }
        return UNIT_CODES[n - 1];
    }
}

