/*
 * Decompiled with CFR 0.152.
 */
package utility.html;

import java.util.Enumeration;
import java.util.Properties;
import utility.charutil;

public class TParseHtmlTag {
    public String RawTag = "";
    public String TagType = "";
    public String Text = "";
    public String AspectPrefix = "";
    public boolean IsClosingTag = false;
    public boolean HasMembers = false;
    public boolean IsAspectTag = false;
    public Properties properties = null;
    public boolean IsSimpleTag = false;
    public boolean IsClosed = false;
    public boolean IsComment = false;
    public boolean IsBlockStart = false;
    public boolean IsTableElement = false;
    public boolean IsHeadElement = false;
    public boolean IsBodyElement = false;
    public boolean IsScriptElement = false;
    public boolean IsText = false;
    public int cIndent = 0;
    public boolean ErrNoOpeningTag = false;
    public boolean ErrWrongIndent = false;
    public boolean ErrNotClosed = false;
    public StringBuilder MemberOf = new StringBuilder();
    public int ParentTag = -1;
    public int LineNumber = 0;
    public int Index = -1;
    public String propExpressionExpression = "";
    public String propDriverDriver = "";
    public String propDriverParams = "";
    public String propDriverDebug = "";
    public String propDriverSystemDriver = "";
    public String propDriverDisplay = "";
    public String propDriverFields = "";
    public String propDriverSort = "";
    public String propDriverFilter = "";
    public String propDriverSubtotal1 = "";
    public String propDriverSubtotal2 = "";
    public String propDriverSubtotal3 = "";
    public String propDriverSubtotal4 = "";
    public String propDriverSubtotal5 = "";
    public String propDriverSubtotal6 = "";
    public String propDriverDetails = "";
    public String propDriverName = "";
    public String propDriverMaxRecords = "";
    public String propDriverStartRecord = "";
    public String propDriverPaging = "";
    public String propDriverPageArgs = "";
    public String propDriverUrl = "";
    public String propDriverCellFormatting = "";
    public String propDriverClass = "";
    public String propDriverTableID = "";
    public String propDriverTableStyle = "";
    public String propDriverTableBorder = "";
    public String propDriverTableHeader = "";
    public String propScriptCommands = "";
    public String propWidgetServer = "";
    public String propWidgetLibrary = "";
    public String propWidgetName = "";
    public String propWidgetDocumentID = "";
    public String propWidgetWidget = "";
    public String propWidgetParams = "";
    public String propWidgetSecure = "";
    public String propWidgetDebug = "";
    public String propConstantName = "";
    public String propConstantValue = "";
    private static String strAspectTags = "|INCLUDE|CONSTANT|CONDITIONAL|RECORD|";
    private static String strSimpleTags = "|BR|HR|IMG|META|DOCTYPE|!--|LINK|CONSTANT|INPUT|INCLUDE|?XML|";
    private static String strSimpleProps = "|HTML|PUBLIC|";
    private int StartIndex = -1;
    private int EndIndex = -1;

    public TParseHtmlTag(String string) {
        this.TagType = charutil.removeQuotes(string);
        if (this.TagType.equalsIgnoreCase("constant") || this.TagType.equalsIgnoreCase("conditional") || this.TagType.equalsIgnoreCase("include")) {
            this.IsAspectTag = true;
        }
    }

    public TParseHtmlTag(String string, int n, int n2) {
        this.RawTag = string;
        this.StartIndex = n;
        this.EndIndex = n2;
        this.parseTag();
    }

    public TParseHtmlTag(String string, int n, int n2, boolean bl) {
        this.RawTag = string;
        this.Text = string;
        this.StartIndex = n;
        this.EndIndex = n2;
        this.IsText = true;
    }

    public void parseTag() {
        this.RawTag = charutil.replaceAllSubstrings(this.RawTag, " =", "=");
        this.RawTag = charutil.replaceAllSubstrings(this.RawTag, "= ", "=");
        this.RawTag = charutil.replaceAllSubstrings(this.RawTag, "/ >", "/>");
        if (this.RawTag.endsWith("/>")) {
            this.RawTag = this.RawTag.substring(0, this.RawTag.length() - 1) + ">";
            this.IsClosed = true;
        }
        if (this.RawTag.startsWith("<!--")) {
            this.IsComment = true;
            if (this.RawTag.endsWith("-->")) {
                this.RawTag = this.RawTag.substring(0, this.RawTag.length() - 2) + ">";
                this.IsClosed = true;
            }
        }
        if (this.IsComment) {
            this.TagType = "comment";
            this.properties = new Properties();
            String string = this.RawTag.substring(4, this.RawTag.length() - 2);
            if (string.endsWith("-->")) {
                string = string.substring(0, string.length() - 3);
            }
            this.properties.setProperty("comment", string);
            return;
        }
        if (this.RawTag.toUpperCase().startsWith("<![CDATA")) {
            this.TagType = "CDATA";
            this.Text = this.RawTag.substring(0, this.RawTag.length() - 1);
            this.Text = charutil.replaceAllSubstrings(charutil.removeControlChars(this.Text), "<![CDATA[", "");
            this.Text = charutil.replaceAllSubstrings(this.Text, "]]", "");
            this.IsText = true;
            this.IsClosed = true;
            return;
        }
        int n = this.RawTag.indexOf(" ");
        if (n >= 0) {
            String[] stringArray;
            this.TagType = this.RawTag.substring(1, n);
            while (this.TagType.startsWith("!")) {
                this.TagType = this.TagType.substring(1);
                this.AspectPrefix = this.AspectPrefix + "!";
            }
            if (this.TagType.endsWith("/")) {
                this.TagType = this.TagType.substring(0, this.TagType.length() - 1);
                this.IsClosed = true;
            }
            String string = this.RawTag.substring(n, this.RawTag.length() - 1);
            int n2 = 32;
            if (strAspectTags.indexOf("|" + this.TagType.toUpperCase() + "|") >= 0) {
                this.IsAspectTag = true;
                n2 = 59;
            }
            if ((stringArray = charutil.getSubStringArray(string, (char)n2, false)) != null && stringArray.length > 0) {
                this.properties = new Properties();
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2;
                    char c = '=';
                    if (this.IsAspectTag) {
                        c = ':';
                    }
                    if ((stringArray2 = charutil.getSubStringArray(stringArray[i], c, false)) == null || stringArray2.length <= 0) continue;
                    stringArray2[0] = charutil.removeControlChars(stringArray2[0]);
                    if (stringArray2.length == 1) {
                        if (stringArray2[0].equals("/")) {
                            this.IsClosed = true;
                            continue;
                        }
                        this.properties.put(stringArray2[0], "");
                        continue;
                    }
                    for (int j = 2; j < stringArray2.length; ++j) {
                        stringArray2[1] = stringArray2[1] + c + stringArray2[j];
                    }
                    stringArray2[1] = charutil.removeQuotes(stringArray2[1]);
                    this.properties.setProperty(stringArray2[0], stringArray2[1]);
                    if (stringArray2[0].equalsIgnoreCase("Expression")) {
                        this.propExpressionExpression = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Driver")) {
                        this.propDriverDriver = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Params")) {
                        this.propDriverParams = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Debug")) {
                        this.propDriverDebug = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("SystemDriver")) {
                        this.propDriverSystemDriver = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Display")) {
                        this.propDriverDisplay = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Fields")) {
                        this.propDriverFields = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Sort")) {
                        this.propDriverSort = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Filter")) {
                        this.propDriverFilter = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Subtotal1")) {
                        this.propDriverSubtotal1 = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Subtotal2")) {
                        this.propDriverSubtotal2 = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Subtotal3")) {
                        this.propDriverSubtotal3 = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Subtotal4")) {
                        this.propDriverSubtotal4 = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Subtotal5")) {
                        this.propDriverSubtotal5 = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Subtotal6")) {
                        this.propDriverSubtotal6 = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Details")) {
                        this.propDriverDetails = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Name")) {
                        this.propDriverName = stringArray2[1];
                        this.propConstantName = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("MaxRecords")) {
                        this.propDriverMaxRecords = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("StartRecord")) {
                        this.propDriverStartRecord = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Paging")) {
                        this.propDriverPaging = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("PageArgs")) {
                        this.propDriverPageArgs = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Url")) {
                        this.propDriverUrl = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("CellFormatting")) {
                        this.propDriverCellFormatting = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Class")) {
                        this.propDriverClass = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("TableID")) {
                        this.propDriverTableID = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("TableStyle")) {
                        this.propDriverTableStyle = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("TableBorder")) {
                        this.propDriverTableBorder = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("TableHeader")) {
                        this.propDriverTableHeader = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Commands")) {
                        this.propScriptCommands = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Server")) {
                        this.propWidgetServer = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Library")) {
                        this.propWidgetLibrary = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Name")) {
                        this.propWidgetName = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("DocumentID")) {
                        this.propWidgetDocumentID = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Widget")) {
                        this.propWidgetWidget = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Params")) {
                        this.propWidgetParams = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Secure")) {
                        this.propWidgetSecure = stringArray2[1];
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("Debug")) {
                        this.propWidgetDebug = stringArray2[1];
                        continue;
                    }
                    if (!stringArray2[0].equalsIgnoreCase("Value")) continue;
                    this.propConstantValue = stringArray2[1];
                }
            }
        } else {
            this.TagType = this.RawTag.substring(1, this.RawTag.length() - 1);
            while (this.TagType.startsWith("!")) {
                this.TagType = this.TagType.substring(1);
                this.AspectPrefix = this.AspectPrefix + "!";
            }
        }
        if (!this.RawTag.equalsIgnoreCase("<link>") && strSimpleTags.indexOf("|" + this.TagType.toUpperCase() + "|") >= 0) {
            this.IsSimpleTag = true;
            this.IsClosed = true;
        }
        if (this.TagType.startsWith("/")) {
            this.TagType = this.TagType.substring(1);
            this.IsClosingTag = true;
        }
    }

    public String getText() {
        return this.Text;
    }

    public int getIndent() {
        return this.cIndent;
    }

    public void setIndent(int n) {
        this.cIndent = n;
    }

    public String getTagType() {
        if (this.IsText) {
            return "Text";
        }
        return this.TagType;
    }

    public boolean isClosingTag() {
        return this.IsClosingTag;
    }

    public boolean isSimpleTag() {
        return this.IsSimpleTag;
    }

    public boolean isAspectTag() {
        return this.IsAspectTag;
    }

    public boolean isText() {
        return this.IsText;
    }

    public void setIsClosed(boolean bl) {
        this.IsClosed = bl;
    }

    public void addMemberOf(int n) {
        if (this.MemberOf.length() > 0) {
            this.MemberOf.append("|");
        }
        this.MemberOf.append(Integer.toString(n));
    }

    public String getMemberOf() {
        return this.MemberOf.toString();
    }

    public void setErrNoOpeningTag(boolean bl) {
        this.ErrNoOpeningTag = bl;
    }

    public boolean getErrNoOpeningTag() {
        return this.ErrNoOpeningTag;
    }

    public void setIsTableElement(boolean bl) {
        this.IsTableElement = bl;
    }

    public boolean getIsTableElement() {
        return this.IsTableElement;
    }

    public void setIsHeadElement(boolean bl) {
        this.IsHeadElement = bl;
    }

    public boolean getIsHeadElement() {
        return this.IsHeadElement;
    }

    public void setIsBodyElement(boolean bl) {
        this.IsBodyElement = bl;
    }

    public boolean getIsBodyElement() {
        return this.IsBodyElement;
    }

    public void setIsScriptElement(boolean bl) {
        this.IsScriptElement = bl;
    }

    public boolean getIsScriptElement() {
        return this.IsScriptElement;
    }

    public boolean isClosed() {
        return this.IsClosed;
    }

    public String getProperty(String string) {
        String string2 = "";
        if (this.properties != null) {
            Enumeration<?> enumeration = this.properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.equalsIgnoreCase(string)) continue;
                string2 = (String)this.properties.get(string3);
                break;
            }
        }
        return string2;
    }

    public void setProperty(String string, String string2) {
        String string3 = string2;
        if (string.equalsIgnoreCase("comment")) {
            string3 = charutil.removeQuotes(string2);
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!string4.equalsIgnoreCase(string)) continue;
            this.properties.setProperty(string4, string3);
            return;
        }
        this.properties.setProperty(string, string3);
    }

    public String getIncludeType() {
        if (!this.IsAspectTag) {
            return "";
        }
        if (this.isFileInclude()) {
            return "file";
        }
        if (this.isExpressionInclude()) {
            return "expression";
        }
        if (this.isDriverInclude()) {
            return "driver";
        }
        if (this.isScriptInclude()) {
            return "script";
        }
        if (this.isWidgetInclude()) {
            return "widget";
        }
        return "";
    }

    public boolean isDriverInclude() {
        return this.getProperty("type").equalsIgnoreCase("driver");
    }

    public boolean isExpressionInclude() {
        return this.getProperty("type").equalsIgnoreCase("expression");
    }

    public boolean isFileInclude() {
        return this.getProperty("type").equalsIgnoreCase("file");
    }

    public boolean isScriptInclude() {
        return this.getProperty("type").equalsIgnoreCase("script");
    }

    public boolean isWidgetInclude() {
        return this.getProperty("type").equalsIgnoreCase("widget");
    }

    public boolean isConstantInclude() {
        return this.getProperty("type").equalsIgnoreCase("constant");
    }

    public String getFormattedOutput() {
        if (this.TagType.equalsIgnoreCase("text")) {
            return this.Text;
        }
        if (this.IsComment) {
            return "<!--" + this.getProperty("comment") + "-->";
        }
        String string = "<" + this.AspectPrefix + this.TagType;
        if (this.properties != null) {
            string = string + " " + this.getProperties("");
        }
        string = string + ">";
        return string;
    }

    public String formatValue(String string) {
        if (string.length() > 0) {
            if (string.indexOf("\"") > 0) {
                if (!string.startsWith("'") || !string.endsWith("'")) {
                    string = "'" + string + "'";
                }
            } else if (!(string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\""))) {
                string = "\"" + string + "\"";
            }
        }
        return string;
    }

    public String getProperties(String string) {
        if (this.properties == null) {
            return "";
        }
        String string2 = string.toUpperCase() + "|";
        String string3 = " ";
        String string4 = "=";
        if (this.IsAspectTag) {
            string3 = "; ";
            string4 = ":";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (string2.indexOf(string5.toUpperCase() + "|") >= 0) continue;
            String string6 = this.properties.getProperty(string5);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string3);
            }
            if (this.isDriverInclude()) {
                stringBuilder.append("\r\n");
            }
            stringBuilder.append(string5);
            if (string6.trim().length() <= 0) continue;
            string6 = this.formatValue(string6);
            stringBuilder.append(string4 + string6);
        }
        return stringBuilder.toString();
    }

    public String getPropertiesHtml() {
        String string = " ";
        if (this.isDriverInclude() || this.isScriptInclude()) {
            string = "\r\n";
        }
        if (this.properties == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.properties.getProperty(string2);
            string2 = charutil.removeControlChars(string2);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            if (this.IsComment) {
                if ((string3 = charutil.removeChar(string3, '\t')).trim().length() <= 0) continue;
                stringBuilder.append("<span class='" + this.TagType + this.getIncludeType() + "propvalue'>" + charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(string3, "<", "&lt;"), ">", "&gt;") + "</span>");
                continue;
            }
            string3 = this.formatValue(string3);
            stringBuilder.append("<span class='" + this.TagType + this.getIncludeType() + "propname'>" + charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(string2, "<", "&lt;"), ">", "&gt;") + "</span>");
            if (string3.trim().length() <= 0) continue;
            stringBuilder.append(" = <span class='" + this.TagType + "propvalue'>" + charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(string3, "<", "&lt;"), ">", "&gt;") + "</span>");
        }
        return stringBuilder.toString();
    }

    public int getStartIndex() {
        return this.StartIndex;
    }

    public int getEndIndex() {
        return this.EndIndex;
    }

    public boolean isMemberOf(int n) {
        String string = "|" + this.MemberOf + "|";
        return string.indexOf("|" + Integer.toString(n) + "|") >= 0;
    }

    public String toString() {
        String string;
        String string2 = charutil.formatNumber(this.StartIndex, "00000") + " " + charutil.formatNumber(this.EndIndex, "00000") + " [";
        string2 = this.IsText ? string2 + "T" : string2 + " ";
        string2 = this.IsSimpleTag ? string2 + "s" : string2 + " ";
        string2 = this.IsAspectTag ? string2 + "a" : string2 + " ";
        string2 = this.IsClosingTag ? string2 + "/" : string2 + " ";
        string2 = this.IsClosed ? string2 + "X" : string2 + " ";
        string2 = string2 + "] ";
        for (int i = 0; i < this.cIndent; ++i) {
            string2 = string2 + "\t";
        }
        if (this.IsClosingTag) {
            string2 = string2 + "/";
        }
        string2 = string2 + this.TagType;
        if (this.properties != null) {
            string2 = string2 + " Properties:";
            Enumeration<?> enumeration = this.properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = this.properties.getProperty(string3);
                string2 = string2 + " " + charutil.removeControlChars(string3);
                if ((string4 = charutil.removeControlChars(string4)).length() <= 0) continue;
                string2 = string2 + "=" + string4;
            }
        }
        if ((string = charutil.removeControlChars(this.Text).trim()).length() > 0) {
            string2 = string2 + string;
        } else if (this.IsText) {
            return "";
        }
        string2 = string2 + " MemberOf: " + this.MemberOf;
        return string2;
    }

    public static boolean isSimpleProperty(String string) {
        return strSimpleProps.indexOf("|" + string.toUpperCase() + "|") >= 0;
    }
}

