/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import utility.charutil;

public class netutil {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean boolNotConnected = false;
    private static Date dtLastExternalIPCheck = new Date();
    private static Hashtable hashHostName = new Hashtable();
    public static StringBuilder ExternalIPAddress = null;

    public static long ipaddrToLong(String string) {
        String[] stringArray = charutil.getSubStringArray(string, '.', false);
        long l = 0L;
        if (stringArray == null) {
            return -1L;
        }
        block6: for (int i = 0; i < stringArray.length; ++i) {
            long l2 = charutil.ival(stringArray[i]);
            switch (i) {
                case 0: {
                    l += l2 * 0x1000000L;
                    continue block6;
                }
                case 1: {
                    l += l2 * 65536L;
                    continue block6;
                }
                case 2: {
                    l += l2 * 256L;
                    continue block6;
                }
                case 3: {
                    l += l2;
                }
            }
        }
        return l;
    }

    public static String longToIPAddr(long l) {
        String string = "";
        int[] nArray = new int[4];
        long l2 = l;
        nArray[0] = (int)Math.floor(l2 / 0x1000000L);
        nArray[1] = (int)Math.floor((l2 -= (long)nArray[0] * 0x1000000L) / 65536L);
        nArray[2] = (int)Math.floor((l2 -= (long)nArray[1] * 65536L) / 256L);
        nArray[3] = (int)(l2 -= (long)nArray[2] * 256L);
        for (int i = 0; i < 4; ++i) {
            string = string + Integer.toString(nArray[i]);
            if (i >= 3) continue;
            string = string + ".";
        }
        return string;
    }

    public static String getNetRangeStart(String string) {
        int n = string.indexOf("-");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getNetRangeEnd(String string) {
        int n = string.indexOf("-");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getExternalIP() {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (MainWin.isRunningOnServer()) {
            String string2 = TMainWin.Application.getTokenValue("AspectServerIP1a").trim();
            MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP AspectServerIP1a=[" + string2 + "]");
            if (string2.length() == 0) {
                string2 = "192.169.215.186";
                TMainWin.Application.setTokenValue("AspectServerIP1a", "192.169.215.186");
                MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP set AspectServerIP1a=[" + string2 + "]");
            }
            return string2;
        }
        if (boolNotConnected && new Date().getTime() - dtLastExternalIPCheck.getTime() < 30000L) {
            if (MainWin.isRunningOnServer()) {
                MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Not connected.  Returning 192.169.215.186");
                return "192.169.215.186";
            }
            MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Not connected.  Returning blank external IP");
            return "";
        }
        dtLastExternalIPCheck = new Date();
        if (TMainWin.AllConnectionsLocal) {
            System.out.println("!!! All connections are local !!!");
            return "70.41.193.36";
        }
        if (ExternalIPAddress != null) {
            if (ExternalIPAddress.toString().trim().length() > 0) {
                return ExternalIPAddress.toString();
            }
            MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Last ExternalIPAddress was is blank");
        } else {
            MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Last ExternalIPAddress was is null");
        }
        if (Aspect.getArg("-local") != null) {
            if (TMainWin.Application.getDevelopmentMode() == 0) {
                System.out.println("============== External IP is fixed ==============");
                ExternalIPAddress = new StringBuilder("999.999.999.999");
                return ExternalIPAddress.toString();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        try {
            MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Getting external IP from earthlink");
            object3 = new URL("http://www.aspect-software.net/Aspect7/getipaddress.shtml");
            object2 = ((URL)object3).openConnection();
            ((URLConnection)object2).setConnectTimeout(30000);
            ((URLConnection)object2).setReadTimeout(30000);
            object = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                stringBuilder.append(string);
            }
            ExternalIPAddress = new StringBuilder(stringBuilder.toString());
            if (ExternalIPAddress.toString().trim().length() > 0) {
                MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Got external IP from earthlink: " + ExternalIPAddress);
                bl = true;
            } else {
                MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Got blank external IP from earthlink");
            }
        }
        catch (Exception exception) {
            MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), exception, 4, "getExternalIP: Error: Could not get IP from earthlink: " + exception.toString());
        }
        if (!bl) {
            try {
                MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Getting external IP from Aspect server");
                object3 = TMainWin.Application.getTokenValue("AspectServerIP1");
                if (((String)object3).trim().length() == 0) {
                    object3 = "192.169.215.186";
                }
                object2 = new URL("http://" + (String)object3 + "/myip");
                object = ((URL)object2).openConnection();
                ((URLConnection)object).setConnectTimeout(30000);
                ((URLConnection)object).setReadTimeout(30000);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                if (netutil.isValidIPAddress(stringBuilder.toString())) {
                    ExternalIPAddress = new StringBuilder(stringBuilder.toString());
                    MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Got external IP from Aspect server: " + ExternalIPAddress);
                } else {
                    MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 4, "getExternalIP: Could not determine external IP address[1].");
                    boolNotConnected = true;
                }
            }
            catch (Exception exception) {
                MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 4, "getExternalIP: Could not determine external IP address[2].");
                boolNotConnected = true;
            }
        }
        if (MainWin.isRunningOnServer() && stringBuilder.toString().trim().length() == 0) {
            stringBuilder.setLength(0);
            stringBuilder.append("192.169.215.186");
            MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Forced external IP to 192.169.215.186");
        }
        MainWin.appendToLog("netutil", "getExternalIP", Thread.currentThread(), null, 3, "getExternalIP: Returns " + stringBuilder.toString());
        return stringBuilder.toString();
    }

    public static InetAddress getInetAddress(String string) {
        InetAddress inetAddress = null;
        String string2 = charutil.removeQuotes(string.trim());
        if (string2.length() == 0) {
            return null;
        }
        try {
            if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
                String[] stringArray = charutil.getSubStringArray(string2, '.', false);
                byte[] byArray = new byte[]{(byte)charutil.ival(stringArray[0]), (byte)charutil.ival(stringArray[1]), (byte)charutil.ival(stringArray[2]), (byte)charutil.ival(stringArray[3])};
                inetAddress = InetAddress.getByAddress(byArray);
            } else {
                inetAddress = InetAddress.getByName(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inetAddress;
    }

    public static String getIPAddress(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        InetAddress inetAddress = netutil.getInetAddress(string);
        if (inetAddress == null) {
            return "";
        }
        byte[] byArray = inetAddress.getAddress();
        for (int i = 0; i < 4; ++i) {
            stringBuilder.append(Integer.toString(charutil.unsignedByteToInt(byArray[i])));
            if (i >= 3) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static String getHostName(String string) {
        if (string == null) {
            return "";
        }
        String string2 = (String)hashHostName.get(string);
        if (string2 != null) {
            return string2;
        }
        InetAddress inetAddress = netutil.getInetAddress(string);
        string2 = inetAddress != null ? inetAddress.getHostName() : "Unknown host";
        hashHostName.put(string, string2);
        return string2;
    }

    public static String getCanonicalHostName(String string) {
        if (string == null) {
            return "";
        }
        if (string.trim().length() == 0) {
            return "";
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                return inetAddress.getHostName();
            }
        }
        catch (Exception exception) {
            System.out.println("getExternalHostName: " + exception.toString());
        }
        return "";
    }

    public static String getLocalIP() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                return inetAddress.getHostAddress();
            }
        }
        catch (Exception exception) {
            System.out.println("getLocalIP: " + exception.toString());
        }
        return "";
    }

    public static String getLocalHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                return inetAddress.getHostName();
            }
        }
        catch (Exception exception) {
            System.out.println("getLocalHostName: " + exception.toString());
        }
        return "";
    }

    public static String extractDnsRequest(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 12;
        int n3 = string.length();
        if (n3 < 13) {
            return "";
        }
        do {
            int n4;
            if ((n = (n4 = (int)string.charAt(n2)) >= 0 ? n4 : n4 + 256) <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            for (int i = 0; i < n && n2 + i + 1 < n3; ++i) {
                stringBuilder.append(string.charAt(n2 + i + 1));
            }
        } while (n != 0 && (n2 += n + 1) < string.length());
        return stringBuilder.toString();
    }

    public static String getNetworkClass(String string) {
        if (netutil.isLocalNetworkIPAddress(string)) {
            return "";
        }
        String[] stringArray = charutil.getSubStringArray(string, '.', false);
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        int n = charutil.ival(stringArray[0]);
        if (n >= 0 && n <= 127) {
            return "A";
        }
        if (n >= 128 && n <= 191) {
            return "B";
        }
        if (n >= 192 && n <= 223) {
            return "C";
        }
        if (n >= 224 && n <= 239) {
            return "D";
        }
        if (n >= 240 && n <= 247) {
            return "E";
        }
        return "";
    }

    public static String getNetworkHostID(String string) {
        String string2;
        String[] stringArray;
        String string3 = "";
        if (string.indexOf(45) >= 0) {
            stringArray = charutil.getSubStringArray(string, '-', false);
            if (stringArray == null) {
                return "";
            }
            string2 = stringArray[0];
        } else {
            string2 = string;
        }
        stringArray = charutil.getSubStringArray(string2, '.', false);
        if (stringArray == null || stringArray.length < 4) {
            return "";
        }
        String string4 = netutil.getNetworkClass(string2);
        if (string4.length() > 0) {
            switch (string4.charAt(0)) {
                case 'A': {
                    string3 = stringArray[1] + '.' + stringArray[2] + '.' + stringArray[3];
                    break;
                }
                case 'B': {
                    string3 = stringArray[2] + '.' + stringArray[3];
                    break;
                }
                case 'C': {
                    string3 = stringArray[3];
                }
            }
        }
        return string3;
    }

    public static String getNetworkNetworkID(String string) {
        String string2;
        String[] stringArray;
        String string3 = "";
        if (string.indexOf(45) >= 0) {
            stringArray = charutil.getSubStringArray(string, '-', false);
            if (stringArray == null) {
                return "";
            }
            string2 = stringArray[0];
        } else {
            string2 = string;
        }
        stringArray = charutil.getSubStringArray(string2, '.', false);
        if (stringArray == null || stringArray.length < 4) {
            return "";
        }
        String string4 = netutil.getNetworkClass(string2);
        if (string4.length() > 0) {
            switch (string4.charAt(0)) {
                case 'A': {
                    string3 = stringArray[0];
                    break;
                }
                case 'B': {
                    string3 = stringArray[0] + '.' + stringArray[1];
                    break;
                }
                case 'C': {
                    string3 = stringArray[0] + '.' + stringArray[1] + '.' + stringArray[2];
                }
            }
        }
        return string3;
    }

    public static boolean isLocalNetworkIPAddress(String string) {
        int n;
        String[] stringArray;
        block7: {
            block6: {
                if (string.equals(TMainWin.Application.getTokenValue("InternalIPAddress"))) break block6;
                if (!string.equals(TMainWin.Application.getTokenValue("ExternalIPAddress"))) break block7;
            }
            return true;
        }
        if (string.startsWith("10.")) {
            return true;
        }
        if (string.startsWith("127.")) {
            return true;
        }
        if (string.startsWith("192.168.")) {
            return true;
        }
        return string.startsWith("172.") && (stringArray = charutil.getSubStringArray(string, '.', false)) != null && stringArray.length > 1 && (n = charutil.ival(stringArray[1])) >= 16 && n <= 31;
    }

    public static boolean isBroadcastIPAddress(String string) {
        if (string.equals("0.0.0.0")) {
            return true;
        }
        if (string.equals("255.255.255.255")) {
            return true;
        }
        return string.equals("192.168.1.255");
    }

    public static boolean isMulticastIPAddress(String string) {
        return netutil.getNetworkClass(string).equalsIgnoreCase("D");
    }

    public static boolean isValidIPAddress(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 7) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '.' && (c < '0' || c > '9')) {
            return false;
        }
        String[] stringArray = charutil.getSubStringArray(string, '.', false);
        if (stringArray == null || stringArray.length < 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            try {
                int n = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static String getTCPPacketDescription(String string, String string2, int n, String string3, int n2, int n3) {
        boolean bl;
        String string4 = string3.toUpperCase();
        String string5 = "";
        boolean bl2 = string4.indexOf("A") >= 0;
        boolean bl3 = string4.indexOf("U") >= 0;
        boolean bl4 = string4.indexOf("P") >= 0;
        boolean bl5 = string4.indexOf("R") >= 0;
        boolean bl6 = string4.indexOf("S") >= 0;
        boolean bl7 = bl = string4.indexOf("F") >= 0;
        if (bl6) {
            if (bl2) {
                return string + " acknowledges connection from " + string2 + " using port " + n3;
            }
            if (n3 == 80) {
                return string + " requests an http connection with " + string2 + " using port " + n2;
            }
            if (n3 == 21) {
                return string + " requests an ftp connection with " + string2 + " listening on port " + n2;
            }
            return string + " requests connection to " + string2 + "'s port " + n3 + " listening on port " + n2;
        }
        if (bl) {
            return string + " closes connection to " + string2 + " using port " + n3;
        }
        if (bl5) {
            return string + " using port " + n2 + " resets connection with " + string2;
        }
        if (bl2 && n <= 40) {
            return "ok";
        }
        if (n3 == 80) {
            return string + " requests a web page from " + string2 + " using port " + n2;
        }
        if (n3 == 21) {
            return string + " requests FTP data from " + string2 + " using port " + n2;
        }
        return string + " sends data to " + string2 + "'s port " + n3;
    }

    public static String getDNSPacketDescription(String string, String string2, String string3) {
        return string + " asks " + string2 + " where is " + netutil.extractDnsRequest(string3);
    }

    public static String extractAUrl(String string, int n) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        int n3 = string.length();
        boolean bl = false;
        while (!bl && n2 < n3) {
            c = string.charAt(n2);
            if (c != '\"' && c != '=' && c != ' ') {
                bl = true;
                continue;
            }
            ++n2;
        }
        stringBuilder.setLength(0);
        bl = false;
        String string2 = "_./:-?";
        while (!bl && n2 < n3) {
            c = string.charAt(n2);
            if (charutil.isAlpha(c) || charutil.isNumeric(c) || string2.indexOf(c) >= 0) {
                stringBuilder.append(c);
            } else {
                bl = true;
            }
            ++n2;
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '/') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String extractUrls(String string, String string2, char c) {
        String string3;
        int n;
        String[] stringArray;
        String string4;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            URL uRL = string.toUpperCase().startsWith("FILE:") || string.toUpperCase().startsWith("HTTP:") || string.toUpperCase().startsWith("HTTP:") ? new URL(string) : new URL("http://" + string);
            string4 = uRL.getHost();
            stringArray = charutil.getSubStringArray(uRL.getPath(), '/', false);
        }
        catch (Exception exception) {
            MainWin.appendToLog("netutil", "getUrls", Thread.currentThread(), exception, 4, "Invalid url in getUrls - " + string);
            return "";
        }
        stringBuilder.append(charutil.replaceChar(string2.toUpperCase(), '\\', '/'));
        int n2 = 0;
        do {
            if ((n = stringBuilder.indexOf("HTTP:", n2)) < 0) continue;
            string3 = netutil.extractAUrl(string2, n + 0);
            if (!arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            n2 = n + 1;
        } while (n >= 0);
        n2 = 0;
        do {
            if ((n = stringBuilder.indexOf("HTTPS:", n2)) < 0) continue;
            string3 = netutil.extractAUrl(string2, n + 0);
            if (!arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            n2 = n + 1;
        } while (n >= 0);
        n2 = 0;
        do {
            if ((n = stringBuilder.indexOf("<A HREF", n2)) < 0) continue;
            string3 = netutil.extractAUrl(string2, n + 7);
            if (string3.toUpperCase().indexOf("MAILTO") < 0 && !arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            n2 = n + 7;
        } while (n >= 0);
        n2 = 0;
        do {
            if ((n = stringBuilder.indexOf("<IMG SRC", n2)) < 0) continue;
            string3 = netutil.extractAUrl(string2, n + 8);
            if (!arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            n2 = n + 1;
        } while (n >= 0);
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3;
            string3 = charutil.replaceChar((String)arrayList.get(i), '\\', '/');
            if (string3.startsWith("/")) {
                stringBuilder2.append(string4);
                stringBuilder2.append(string3);
            } else if (string3.startsWith("../")) {
                n2 = 0;
                while (string3.startsWith("../")) {
                    ++n2;
                    string3 = string3.substring(3);
                }
                stringBuilder2.append(string4);
                if (stringArray != null) {
                    for (n3 = 0; n3 < stringArray.length - 1 - n2; ++n3) {
                        stringBuilder2.append(stringArray[n3]);
                        stringBuilder2.append("/");
                    }
                }
                stringBuilder2.append(string3);
            } else if (string3.toUpperCase().startsWith("HTTP://") || string3.toUpperCase().startsWith("HTTP://")) {
                stringBuilder2.append(string3);
            } else {
                stringBuilder2.append(string4);
                if (stringBuilder2.length() > 0 && stringBuilder2.charAt(stringBuilder2.length() - 1) != '/') {
                    stringBuilder2.append("/");
                }
                if (stringArray != null) {
                    for (n3 = 0; n3 < stringArray.length - 1; ++n3) {
                        if (stringArray[n3].length() <= 0) continue;
                        stringBuilder2.append(stringArray[n3]);
                        stringBuilder2.append("/");
                    }
                }
                stringBuilder2.append(string3);
            }
            if (i >= arrayList.size() - 1) continue;
            stringBuilder2.append(c);
        }
        return stringBuilder2.toString();
    }

    public static String getSearchQuery(String string) {
        String[] stringArray = new String[]{"?query=", "&query=", "&q=", "?q=", "&string=", "web/", "searchfor=", "keyword--", "qq-", "?name_query=", "?qry="};
        String[] stringArray2 = new String[]{"&ie", "&rls", "&client", "&sourceid", "&spell", "&btnG", "&hl", "&sch", "&submit", "&pg", "&invocation", "&st", "qsrc", "&where", "__", "&pr", "&channel", "&tpr", "&area", "?CMP", "/1", "--", "@message", "&sa", "&do"};
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2 = string.indexOf(stringArray[i]);
            if (n2 <= 0) continue;
            stringBuilder.append(string.substring(n2 + stringArray[i].length()));
            for (n = 0; n < stringBuilder.length(); ++n) {
                if (stringBuilder.charAt(n) != '%') continue;
                String string2 = stringBuilder.substring(n + 1, n + 3);
                int n3 = charutil.ival("0x" + string2);
                if (n3 <= 0) continue;
                stringBuilder2.setLength(0);
                stringBuilder2.append((char)n3);
                charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "%" + string2, stringBuilder2.toString());
            }
            for (n = 0; n < stringArray2.length; ++n) {
                n2 = stringBuilder.toString().toUpperCase().indexOf(stringArray2[n].toUpperCase());
                if (n2 < 0) continue;
                stringBuilder.delete(n2, stringBuilder.length());
            }
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "+", " ");
            return stringBuilder.toString().trim();
        }
        return "";
    }

    public static boolean isMobileDevice(String string) {
        String string2 = string.toUpperCase();
        boolean bl = string2.indexOf("MOBILE") >= 0;
        bl = bl || string2.indexOf("GALAXY NEXUS") >= 0;
        return bl;
    }
}

