/*
 * Decompiled with CFR 0.152.
 */
package utility.notifications;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCacheObj;
import cache.TRawWidgetGetter;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.TScriptSocket;
import utility.asciifiles.TAsciiOutput;
import utility.backoffice.invutil;
import utility.charutil;
import utility.counters.TEventCounter;
import utility.dosutil;
import utility.notifications.TNotification;
import utility.notifications.TNotificationTrace;
import utility.notifications.TNotification_ClientSide;
import utility.notifications.TProxyHandler;
import utility.security.TPasswordService;
import utility.session.TSessionObj;
import utility.ziputil;

public class TNotificationClient
extends Thread {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    boolean Terminate = false;
    public static Date tmNotificationClientLastLoop = new Date();
    public static long countsendClientNotifications = 0L;
    public static long durationsendClientNotifications = 0L;
    public static long countgetNotifications = 0L;
    public static long durationgetNotifications = 0L;
    public static String Status = "Uninitialized";
    public static TEventCounter EventCounter = new TEventCounter("Notification Client", 3600000L);
    public static long tmNotificationLastReceived = new Date().getTime();
    public static long tmNotificationLastSent = new Date().getTime();
    public static TNotification_ClientSide Notification_ClientSide = null;
    public static TScriptSocket DirectSocket = null;
    private TProxyHandler ProxyHandler = new TProxyHandler();
    long iTimeoutConst1 = 15L;
    long iTimeoutConst2 = 15L;

    public TNotificationClient() {
        super("TNotificationClient");
        this.setPriority(1);
        TFormulaEvaluator.hashCounter.put("Notification Client", EventCounter);
    }

    public void terminate() {
        this.Terminate = true;
    }

    public boolean isConnected() {
        if (DirectSocket == null) {
            return false;
        }
        return !DirectSocket.isClosed();
    }

    public int getEventCount(String string) {
        return EventCounter.getEventCount(string);
    }

    public void addProxySocket(TScriptSocket tScriptSocket, String string, String string2) {
        this.ProxyHandler.addSocket(tScriptSocket, string, string2);
    }

    public void addSocketWidgetRequest(TScriptSocket tScriptSocket, String string, TSessionObj tSessionObj) {
        this.ProxyHandler.addSocketWidgetRequest(tScriptSocket, string, tSessionObj);
    }

    public TProxyHandler getProxyHandler() {
        return this.ProxyHandler;
    }

    public void addProxyRequest(TCacheObj tCacheObj, TNotification tNotification, String string) {
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TNotificationClient", "addProxyRequest", Thread.currentThread(), null, 3, "Notification Client: Adding request: " + tNotification.toString());
        }
        if (tNotification.isDiagnostic()) {
            this.MainWin.appendToLog("TNotificationClient", "addProxyRequest", Thread.currentThread(), null, 3, "Notification Client+: Adding request: " + tNotification.toString());
        }
        this.ProxyHandler.addRequest(tCacheObj, tNotification, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendNotifications() {
        if (TFormulaEvaluator.bOpeningDirectSocket) {
            return;
        }
        long l = new Date().getTime();
        ++countsendClientNotifications;
        String string = this.Application.getAspectHashID();
        int n = 0;
        while (true) {
            block28: {
                TNotification tNotification;
                block30: {
                    block32: {
                        block31: {
                            block29: {
                                if (n >= TNotification_ClientSide.arPendingNotifications.size()) {
                                    durationsendClientNotifications += new Date().getTime() - l;
                                    return;
                                }
                                tNotification = (TNotification)TNotification_ClientSide.arPendingNotifications.get(n);
                                if (DirectSocket == null || tNotification.To.equalsIgnoreCase(string)) break block28;
                                if (tNotification.Type != TNotification.NOTIFICATION_PING) break block29;
                                this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: Sending ping notification");
                                DirectSocket.setTimeout(120000);
                                if (!DirectSocket.writeInt(1, true)) {
                                    this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: Error sending ping: " + DirectSocket.getLastMessage());
                                    DirectSocket.dispose();
                                    DirectSocket = null;
                                    durationsendClientNotifications += new Date().getTime() - l;
                                    return;
                                }
                                break block30;
                            }
                            if (!tNotification.isExpired()) break block31;
                            TNotification_ClientSide.arPendingNotifications.remove(n);
                            if (tNotification != null) {
                                EventCounter.addEvent("Expire", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                            }
                            this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 23, "Notification expired", tNotification.ID, tNotification.ParentID, tNotification.Type, tNotification.TimeToLive, tNotification.From, tNotification.To, "", 0L, tNotification.Data.length(), tNotification.AttachedFilename, 0L);
                            if (TFormulaEvaluator.NotificationTrace != null) {
                                TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_EXPIRED, tNotification);
                            }
                            if (TNotification.DebugNotifications) {
                                this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: Removed expired notification: " + tNotification.toString());
                            }
                            if (tNotification.isDiagnostic()) {
                                this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client+: Removed expired notification: " + tNotification.toString());
                            }
                            break block30;
                        }
                        if (tNotification.Attempts != 0 && new Date().getTime() - tNotification.dtLastAttempt.getTime() <= 30000L) break block30;
                        ++tNotification.Attempts;
                        if (tNotification != null) {
                            EventCounter.addEvent("Send", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                        }
                        this.MainWin.appendToLog("TNotificationClient", "sendClientNotifications", Thread.currentThread(), null, 3, "Notification Client: Sending Attempt:" + tNotification.Attempts + " " + tNotification.toString());
                        tNotification.dtLastAttempt = new Date();
                        String string2 = tNotification.toSendString();
                        if (TNotification.DebugNotifications) {
                            this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: len of string to send=" + string2.length());
                        }
                        if (TFormulaEvaluator.NotificationTrace != null) {
                            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_SENDSTART, tNotification);
                        }
                        DirectSocket.setTimeout(120000);
                        if (TNotification.DebugNotifications) {
                            this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: Beginning writeZipString");
                        }
                        if (!DirectSocket.writeZipString(string2, true)) break block32;
                        if (TNotification.DebugNotifications) {
                            this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: writeZipString complete");
                        }
                        if (tNotification.AttachedFilename.trim().length() > 0) {
                            File file = new File(tNotification.AttachedFilename);
                            if (file.exists() && !file.isDirectory()) {
                                long l2 = dosutil.getChecksum(tNotification.AttachedFilename);
                                this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: Sending attachment for " + tNotification.ID + " Size=" + file.length() + " crc=" + l2);
                                DirectSocket.writeInt((int)file.length(), false);
                                String string3 = DirectSocket.sendFile(tNotification.AttachedFilename);
                                DirectSocket.flush();
                                tNotification.dtLastAttempt = new Date();
                                this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: Sending attachment for " + tNotification.ID + " complete: " + string3);
                            } else {
                                DirectSocket.writeInt(0, true);
                                if (TNotification.DebugNotifications) {
                                    this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: 0 bytes sent for " + tNotification.ID);
                                }
                                if (tNotification.isDiagnostic()) {
                                    this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client+: 0 bytes sent for " + tNotification.ID);
                                }
                            }
                        }
                        if (tNotification.Type != TNotification.NOTIFICATION_PING) {
                            Notification_ClientSide.recordTimeSent(tNotification);
                            if (TNotification.DebugNotifications) {
                                this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 19, "Notification Client: Sent " + tNotification.toString(), tNotification.ID, tNotification.ParentID, tNotification.Type, tNotification.TimeToLive, tNotification.From, tNotification.To, tNotification.Data.substring(0, Math.min(tNotification.Data.length(), 256)), 0L, tNotification.Data.length(), tNotification.AttachedFilename, 0L);
                            }
                            if (tNotification.isDiagnostic()) {
                                this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 19, "Notification Client+: Sent " + tNotification.toString(), tNotification.ID, tNotification.ParentID, tNotification.Type, tNotification.TimeToLive, tNotification.From, tNotification.To, tNotification.Data.substring(0, Math.min(tNotification.Data.length(), 256)), 0L, tNotification.Data.length(), tNotification.AttachedFilename, 0L);
                            }
                            if (TFormulaEvaluator.NotificationTrace != null) {
                                TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_SENDEND, tNotification);
                            }
                            break block30;
                        } else if (TFormulaEvaluator.NotificationTrace != null) {
                            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_PING, tNotification);
                        }
                        break block30;
                    }
                    if (TNotification.DebugNotifications) {
                        this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: Error in writeZipString: " + DirectSocket.getLastMessage() + "  Pending notifications=" + TNotification_ClientSide.arPendingNotifications.size());
                    }
                    if (tNotification.isDiagnostic()) {
                        this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client+: Error in writeZipString: " + DirectSocket.getLastMessage() + "  Pending notifications=" + TNotification_ClientSide.arPendingNotifications.size());
                    }
                    if (TFormulaEvaluator.NotificationTrace != null) {
                        TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_SENDERROR, tNotification);
                    }
                    this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 4, "Error sending notification", tNotification.ID, tNotification.ParentID, tNotification.Type, tNotification.TimeToLive, tNotification.From, tNotification.To, "", 0L, tNotification.Data.length(), tNotification.AttachedFilename, 0L);
                    DirectSocket.dispose();
                    DirectSocket = null;
                    durationsendClientNotifications += new Date().getTime() - l;
                    return;
                }
                if (tNotification.Type == TNotification.NOTIFICATION_PING) {
                    TNotification_ClientSide.arPendingNotifications.remove(n);
                    continue;
                }
                tmNotificationLastSent = new Date().getTime();
                ++n;
                continue;
            }
            ++n;
        }
    }

    public void getNotifications() {
        if (TFormulaEvaluator.bOpeningDirectSocket) {
            if (new Date().getTime() - TMainWin.ProgramStartTime.getTime() > 180000L) {
                // empty if block
            }
            return;
        }
        if (DirectSocket == null) {
            if (new Date().getTime() - TMainWin.ProgramStartTime.getTime() > 180000L) {
                // empty if block
            }
            return;
        }
        if (TNotificationClient.DirectSocket.socketInputStream == null) {
            if (new Date().getTime() - TMainWin.ProgramStartTime.getTime() > 180000L) {
                // empty if block
            }
            return;
        }
        long l = new Date().getTime();
        ++countgetNotifications;
        int n = 0;
        try {
            TNotificationClient.DirectSocket.socket.setSoTimeout(1000);
            n = TNotificationClient.DirectSocket.socketInputStream.readInt();
            TNotificationClient.DirectSocket.tmLastRead = new Date().getTime();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n < 6000000 && n > 0) {
            if (TNotification.DebugNotifications) {
                this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Reading notification - " + Integer.toString(n) + " bytes");
            }
            tmNotificationLastReceived = new Date().getTime();
            byte[] byArray = new byte[n];
            int n2 = 0;
            long l2 = new Date().getTime();
            long l3 = new Date().getTime();
            try {
                TNotificationClient.DirectSocket.socket.setSoTimeout(60000);
                int n3 = TNotificationClient.DirectSocket.socket.getReceiveBufferSize();
                do {
                    int n4 = Math.min(n - n2, n3);
                    int n5 = TNotificationClient.DirectSocket.socketInputStream.read(byArray, n2, n4);
                    n2 += n5;
                    try {
                        Thread.yield();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    long l4 = new Date().getTime();
                    if (l4 - l3 <= 3000L) continue;
                    System.out.println("TNotificationClient reading socket: " + n2 + " of " + n + " bytes.  Elapsed: " + (l4 - l2));
                    l3 = l4;
                } while (n2 < n);
            }
            catch (IOException iOException) {
                long l5 = new Date().getTime();
                this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), iOException, 4, "\tNotification Client: Error reading notification: Elapsed: " + (l5 - l3) + " ms. Reopening socket." + iOException.toString());
                durationgetNotifications += new Date().getTime() - l;
                DirectSocket.dispose();
                DirectSocket = null;
                return;
            }
            if (Notification_ClientSide == null) {
                Notification_ClientSide = new TNotification_ClientSide();
            }
            TNotification tNotification = null;
            String string = "";
            try {
                string = ziputil.gunzipString(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.trim().length() > 0) {
                tNotification = new TNotification(string);
                System.out.println("*** " + tNotification.toString());
                if ((this.Application.getTokenValue("AspectHashID").equalsIgnoreCase("4idczse69") || this.Application.getTokenValue("AspectHashID").equalsIgnoreCase("Z6P4IZLYG")) && "WMEGQ7KGH|C2DXGDRYB|UW1X8780H|LY3CJVOHX|KA7WTY00E".indexOf(tNotification.From.toUpperCase()) >= 0) {
                    System.out.println("*** ignoring notification from " + tNotification.From);
                    return;
                }
            } else {
                this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Error reading notification (" + Integer.toString(n) + " bytes read)");
                String string2 = this.Application.getTemporaryFiles() + TPasswordService.generateSalt(4) + ".$$$";
                TAsciiOutput.writeContent(string2, new String(byArray));
                System.out.println("notificatoni content written to " + string2);
            }
            if (tNotification != null && !tNotification.IsValid) {
                this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Notification is not valid: " + tNotification.toString());
            }
            if (tNotification != null && tNotification.IsValid) {
                this.Application.setTokenValue("tmLastNotificationReceived_" + tNotification.Type, Long.toString(new Date().getTime()));
                if (tNotification.Type != TNotification.NOTIFICATION_PING) {
                    if (tNotification.Type == TNotification.NOTIFICATION_DELIVERY_CONFIRMED) {
                        this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Received " + tNotification.toString());
                    } else if (tNotification.Type == TNotification.NOTIFICATION_SERVER_RECEIPT) {
                        this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Received " + tNotification.toString());
                    } else {
                        this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Received " + tNotification.toString());
                    }
                    if (tNotification.isDiagnostic()) {
                        if (tNotification.Type == TNotification.NOTIFICATION_DELIVERY_CONFIRMED) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client+: Received " + tNotification.toString());
                        } else if (tNotification.Type == TNotification.NOTIFICATION_SERVER_RECEIPT) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client+: Received " + tNotification.toString());
                        } else {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client+: Received " + tNotification.toString());
                        }
                    }
                    if (TFormulaEvaluator.NotificationTrace != null) {
                        TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_RECV, tNotification);
                    }
                    if (tNotification.Type != TNotification.NOTIFICATION_SERVER_RECEIPT) {
                        if (TNotification.DebugNotifications) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Sending receipt for " + tNotification.getTypeName() + " ID:" + tNotification.ID);
                        }
                        if (tNotification.isDiagnostic()) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client+: Sending receipt for " + tNotification.getTypeName() + " ID:" + tNotification.ID);
                        }
                        DirectSocket.writeZipString(tNotification.toReceiptString(), true);
                        if (TFormulaEvaluator.NotificationTrace != null) {
                            TNotification tNotification2 = new TNotification(tNotification);
                            if (tNotification.ParentID.length() > 0) {
                                tNotification2.ParentID = tNotification.ParentID;
                            }
                            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_SENDRECEIPT, tNotification2);
                        }
                    }
                    if (tNotification.AttachedFilename.trim().length() > 0) {
                        this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Getting attached file for: " + tNotification.ID);
                        if (tNotification.isDiagnostic()) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client+: Getting attached file for: " + tNotification.ID);
                        }
                        tNotification.AttachedFilename = this.Application.getHomeDir() + "greenlight/notifications/attachments/" + tNotification.From + "_" + dosutil.getFileName(tNotification.OriginalFilename) + dosutil.getFileExt(tNotification.OriginalFilename);
                        try {
                            TNotificationClient.DirectSocket.socket.setSoTimeout(60000);
                            n = TNotificationClient.DirectSocket.socketInputStream.readInt();
                            long l6 = DirectSocket.writeToFile(tNotification.AttachedFilename, n);
                        }
                        catch (Exception exception) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Error getting attachment: " + exception.toString());
                        }
                        long l7 = dosutil.getChecksum(tNotification.AttachedFilename);
                        this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Got attached file for: " + tNotification.ID + " (" + n + " bytes) Filename=" + tNotification.AttachedFilename + " crc=" + l7);
                    }
                    boolean bl = false;
                    if (tNotification.Type != TNotification.NOTIFICATION_DELIVERY_CONFIRMED && tNotification.Type != TNotification.NOTIFICATION_SERVER_RECEIPT) {
                        bl = this.ProxyHandler.handleNotification(tNotification);
                    }
                    if (bl) {
                        Notification_ClientSide.recordTimeResponseReceived(tNotification.ParentID);
                        if (TNotification.DebugNotifications) {
                            Notification_ClientSide.outputProfileInfo(tNotification.ParentID);
                        }
                        if (tNotification.isDiagnostic()) {
                            Notification_ClientSide.outputProfileInfo(tNotification.ParentID);
                        }
                        tNotification.Data = "Text=Proxy request received.  " + tNotification.Data.length() + " bytes&suppressdisplay=true";
                        tNotification.Type = TNotification.NOTIFICATION_TEXT;
                        tNotification.ExternalFilename = "";
                        Notification_ClientSide.addNotification(tNotification);
                        if (tNotification != null) {
                            EventCounter.addEvent("Receive", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                        }
                        if (TNotification.DebugNotifications) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "Notification Client: Handled by proxyhandler: " + tNotification.toString());
                        }
                        if (tNotification.isDiagnostic()) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "Notification Client+: Handled by proxyhandler: " + tNotification.toString());
                        }
                    } else {
                        if ((tNotification = Notification_ClientSide.addNotification(tNotification)) != null) {
                            EventCounter.addEvent("Receive", "Type=" + TNotification.getTypeName(tNotification.Type) + "&From=" + tNotification.From + "&To=" + tNotification.To);
                        }
                        if (TNotification.DebugNotifications) {
                            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "Notification NOT handled by proxyhandler");
                        }
                    }
                } else {
                    this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "Notification Client:Received ping response from server");
                }
            } else {
                this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Invalid zip data in notification.  Len=" + Integer.toString(n) + " bytes.  Reopening socket");
                DirectSocket.dispose();
                DirectSocket = null;
            }
        } else if (n > 0) {
            this.MainWin.appendToLog("TNotificationClient", "getNotifications", Thread.currentThread(), null, 3, "\tNotification Client: Invalid length in notification. " + n + " Reopening socket");
            DirectSocket.dispose();
            DirectSocket = null;
        }
        durationgetNotifications += new Date().getTime() - l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getLocalNotifications() {
        if (Notification_ClientSide == null) {
            Notification_ClientSide = new TNotification_ClientSide();
        }
        String string = this.Application.getAspectHashID();
        int n = 0;
        while (n < TNotification_ClientSide.arPendingNotifications.size()) {
            TNotification tNotification = (TNotification)TNotification_ClientSide.arPendingNotifications.get(n);
            if (tNotification.To.equalsIgnoreCase(string)) {
                boolean bl;
                if (tNotification.isDiagnostic()) {
                    this.MainWin.appendToLog("TNotificationClient", "getLocalNotifications", Thread.currentThread(), null, 3, "\tNotification Client+: Received local " + tNotification.toString());
                }
                Notification_ClientSide.removeNotification(tNotification, n);
                tNotification.IsValid = true;
                if (tNotification.AttachedFilename.trim().length() > 0) {
                    // empty if block
                }
                if (bl = this.ProxyHandler.handleNotification(tNotification)) continue;
                tNotification = Notification_ClientSide.addNotification(tNotification);
                continue;
            }
            ++n;
        }
        return;
    }

    public int archiveNotifications() {
        if (Notification_ClientSide == null) {
            return -1;
        }
        return Notification_ClientSide.archiveNotifications();
    }

    private void initializeConstants() {
        long l = charutil.lval(this.Application.getTokenValue("NotificationClientConst1"));
        if (l > 0L) {
            this.iTimeoutConst1 = l;
        }
        if (this.MainWin.isDevelopmentMode()) {
            this.iTimeoutConst1 = 5L;
            System.out.println("TNotificationClient set iTimeoutConst1=" + this.iTimeoutConst1);
        }
        if ((l = charutil.lval(this.Application.getTokenValue("NotificationClientConst2"))) > 0L) {
            this.iTimeoutConst2 = l;
        }
    }

    public void checkMemory() {
        long l;
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long l3 = Runtime.getRuntime().maxMemory();
        long l4 = Runtime.getRuntime().freeMemory();
        double d = (double)l4 / (double)l3;
        if (l2 > TFormulaEvaluator.MemPeak) {
            if (l2 > 0x10000000L) {
                l = l2;
                System.gc();
                l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            }
            if (l2 > TFormulaEvaluator.MemPeak) {
                TFormulaEvaluator.MemPeak = l2;
                TFormulaEvaluator.DtMemPeak = new Date();
            }
        }
        if (d < 0.1) {
            System.gc();
            l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            l3 = Runtime.getRuntime().maxMemory();
            l4 = Runtime.getRuntime().freeMemory();
            d = (double)l4 / (double)l3;
        }
        if (d < 0.1) {
            l = Runtime.getRuntime().freeMemory();
            TDriverStruct.clearHashedStructures();
            this.Application.AppCollections.clearCache();
            TRawWidgetGetter.clearCache();
            TAspectDriver.clearFieldProfileHashtable();
            invutil.hashConvertSize.clear();
            invutil.hashConvertPrice.clear();
            invutil.hashCalcPrice.clear();
            long l5 = Runtime.getRuntime().freeMemory();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = new Date().getTime();
        do {
            if (bl2) {
                long l2;
                bl3 = this.Application.getAspectHashID().equals("4idczse69");
                tmNotificationClientLastLoop = new Date();
                if (bl) {
                    this.initializeConstants();
                    bl = false;
                }
                if (Notification_ClientSide == null) {
                    Notification_ClientSide = new TNotification_ClientSide();
                }
                if (DirectSocket == null) {
                    if (!TFormulaEvaluator.bOpeningDirectSocket) {
                        Status = "Opening direct socket";
                        int n = TScriptSocket.getConnectionAttempts();
                        int n2 = n < 5 ? 30 : 60;
                        long l3 = l2 = TScriptSocket.dtLastOpenDirectSocket == null ? -1L : (new Date().getTime() - TScriptSocket.dtLastOpenDirectSocket.getTime()) / 1000L;
                        if (TScriptSocket.dtLastOpenDirectSocket == null || l2 > (long)n2) {
                            this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client+: Direct socket is not open in sendClientNotifications.  Opening socket now.");
                            Thread thread = new Thread(){

                                @Override
                                public void run() {
                                    new TFormulaEvaluator().openDirectSocket();
                                }
                            };
                            thread.setPriority(1);
                            thread.start();
                        }
                    } else {
                        this.MainWin.appendToLog("TNotificationClient", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client+: Direct socket is null.  Already opening socket");
                    }
                }
                if (TFormulaEvaluator.SocketQueue == null || TFormulaEvaluator.SocketQueue.getQueueCount() < 100) {
                    try {
                        Status = "sendNotifications()";
                        this.sendNotifications();
                        Status = "getNotifications()";
                        this.getNotifications();
                    }
                    catch (Exception exception) {
                        this.MainWin.appendToLog("TNotificationClient", "run", Thread.currentThread(), null, 4, "Error in TNotificationClient1: " + exception.toString());
                    }
                } else {
                    Status = "Socket queue full";
                }
                try {
                    Status = "getLocalNotifications()";
                    this.getLocalNotifications();
                }
                catch (Exception exception) {
                    this.MainWin.appendToLog("TNotificationClient", "run", Thread.currentThread(), null, 4, "Error in TNotificationClient2: " + exception.toString());
                }
                long l4 = new Date().getTime();
                l2 = (int)(l4 - tmNotificationLastReceived);
                long l5 = (int)(l4 - tmNotificationLastSent);
                long l6 = (int)(l4 - TScriptSocket.tLastOpenDirectSocketSuccess);
                long l7 = Math.min(Math.min(l2, l5), l6);
                if (DirectSocket != null && l2 > this.iTimeoutConst1 * 60L * 1000L && l6 > this.iTimeoutConst1 * 60L * 1000L) {
                    long l8;
                    long l9 = l8 = TScriptSocket.dtLastOpenDirectSocket != null ? l4 - TScriptSocket.dtLastOpenDirectSocket.getTime() : 0L;
                    if (l8 > this.iTimeoutConst2 * 1000L * 60L) {
                        this.initializeConstants();
                        this.MainWin.appendToLog("TNotificationClient", "run", Thread.currentThread(), null, 3, "TNotificationClient: Resetting direct socket.  Time since activity: " + l7 + " open attempt: " + l8 + " open success: " + l6 + " receive: " + l2);
                        try {
                            DirectSocket.dispose();
                            DirectSocket = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (l7 > 600000L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl3) {
                    // empty if block
                }
            } else {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl2 = this.Application.getTokenValue("Aspect_Initialized").equalsIgnoreCase("true");
            }
            long l10 = new Date().getTime();
            if (l10 - l <= 60000L) continue;
            this.checkMemory();
            l = l10;
        } while (!this.Terminate);
    }
}

